#!/usr/bin/perl -w 


   use Encode;    # fuer OpenOffice - Konvertierung in UTF-8     
   use PDF::API2; # fuer Umwandlung des Scan-Bilds in eine PDF-Datei

   use strict;
   use CGI;
   my  $cgi = new CGI;
   use CGI::Carp qw(fatalsToBrowser);

   use lib "/home/matthias/lawsuit/cgi-bin/LS";
   use LS::Form;
   
   use Cwd;
   my $home = cwd;
      $home =~s/\/lawsuit.*$//g;
   my $Documentfolder="$home/Documents"; # 

   my $Althtml=encode("utf8", $cgi->param("Cfile_alt"));
   my $Neuhtml=encode("utf8", $cgi->param("Cfile_neu"));
   my $Altutf8=Form::html2utf8($Althtml);
   my $Neuutf8=Form::html2utf8($Neuhtml);
   

   my $gefunden=0;
   my @Adminzeilen="#!/bin/bash\n\n#Aktuelle Skript-Ausgabe von umbenennen.pl:"; # Falls rename mangels Rechten nicht funktioniert -> Ausgabe in bin/shallrename

############################################################################################
if( $ENV{CONTENT_LENGTH} <= 0 ) {
############################################################################################

   my %Daten;
      $Daten{"Cfile_alt"}=$cgi->param("Cfile_alt");
      $Daten{"Cfile_neu"}=$cgi->param("Cfile_neu");

   print $cgi->header(),
	 $cgi->start_html(-title =>'Lawsuit - Dateigrundzuordnungen anpassen', -charset =>'utf8');

   print @{Form::HTML("umbenennen", \%Daten)};

   print $cgi->end_html;

   
############################################################################################
} else {
############################################################################################

   print $cgi->header(),
	 $cgi->start_html(-title =>'Lawsuit - Dateigrundzuordnungen anpassen',  -style  =>{'src'=>'../stylesheets/faelle.css'}, -charset =>'utf8');

   print '
	<script language="JavaScript" type="text/javascript" src="../javascript/dhtml.js"></script>
	<script language="JavaScript" type="text/javascript" src="../javascript/formular.js"></script>

	<h1 style="text-align:center; margin-top:30px; color:silver">keine Daten gefunden!</h1>

<TABLE id="main" style="position:absolute; left:180px; right:180px">
<tr><td style="min-width:700px;text-align:center;background-color:#666666">
';

	my @Faelle = glob("$Documentfolder/2*/*/*.*"); 
	
	if( $cgi->param("Cparties") eq "all" or $cgi->param("Cparties") eq "parties"  or $cgi->param("Cparties") eq "clients" ) {
	
			
	my @Postweg;
	if( $cgi->param("Ausgang") ) { push(@Postweg, "A"); }
	if( $cgi->param("Eingang") ) { push(@Postweg, "E"); }
	
	foreach my $Postweg (@Postweg) {

		if( $Postweg eq "E" ) {
			$Altutf8=$Altutf8."_";
			$Neuutf8=$Neuutf8."_";
			}
		my %Schreiben;
		my @Schreiben;
		my %Schriftsatz;
		my @Schriftsatz;
		foreach my $F (@Faelle) { 
			
			my $Datei=$F;
			$Datei=~s/^.*\///;
			
			# bei Posteingang PDF-Dateien und Hauptdateien alternativ suchen, 
			if( $Postweg eq "E" ) { 
				#nach dem Namen muss ein Unterstrich und eine Zahl folgen
				if( $Datei=~m/$Altutf8\d.+pdf$/ or $Datei=~m/$Altutf8\d.+doc$/ ) {
					#Inode-Zeit der Datei erfragen
					my @Info = stat($F);
					$Schreiben{$Datei}=$Info[10]."#:#".$F."#:#".$Datei;
					push(@Schreiben, $Info[10]."#:#".$F."#:#".$Datei);
					print "Ich habe das Schreiben&nbsp; ",Form::utf82html($F)," gefunden.<br>";
					}
				#nach dem Namen muss ein Unterstrich und ein Großbuchstabe folgen
				if( $Datei=~m/$Altutf8[A-Z].+pdf$/ or $Datei=~m/$Altutf8[A-Z].+doc$/ ) {
					#Inode-Zeit der Datei erfragen
					my @Info = stat($F);
					$Schriftsatz{$Datei}=$Info[10]."#:#".$F."#:#".$Datei;
					push(@Schriftsatz, $Info[10]."#:#".$F."#:#".$Datei);
					print "Ich habe den Schriftsatz ",Form::utf82html($F)," gefunden.<br>";
					}
				}
			#nach dem Namen muss eine Zahl folgen
			if( $Datei=~m/$Altutf8\d.+odt$/ or $Datei=~m/$Altutf8\d.+sxw$/ or $Datei=~m/$Neuutf8\d.+odt$/ or $Datei=~m/$Neuutf8\d.+sxw$/ ) {
				#Inode-Zeit der Datei erfragen
				my @Info = stat($F); 
				#urspruengliche Benennungsfolge wenn moeglich beibehalten
				my $Zahl=$Datei; $Zahl=~s/.+\///g; $Zahl=~s/\D+//g; 
				#Ergaenzungen abschneiden
				$Datei=~s/(\-\D+)?\..+$//g;
				while( length($Zahl)<4 ) { $Zahl="0".$Zahl; } 
				$Schreiben{$Datei}=$Zahl.$Info[10]."#:#".$F."#:#".$Datei;
				push(@Schreiben, $Zahl.$Info[10]."#:#".$F."#:#".$Datei);
				print "Ich habe das Schreiben&nbsp; ",Form::utf82html($F)," gefunden.<br>";
				}
			#nach dem Namen muss ein Großbuchstabe folgen
			if( $Datei=~m/$Altutf8[A-Z].+odt$/ or $Datei=~m/$Altutf8[A-Z].+sxw$/ or $Datei=~m/$Neuutf8[A-Z].+odt$/ or $Datei=~m/$Neuutf8[A-Z].+sxw$/ ) {
				#Inode-Zeit der Datei erfragen
				my @Info = stat($F);
				$Schriftsatz{$Datei}=$Info[10]."#:#".$F."#:#".$Datei;
				push(@Schriftsatz, $Info[10]."#:#".$F."#:#".$Datei);
				print "Ich habe den Schriftsatz ",Form::utf82html($F)," gefunden.<br>";
				}
			}
	
		my @Doppelschreiben;
		my @Doppelschriftsatz;
		my @Restschreiben; foreach(@Schreiben) { push(@Restschreiben,$_); }
		my @Restschriftsatz;  foreach(@Schriftsatz) { push(@Restschriftsatz,$_); }
		my @Doppelmajuskel = "";
		# Doppelungen in Altsschreiben -> @Restschreiben
		foreach my $Datei (keys(%Schreiben)) { my $x=0; while($x<=$#Restschreiben and $Schreiben{$Datei} ) {
			if( $Restschreiben[$x] =~ m/$Datei$/ ) { splice(@Restschreiben,$x,1); delete $Schreiben{$Datei}; } $x++; } }
		# Doppellungen in Neuschreiben -> @Doppelschreiben
		foreach my $Datei (keys(%Schreiben)) { for(my $x=0;$x<=$#Schreiben;$x++) { 
			if( $Datei =~ m/$Altutf8/ ) { $Datei =~ s/$Altutf8/$Neuutf8/; 
			if( $Schreiben[$x] =~ m/$Datei$/ && $Altutf8 ne $Neuutf8 ) { push(@Doppelschreiben, $Schreiben[$x]); } } } }
		# Doppelungen in Altsschriftsaetzen -> @Restschriftsatz
		foreach my $Datei (keys(%Schriftsatz)) { my $x=0; while($x<=$#Restschriftsatz and $Schriftsatz{$Datei} ) {
			if( $Restschriftsatz[$x] =~ m/$Datei$/ ) { splice(@Restschriftsatz,$x,1); delete $Schriftsatz{$Datei}; } $x++; } }
		# Doppellungen in Neuschriftsaetzen -> @Doppelschriftsatz
		foreach my $Datei (keys(%Schriftsatz)) { for(my $x=0;$x<=$#Schriftsatz;$x++) { 
			if( $Datei =~ m/$Altutf8/ ) { $Datei =~ s/$Altutf8/$Neuutf8/; 
			if( $Schriftsatz[$x] =~ m/$Datei$/ && $Altutf8 ne $Neuutf8 ) { push(@Doppelschriftsatz, $Schriftsatz[$x]); $Datei =~ s/$Neuutf8//; push(@Doppelmajuskel,substr($Datei,0,1)); } } } }
		# Zusammenfassen
		foreach(@Restschreiben) { push(@Doppelschreiben,$_) };
		foreach(@Restschriftsatz) { push(@Doppelschriftsatz,$_) };
	
	        #Doppelungen gefunden?
		if( ($#Doppelschreiben>0 or $#Doppelschriftsatz>0) and !($cgi->param("Ignorieren")) ) {
		
			print "<p> Es sind"; if( $Postweg eq "E" ) { print " im Posteingang " } else { print " im Postausgang "; }
			print "Doppelungen in <br>",(@Doppelschreiben*1)," Schreiben und <br> ",(@Doppelschriftsatz*1)," Schrifts&auml;tzen <br>vorhanden.<p>";
			print "Es handelt sich um die Schreiben<br>"; foreach(sort(@Doppelschreiben)) { print Form::utf82html($_),"<br>"; }
			if( @Doppelschriftsatz>0 ) { print "<p>und die Schrifts&aumltze<br>"; foreach(sort(@Doppelschriftsatz)) { print Form::utf82html($_),"<br>"; } }

			if( $cgi->param("Weiterzaehlen") ) {
			        #Ermittlung von vorne mit aeltestem Schreiben beginnen
				@Schreiben=sort(NummernSort @Schreiben);
				my $Later=0;
				my %Ersetzung;
				foreach (@Schreiben) {
					@_=split("#:#", $_);
					my @Pfad=split('\/',@_[1]);
					my $Altname = pop(@Pfad);
					my $Pfad=join("/", @Pfad)."/";
					my $Name = $Altname;
					$Name =~ s/(\-\D+)?\..+$//;       # hermanns1-re.odt
					$Name =~ s/\_\D+\..+$/_/;          # hermanns2_Abschrift.odt
					$Name =~ s/\_Anlage\w+\..+$/_/;    # hermanns2_Anlage1.odt
					my $Last = $Name;
					$Last =~ s/\D+//g;
					#Wenn nicht Unterdokument (z.B. engers2a-re.odt) oder Anlage -> hochzaehlen
					unless( $Name =~ m/[a-z_]$/ ) { $Later++; } 
					my $Neuname=$Altname;
					$Neuname =~ s/$Last/$Later/;
					$Neuname =~ s/$Altutf8/$Neuutf8/;
					if( $Last*1 != $Later ) {
						$Ersetzung{@_[0]."#:#".$Pfad.$Altname} = $Pfad.$Neuname;
						print "Das Schreiben ",Form::utf82html($Altname)," wird in ",Form::utf82html($Neuname)," umbenannt.<br>","\n";
						}
					#als PDF vorhanden?
					$Altname =~ s/\..+$/\.pdf/;
					$Neuname =~ s/\..+$/\.pdf/;
					#als PDF vorhanden? -e funktioniert nicht !
					if(-e "@_[1]$Altname" && $Last*1 != $Later ) {
						$Ersetzung{@_[0]."#:#".@_[1].$Altname} = "@_[1]$Neuname";
						print "Das zugeh&ouml;rige PDF-Dokument ",Form::utf82html($Altname)," wird in ",Form::utf82html($Neuname)," umbenannt.<br>","\n";
						}
					}
				print "<p>";
			        #Umbenennung von hinten mit juengstem Schreiben beginnen
				foreach my $Datei (reverse(sort(keys(%Ersetzung)))) {
					my $D=$Datei; $D=~s/^.+#:#//g;
					rename( $Datei, $Ersetzung{$Datei} || die "$!");
					push(@Adminzeilen, "mv ".$D." ".$Ersetzung{$Datei});
					}
			        #von hinten mit juengster Datei in juengstem Fall beginnen
				foreach(@Schriftsatz) {
					@_=split("#:#", $_);
					my $Pfad=@_[1];
					$Pfad=~ s/.+$Documentfolder\///g;
					$Pfad=~ s/_//g; #abgelegte Faelle in Sortierung einbeziehen
					my @Fall=split('\/', $Pfad);
					while( length(@Fall[1])<5 ) { @Fall[1]="0".@Fall[1]; }
					#20140001212419809120001#:#/home/matthias/Documents/2014/12/engbersA2.odt#:#engbersA2.odt
					$_=@_[0].@Fall[0].@Fall[1]."#:#".@_[1]."#:#".@_[2];
					}
				@Schriftsatz=sort(NummernSort @Schriftsatz);
				@Schriftsatz=reverse(@Schriftsatz);
				#Beruecksichtigt nur doppelte Buchstaben, nicht doppelte Zahlen, da solche bei der Fallauftteilung praktisch nicht moeglich sind, ohne eine Fehlermeldung von openOffice auszuloesen
				foreach(@Schriftsatz) {
					@_=split("#:#", $_);
					my $Altname = pop(@_);
					@_[1]=~s/$Altname$//g;
					my $Name = $Altname;
					$Name =~ s/(\-\w+)?\..+$//;
					$Name =~ s/^$Neuutf8//;
					$Name =~ s/^$Altutf8//;
					my $Char = $Name;
					$Char =~ s/\d+//g;
					#mit Doppelmajuskeln vergleichen, wenn kleiner, aufschlagen, wenn Abfrage bereits darueber hinweggegangen, loeschen
					my $Aufschlag=0;
					for( my $x=0;$x<$#Doppelmajuskel;$x++ ) { 
						if( ord($Doppelmajuskel[$x])<=ord($Char) ) { $Aufschlag++; }
						elsif( ord($Doppelmajuskel[$x])>ord($Char) ) { splice(@Doppelmajuskel,$x,1); } }
					#nach Z wieder mit A beginnen
					my $Charer = chr( (ord($Char)+$Aufschlag) % 65 + 65 );
					my $Neuname = $Altname;
					$Neuname =~ s/$Char/$Charer/;
					$Neuname =~ s/$Altutf8/$Neuutf8/;
					if( $Aufschlag>1 ) {
						rename ("@_[1]$Altname", "@_[1]$Neuname" || die "$!");
						print "Das Schreiben ",Form::utf82html($Altname)," wurde in ",Form::utf82html($Neuname)," umbenannt.<br>","\n";
						push(@Adminzeilen, "mv @_[1]$Altname @_[1]$Neuname"); }
					#als PDF vorhanden? 
					$Altname =~ s/\..+$/\.pdf/;
					$Neuname =~ s/\..+$/\.pdf/;
					if(-e "@_[1]$Altname" && $Aufschlag>1 ) {
						rename ("@_[1]$Altname", "@_[1]$Neuname" || die "$!");
						print "Das zugeh&ouml;rige PDF-Dokument ",Form::utf82html($Altname)," wurde in ",Form::utf82html($Neuname)," umbenannt.<br>","\n";
						push(@Adminzeilen, "mv @_[1]$Altname @_[1]$Neuname");
						}
					}
				
			} else {
				print "<p>Ich breche die Umbenennung ab. Es wurden keine Daten ver&auml;ndert.<p>", "\n";
				exit;
			}
			
		#keine Doppelungen
		} else {
			foreach (@Schreiben) {
				@_=split("#:#", $_);
				my $Datei=@_[1];
				$Datei =~ s/$Altutf8/$Neuutf8/g;
				#wenn keine Namensidentität -> umbenennen
				unless( @_[1] =~ m/$Neuutf8/ ) { 
					rename ("@_[1]", $Datei);
					print "Das Schreiben ",Form::utf82html(@_[1])," wurde in  ",Form::utf82html($Datei)," umbenannt.<br>","\n";
					push(@Adminzeilen, "mv @_[1] $Datei");
					}
				#als PDF vorhanden?
				@_[1] =~ s/\.[A-Za-z]+$/\.pdf/g;
				$Datei =~ s/\.[A-Za-z]+$/\.pdf/g;
				#wenn Hauptdatei bereits zuvor umbenannt wurde, trotzdem nachhaken
				@_[1] =~ s/$Neuutf8/$Altutf8/;
				if(-e "@_[1]" && !(@_[1] =~ m/$Neuutf8/) ) {
					rename ("@_[1]", "$Datei" || die "$!");
					print "Das zugeh&ouml;rige PDF-Dokument ",Form::utf82html(@_[1])," wurde in  ",Form::utf82html($Datei)," umbenannt.<br>","\n";
					push(@Adminzeilen, "mv @_[1] $Datei");
					}
				}
			foreach (@Schriftsatz) {
				@_=split("#:#", $_);
				my $Datei=@_[1];
				$Datei =~ s/$Altutf8/$Neuutf8/g;
				#wenn keine Namensidentität -> umbenennen
				unless(@_[1] =~ m/$Neuutf8/ ) {
					rename ("@_[1]", $Datei);
					print "Der Schriftsatz  ",Form::utf82html(@_[1])," wurde in  ",Form::utf82html($Datei)," umbenannt<br>","\n";
					push(@Adminzeilen, "mv @_[1] $Datei");
					}
				#als PDF vorhanden? -e funktioniert nicht !
				@_[1] =~ s/\.[A-Za-z]+$/\.pdf/;
				$Datei =~ s/\.[A-Za-z]+$/\.pdf/;
				#wenn Hauptdatei bereits zuvor umbenannt wurde, trotzdem nachhaken
				@_[1] =~ s/$Neuutf8/$Altutf8/;
				if( -e @_[1] && !(@_[1] =~ m/$Neuutf8/) ) {
					rename (@_[1], "$Datei" || die "$!");
					print "Das zugeh&ouml;rige PDF-Dokument  ",Form::utf82html(@_[1])," wurde in  ",Form::utf82html($Datei)," umbenannt.<br>","\n";
					push(@Adminzeilen, "mv @_[1] $Datei");
					}
				}
			}
	        }
	        
	}
	
	#Posteingangssuffix zuruecknehmen
	$Altutf8 =~ s/\_$//;
	$Neuutf8 =~ s/\_$//;
	

	#Stammdaten in Faellen aendern
		
	my @Faelle =  glob("$Documentfolder/2*/*/data/stammdaten.cfg");
	
	foreach my $F (@Faelle) {
		$gefunden=0;
		my @Zeilen=@{Form::Auslesen("$F")};
		foreach(@Zeilen) {
			if( $cgi->param("Cparties") eq "clients" ) {
				if( $_ =~ m/Cm.+ile#:#$Althtml\n/ ) { $_=~ s/$Althtml\n/$Neuhtml\n/g; $gefunden="Mandanten"; }
			} elsif( $cgi->param("Cparties") eq "opponents" ) {
				if( $_ =~ m/Cg.+ile#:#$Althtml\n/ ) { $_=~ s/$Althtml\n/$Neuhtml\n/g; $gefunden="Gegner"; }
			} else {
				if( $_ =~ m/file#:#$Althtml\n/ ) { $_=~ s/$Althtml\n/$Neuhtml\n/g; $gefunden="Partei"; }
			}
		}
		if( $gefunden && $Althtml ne $Neuhtml ) {
			Form::Speichern($F, \@Zeilen, "die Datei $F kann nicht beschrieben werden :\n$!"); 
			print "<p>Der ",$gefunden,"eintrag $Althtml in $F wurde in $Neuhtml angepasst.<br>", "\n";
			}
		}
	
	#Datenbank aendern
	my @Verzeichnis;
	
	if( $cgi->param("Cparties") eq "all" ) {
		@Verzeichnis = qw(clients opponents parties);
	} else {
		push(@Verzeichnis, $cgi->param("Cparties")); }
		
	if( $gefunden ) { printf "<p>Datenbank&auml;nderungen sollen erfolgen in @Verzeichnis."; }
	
	foreach my $verzeichnis (@Verzeichnis) {
	        my @Eintraege = glob("../$verzeichnis/*");
		   foreach(@Eintraege) { 
			if( -d  $_ && $_ =~ m/$Altutf8$/ ) { # nur Verzeichnisnamen;
				my $Neu = $_; $Neu =~ s/$Altutf8/$Neuutf8/g;	
				if( $Altutf8 ne $Neuutf8 ) {
					rename( $_, $Neu || "$!") ; 
					print "../$verzeichnis/$Althtml -> ../$verzeichnis/$Neuhtml<br>", "\n";
					}
				}
			}
		if (-e "../$verzeichnis/all.cfg" ) {
			my @Zeilen=@{Form::Auslesen("../$verzeichnis/all.cfg")};
			$gefunden=0;
			foreach (@Zeilen) { 
				if( $_=~ m/^$Althtml.:#/ ) {
					$_=~s/^$Althtml.:#/$Neuhtml#:#/g;
					$gefunden=1; }
				}
			if( $gefunden && $Althtml ne $Neuhtml) {
				Form::Speichern("../$verzeichnis/all.cfg", \@Zeilen, "die Liste $verzeichnis/all.cfg kann nicht beschrieben werden :\n$!");
				print "<p>Die Liste ../$verzeichnis/all.cfg wurde angepasst.", "\n";
				}
		} else {
			print "<p>Die Liste../$verzeichnis/all.cfg wurde nicht gefunden<p>", "\n";
			}
		}
	
	

	print '
</td></tr>
<tr><td>
Alternatives Linux Shell scirpt: <a href="../cgi-bin/tmp/umbenennen.sh">',$home,'/lawsuit/cgi-bin/tmp/umbenennen.sh</a>
</td></tr>
</TABLE>
</body>
</html>
';

foreach(@Adminzeilen) { $_=decode("utf8",Form::html2utf8(encode("utf8",$_)))."\n"; }
open(LINUX, ">$home/lawsuit/cgi-bin/tmp/umbenennen.sh" || die "Keine Schreibrechte in $home/lawsuit/cgi-bin/tmp/:\n$!"); 
	print LINUX @Adminzeilen;
close(LINUX);
chmod(0777, "$home/lawsuit/cgi-bin/tmp/umbenennen.sh");


############################################################################################
        }
############ und am Ende ###################################################################


sub NummernSort {
 if($a < $b)
  { return -1; }
 elsif($a == $b)
  { return 0; }
 else
  { return 1; }
}
