#!/usr/bin/perl -w 

   use Encode; # fuer OpenOffice - Konvertierung in UTF-8 

   use strict;
   use CGI;
   my $cgi = new CGI;
   use CGI::Carp qw(fatalsToBrowser);

   use lib "/home/hedele/lawsuit/cgi-bin/LS";
   use LS::Form;


   my $Datei=$cgi->param("Datei");
   my $Name=$cgi->param("Name");
   my $Altdatei=$cgi->param("Buchungsdatei1");
   my $Css = ( $Datei =~ m/.+privat.+/ )? 'accountingP' : 'accountingG';    # Privat- oder Geschaeftskonto?
   my %Daten;

   my @Wort= split(/\./, $Datei);
   my $Jahr = $Wort[1];
      $Jahr =~ s/L//g; 
      $Jahr *=1;
   my $Zeile;
   my @Zeilen;

########################################################################################
if( length($cgi->param("Auswahl"))<=0 ) {                                     ## ABFRAGE
########################################################################################

       
      #Aeltere Buchfuehrung einbinden
      my $Vorjahr=$Jahr-1;
      my @Dateien=glob("../data/*_L$Vorjahr.cfg");
       foreach my $Eintrag (@Dateien) {
	    my @Info = stat($Eintrag);
	    # Letzte Aenderungsszeit:
	    $Eintrag=~s/.+\///g;
	    $Eintrag=~s/\.cfg//g;
	    $Eintrag=~s/_/\./g;
	    $Eintrag=Form::utf82html($Eintrag);
	    $Zeile="$Info[9]"."#:#".$Eintrag."#:#".$Eintrag;
	    #Bankdateien aussparen
	    unless( $Eintrag=~m/\w\w\d\d\d\d\d\d\d\d\d\d\d\d\d\d\d\d\d\d\d\d.\w\d\d\d\d/ ) {
		    push(@Zeilen, $Zeile); }
	    }
    
      #Zuletzt bearbeitete zuerst
      @Dateien=reverse(@Zeilen);
    
      #Stat-Eintrag entfernen
      foreach (@Dateien) {
	    $_=~s/^\d+#\:#//;
	    }

   $Daten{"BuchungsdateienHTML"}=Form::Ausklappmenue(\@Dateien, "Buchungsdatei", "", 10, 100, 100,'onClick=getElement("name","altbuchung",0).checked=true;');


      my $Febend;
      if( ($Jahr % 4 == 0 && $Jahr % 100 != 0) || ($Jahr % 1000 == 0) ) { $Febend=29; }
      else { $Febend=28; }

   print "Content-type: text/html\n\n";
   print '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
       "http://www.w3.org/TR/html4/loose.dtd">

<HTML>
<HEAD>  <TITLE>Lawsuit - Umsatzsteuervoranmeldung</TITLE>

	<link rel="icon" href="../favicon.ico" type="image/x-icon">
	<link rel="stylesheet" type="text/css" href="../stylesheets/lawsuit.css">
	<link rel="stylesheet" type="text/css" href="../stylesheets/',$Css,'.css">
	<style>
	table#liste TH    { font-size : 8px; }
	table#liste TD    { font-size : 7px; }
	table#liste INPUT { border-style : none;
			    font-size    : 8px; 
			    background-color : dunkel;}
	</style>

	<script language="JavaScript" type="text/javascript" src="../javascript/dhtml.js"></script>
	<script language="JavaScript" type="text/javascript" src="../javascript/formular.js"></script>
	<script language="JavaScript" type="text/javascript">
	function ganzesjahr() {
		if( document.as.Quartal.selectedIndex == 4 )
		    for(i=0;i<10;i++) getElement("name", "Ganzesjahr", i).style["display"]="table-row"; 
	}
	</script>

</HEAD>
<BODY class="grund">
';

   print'<BR><BR><BR>
	<FORM name="as">

	<TABLE cellpadding="50" cellspacing="0" align="center" width="600">
		<TR>
		<TD class="hell" align="center"><left><H2>Umsatzsteuer-Voranmeldung und Umsatzsteuererkl&auml;rung ',$Jahr,'<br> f&uuml;r den Zeitraum:</h2>
			<input type="radio" name="Auswahl" value="Monat">&nbsp;
			<select name="Monat" onChange="document.as.Auswahl[0].checked=true;">
				<option value="',Form::Zeit("01.01.$Jahr"),'-',Form::Zeit("31.01.$Jahr"),'-a" selected>Januar
				<option value="',Form::Zeit("01.02.$Jahr"),'-',Form::Zeit("$Febend.02.$Jahr"),'-b">Februar
				<option value="',Form::Zeit("01.03.$Jahr"),'-',Form::Zeit("31.03.$Jahr"),'-c">M&auml;rz
				<option value="',Form::Zeit("01.04.$Jahr"),'-',Form::Zeit("30.04.$Jahr"),'-d">April
				<option value="',Form::Zeit("01.05.$Jahr"),'-',Form::Zeit("31.05.$Jahr"),'-e">Mai
				<option value="',Form::Zeit("01.06.$Jahr"),'-',Form::Zeit("30.06.$Jahr"),'-f">Juni
				<option value="',Form::Zeit("01.07.$Jahr"),'-',Form::Zeit("31.07.$Jahr"),'-g">Juli
				<option value="',Form::Zeit("01.08.$Jahr"),'-',Form::Zeit("31.08.$Jahr"),'-h">August
				<option value="',Form::Zeit("01.09.$Jahr"),'-',Form::Zeit("30.09.$Jahr"),'-i">September
				<option value="',Form::Zeit("01.10.$Jahr"),'-',Form::Zeit("31.10.$Jahr"),'-j">Oktober
				<option value="',Form::Zeit("01.11.$Jahr"),'-',Form::Zeit("30.11.$Jahr"),'-k">November
				<option value="',Form::Zeit("01.12.$Jahr"),'-',Form::Zeit("31.12.$Jahr"),'-l">Dezember
			</select>
			&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
			<input type="radio" name="Auswahl" value="Quartal">&nbsp;
			<select name="Quartal" onChange="document.as.Auswahl[1].checked=true;ganzesjahr();">
				<option value="',Form::Zeit("01.01.$Jahr"),'-',Form::Zeit("31.03.$Jahr"),'-n" selected>&nbsp;&nbsp;I. Quartal</option>
				<option value="',Form::Zeit("01.04.$Jahr"),'-',Form::Zeit("30.06.$Jahr"),'-o">&nbsp;II. Quartal</option>
				<option value="',Form::Zeit("01.07.$Jahr"),'-',Form::Zeit("30.09.$Jahr"),'-p">III. Quartal</option>
				<option value="',Form::Zeit("01.10.$Jahr"),'-',Form::Zeit("31.12.$Jahr"),'-q">  IV. Quartal</option>
				<option value="',Form::Zeit("01.01.$Jahr"),'-',Form::Zeit("31.12.$Jahr"),'-m">Ganzes Jahr</option>
			</select>
		</TD>
		</TR>
	</TABLE>
';

   my %Settings=%{Form::Auslesen_Spiegel("../settings/$Name.cfg", "[KPBG].+", "")};
   foreach (keys %Settings) { $Daten{$_}=$Settings{$_}; }


#  Listenauswurf fuer Berichtigung des Vorsteuer-Abzuges nach Par. 15a UStG

   my @Liste=@{Form::Auslesen("../data/$Datei")};
   # Liste umstellen und nach Datum sortieren
   my @NeueListe;
   for(my $i=0;$i<=$#Liste;$i++) {
        $Liste[$i]=~s/&minus;/-/g; # Bug workarround;
        my @Zeile = split(/#:#/, $Liste[$i]);
	foreach (@Zeile) { 
		$_=~ s/\n//g;
		if( $_ =~ /^\d\d\.\d\d\.20\d\d*/ ) { $_=Form::Zeit($_); }
		} 
 	my $NeueZeile = $Zeile[2]."#:#";
        #Liste nur je bis zum Betrag auslesen
	for(my $i=4;$i<=7;$i++) { $NeueZeile.=$Zeile[$i]."#:#"; } 
	#Buchungsnummer am Ende anhaengen fuer Aktiv-Auswahl
	$NeueZeile.=$Zeile[10]."#:#".$Zeile[1]."#:#".$Zeile[15]."\n";
	push(@NeueListe, $NeueZeile);
	}
	
   @Liste=sort(@NeueListe);


   my @Width = qw( 9 2 6 20 30 4); 
   my @Align = qw( center center center left left right); 

   my @Zeilen;
   my $Anzeige=0;
   my $EFeld;
   my $UFeld;
   my $Ref;
   my $y=1;
   for (my $i=0; $i<=$#Liste; $i++) {
	my $z=0;
	my @Zeile=split("#:#", $Liste[$i]);
	foreach(@Zeile) { $_=~s/\n$//g; }
	# Datum zurueckformatieren
	$Zeile[0]=Form::Zeigezeit($Zeile[0]);
	#Aenderung bei Immobilien (Ziff. 1)
	if( $Zeile[2] eq "155800" ) { $EFeld="86a"; $z=1; $Ref="371" }
	if( $Zeile[2] eq "155900" ) { $EFeld="86b"; $z=1; $Ref="371" }
	#Aenderung bei beweglichen Gegenstaenden oder sonst. Leistungen (Ziff. 2)
	if( $Zeile[2] eq "155600" ) { $EFeld="87a"; $z=2; $Ref="372" }
	if( $Zeile[2] eq "155700" ) { $EFeld="87b"; $z=2; $Ref="372" }
	#Aufsplittung bei land- und forstwirtschaftlichen Umsaetzten (Forst - Saegewerk) 19%
	if( $Zeile[2] eq "819000" ) { $EFeld="255"; $z=4; $Ref=""; $UFeld="256"; }
	#Herauswahl von Dreiecksgeschaeften bei EU-Lieferung
	if( $Zeile[2] eq "312300" ) { $EFeld="751a"; $z=8; $Ref="dreieck"; $UFeld="751b"; }
	if( $Zeile[2] eq "314300" ) { $EFeld="751a"; $z=8; $Ref="dreieck"; $UFeld="751b"; }
	if( $Zeile[2] eq "342500" ) { $EFeld="751a"; $z=8; $Ref="dreieck"; $UFeld="751b"; }
	if( $Zeile[2] eq "311300" ) { $EFeld="746a"; $z=8; $Ref="dreieck"; $UFeld="746b"; }
	if( $Zeile[2] eq "313300" ) { $EFeld="746a"; $z=8; $Ref="dreieck"; $UFeld="746b"; }
	if( $Zeile[2] eq "342000" ) { $EFeld="746a"; $z=8; $Ref="dreieck"; $UFeld="746b"; }
	if( $Zeile[2] eq "343000" ) { $EFeld="746a"; $z=8; $Ref="dreieck"; $UFeld="746b"; }
	if( $Zeile[2] eq "342900" ) { $EFeld="747";  $z=8; $Ref="dreieck"; $UFeld="748"; }
	if( $Zeile[2] eq "343600" ) { $EFeld="747";  $z=8; $Ref="dreieck"; $UFeld="748"; }
	#Lieferung vor der Einlagerung in ein UmSt-Lager
	if( $Zeile[2] eq "812500" ) { $EFeld="852"; $z=9; $Ref=""; $UFeld="853"; }

	if( length($Liste[$i])>0 && $z>0 ) {
		$y++;
		my $Farbe = ( $y % 2 == 0 )?  "dunkel" : "hell"; 
		$Zeilen[$z].= '
				<tr class='.$Farbe.'>
					';
		for (my $k=0; $k<6; $k++) {                           # Zeile auswerfen
			$Zeilen[$z].= '<td><input size="'.$Width[$k].'" value="'.$Zeile[$k].'" class="'.$Farbe.'" style="text-align:'.$Align[$k].'"></td>';
			}
		
		$Zeilen[$z].= '
					<td class="hell" align=center><input type="checkbox" name="'.$Zeile[6].'_'.$EFeld.'&'.$UFeld.'" value="'.Form::Zahl($Zeile[5]).'&'.Form::Zahl($Zeile[7]).'" onClick="if(this.checked==true) document.getElementsByName(&apos;'.$Ref.'&apos;)[0].checked=true;"></TD>
				</tr>
';		}
	}
	#Aenderung bei beweglichen Gegenstaenden oder sonst. Leistungen (Ziff. 2)
	$Zeilen[3]=$Zeilen[2];
	$Zeilen[3]=~s/_87/_88/g; # Additionsfeld an Ziff. 3 anpassen
	$Zeilen[3]=~s/\&apos;372\&apos;/\&apos;369\&apos;/g; #Referenzcheckbox an Ziff. 3 anpassen
	#Aufsplittung bei land- und forstwirtschaftlichen Umsaetzten (Forst - Saegewerk) 10,7%
	$Zeilen[5]=$Zeilen[4];
	$Zeilen[5]=~s/_255&256/_257&258/g; # Freie Additionsfelder von Forstwirt 
	#Aufsplittung bei land- und forstwirtschaftlichen Umsaetzten (Forst - Rest) 5,5%
	$Zeilen[6]=$Zeilen[4];
	$Zeilen[6]=~s/_255&256/__257&258/g; # Additionsfeld von Forstwirt 
	#Aufsplittung bei land- und forstwirtschaftlichen Umsaetzten (Land - Getraenke) 19%
	$Zeilen[7]=$Zeilen[4];
	$Zeilen[7]=~s/_255&256/_344a&344b/g; # Additionsfeld von Forstwirt an Landwirt anpassen

   for (my $z=1; $z<=5; $z++) {
	if( length($Zeilen[$z])>0 ) {
		$Zeilen[$z]= '
			<table cellpadding="0" cellspacing="0" align="center" id="liste">
				<tr>
					<TH class="rahmen">Datum</TH><TH class="rahmen">Art</TH><TH class="rahmen">B/E-Konto</TH><TH class="rahmen">Bezeichnung</TH><TH class="rahmen">Buchungstext</TH><TH class="rahmen">Betrag</TH>
					<td class="hell" align=bottom><b>&nbsp;aktiv&nbsp;<b></td>
				</tr>
'.$Zeilen[$z].'
			</table>
';
		}
	}

# Ende Listenauswurf fuer Berichtigung des Vorsteuerabzugs

   print '
	<TABLE cellpadding="0" cellspacing="0" align="center" width="600px">
		<tr name="Ganzesjahr" style="display:none">
		<td class="hell" width="50px" rowspan="16" >
				&nbsp;
		</td>
		<td class="hell">
				<div class="comment"><b>Dauer</b> der Unternehmereigenschaft <br>(falls nicht vom 01.01. bis 31.12.)</div>
		</td>
		<td class="hell">
				<div class="comment">vom&nbsp;<input type="text" name="Mraum1" size="10" maxlength="10" value="',$Daten{"Mraum1"},'" onChange="datum(this.name,1,0)"/>&nbsp;bis&nbsp;<input type="text" name="Mraum2" size="10" maxlength="10" value="',$Daten{"Mraum2"},'" onChange="datum(this.name,1,0)"/></div>
				<div class="comment">vom&nbsp;<input type="text" name="Mraum3" size="10" maxlength="10" value="',$Daten{"Mraum3"},'" onChange="datum(this.name,1,0)"/>&nbsp;bis&nbsp;<input type="text" name="Mraum4" size="10" maxlength="10" value="',$Daten{"Mraum4"},'" onChange="datum(this.name,1,0)"/></div>
		</td>
		<td class="hell" width="50px" rowspan="16" >
				&nbsp;
		</td>
		</tr><tr name="Ganzesjahr" style="display:none">
		<td class="hell" colspan="2">
				<input type="checkbox" name="Ukleinunternehmer" value="1" onChange="if(this.checked==true) document.getElementById(&apos;klein&apos;).style[&apos;display&apos;]=&apos;table-row&apos;;else document.getElementById(&apos;klein&apos;).style[&apos;display&apos;]=&apos;none&apos;"><span class="comment">Besteuerung als <b>Kleinunternehmer</b> <a href=javascript:gesetz("19%20ustg")>&sect; 19 Abs. 1 UStG</a></span>
		</td>
		</tr><tr id="klein" style="display:none">
		<td colspan="2">
		    <table cellpadding="0" cellspacing="0" align="center" width="100%">
			<tr>
			<td class="hell" colspan="2">
				<div class="comment">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>Umsatz im Kalenderjahr ',($Jahr-1),'</b></div>
				<div class="comment">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input type="radio" name="altbuchung" value="1"/> ermitteln aus 
				',$Daten{"BuchungsdateienHTML"},' <input type="radio" name="altbuchung" value=""> betrug <input type="text" name="238EUR" size="10" maxlength="35" value="',$Daten{"238EUR"},'" style="text-align:right" onChange="zahl(this.name,2);getElement(&apos;name&apos;,&apos;altbuchung&apos;,1).checked=true;"/>&nbsp;EUR</div>
			</td>
			<tr>
			<td class="hell" width="287px">
				<div style="margin-left:25px;" class="comment">Steuer-, Vorsteuer- und K&uuml;rzungsbetr&auml;ge, die auf Besteuerungszeitr&auml;ume vor ',$Jahr,' entfallen</div>
			</td>
			<td class="hell">
				<div class="comment"><input type="text" name="391EUR" size="10" maxlength="10" value="',$Daten{"391"},'" style="text-align:right" onChange="zahl(this.name, 2)">&nbsp;EUR</div>
			</td>
			</tr>
		    </table>
		</td>
		</tr><tr name="Ganzesjahr" style="display:none">
		<td class="hell" colspan="2">
				
				<div style="margin-left:25px;text-indent:-25px;" class="comment"><input type="checkbox" name="landwirt" value="1" onChange="if(this.checked==true) document.getElementById(&apos;land&apos;).style[&apos;display&apos;]=&apos;table-row&apos;;else document.getElementById(&apos;land&apos;).style[&apos;display&apos;]=&apos;none&apos;">&nbsp;Ich f&uuml;hre einen <b>land-/forstwirtschaftlichen Betrieb</b> nach <a href=javascript:gesetz("24%20ustg")>&sect; 24 UStG</a>.</div>
		</td>
		</tr><tr id="land" style="display:none">
		<td class="hell" colspan="2">
				<div style="margin-left:25px;" class="comment"> Folgende Ums&auml;tze betreffen steuerpflichtige Lieferungen der <b>Forstwirtschaft</b> (einschlie&szlig;lich unentgeltlicher Wertabgaben), n&auml;mlich von S&auml;gewerkserzeugnissen, die nicht bereits laut <a href="http://www.gesetze-im-internet.de/ustg_1980/anlage_2_83.html" target="_blank">Anlage 2 UStG</a> mit nur 7% besteuert werden:</div>
';	if(length($Zeilen[4])>0) { print $Zeilen[4], "\n"; }
   print '	
				<div style="margin-left:25px;" class="comment"> Folgende Ums&auml;tze betreffen die &uuml;brigen  S&auml;gewerkserzeugnisse zu 10,7% UmSt:</div>
';	if(length($Zeilen[5])>0) { print $Zeilen[5], "\n"; }
   print '	
				<div style="margin-left:25px;" class="comment"> Folgende Ums&auml;tze betreffen die Lieferungen zu 5,5% UmSt von anderen Produkten der Forstwirtschaft als S&auml;gewerkserzeugnissen:</div>
';	if(length($Zeilen[6])>0) { print $Zeilen[6], "\n"; }
   print '	
				<div style="margin-left:25px;" class="comment"> Folgende Ums&auml;tze betreffen steuerpflichtige Lieferungen der <b>Landwirtschaft</b> (einschlie&szlig;lich unentgeltlicher Wertabgaben), n&auml;mlich insbesondere von Getr&auml;nken, die nicht bereits laut <a href="http://www.gesetze-im-internet.de/ustg_1980/anlage_2_83.html" target="_blank">Anlage 2 UStG</a> mit nur 7% besteuert werden, und von alkoholischen Fl&uuml;ssigkeiten:</div>
';	if(length($Zeilen[7])>0) { print $Zeilen[7], "\n"; }
   print '	
		</td>
		</tr><tr name="Ganzesjahr" style="display:none">
		<td class="hell" colspan="2">
				
				<div style="margin-left:25px;text-indent:-25px;" class="comment"><input type="checkbox" name="aend" value="1" onChange="if(this.checked==true) document.getElementById(&apos;immo&apos;).style[&apos;display&apos;]=&apos;table-row&apos;;else document.getElementById(&apos;immo&apos;).style[&apos;display&apos;]=&apos;none&apos;">&nbsp;Ich m&ouml;chte <b>Berichtigungen des Vorsteuerabzugs</b> aus fr&uuml;heren Jahren vornehmen gem&auml;&szlig; <a href=javascript:gesetz("15a%20ustg")>&sect; 15a UStG</a>, weil sich innerhalb von 5 bzw. 10 Jahren &Auml;nderungen in der Nutzung eines Grundst&uuml;cks, eines Wirtschaftsgutes oder einer sonstige Leistung ergeben haben, weil ein solcher Gegenstand ausgebucht wurde, bzw. weil auf ihn nunmehr ein anderer Steuersatz anzuwenden ist.</div>
		</td>
		</tr><tr id="immo" style="display:none">
		<td class="hell" colspan="2">
				<div style="margin-left:45px;text-indent:-25px;" class="comment"><input type="checkbox" name="370" value="1"> Es sind im Kalenderjahr ',$Jahr,' Grundst&uuml;cke, Grundst&uuml;cksteile, Geb&auml;ude oder Geb&auml;udeteile, f&uuml;r die Vorsteuer abgezogen worden ist, erstmals tats&auml;chlich verwendet worden.</div>
				<div style="margin-left:45px" class="comment">(Geben Sie bitte auf besonderem Blatt f&uuml;r jedes Grundst&uuml;ck oder Geb&auml;ude gesondert an: Lage, Zeitpunkt der erstmaligen tats&auml;chlichen Verwendung, Art und Umfang der Verwendung im Erstjahr, insgesamt angefallene Vorsteuer, in den Vorjahren - Investitionsphase - bereits abgezogene Vorsteuer!)</div><p>
				<div  style="margin-left:20px" class="comment">F&uuml;r welche urspr&uuml;nglich vom Vorsteuerabzug erfassten <b>Gegenst&auml;nde</b> haben sich die Verh&auml;ltnisse ge&auml;ndert?</div><p>
				<ol style="margin-left:40px">
				    <li><div style="margin-left:25px;text-indent:-25px;" class="comment"><input type="checkbox" name="371" value="1"> bei Grundst&uuml;cken, Grundst&uuml;cksteilen, Geb&auml;uden oder Geb&auml;udeteilen, die innerhalb der letzten 10 Jahre erstmals tats&auml;chlich und nicht nur einmalig zur Ausf&uuml;hrung von Ums&auml;tzen verwendet worden sind.</div>
';	if(length($Zeilen[1])>0) { print $Zeilen[1], "\n"; }
   print '	
				   <li><div style="margin-left:25px;text-indent:-25px;" class="comment"><input type="checkbox" name="372" value="1"> bei anderen Wirtschaftsg&uuml;tern und sonstigen Leistungen, die innerhalb der letzten 5 Jahre erstmals tats&auml;chlich und nicht nur einmalig zur Ausf&uuml;hrung von Ums&auml;tzen verwendet worden sind.</div>
';	if(length($Zeilen[2])>0) { print $Zeilen[2], "\n"; }
   print '	
				    <li><div style="margin-left:25px;text-indent:-25px;" class="comment"><input type="checkbox" name="369" value="1"> bei Wirtschaftsg&uuml;tern und sonstigen Leistungen, die nur einmalig zur Ausf&uuml;hrung von Ums&auml;tzen verwendet worden sind.</div>
';	if(length($Zeilen[3])>0) { print $Zeilen[3], "\n"; }
   print '	
				</ol>
				<div style="margin-left:20px" class="comment"><b>Erl&auml;uterung:</b></div>
				<div style="margin-left:20px" class="comment">Die Verh&auml;ltnisse, die urspr&uuml;nglich f&uuml;r die Beurteilung des Vorsteuerabzugs ma&szlig;gebend waren, haben sich seitdem ge&auml;ndert durch</div>
				<div style="margin-left:20px" class="comment"><input type="checkbox" name="80a" value="X"> Ver&auml;u&szlig;erung<br>
				<input type="checkbox" name="80b" value="X"> Lieferung i. S. des <a href=javascript:gesetz("3%20ustg")>&sect; 3 Abs. 1b UStG</a><br>
				<input type="checkbox" name="80c" value="X"> Nutzungs&auml;nderung, und zwar</div>
				<ul style="margin-left:20px">
				    <li><div style="margin-left:22px;text-indent:-22px;" class="comment"><input type="checkbox" name="82a" value="X">&Uuml;bergang von steuerpflichtiger zu steuerfreier Vermietung oder umgekehrt bzw. &Auml;nderung des Verwendungsschl&uuml;ssels bei gemischt genutzten Grundst&uuml;cken (insbesondere bei Mieterwechsel),</div>
				    <li><div style="margin-left:22px;text-indent:-22px;" class="comment"><input type="checkbox" name="83a" value="X">steuerfreie Vermietung bisher eigengewerblich genutzter R&auml;ume oder umgekehrt; &Uuml;bergang von einer Vermietung f&uuml;r NATO oder &auml;hnliche Zwecke zu einer nach <a href=javascript:gesetz("4%20ustg")>&sect; 4 Nr. 12 UStG</a> steuerfreien Vermietung,</div>
				    <li><div style="margin-left:22px;text-indent:-22px;" class="comment"><input type="checkbox" name="84a" value="X"> <input type="text" name="84b" size=50 maxsize=100 value=',$Daten{"84b"},'>.</div>
				</ul>  
		</td>
		</tr><tr name="Ganzesjahr" style="display:none">
		<td class="hell" colspan="2">
				<div style="margin-left:25px;text-indent:-25px;" class="comment"><input type="checkbox" name="eu" value="1" onChange="if(this.checked==true) document.getElementById(&apos;drei&apos;).style[&apos;display&apos;]=&apos;table-row&apos;; else document.getElementById(&apos;drei&apos;).style[&apos;display&apos;]=&apos;none&apos;" > Ich habe im Kalenderjahr ',$Jahr,' in einen <b>EU-Mitgliedsstaat</b> geliefert oder aus einem Mitgliedstaat Lieferungen und Leistungen erhalten.</div>
		</td>
		</tr><tr id="drei" style="display:none">
		<td class="hell" colspan="2">
				<div style="margin-left:45px;text-indent:-25px;" class="comment"><input type="checkbox" name="dreieck" value="1"> Nachfolgenden Buchungen zu innergemeinschafltichen Leistungen und Lieferungen aus dem Kalenderjahr ',$Jahr,' erfolgten im Rahmen eines <b>Dreiecksgesch&auml;fts</b> nach <a href=javascript:gesetz("25b%20ustg")>&sect; 25b UStG</a>, bei dem Versender oder Bef&ouml;rderer, erster Abnehmer und letzter Empf&auml;nger in jeweils anderen Mitgliedstaaten ans&auml;ssig waren:
';	if(length($Zeilen[8])>0) { print $Zeilen[8], "\n"; }
   print '	
				</div>
		</td>
		</tr><tr name="Ganzesjahr" style="display:none">
		<td class="hell" colspan="2">
				<div style="margin-left:25px;text-indent:-25px;" class="comment"><input type="checkbox" name="auslager" value="1" onChange="if(this.checked==true) document.getElementById(&apos;lager&apos;).style[&apos;display&apos;]=&apos;table-row&apos;; else document.getElementById(&apos;lager&apos;).style[&apos;display&apos;]=&apos;none&apos;" > Ich beschicke ein <b>Umsatzsteuerlager</b>.</div>
		</td>
		</tr><tr id="lager" style="display:none">
		<td class="hell" colspan="2">
				<div style="margin-left:25px;" class="comment"> Nachfolgenden Buchungen gingen einer sp&auml;teren Auslagerung aus einem Umsatzsteuerlager voraus:
';	if(length($Zeilen[8])>0) { print $Zeilen[9], "\n"; }
   print '	
				</div>
		</td>
		</tr><tr name="Ganzesjahr" style="display:none">
		<td class="hell" colspan="2">
				<div style="margin-left:25px;text-indent:-25px;" class="comment"><input type="checkbox" name="auslaender" value="1" onChange="if(this.checked==true) document.getElementById(&apos;ausl&apos;).style[&apos;display&apos;]=&apos;table-row&apos;; else document.getElementById(&apos;ausl&apos;).style[&apos;display&apos;]=&apos;none&apos;" > Ich bin ein <b>im Ausland ans&auml;ssiger Unternehmer</b>.</div>
		</td>
		</tr><tr id="ausl" style="display:none">
		<td class="hell">
				<div style="margin-left:25px;" class="comment"> und habe als solcher entrichtet
				<ul>
				    <li><div class="comment"> Umsatzsteuer bei der <b>Bef&ouml;r-</b><br><b>derungseinzelbesteuerung</b><br><a href=javascript:gesetz("18%20ustg")>&sect; 18 Abs. 5b Satz 2 UStG</a><br>(Anlage UN Zeile 20)</div>
				    <li><div class="comment"> <b>Sicherheitsleistungen</b><br><a href=javascript:gesetz("18%20ustg")>&sect; 18 Abs. 12 Satz 5 UStG</a><br>(Anlage UN Zeile 21)</div>
				</ul>
				</div>
		</td>
		<td class="hell" width="50%">
				<div class="comment"><input type="text" name="888EUR" size="10" maxlength="10" value="',$Daten{"888"},'" style="text-align:right" onChange="zahl(this.name, 2)">&nbsp;EUR</div>
				<div class="comment"> <input type="text" name="886EUR" size="10" maxlength="10" value="',$Daten{"886"},'" style="text-align:right" onChange="zahl(this.name, 2)">&nbsp;EUR</div>
		</td>
		</tr><tr name="Ganzesjahr" style="display:none">
		<td class="hell" colspan="2">
				<div style="margin-left:25px;text-indent:-25px;" class="comment"><input type="checkbox" name="fehlerhaft" value="1" onChange="if(this.checked==true) document.getElementById(&apos;fehler&apos;).style[&apos;display&apos;]=&apos;table-row&apos;; else document.getElementById(&apos;fehler&apos;).style[&apos;display&apos;]=&apos;none&apos;" >  Es ist im Kalenderjahr ',$Jahr,' Umsatzsteuer <b>falsch ausgewiesen</b> worden oder falsch ausgewiesene von mir &uuml;bernommen worden:</b></div>
		</td>
		</tr><tr id="fehler" style="display:none">
		<td class="hell">
				<div style="margin-left:25px;" class="comment">
				<ul>
				    <li><div class="comment"> In Rechnungen unrichtig oder unberechtigt ausgewiesene Steuerbetr&auml;ge nach <a href=javascript:gesetz("14c%20ustg")>&sect; 14c  UStG</a></div>
				    <li><div class="comment"> Von mir, nachdem ein anderer Umsatzsteuer falsch in Rechnung gestellt hat, freiwillig &uuml;bernommen worden nach <a href=javascript:gesetz("17%20ustg")>&sect; 17 Abs. 1 Satz 6 UStG</a> </div>
				    <li><div class="comment"> Bei innergemeinschaftlichen Dreiecksgesch&auml;ften wegen Fehlens der Ust-Id oder anderer M&auml;ngel von mir als erstem Abnehmer geschuldet nach <a href=javascript:gesetz("6ac%20ustg")>&sect; 6a Abs. 4 Satz 2 UStG</a></div>
				</ul>
				</div>
		</td>
		<td class="hell" width="50%">
				<div class="comment"><input type="text" name="318aEUR" size="10" maxlength="10" value="',$Daten{"318aEUR"},'" style="text-align:right" onChange="zahl(this.name, 2)">&nbsp;EUR</div>
				<div class="comment"> <input type="text" name="331EUR" size="10" maxlength="10" value="',$Daten{"331EUR"},'" style="text-align:right" onChange="zahl(this.name, 2)">&nbsp;EUR</div>
				<div class="comment"><input type="text" name="318bEUR" size="10" maxlength="10" value="',$Daten{"318bEUR"},'" style="text-align:right" onChange="zahl(this.name, 2)">&nbsp;EUR</div>
		</td>
		</tr><tr name="Ganzesjahr" style="display:none">
		<td class="hell">
				<div class="comment"><b>Vorentrichtete</b> Umsatzsteuer f&uuml;r Voranmeldungen in '.$Jahr,' zur Zeit:</div>
		</td>
		<td class="hell" width="50%">
				<div class="comment"><input type="text" name="108aEUR" size="10" maxlength="10" value="',$Daten{"108aEUR"},'" style="text-align:right" onChange="zahl(this.name, 2)"/>&nbsp;EUR</div>
		</td>
		</tr><tr name="Ganzesjahr" style="display:none">
		<td class="hell" colspan="4">
				&nbsp;
		</td>
		</tr>
	</TABLE>
	<TABLE cellpadding="0" cellspacing="0" align="center" width="600px">
		<tr>
		<td class="hell" width="50px" rowspan="7" >
				&nbsp;
		</td>
		<td class="hell" colspan="2">
				<h4>Bei der Anfertigung dieser Steueranmeldung hat mitgewirkt:</h4>
		</td>
		<td class="hell" width="50px" rowspan="7">
				&nbsp;
		</td>
		</tr><tr>
		<td class="hell" colspan="2">
				<input type="text" name="Mvorname" size="35" maxlength="40" value="',Form::html2form($Daten{"Mvorname"}),'"/>
				<br><div class="comment">Vorname</div>
		</td>
		</tr><tr>
		<td class="hell" colspan="2">
				<input type="text" name="Mnachname" size="35" maxlength="40" value="',Form::html2form($Daten{"Mnachname"}),'"/>
				<br><div class="comment">Nachname</div>
		</td>
		</tr><tr>
		<td class="hell" colspan="2">
				<input type="text" name="Mfirma" size="35" maxlength="40" value="',Form::html2form($Daten{"Mfirma"}),'"/>
				<br><div class="comment">Firma</div>
		</td>
		</tr><tr>
		<td class="hell" colspan="2">
				<input type="text" name="Mstrasse" size="35" maxlength="40" value="',Form::html2form($Daten{"Mstrasse"}),'"/>
				<br><div class="comment">Stra&szlig;e, Hausnummer</div>
		</td>
		</tr><tr>
		<td class="hell" width="67px">
				<input type="integer" name="Mplz" size="5" maxlength="5" value="',Form::html2form($Daten{"Mplz"}),'" />
				<br><div class="comment">PLZ</div>
		</td>
		<td class="hell">
				<input type="text" name="Mstadt" size="25" maxlength="35" value="',Form::html2form($Daten{"Mstadt"}),'" align="right" />
				<br><div class="comment">Stadt</div>
		</td>
		</tr><tr>
		<td class="hell" colspan="4">
				&nbsp;
		</td>
		</tr>
	</table>
	<table cellpadding="0" cellspacing="0" align="center" width="600px">
		<tr>
		<td class="hell" width="50px" rowspan="5" >
				&nbsp;
		</td>
		<td class="auswahl" rowspan="2">
			<div class="comment">Falls ein Erstattungsanspruch entsteht</div>
		</td>
		<td class="hell">
			<input type="checkbox" name="10" value="1"><span class="comment">Berichtigte Anmeldung</span>
		</td>
		<td class="hell" width="50px" rowspan="5" >
				&nbsp;
		</td>
		</tr><tr>
		<td class="hell">
			<input type="checkbox" name="22" value="1"><span class="comment">Belege anbei / werden nachgereicht</span>
		</td>
		</tr><tr>
		<td class="auswahl">
			<input type="checkbox" name="29" value="1"><span class="comment">w&uuml;nsche ich Verrechnung</span>
		</td>
		<td class="hell" rowspan="2">
			<input type="text" name="Datum" size="25" maxlength="35" value="',Form::Datum(2,0),'" align="right" />
			<br><div class="comment">Datum</div>
		</td>
		</tr><tr>
		<td class="auswahl">
			<input type="checkbox" name="26" value="1"><span class="comment">Einzugserm&auml;chtigung wird (daher) widerrufen</span>
		</td>
		</tr><tr>
		<td class="hell" colspan="2">
				&nbsp;<br>&nbsp;
		</td>
		</tr>
	</table>
	<TABLE cellpadding=10 align="center" width="600">
		<TR>
		<TD align="right">
			<input type="button" value="  Erstellen  " onClick="encodeall();submit()">
		</TD>
		</TR>
	</TABLE>
	<INPUT TYPE="hidden" name="Datei" value="',$Datei,'">
	<INPUT TYPE="hidden" name="Name" value="',$Name,'">
	</FORM>
';

   print qq~<BR><BR><BODY><HTML>~;


########################################################################################
} else {                                                                      ## AUSGABE
########################################################################################


   my @Feldnamen = $cgi->param();
   foreach my $Feld (@Feldnamen) {
	if( $cgi->param($Feld) )  {
		$Daten{$Feld} = encode("utf8",Form::utf82html($cgi->param($Feld)));
	} else {
		$Daten{$Feld} = "";
		}
   }

   #Ungebrauchte Booleans leeren
   $Daten{"10"} |= "";
   $Daten{"22"} |= "";
   $Daten{"29"} |= "";
   $Daten{"26"} |= "";

   $Daten{"27a"} |= "";
   $Daten{"28a"} |= "";
   $Daten{"370"} |= "";
   $Daten{"371"} |= "";
   $Daten{"372"} |= "";
   $Daten{"369"} |= "";
   $Daten{"80a"} |= "";
   $Daten{"80b"} |= "";
   $Daten{"80b"} |= "";
   $Daten{"80c"} |= "";
   $Daten{"81a"} |= "";
   $Daten{"82a"} |= "";
   $Daten{"83a"} |= "";
   $Daten{"84a"} |= "";


   #Neue Werte an Settings anhaengen

   my %AlleDaten=%{Form::Auslesen_Spiegel("../settings/$Name.cfg", "", "")};

   foreach (@Feldnamen) {
	unless($_ =~ m/^\d\d/) {
		$AlleDaten{$_} = $Daten{$_};
	}
   }
   @Feldnamen="";
   foreach (keys (%AlleDaten)) {
	push(@Feldnamen, $_);
	}

   Form::Speichern_Spiegel( \@Feldnamen, \%AlleDaten, "../settings/$Name.cfg", "");

   #Nur eine Auswahl fuer tax verwenden

   foreach (keys (%AlleDaten)) {
	if ( $_ =~ m/[MSU]/ ) {
		$Daten{$_} = $AlleDaten{$_};
	}
   }

   #Periodenauswahl
   my $Auswahl=$cgi->param("Auswahl");
   my @Zeiten=split(/-/, $cgi->param("$Auswahl"));




   my @Liste=@{Form::Auslesen("../data/$Datei")};


   #Periodenwahl ins Formular eintragen
   $Daten{$Zeiten[2]} = "1";
   for( my $i=97;$i<=113;$i++ ) {
	$Daten{(chr($i))} |= "";
   }
   if( $Daten{"m"} ) { $Daten{"Jahresmeldung"}="1"; delete($Daten{"m"}); } # fuehrt zu Ersetzungsfehlern


   # Konten berechnen
   my @Konto;
   for(my $i=0;$i<=$#Liste;$i++) {
        $Liste[$i]=~s/&minus;/-/g; # Bug workarround;
        my @Zeile = split(/#:#/, $Liste[$i]);
	 foreach (@Zeile) { 
		$_=~ s/\n//g;
		if( $_ =~ /^\d\d\.\d\d\.20\d\d*/ ) { $_=Form::Zeit($_); }
		} 
	 if( $Zeile[2]>=$Zeiten[0] && $Zeile[2]<=$Zeiten[1] ) {
		my $B=int($Zeile[11]/100); 
		my $E=int($Zeile[5]/100);
		my $U=int($Zeile[13]/100); 
		if( $Zeile[4] eq "E" ) {
			$Konto[$B]-=Form::Zahl($Zeile[8])-0.000000001;
		} else {
			$Konto[$B]+=Form::Zahl($Zeile[8])+0.000000001;
			}
		$Konto[$E]+=Form::Zahl($Zeile[10])+0.000000001;
		if( $E>=8190 && $E<=8540 ) { 
			$Daten{"239"}+=Form::Zahl($Zeile[10])+0.0000000001; }
		if( $E>=8625 && $E<=8650 ) { 
			$Daten{"239"}+=Form::Zahl($Zeile[10])+0.0000000001; }
		if( $E>=8700 && $E<=8729 ) { 
			$Daten{"239"}-=Form::Zahl($Zeile[10])+0.0000000001; }
		$Konto[$U]+=Form::Zahl($Zeile[15])+0.000000001;
		if( $U==1778 ) { 
			$Daten{"361"}+=Form::Zahl($Zeile[10])+0.0000000001; }
		}
        }

   ################################################################
    if( $Daten{"Jahresmeldung"} ) {               # Jahresmeldung
   ################################################################

   #Sonderfelder fuer Jahresmeldung
   $Daten{"86a"}=0; $Daten{"86b"}=0;
   $Daten{"87a"}=0; $Daten{"87b"}=0;
   $Daten{"88a"}=0; $Daten{"88b"}=0;
   $Daten{"357"}=0; $Daten{"359"}=0;

   for(my $i=1;$i<=4;$i++ ) {
	my @Wort= split(/\./, $Daten{"Mraum".$i});
	$Daten{"t".$i}=($Wort[0])? $Wort[0] : "";
	$Daten{"m".$i}=($Wort[1])? $Wort[1] : "";;
	}
   $Daten{"110"}=$Daten{"10"};
   $Daten{"125"}=($Daten{"auslaender"})? "X" : "";
   $Daten{"129"}=$Daten{"22"};
   $Daten{"238"}=0;

   if( length($Daten{"Ukleinunternehmer"})>0 ) {
	if( $Daten{"altbuchung"} ) {
		$Altdatei=Form::html2utf8($Altdatei);

		my @Liste=@{Form::Auslesen("../data/$Altdatei")};

		# Feld 239 berechnen
		      foreach (@Liste) { 
              $_=~s/&minus;/-/g; # Bug workarround;
		      my @Zeile = split(/#:#/, $_);
			      my $E=int($Zeile[5]/100);
			      if( $E>=8190 && $E<=8540 ) { 
					$Daten{"238"}+=Form::Zahl($Zeile[10])+0.0000000001; }
			      if( $E>=8625 && $E<=8650 ) { 
					$Daten{"238"}+=Form::Zahl($Zeile[10])+0.0000000001; }
			      if( $E>=8700 && $E<=8729 ) { 
					$Daten{"238"}-=Form::Zahl($Zeile[10])+0.0000000001; }
		       }
	} else {
		$Daten{"238"}=$Daten{"238EUR"};
		}
	}

   if( $Daten{"238"}==0 ) { $Daten{"239"}=0; }


   # Sonderfelder mit Einzelabfrage
   foreach my $Feld (keys %Daten) {
	if( $Feld =~ m/_/ ) {
		my @Wert=split("&", $Daten{$Feld});
		@Wort=split("_", $Feld);
		@Wort=split("&", $Wort[1]);
		$Daten{$Wort[0]}+=$Wert[0]*1;
		if( length($Wort[1])>0 ) { $Daten{$Wort[1]}+=$Wert[1]; }
		}
	} 

   #Subtraktionen fuer spaetere "blinde" Additionen in UR
   if( $Konto[3125]>0 ) { $Konto[1574]-=$Konto[3125]*0.19; }
   if( $Konto[3116]>0 ) { $Konto[1798]-=$Konto[3116]*0.19; }
   if( $Konto[3117]>0 ) { $Konto[1798]-=$Konto[3117]*0.19; }


   $Daten{"110"}=$Daten{"10"}; delete($Daten{"10"});
			       delete($Daten{"22"});
   $Daten{"129"}=$Daten{"29"}; delete($Daten{"29"});
			       delete($Daten{"26"});

   $Daten{"177a"} = ($Konto[8400])? $Konto[8400] : 0;
   $Daten{"177a"}+= ($Konto[8900])? $Konto[8900] : 0;
	$Daten{"177b"} = $Daten{"177a"}*0.19;
	$Daten{"177a"} = int($Daten{"177a"});
   $Daten{"178a"} = ($Konto[8935])? $Konto[8935] : 0;
   $Daten{"178a"}+= ($Konto[8940])? $Konto[8940] : 0;
	$Daten{"178b"} = $Daten{"179a"}*0.19;
	$Daten{"178a"} = int($Daten{"178a"});
   $Daten{"179a"} = ($Konto[8920])? $Konto[8920] : 0;
   $Daten{"179a"}+= ($Konto[8925])? $Konto[8925] : 0;
	$Daten{"179b"} = $Daten{"179a"}*0.19;
	$Daten{"179a"} = int($Daten{"179a"});
   $Daten{"275a"} = ($Konto[8300])? $Konto[8300] : "";
	$Daten{"275b"} = $Daten{"275a"}*0.07;
	$Daten{"275a"} = int($Daten{"275a"});
   $Daten{"195a"} = ($Konto[8945])? $Konto[8945] : 0;
	$Daten{"195b"} = $Daten{"195b"}*0.07;
	$Daten{"195a"} = int($Daten{"195a"});
   $Daten{"196a"} = ($Konto[8915])? $Konto[8915] : 0;
   $Daten{"196a"}+= ($Konto[8932])? $Konto[8932] : 0;
	$Daten{"196b"} = $Daten{"196b"}*0.07;
	$Daten{"196a"} = int($Daten{"196a"});
   $Daten{"155"} = ($Konto[8340])? int($Konto[8340]) : 0;      # bisher hier nur 16%-Erloese beruecksichtigt
   $Daten{"155"}+= ($Konto[8944])? int($Konto[8340]) : 0;      # bisher hier nur 16%-Erloese beruecksichtigt
	$Daten{"156"} = ($Konto[1775])? $Konto[1775]  : "";    # bisher hier nur 16%-UmSt beruecksichtigt
   if( $Daten{"landwirt"} ) {
	$Daten{"777"} = ($Konto[8336])? int($Konto[8336]) : 0;
	$Daten{"255"} = int($Daten{"255"});
	$Daten{"344a"}= int($Daten{"344a"});
	$Daten{"257"} = int($Daten{"257"});
	$Daten{"361"} = int($Daten{"361"});
   } else {
	$Daten{"777"} ="";
	$Daten{"255"} ="";
	$Daten{"256"} ="";
	$Daten{"344a"} ="";
	$Daten{"344b"} ="";
	$Daten{"257"} ="";
	$Daten{"258"} ="";
	$Daten{"361"} ="";
	}
   $Daten{"317"} = ($Konto[1799]<0)? $Konto[1799] : "";
   $Daten{"367"} = ($Daten{"317"}<0)? int($Daten{"317"}/0.19) :"";       #bisher hier nur 19%-Erloese beruecksichtigt
   $Daten{"319"} = ($Konto[1799]>0)? $Konto[1799] : "";

   $Daten{"Summe2"}=$Daten{"177b"}+$Daten{"178b"}+$Daten{"179b"}+$Daten{"275b"}+$Daten{"195b"}+$Daten{"196b"}+$Daten{"156"}+$Daten{"256"}+$Daten{"344b"}+$Daten{"258"}+$Daten{"317"}+$Daten{"319"};


	$Daten{"320"} = ($Konto[1560])? $Konto[1560] : 0;
	$Daten{"320"}+= ($Konto[1566])? $Konto[1566] : 0;
	$Daten{"320"}+= ($Konto[1570])? $Konto[1570] : 0;
	$Daten{"320"}+= ($Konto[1571])? $Konto[1571] : 0;
	$Daten{"320"}+= ($Konto[1575])? $Konto[1575] : 0;
	$Daten{"320"}+= ($Konto[1576])? $Konto[1576] : 0;
	$Daten{"761"} = ($Konto[1572])? $Konto[1572] : 0;
	$Daten{"761"}+= ($Konto[1573])? $Konto[1573] : 0;
	$Daten{"761"}+= ($Konto[1574])? $Konto[1574] : 0;
	$Daten{"762"} = ($Konto[1588])? $Konto[1588] : 0;
	$Daten{"466"} = ($Konto[1585])? $Konto[1585] : 0;
	$Daten{"467"} = ($Konto[1577])? $Konto[1577] : 0;
	$Daten{"467"}+= ($Konto[1579])? $Konto[1579] : 0;
	$Daten{"333"} = ($Konto[1587])? $Konto[1587] : 0;
	$Daten{"334"} = "";     #keine sk03-Nummer 7% fuer bestimmte kirchliche GbR und Vermoegensmassen (Fond)
	$Daten{"759"} = ($Konto[1584])? $Konto[1584] : 0;
	$Daten{"760"} = ($Konto[1589])? $Konto[1589] : 0;

   $Daten{"Summe3"}=$Daten{"320"}+$Daten{"761"}+$Daten{"762"}+$Daten{"466"}+$Daten{"467"}+$Daten{"333"}+$Daten{"334"}+$Daten{"759"}+$Daten{"760"};

   if( $Daten{"aend"} ) {
	$Daten{"357"} = $Daten{"86a"}+$Daten{"87a"}+$Daten{"88a"};
	$Daten{"359"} = $Daten{"86b"}+$Daten{"87b"}+$Daten{"88b"};
	}

   $Daten{"92a"} = Form::Zeigezahl($Daten{"Summe2"}, "2");

   #####################################################
   # Anlage UR  ########################################
   $Daten{"AnlageUR"}="";
   $Daten{"791"} = ($Konto[3550])? int($Konto[3550]) : 0;
   $Daten{"781a"} = ($Konto[3123])? int($Konto[3123]) : 0;
   $Daten{"781a"}+= ($Konto[3143])? int($Konto[3143]) : 0;
   $Daten{"781a"}+= ($Konto[3425])? int($Konto[3425]) : 0;
   $Daten{"781a"}+= ($Konto[3435])? int($Konto[3435]) : 0;
	$Daten{"781b"} = ($Konto[1769])? $Konto[1769] : 0;
	$Daten{"781b"}+= ($Konto[1774])? $Konto[1774] : 0;
	$Daten{"781b"}+= ($Konto[1777])? $Konto[1777] : 0;
   $Daten{"793a"} = ($Konto[3113])? int($Konto[3113]) : 0;
   $Daten{"793a"}+= ($Konto[3133])? int($Konto[3133]) : 0;
   $Daten{"793a"}+= ($Konto[3420])? int($Konto[3420]) : 0;
   $Daten{"793a"}+= ($Konto[3430])? int($Konto[3430]) : 0;
	$Daten{"793b"} = ($Konto[1772])? $Konto[1772] : 0;
   $Daten{"798"}  = ($Konto[3429])? int($Konto[3429]) : 0;
   $Daten{"798"} += ($Konto[3436])? int($Konto[3436]) : 0;
	$Daten{"799"} = ($Konto[1773])? $Konto[1773] : 0;
   $Daten{"794"} = ($Konto[8135])? int($Konto[8135]) : 0;
   $Daten{"794"}+= ($Konto[8137])? int($Konto[8137]) : 0;
	$Daten{"796"} = ($Konto[1784])? $Konto[1784] : 0;

   $Daten{"93a"} = $Daten{"781b"}+$Daten{"793b"}+$Daten{"799"}+$Daten{"796"};


   $Daten{"742"} = ($Konto[8130])? int($Konto[8130]) : 0;
   #Dreiecksauswahl
   $Daten{"751a"}=int($Daten{"751a"});
   $Daten{"781a"}-=$Daten{"751a"};
   $Daten{"781b"}-=$Daten{"751b"};
   $Daten{"746a"}=int($Daten{"746a"});
   $Daten{"793a"}-=$Daten{"746a"};
   $Daten{"793b"}-=$Daten{"746b"};
   $Daten{"747"}=int($Daten{"747"});
   $Daten{"798"}-=$Daten{"747"};
   $Daten{"799"}-=$Daten{"748"};
   #
   $Daten{"94a"}=$Daten{"751b"}+$Daten{"746b"}+$Daten{"748"};



   $Daten{"871"}+= ($Konto[3125])? int($Konto[3125]) : 0;
	if( $Daten{"871"}>0 ) { $Daten{"872"} = $Daten{"871"}*0.19; } # vorher unter #Subtraktionen 1574 abgezogen
   $Daten{"873"}+= ($Konto[3116])? int($Konto[3116]) : 0;
	if( $Daten{"873"}>0 ) { $Daten{"874"} = $Daten{"874"}*0.19; } # vorher unter #Subtraktionen 1798 abgezogen
   $Daten{"875"}+= ($Konto[3117])? int($Konto[3117]) : 0;
	if( $Daten{"875"}>0 ) { $Daten{"876"} = $Daten{"875"}*0.19; } # vorher unter #Subtraktionen 1798 abgezogen
   $Daten{"877"}+= ($Konto[3120])? int($Konto[3120]) : 0;
	$Daten{"797"} = ($Konto[1797])? $Konto[1797] : 0;
   $Daten{"883"}+= ($Konto[3125])? int($Konto[3125]) : 0;
	$Daten{"884"} = ($Konto[1796])? $Konto[1796] : 0;


   $Daten{"95a"} = $Daten{"8721"}+$Daten{"8743"}+$Daten{"876"}+$Daten{"878"}+$Daten{"884"};

   $Daten{"852"} = ($Daten{"852"})? int($Daten{"852"}) : 0; # 853 durch Abfrage ausgefuellt

   $Daten{"96a"} = $Daten{"853"};

   if( ( $Daten{"93a"}*1+$Daten{"94a"}*1+$Daten{"95a"}*1+$Daten{"96a"} )>0 ) { $Daten{"AnlageUR"}="1"; }
  
   if( $Daten{"AnlageUR"} ) {	      
	$Daten{"27a"}="X"; $Daten{"28a"}="";
	$Daten{"URsteuernummer"}=$Daten{"Ssteuernummer"};
	$Daten{"URvorname"}=$Daten{"Uvorname"};
	$Daten{"URnachname"}=$Daten{"Unachname"};
	$Daten{"URart"}=$Daten{"Uart"};
   } else { 
	$Daten{"27a"}="";  $Daten{"28a"}="X"; 
	$Daten{"URsteuernummer"}="";
	$Daten{"URvorname"}="";
	$Daten{"URnachname"}="";
	$Daten{"URart"}="";
	$Daten{"751b"}="";
	$Daten{"746b"}="";
	$Daten{"748"}="";
	$Daten{"872"}="";
	$Daten{"874"}="";
	$Daten{"876"}="";
	$Daten{"878"}="";
	$Daten{"833"}="";
	$Daten{"844"}="";
	$Daten{"853"}="";
	}


   #####################################################
   
   $Daten{"888"} = $Daten{"888EUR"};$Daten{"886"} = $Daten{"886EUR"};
   $Daten{"106a"} = Form::Zahl($Daten{"888"})+Form::Zahl($Daten{"886"});
   if( $Daten{"106a"}>0 ) { $Daten{"AnlageUN"}=1; }
 
   $Daten{"97a"} = $Daten{"357"};
   $Daten{"98a"} = Form::Zahl($Daten{"92a"})+Form::Zahl($Daten{"93a"})+Form::Zahl($Daten{"94a"})+Form::Zahl($Daten{"95a"})+Form::Zahl($Daten{"96a"})+Form::Zahl($Daten{"97a"});
   $Daten{"98a"} = Form::Zeigezahl($Daten{"98a"}, "2");
   $Daten{"99a"} = Form::Zeigezahl(($Daten{"Summe3"}*-1), "2");
   $Daten{"100a"} = $Daten{"359"};
   $Daten{"101a"} = Form::Zahl($Daten{"98a"})+Form::Zahl($Daten{"99a"});
   $Daten{"101a"} = Form::Zeigezahl($Daten{"101a"}, "2");
   $Daten{"318"} = $Daten{"318aEUR"}+$Daten{"318bEUR"};  
   $Daten{"331"} = $Daten{"331EUR"};
   $Daten{"391"} = $Daten{"391EUR"};
   $Daten{"105a"} = Form::Zahl($Daten{"101a"})+Form::Zahl($Daten{"318"})+Form::Zahl($Daten{"331"})+Form::Zahl($Daten{"391"});
   $Daten{"105a"} = Form::Zeigezahl($Daten{"105a"}, "2");
   $Daten{"816"} = Form::Zahl($Daten{"105a"})-Form::Zahl($Daten{"106a"});
   $Daten{"816"} = Form::Zeigezahl($Daten{"816"}, "2");
   $Daten{"108a"} = Form::Zahl($Daten{"108aEUR"})*-1;
   $Daten{"108a"} = Form::Zeigezahl($Daten{"108a"}, "2");

   $Daten{"820"} = Form::Zahl($Daten{"816"})+Form::Zahl(($Daten{"108a"}));
   $Daten{"820"} = Form::Zeigezahl($Daten{"820"}, "2");



   ################################################################
   } else { 					  # Quartalsmeldung
   ################################################################

   #Kontenbestand abfragen und Ausgabedaten erstellen

   #Voranmeldung
   $Daten{"41"} = ($Konto[8125])? int($Konto[8125]) : "";
   $Daten{"44"} = ($Konto[8135])? int($Konto[8135]) : "";
   $Daten{"49"} = ($Konto[8137])? int($Konto[8137]) : "";
   $Daten{"43"} = ($Konto[8150])? int($Konto[8150]) : "";
   $Daten{"48"} = ($Konto[8100])? int($Konto[8100]) : "";
   $Daten{"81"} = ($Konto[8400])? int($Konto[8400]) : 0;
   $Daten{"81"}+= ($Konto[8900])? int($Konto[8900]) : 0;
   $Daten{"81"}+= ($Konto[8935])? int($Konto[8935]) : 0;
   $Daten{"81"}+= ($Konto[8940])? int($Konto[8940]) : 0;
   $Daten{"81"}+= ($Konto[8920])? int($Konto[8920]) : 0;
   $Daten{"81"}+= ($Konto[8925])? int($Konto[8925]) : 0;
   	$Daten{"S81"} = ($Konto[1776])? $Konto[1776] : "";
	if( $Daten{"81"}*0.19>$Daten{"S81"} ||  ($Daten{"81"}+0.99)*0.19<$Daten{"S81"} ) {
		$Daten{"error"}.="<li>Die Bemessungsgrundlage in <b>Feld 81</b> passt nicht zum zugordneten Umsatzsteuerfeld, wenn die Umsatzteuer 19% betr&auml;gt.\n"; }
   $Daten{"86"} = ($Konto[8300])? int($Konto[8300]) : "";
   $Daten{"86"}+= ($Konto[8932])? int($Konto[8932]) : 0;
   $Daten{"86"}+= ($Konto[8945])? int($Konto[8945]) : 0;
   $Daten{"86"} = ($Konto[8915])? int($Konto[8915]) : 0;
   $Daten{"86"}+= ($Konto[8932])? int($Konto[8932]) : 0;
  	$Daten{"S86"} = ($Konto[1771])? $Konto[1771] : "";
	if( $Daten{"86"}*0.07>$Daten{"S86"} || ($Daten{"86"}+0.99)*0.07<$Daten{"S86"} ) {
		$Daten{"error"}.="<li>Die Bemessungsgrundlage in <b>Feld 86</b> passt nicht zum zugordneten Umsatzsteuerfeld, wenn die Umsatzteuer 7% betr&auml;gt.\n"; }
   $Daten{"35"} = ($Konto[8340])? int($Konto[8340]) : 0;      # bisher hier nur 16%-Erloese beruecksichtigt
   $Daten{"35"}+= ($Konto[8944])? int($Konto[8340]) : 0;      # bisher hier nur 16%-Erloese beruecksichtigt
   	$Daten{"36"} = ($Konto[1775])? $Konto[1775]  : "";    # bisher hier nur 16%-UmSt beruecksichtigt
	if( $Daten{"35"}*0.01>$Daten{"36"} || ($Daten{"35"}+0.99)*0.16<$Daten{"36"} ) {
		$Daten{"error"}.="<li>Die Bemessungsgrundlage in <b>Feld 35</b> passt nicht zum zugordneten Umsatzsteuerfeld, wenn die Umsatzteuer zwischen 1% und 16% betr&auml;gt.\n"; }
   $Daten{"77"} = ($Konto[8320])? int($Konto[8320]) : 0;
   $Daten{"77"}+= ($Konto[8336])? int($Konto[8320]) : 0;
   $Daten{"76"} = ($Konto[8315])? int($Konto[8315]) : "";
   	$Daten{"80"} = ($Konto[8315])? int($Konto[8315])*0.19 : ""; # Konto 1778 bereits vergeben
   $Daten{"91"} = ($Konto[3550])? int($Konto[3550]) : "";
   $Daten{"89"} = ($Konto[3425])? int($Konto[3425]) : "";
   	$Daten{"S89"} = ($Konto[1774])? $Konto[1774] : "";
   $Daten{"93"} = ($Konto[3420])? int($Konto[3420]) : "";
   	$Daten{"S93"} = ($Konto[3420])? int($Konto[3420])*0.07 : ""; # Konto 1772 nicht eindeutig 7%
   $Daten{"95"} = ($Konto[3430])? int($Konto[3430]) : 0;
   $Daten{"95"}+= ($Konto[3435])? int($Konto[3435]) : 0;
   	$Daten{"98"} = ($Konto[1779])? $Konto[1779] : "";
   $Daten{"94"} = ($Konto[3440])? int($Konto[3440]) : "";
   	$Daten{"96"} = ($Konto[1784])? $Konto[1784] : "";
   $Daten{"42"} = ($Konto[8130])? int($Konto[8130]) : "";
   $Daten{"68"} = ($Konto[8335])? int($Konto[8335]) : "";
   $Daten{"60"} = ($Konto[8337])? int($Konto[8337]) : "";
   $Daten{"21"} = ($Konto[8339])? int($Konto[8339]) : "";
   $Daten{"45"} = ($Konto[8338])? int($Konto[8338]) : "";


   $Daten{"47"} = ($Konto[1774])? int($Konto[1774]) : 0;
   	$Daten{"46"} = ($Konto[1774])? $Konto[1774]/1.19 : "";
   $Daten{"47"}+= ($Konto[1773])? int($Konto[1773]) : 0;
   	$Daten{"46"}+= ($Konto[1773])? $Konto[1773]/1.16 : "";
   $Daten{"52"} = ($Konto[3115])? int($Konto[3115]) : 0;
   $Daten{"52"}+= ($Konto[3125])? int($Konto[3125]) : 0;
   	$Daten{"53"} = ($Konto[1796])? $Konto[1796] : "";
   $Daten{"73"} = ($Konto[3116])? int($Konto[3116]) : "";
   	$Daten{"74"} = ($Konto[1798])? $Konto[1798] : "";
   $Daten{"78"} = ($Konto[3122])? int($Konto[3122]) : 0;
   	$Daten{"79"} = ($Konto[3122])? $Konto[3122]/1.19 : "";
   $Daten{"84"} = ($Konto[3120])? int($Konto[3120]) : 0;
   $Daten{"84"}+= ($Konto[3122])? int($Konto[3122]) : 0;
   $Daten{"84"}+= ($Konto[3130])? int($Konto[3130]) : 0;
   	$Daten{"85"} = ($Konto[1797])? $Konto[1797] : "";
   	$Daten{"65"} = ($Konto[1799])? $Konto[1799] : "";
   

	$Daten{"66"} = ($Konto[1566])? $Konto[1566] : 0;
	$Daten{"66"}+= ($Konto[1570])? $Konto[1570] : 0;
	$Daten{"66"}+= ($Konto[1571])? $Konto[1571] : 0;
	$Daten{"66"}+= ($Konto[1575])? $Konto[1575] : 0;
	$Daten{"66"}+= ($Konto[1576])? $Konto[1576] : 0;
   	$Daten{"66"}+= ($Konto[1585])? $Konto[1585] : 0;
   	$Daten{"61"} = ($Konto[1572])? $Konto[1572] : 0;
   	$Daten{"61"}+= ($Konto[1573])? $Konto[1573] : 0;
   	$Daten{"61"}+= ($Konto[1574])? $Konto[1574] : 0;
   	$Daten{"62"} = ($Konto[1588])? $Konto[1588] : "";
  	$Daten{"67"} = ($Konto[1577])? $Konto[1577] : "";
   	$Daten{"67"}+= ($Konto[1579])? $Konto[1579] : "";
   	$Daten{"63"} = ($Konto[1587])? $Konto[1587] : "";
   	$Daten{"64"} = ($Konto[1556])? $Konto[1556] : 0;
   	$Daten{"64"}+= ($Konto[1558])? $Konto[1558] : 0;
   	$Daten{"64"}-= ($Konto[1557])? $Konto[1557] : 0;
   	$Daten{"64"}-= ($Konto[1559])? $Konto[1559] : 0;
   	$Daten{"59"} = ($Konto[1584])? $Konto[1584] : "";

   	$Daten{"69"} = ($Konto[1783])? $Konto[1783] : 0;
   	$Daten{"69"}+= ($Konto[1589])? $Konto[1589] : 0;


  	$Daten{"Uebertrag"} = $Daten{"S81"}+$Daten{"S86"}+$Daten{"36"}+$Daten{"80"}+$Daten{"S89"}+$Daten{"S93"}+$Daten{"98"}+$Daten{"96"};

  	$Daten{"USt"} = $Daten{"Uebertrag"}+$Daten{"53"}+$Daten{"74"}+$Daten{"79"}+$Daten{"85"}+$Daten{"65"};

  	$Daten{"VSt"} = $Daten{"USt"}-$Daten{"66"}-$Daten{"61"}-$Daten{"62"}-$Daten{"67"}-$Daten{"63"}-$Daten{"64"}-$Daten{"59"};

   	$Daten{"Zwsumme"} = $Daten{"VSt"}+$Daten{"69"};

   	$Daten{"39"} = ($Konto[1781])? $Konto[1781] : "";

   	$Daten{"83"} = $Daten{"Zwsumme"}+$Daten{"39"};


   ################################################################
   }
   ################################################################



   my @Zahlen = keys (%Daten);
   foreach (@Zahlen) {
   	if( $Daten{$_} eq "0") {
		$Daten{$_}= "";
	}
   }

   my @Zahlen = keys (%Daten);
   foreach (@Zahlen) {
	if( $_ =~/[a-q]$/ && $Daten{$_} eq "1" ) {   # Im Kopf nicht mit "1" sondern "X" ankreuzen
		$Daten{$_}="X";
		 }
	elsif( $Daten{$_} =~ m/^(\-)?\d+\.\d+$/ or $Daten{$_} eq "0" ) {
		my $x=$Daten{$_};
		$Daten{$_}=Form::Zeigezahl($x,"2");
		}
	elsif( $_ =~ m/^\d/ && $Daten{$_} =~ m/^(\-)?\d+$/ ) { # nur Ganzzahlenfelder formatierten, nicht Uplz
		my $x=$Daten{$_};
		$Daten{$_}=Form::Zeigezahl($x,"0");
		}
	}

   print "Content-type: text/html\n\n";
   print '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
       "http://www.w3.org/TR/html4/loose.dtd">

<HTML>
<HEAD>  <TITLE>Lawsuit - Umsatzsteuervoranmeldung</TITLE>

	<link rel="icon" href="../favicon.ico" type="image/x-icon">
	<link rel="stylesheet" type="text/css" href="../stylesheets/lawsuit.css">
	<link rel="stylesheet" type="text/css" href="../stylesheets/',$Css,'.css">
</HEAD>
<BODY class="grund">

<BR><BR><BR>


	<TABLE cellpadding="50" cellspacing="0" align="center" width="600">
		<TR>
		<TD class="hell" align="left">
';
   if( $Daten{"Jahresmeldung"} ) {
	print Form::Formular(\%Daten, "ust_jahresmeldung_$Jahr.odt");
	print '<p><a href="../pdf/ust_jahreserklaerung_',$Jahr,'.pdf">ust_jahreserklaerung_',$Jahr,'.pdf</a>';
	if( $Daten{"AnlageUR"}  ) {
		print '<p>',Form::Formular(\%Daten, "ust_anlage_ur_$Jahr.sxw");
		print '<p><a href="../pdf/ust_anlage_ur_',$Jahr,'.pdf">ust_anlage_Ur_',$Jahr,'.pdf</a>';
		}
  } else {
	print Form::Formular(\%Daten, "ust_voranmeldung_$Jahr.sxw");
	print '<p><a href="../pdf/ust_voranmeldung_',$Jahr,'.pdf">ust_voranmeldung_',$Jahr,'.pdf</a>';
	}
   if( $Daten{"error"} ) {
	print '<p><div style="color:red">Plausibilit&auml;tsfehler!</div><ul>',$Daten{"error"},'</ul>', "\n";
	}
   print '	
		</TD>
		</TR>
	</TABLE>

<BR><BR><BODY><HTML>
';


}


