#!/usr/bin/perl -w 

   use Encode;    # fuer OpenOffice - Konvertierung in UTF-8     
   use File::Copy;# um Verzeichnis aus parties in clients zu verschieben und Ablage anzulegen

   use strict;
   use CGI;
   my $cgi = new CGI;
   use CGI::Carp qw(fatalsToBrowser);

   use lib "/home/matthias/lawsuit/cgi-bin/LS";
   use LS::Form;
   use LS::Stamm;


   my @Feldnamen = $cgi->param();
   my $Ueberspringe=0;
   my %Daten;
   my @Zeile;
   my $Zeile;
   my $Fritzzeile;
   my @Zeilen;
   my @Fritzzeilen;
   my @Woerter;
   my @Namensteil;
   my $Mandant;
   my $mandant;
   my $Gegner;
   my $Jahr;
   my $Fall;
   my @User;
   my $Anwaltsdatei;
   my $Kanzleidatei;
   my @Anwaltszeilen;
   my $Frei0=0;
   my $FreiA="A";
   my $FreiA0=0;
   my %return;
   my @return;
   my $return;

   my @Ges = qw(2#:#Frau 1#:#Herr 3#:#An&nbsp;die 4#:#An&nbsp;das 5#:#An&nbsp;den);
   my @Titel = qw(#:# Dr.#:#Dr. Prof.#:#Prof. Prof.&nbsp;Dr.#:#Prof.&nbsp;Dr. Mtre#:#Mtre Msgr.#:#Msgr. Dott.#:#Dott. Dott.ssa#:#Dott.ssa);
   my @Kontakt;
   my @Kontakte = @{Form::Auslesen("../data/kontakt.cfg")};
   foreach (@Kontakte) {
	@Woerter=split(/#?\:#?/,$_);
	$Zeile=$Woerter[0].'_'.$Woerter[1].'_'.$Woerter[2].'_'.$Woerter[3].'#:#'.$Woerter[0];
	push(@Kontakt, $Zeile);
	}
   my @Land;
   my @Laender=@{Form::Auslesen("../data/land.cfg")};
   foreach (@Laender) {
	@Woerter=split(/#?\:#?/,$_);
	$Zeile=$Woerter[0].'#:#'.$Woerter[0];
	push(@Land, $Zeile);
	}
   my @Bankland;
   my @Banklaender=@{Form::Auslesen("../data/bankland.cfg")};
   foreach (@Banklaender) {
	@Woerter=split(/#?\:#?/,$_);
	$Zeile=$Woerter[0].'#:#'.$Woerter[0];
	push(@Bankland, $Zeile);
	}


#########################################
# Grundeinstellungen
# Verzeichnisse cgi-bin, tmp, Clients nd Opponents (je mit Vorlage), 
# javascript (insb. prozessregister) und html # muessen bestehen
# Es folgt Einrichtung von Stylesheets, spaeter Anlage der Mandanten 
# incl. adresse.cfg und schreiben-Liste, cocoon fuer Formularausgabe 
# und Anlage der Fallverzeichnisse mit data
#########################################

## Wenn Pozessregister im externen Aufruf angegeben, gleich zu Stufe 2
   if( ($ENV{CONTENT_LENGTH} <= 0) && (length($cgi->param("Cprozessregister"))>0) ) { $Ueberspringe=1; }
#

   my @Gebiet=@{Form::Auslesen("../settings/rechtsgebiet.cfg")};

# funtioniert, aber einmal gespeichert reicht

#   my @Gebiete;
#   for( my $i=0; $i<=$#Gebiet; $i++ ) {
#	 @_ = split(/#:#/, $Gebiet[$i]);
#	 foreach (@_) { $_=~ s/\n//g; }
#	 push( @Gebiete, [@_] ); 
#         }
#
#   for(my $i=0;$i<=$#Gebiete;$i++) {
#	@Zeile=(
#'	.grund    { background-color : #'.$Gebiete[$i][3].'; }',"\n",
#'	.dunkel   { background-color : #'.$Gebiete[$i][2].'; }',"\n",
#'	.hell     { background-color : #'.$Gebiete[$i][4].'; }',"\n"
#	);
#	my $name=$Gebiete[$i][0];
#	open(DATEI, ">../stylesheets/$name.css") || die "Neue $name.css kann nicht geschrieben werden:\n$!";
#	   print DATEI @Zeile;
#	close(DATEI);
#   }


############################################################################################
if( $ENV{CONTENT_LENGTH} <= 0 && !$Ueberspringe ) {
############################################################################################


   $Daten{"rechtsgebieteHTML"}=Form::Ausklappmenue(\@Gebiet, "Crechtsgebiet", "AV", "", 200, 200, "");


   print $cgi->header(),
	 $cgi->start_html(-title =>'Lawsuit - Neuer Fall', -charset =>'utf8');
   print @{Form::HTML("stammdatenA", \%Daten)};
   print $cgi->end_html;


############################################################################################
} if( $cgi->param('stufe') eq "1" ) {
############################################################################################

  foreach my $Feld (@Feldnamen) {
       if( $cgi->param($Feld) )  {
          $Daten{$Feld} = $cgi->param($Feld);
       } else {
          $Daten{$Feld} = "";
       }
   }


  if ( length($Daten{"Ckurzrubrum"})>1 ) {

      @Woerter = split(/\.\/\./, Form::utf82html(encode("utf8",$cgi->param("Ckurzrubrum"))));
      $Mandant = $Woerter[0];
      $Gegner  = $Woerter[1];
      @Woerter = split(/\,/, $Mandant); 		#Vornamen in Strafsachen fuer die Suche abschneiden
      $Mandant = $Woerter[0];
      # irritierende Leerzeichen entfernen
      $Mandant = Stamm::Rubrumklar($Mandant);
      $Gegner = Stamm::Rubrumklar($Gegner);


      my @Partei=qw(M G W X);
      foreach my $P (@Partei) {


	my $Partei;
	my $partei;
	my $parteien;
	my $javaclick="onClick";
	if( $P eq "M" ) { $Partei=$Mandant; $partei="mandant"; $parteien="mandanten"; }
	if( $P eq "G" ) { $Partei=$Gegner; $partei="gegner"; $parteien="gegner"; }
	if( $P eq "W" ) { $Partei=$Mandant; $partei="widerstreitmandant"; $parteien="widerstreit"; }
	if( $P eq "X" ) { $Partei=$Gegner; $partei="widerstreitgegner"; $parteien="widerstreit"; }

	my $Auswahl="";
	$Daten{"auswahlhinweisHTML"}="&nbsp;";
	if( $Daten{"Crechtsgebiet"} eq "SR" and ( $P eq "G" or $P eq "X" ) ) {
		$Daten{"auswahlhinweisHTML"}="Zust&auml;ndige Staatsanwaltschaft/Polizeibeh&ouml;rde:"; $Auswahl="Staatsanwaltschaft"; 
		$javaclick="onClick"; }
 	if( $Daten{"Crechtsgebiet"} eq "BG" and ( $P eq "G" or $P eq "X" ) ) {
		$Daten{"auswahlhinweisHTML"}="Zust&auml;ndige Verfolgungsbeh&ouml;rde";	$Auswahl="Verwaltungstraeger";
		$javaclick="onChange"; }

        $Partei=~s/\s//g; # Leerzeichen in diesem Teilrubrum entfernen
        my @Adressen=@{Stamm::Adressliste($Partei, "P", "$Auswahl")}; # mit Altadressen vergleichen
	my @Options =@{Stamm::Adressliste($Partei, $P, "$Auswahl")}; # aktuelle Faelle anhaengen
	if( $P eq "M" or $P eq "G" ) {
		foreach (@Adressen) { push(@Options, $_); }
		@Options=sort(From2Sort @Options);
		}

        $Daten{$partei."HTML"}=Form::Ausklappmenue(\@Options, "$parteien", "", 10, 200, 200, $javaclick.'=javascript:found("'.$parteien.'")');
	
	if( $Auswahl ne "" ) {  $Daten{"widerstreitgegnerHTML"} = " ";  }

	}


  } else {

      $Daten{"mandantHTML"} = " ";
      $Daten{"gegnerHTML"} = " ";
      $Daten{"widerstreitmandantHTML"} = " ";
      $Daten{"widerstreitgegnerHTML"} = " ";

      }

  if ( length($Daten{"widerstreitmandantHTML"})>1 ) { 
      $Daten{"widerstreitmandantHTML"} = '			<P>
			<FONT FACE="Helvetica, sans-serif" COLOR="red">M&ouml;gliche widerstreitende Interessen mit:</FONT><BR>'."\n".$Daten{"widerstreitmandantHTML"};
      }
  if ( length($Daten{"widerstreitgegnerHTML"})>1 ) { 
      $Daten{"widerstreitgegnerHTML"} = '			<P>
			<FONT FACE="Helvetica, sans-serif" COLOR="red">M&ouml;gliche widerstreitende Interessen mit:</FONT><BR>'."\n".$Daten{"widerstreitgegnerHTML"};
      }


  ### Zwischenseite nur auswerfen, wenn ueberhaupt neue Inhalte vorhanden
  if ( length($Daten{"mandantHTML"})>1 || length($Daten{"gegnerHTML"})>1 || length($Daten{"widerstreitHTML"})>1) { 
	print $cgi->header(),
	     $cgi->start_html(-title =>'Lawsuit - Neuer Fall', -charset =>'utf8');
	print @{Form::HTML("stammdatenB", \%Daten)};
	print $cgi->end_html;
	}
  else  {
	$Ueberspringe=1;
	}


############################################################################################
} if( $cgi->param('stufe') eq "2" || $cgi->param('stufe') eq "3" || $Ueberspringe ) {
############################################################################################

        @Woerter=split(/\//, $cgi->param("Cprozessregister"));
	$Jahr=$Woerter[1];
	$Fall=$Woerter[0];


   if( ($ENV{CONTENT_LENGTH} <= 0) && (length($cgi->param("Cprozessregister"))>0) ) {  # Aufruf aus Prozessregistersuche

        %Daten=%{Form::Auslesen_Spiegel("../../Documents/$Jahr/$Fall/data/stammdaten.cfg". "", "")};
	# Alte Fehlvariablen loeschen
	  delete $Daten{"Csw"};
	  delete $Daten{"Cgb"};

   } else {                                                                           # Aufruf aus Neuer Fall

   ###### Felder mit Leerdaten fuellen, sofern nicht im Folgenden veraendert ######
 
        %Daten=%{Form::Auslesen_Spiegel("./tmp/vorlage.cfg", "", "")};   #Eingabefelder mit Leerzeichen fuellen
        foreach my $Feld (@Feldnamen) {
            if( $cgi->param($Feld) )  {
               $Daten{$Feld} = Form::utf82html(encode("utf8", $cgi->param($Feld)));
	       $Daten{$Feld}=~s/undefined(&nbsp;)?//g;
            } else {
               $Daten{$Feld} = "";
            }
        }
	$Daten{"Ckurzrubrum"}=~s/&frasl;/\//g;
	@Woerter=split(/\.\/\./, Form::utf82html(encode("utf8",$cgi->param("Ckurzrubrum"))));
	$Daten{"mrohname"} =$Woerter[0]; 
	$Daten{"grohname"} =$Woerter[1];

   }

	# Servertest
	my $serverup=0;
	eval {
		my $ping = "iustus.eu";
		# Leise Pingen und aus der 1. "transmitted"-Zeile, auf "1 received"=1 testen, 1 sec warten
		unless( system("ping -q -c 1 -W 1 $ping | grep -P 1.received >/dev/null") ) { } #$serverup=1; }
	};
	if ( $serverup ) {
		$Daten{"server"} = "http://www.iustus.eu";
		$Daten{"hinweisaufserver"} = "";
	} else {
		$Daten{"server"} = 'http://k1/lawsuit';
		$Daten{"hinweisaufserver"} = '&nbsp;-- ohne Serveranbindung --&nbsp;';
	}
	# bei Typen- und Formwechsel dennoch Prozessregisterabwahl erhalten
        if( $Daten{"mchange"} or $Daten{"gchange"} ) {
		$Daten{"azchecked"} = ($Daten{"Prozessregister"})? "checked" : ""; }
	# fuer Ablage geaendert, vorher="checked"
	else {	$Daten{"azchecked"} = ""; }




   ###### Dateinamen kreieren #####################



   my @Partei=qw(M G);
   if( $Daten{"Crechtsgebiet"} eq "AB" or $Daten{"Crechtsgebiet"} eq "PI" ) {
	pop(@Partei);
	}
   my $z;  # fuer Cm?file
 
   foreach (@Partei) {


	my $P = $_;
	my $p = lc($P);
	my $Partei;
	my $Parteiname;
	my $Parteien;
	my $partei;
	my $verzeichnis;

	if( $P eq "M" ) { $Parteiname="Mandant"; $Parteien="Mandanten"; $verzeichnis="clients"; }
	if( $P eq "G" ) { $Parteiname="Gegner"; $Parteien="Gegner"; $verzeichnis="opponents"; }
	if( $Daten{"C".$p."quelle"} eq "P" ) { $verzeichnis="parties"; }

	$Daten{$p."rohname"}=Stamm::Rubrumklar($Daten{$p."rohname"});
	$Partei = $Daten{$p."rohname"};


	# Fuer weitere Beteiligte neuen zusammengesetzten Dateinamen abfragen, Hilfsfeld im Rubrum bewahrt Hauptnamen
	# Sinn der folgenden Java-Anweisung: Hilfsfeld im Rubrum wird bei Cmfile selbst noch
	# angepasst, bei weiteren Beteiligten wird es zur harmlosen In-sich-Schleife
	##########################

	$z=$Daten{$p."zaehler"};
	unless ($z>0) { $z=""; }
	if( length($Daten{"C".$p.$z."file"})>0 && $Daten{"C".$p.$z."file"} ne "vorlage" ) {
					                # Uebergabae aus Hidden-Field, ansonsten neu zusammenstellen
	    $Partei = $Daten{"C".$p.$z."file"}; 
	    $partei = Form::html2utf8($Partei);
	    $Daten{"uebernahme"}.=$P;
	    }	
	else {
	    my @Woerter=split(/\,\s/, $Partei);
	    $Partei=$Woerter[0].substr($Woerter[1],0,1);
	    $Partei =~ s/[\.\,\s ]//g;                  # Leer- und Hilfseichen entfernen: Atalan, &Ouml;.
	    $Partei =~ s/&nbsp;//g;
	    $Partei = lc($Partei);                      # Standardnamen erzeuten Atalanö
#	    $Partei =~ s/&A/&a/g;                       # Kleinbuchstaben für Ährenfeld
#	    $Partei =~ s/&E/&e/g;                       # Kleinbuchstaben für État
#	    $Partei =~ s/&O/&o/g;                       # Kleinbuchstaben für Özcan
#	    $Partei =~ s/&U/&u/g;                       # Kleinbuchstaben für Überlingen
	    $partei = "vorlage";
	    }

	$Daten{"C".$p.$z."file"}=$Partei;               # Gewaehlten Dateinamen in Eingabefeld sichtbar machen

 


   ###### Mandanten und Gegner anlegen, Verzeichnisse anlegen, wenn mehrere Beteiligte ######

	# Bereits weitere Beteiligte?


   ###### Mandanten und Gegner anlegen,
	if( $Daten{$p."change"} && $partei ne "vorlage" ) {
	    unless ( -e "../$verzeichnis/$partei" ) {
		mkdir("../$verzeichnis/$partei") || die "Neuer $Partei $partei kann im Verzeichnis $verzeichnis nicht angelegt werden :\n$!";
		chmod(0777, "../$verzeichnis/$partei");
		}
	    elsif ( -e "../$verzeichnis/$partei/adresse.cfg" ) {
        	my @Zeilen = @{Form::Auslesen("../$verzeichnis/$partei/adresse.cfg")};
		  open(DATEI, ">>../$verzeichnis/$partei/adresse.old") || die "Die Datei adresse.old kann unter $partei nicht beschrieben werden :\n$!";
			print DATEI Form::Datum(3,0)," ########################################\n";
			print DATEI @Zeilen;
		  close(DATEI);
		  chmod(0777, "../$verzeichnis/$partei/adresse.old");
        	}
	    Form::Speichern_Spiegel( \@Feldnamen, \%Daten, "../$verzeichnis/$partei/adresse.cfg", "$P");

            if( $Daten{"C".$p."zahl"}>0 && length($Daten{$P."name"})>0 ) {
		open(DATEI, "<../$verzeichnis/all.cfg") || die "Die Datei $verzeichnis/all besteht nicht, oder Sie haben keine Leseberechtigung:\n$!";
			@Zeilen = <DATEI>; 
		close(DATEI);
		$Zeile=Form::Liste($P, $z, \%Daten, \%Daten);
		# Userpasswort Online-Archiv#
		if(-e "../../Documents/$Jahr/$Fall/user.cfg") {
			@User=@{Form::Auslesen("../../Documents/$Jahr/$Fall/user.cfg")}; }
		$User[$Daten{$p."zaeler"}]=$Daten{$P."user"}.':'.crypt($Daten{$P."passwort"},"IN")."\n";
		if( $Daten{$P."online"} ) { Form::Speichern("../../Documents/$Jahr/$Fall/data/user.cfg", \@User, "In $Jahr/$Fall/data kann user.cfg nicht geschrieben werden oder Sie haben keine Schreibberechtigung:\n$!"); }
		# FritzBox #
		my $Wo=($Daten{$P."typ"} eq "Person" || $Daten{$P."typ"} eq "Mehrheit")? "home" : "work";
		$Fritzzeile="<contact><category>0</category><person><realName>".Form::fritzform($Daten{$P."name"})."</realName><ImageURL /></person><telephony>";
		if( $Daten{$P.'telefon'} ) { $Fritzzeile.='<number type="'.$Wo.'" quickdial="" vanity="" prio="1">'.Form::fritzform($Daten{$P.'telefon'}).'</number>'; }
		if( $Daten{$P.'handy'} ) { $Fritzzeile.='<number type="mobile" quickdial="" vanity="" prio="">'.Form::fritzform($Daten{$P.'handy'}).'</number>'; }
		$Fritzzeile.='</telephony><services /><setup /></contact>';
		unless( $Fritzzeile =~ m/quickdial/ ) { $Fritzzeile=""; }  # nur Leute mit Telefon aufnehmen
		############
		foreach (@Zeilen) { if( Form::html2utf8(\$_) =~ m/^$partei/g ) { $Zeilen[$.]=$Zeile; $Zeile="";} }
		if ( length($Zeile)>0 ) { 
			push (@Zeilen, $Zeile); 
			push (@Fritzzeilen, $Fritzzeile);
			}
		@Zeilen=sort(@Zeilen);
		Form::Speichern("../$verzeichnis/all.cfg", \@Zeilen, "In $verzeichnis kann nicht geschrieben werden oder Sie haben keine Schreibberechtigung fuer die Liste all:\n$!");
		Stamm::Fritz(\@Fritzzeilen);
		}

	    }

        ##### Weitere #######
	if( $Daten{"C".$p."zahl"}*1>0 ) {
		@Zeilen=split(/\<BR\>/, $Daten{"C".$p."weiter_beteiligt"} );
		$Zeilen[0]="Auf ".$Parteien."seite&#58;";
		while( $#Zeilen<$Daten{"C".$p."zahl"}*1 ) { push(@Zeilen, "&nbsp;"); }
		if( $Daten{$p."zaehler"}*1>=1 ) {
			$Zeilen[($Daten{$p."zaehler"}*1)]=($Daten{$p."zaehler"}*1).". ".$Daten{$P."anrede"}." ".$Daten{$P."name"}."; ".$Daten{$P."strasse"}."; ".$Daten{$P."land"}."-".$Daten{$P."plz"}." ".$Daten{$P."stadt"}; }
		$Daten{"C".$p."weiter_beteiligt"}=join("<BR>", @Zeilen); 
		}
	else {
		$Daten{"C".$p."weiter_beteiligt"}="";
		}
	if( length($Daten{$p."weitererer"})>0 ) { 
		if(    $Daten{$p."weitererer"} eq "&minus;" ) { $Daten{$p."zaehler"}--; }
		elsif( $Daten{$p."weitererer"} =~ m/\d/ ) { $Daten{$p."zaehler"}++; } #Pluszeichen wird von Perl als Zahl interpretiert!
		}
	my $k=0; #Korrekturwert fuer altbekannte Adresse 
	$z=$Daten{$p."zaehler"}*1; 
	unless ($z>0) { $z=""; }
	my $file=$Daten{"C".$p.$z."file"}; #Leerfeld auswerfen, wenn neuer Beteiligter
	if( $Daten{$p."zaehler"}>0 ) {
		$Daten{$P."weiterbutton"}='<INPUT TYPE=BUTTON NAME="'.$p.'zurueck" onClick=javascript:weiterer("'.$P.'","-") VALUE="   <   ">'; }
	if( $Daten{$p."zaehler"}*1>$Daten{"C".$p."zahl"}*1 ) {
		@Woerter = split(/,/, Form::html2utf8($Daten{$P."name"}));	#fuer Beteiligte_lang
		$Daten{$P."rohname"} = Form::utf82html($Woerter[0].", ".substr($Woerter[1],0,1));
		$k=1; $file=""; # Skript schlaegt bekannte Adresse fuer neuen Beteiligten vor
		}
	if( $Daten{"C".$p."zahl"}*1>0 ) {
		$Daten{$P."loeschen"}='<INPUT TYPE=BUTTON NAME="'.$p.'loeschen"  onClick=javascript:loeschen("C'.$p.$z.'file") VALUE=" L&ouml;schen ">'; 
		} else { $Daten{$P."loeschen"}=""; }
	if( $Daten{$p."zaehler"}*1>=$Daten{"C".$p."zahl"}*1 ) {
		$Daten{$P."weiterbutton"}.='<INPUT TYPE=BUTTON NAME="'.$p.'weiterer"  onClick=javascript:weiterer("'.$P.'","+") VALUE="   Weiterer '.$Parteiname.'   ">'; 
		}
	else {  
		$Daten{$P."weiterbutton"}.='<INPUT TYPE=BUTTON NAME="'.$p.'weiterer" 		onClick=javascript:weiterer("'.$P.'","+") VALUE="   >   ">'; }

	# Zweite Partei-Definition mit hochgezaehltem zaehler fuer naechste Beteiligte (z.B. Partei 2/3)
	$z=$Daten{$p."zaehler"}*1-$k; # naechste Beteiligte (s.o.++)
	unless ($z>0) { $z=""; }
	if( $Daten{"C".$p.$z."file"} && $partei ne "vorlage" ) {
					                # Uebergabae aus Hidden-Field, ansonsten neu zusammenstellen
	    $Partei = $Daten{"C".$p.$z."file"}; 
	    $partei = Form::html2utf8($Partei);
	    $Daten{"uebernahme"}.=$P;
	    }	
        my $zk=$Daten{$p."zaehler"}*1;
	unless ($zk>0) { $zk=""; }
        $Daten{$Parteien."datei"}=qq| 					<INPUT TYPE=text NAME="C|.$p.$zk.qq|file"  MAXSIZE=50 VALUE="|.$file.qq|" style="background-color:#cccccc;" onClick="alert('Um einen neuen Datensatz anzulegen, bearbeiten Sie bitte zuerst den Namen!');" onChange="document.getElementsByName('C|.$p.$zk.qq|file')[0].value=this.value;" readonly>|;

   ###### Wenn Uebergabe aus vorhandenen Daten, dann einlesen, ansonsten ermittelten neuen $Mandanten bzw $Gegner verwenden 

   if( $Daten{$p."zaehler"}*1 < 0 ) { $Daten{$P."zaehler"} = 0; }

   if( $Daten{"stufe"} eq "3" && ( $cgi->param($p."change") || length($cgi->param("C".$p."file"))>0 ) ) {

	if( $Daten{"C".$p."quelle"} eq "P" ) { ## wenn Daten aus Parties geholt werden, dann all.cfg anpassen, sofern nicht leeres Vorlagenfeld
		Form::Move("../parties/$partei/*", "../$verzeichnis/$partei") || die "$Partei kann nicht aus parties in $verzeichnis verschoben werden: $!";
		my @Parteien=@{Form::Auslesen("../parties/all.cfg")};
		my $x=0; my $y; foreach (@Parteien) { if( $_=~/^$Partei\#*/) {$y=$x;} $x++; }
		$Zeile=splice(@Parteien, $y, 1)."\n";
		Form::Speichern("../parties/all.cfg", \@Parteien, "die Datei parties/all.cfg kann nicht beschrieben werden :\n$!");
		my @Parteien=@{Form::Auslesen("../$verzeichnis/all.cfg")};
		push(@Parteien, $Zeile); @Parteien=sort(@Parteien);
		Form::Speichern("../$verzeichnis/all.cfg", \@Parteien, "die Datei $verzeichnis/all.cfg kann nicht beschrieben werden :\n$!");
		}
	}


   if( $Daten{"Cgquelle"} eq "M" ) { $verzeichnis="clients"; } # Fuer widerstreitende Interessen bei Anwaltshonorar

   unless (-e "../$verzeichnis/$partei" || $partei eq "vorlage") { $verzeichnis="parties"; } 

   my %Adresse=%{Form::Auslesen_Spiegel("../$verzeichnis/$partei/adresse.cfg", "", "")};

	# Alte Fehlvariablen loeschen
	  delete $Daten{"Csw"};
	  delete $Daten{"Cgb"};
   foreach (keys(%Adresse)) {
	my $neu = $_;
	if( $Daten{"C".$p."quelle"} eq "P" or $verzeichnis eq "parties" ) { $neu =~s/^P/$P/; }
	if( $Daten{"Cgquelle"} eq "M" ) { $neu =~s/^M/$P/; } # Fuer widerstreitende Interessen bei Anwaltshonorar
	$Daten{$neu} = $Adresse{$_};


	# Vorschlag fuer neuen Datensatz bereinigen
	if( $Daten{$p."zaehler"}*1>$Daten{"C".$p."zahl"}*1 ) {
		$Daten{$P."ges"}="1";
		$Daten{$P."name"}="";
		$Daten{$P."vorname"}="";
		$Daten{$P."nachname"}="";
		$Daten{$P."geboren"}="";
		$Daten{"C".$p."zahl"}=$Daten{$p."zaehler"};
		}
	}

   }# Ende Partei

   my $Auswahl=$Daten{"TatortLand"} ||= "D";
   $Daten{"TatortLand"}=Form::Ausklappmenue(\@Land, "Cland", $Auswahl, "", 30, 100, "");
   $Daten{"TatortGericht"}='&nbsp;&nbsp;<a href=javascript:justizadresse("Cplz")><img src="../img/court.gif" height=15 width=15 border=""></a>'; 


   my $Rechtsgebiet=$Daten{"Crechtsgebiet"};
   # Vereinfachen, wenn Zivilrecht (ausser Familienrecht)
   if( $Rechtsgebiet eq "AV" || $Rechtsgebiet eq "AG" || $Rechtsgebiet eq "MP" || $Rechtsgebiet eq "DR" || $Rechtsgebiet eq "VR" || $Rechtsgebiet eq "ER" || $Rechtsgebiet eq "ZV" || $Rechtsgebiet eq "AB" || $Rechtsgebiet eq "IK" ) { $Rechtsgebiet="ZR"; }
   if( $Rechtsgebiet eq "SR" || $Rechtsgebiet eq "BG" || $Rechtsgebiet eq "SN" ) { $Rechtsgebiet="SR"; }
   my @Gerichte = @{Form::Auslesen("../courts/$Rechtsgebiet.cfg", "", "")};
   for( my $i=0; $i<=$#Gerichte; $i++ ) {
        @_ = split(/#:#/, $Gerichte[$i]);
	foreach (@_) { $_=~ s/\n//g; }
	$Daten{"GerichteHTML"}.= "
	     gerichte[$i] = new Object();
	     gerichte[$i]".'["land"] = "'.@_[0].'";
	     '."gerichte[$i]".'["plz"] = "'.@_[1].'";';
   	for( my $k=1; $k<=4; $k++ ) {
	     $Daten{"GerichteHTML"}.= "
	     gerichte[$i]".'["'.$k.'"] = "'.@_[($k+1)].'";';
	     }
	}

   #Rubrum
   my @Folge = qw(#:# I#:#I II#:#II III#:#III IV#:#IV V#:#V VI#:#VI VII#:#VII VIII#:#VIII IX#:#IX X#:#X XI#:#XI XII#:#XII XIII#:#XIII XIV#:#XIV XV#:#XV XVI#:#XVI XVII#:#XVII XVIII#:#XVIII XIX#:#XIX XX#:#XX XXI#:#XXI XXII#:#XXII XXIII#:#XXIII XXIV#:#XXIV XXV#:#XXV XXVI#:#XXVI XXVII#:#XXVII XXVIII#:#XXVIII XXIX#:#XXIX XXX#:#XXX XXXI#:#XXXI XXXII#:#XXXII XXXIII#:#XXXIII XXXIV#:#XXXIV XXXV#:#XXXV XXXVI#:#XXXVI XXXVII#:#XXXVII XXXVIII#:#XXXVIII XXXIX#:#XXXIX XL#:#XL);
   my $Auswahl=$Daten{"Cfolge"};	
   $Daten{"Folge"}= Form::Ausklappmenue(\@Folge, "Cfolge", $Auswahl, "", 20, 50);


   #Fuer jede Partei den eigenen Typenkopf bilden
   my @Partei=qw(M G);
   if( $Daten{"Crechtsgebiet"} eq "AB" or $Daten{"Crechtsgebiet"} eq "PI" ) {
	pop(@Partei);
	}
   foreach (@Partei) {


	my $P = $_;
	my $p = lc($P);
	my $Partei;
	my $Parteien;
	if( $P eq "M" ) { $Partei="Mandant"; $Parteien="Mandanten" }
	if( $P eq "G" ) { $Partei="Gegner"; $Parteien="Gegner" }
 	if( $Daten{"Crechtsgebiet"} eq "BG" and ( $P eq "G" or $P eq "X" ) ) { 
		# Gtyp muss gesetzt sein, bevor StammdatenC aufgerufen wird, sonst kein Geinschub
		$Daten{"Gtyp"}='Verwaltungstraeger'; }

	my %NeueDaten = %{Stamm::Typ($P, \%Daten, \@Ges, \@Land, \@Titel)};
	foreach (keys(%NeueDaten)) {
		$Daten{$_} = $NeueDaten{$_};
	} 


   my $Auswahl;

   $Auswahl=$Daten{$P."ges"} ||= 1;
   $Daten{$Partei."Ges"}=Form::Ausklappmenue(\@Ges, $P."ges", $Auswahl, "", 40, 150, q~onChange="javascript:anrede('~.$P.q~')"~);
   $Auswahl=$Daten{$P."titel"} ||="";
   $Daten{$Partei."Titel"}=Form::Ausklappmenue(\@Titel, $P."titel", $Auswahl, "", 40, 150, q~onChange="javascript:anrede('~.$P.q~')"~);   
   $Auswahl=$Daten{$P."kontakt"} ||="formell_Sehr geehrter Herr_Sehr geehrte Frau_Mit freundlichen Gr&uuml;&szlig;en";
   $Daten{$Partei."Kontakt"}=Form::Ausklappmenue(\@Kontakt, $P."kontakt", $Auswahl, "", 40, 300, q~onChange="javascript:anrede('~.$P.q~')"~);
   $Auswahl=$Daten{$P."bankland"} ||="DE";
   $Daten{$Partei."bankland"}=Form::Ausklappmenue(\@Bankland, $P."bankland", $Auswahl, "", 40, 200, q~onChange="javascript:ibanformat('~.$P.q~')"~);

   #$Daten{$p."zaehler"}||=0;                                  # in Zahl ueberfuehren
   $Daten{$p."zaehler"} = ( $Daten{$p."zaehler"}<0 )? 0 : $Daten{$p."zaehler"}; 
   $Auswahl=$Daten{$P."land"} ||= "D";
   $Daten{$Partei."Land"}=Form::Ausklappmenue(\@Land, $P."land", $Auswahl, "", 30, 100, "");

   my @Repnummer = qw(0#:#Alleinvertretungsberechtigten 1#:#zwei&nbsp;gemeinschaftlich 2#:#drei&nbsp;gemeinschaftlich 3#:#vier&nbsp;gemeinschaftlich 4#:#f&uuml;nf&nbsp;gemeinschaftlich 5#:#sechs&nbsp;gemeinschaftlich 6#:#sieben&nbsp;gemeinschaftlich);
   $Auswahl=$Daten{$P."repnummer"} ||= 0;
   $Daten{$P."Repnummer"}=Form::Ausklappmenue(\@Repnummer, $P."repnummer", $Auswahl, "", 100, 300, 'onChange=javascript:addrepresentation("'.$P.'vertreten")' );


   # Angezeigte Gerichtslinks an Rechtsgebiet anpassen

	$Daten{"MandantGericht"}='&nbsp;&nbsp;<a href=javascript:justizadresse("Mplz")><img src="../img/court.gif" height=15 width=15 border=""></a>'; 
	$Daten{"GegnerGericht"}='&nbsp;&nbsp;<a href=javascript:justizadresse("Gplz")><img src="../img/court.gif" height=15 width=15 border=""></a>';

   # Boolens fuellen
   $Daten{"Cmuntervollmacht"}=($Daten{"Cmuntervollmacht"})? "checked" : "";
   $Daten{"Mrechtsschutzversicherung"}=($Daten{"Mrechtsschutzversicherung"})? "checked" : "";
   $Daten{"Mpkh"}=($Daten{"Mpkh"})? "checked" : "";
   $Daten{"Mberatungshilfe"}=($Daten{"Mberatungshilfe"})? "checked" : "";
   $Daten{"Mhiddenonline"}=($Daten{"Monline"})? "table-row" : "none";
   $Daten{"Monline"}=($Daten{"Monline"})? "checked" : "";
   $Daten{"Muser"}||="";     # kann entfallen, nur fuer Altdateien, jetzt durch vorlage.cfg geloest
   $Daten{"Mpasswort"}||=""; # kann entfallen, nur fuer Altdateien, jetzt durch vorlage.cfg geloest

   ###### Alle bereits eingegebenen Beteiligten weitergeben

   $Daten{"GegnerDateien"}='<INPUT TYPE=TEXT NAME="Cgfile" VALUE="vorlage" class="grund">', "\n"; # fuer blosse Beratung
   $Daten{$Parteien."Dateien"}="";
   $Daten{$P."aktion"}="";
   my $Zahl = $Daten{"C".$p."zahl"};
   for(my $i=0;$i<=$Zahl;$i++) {
	 my $Feld = ($i==0)? "C".$p."file": "C".$p.$i."file";
         $Daten{$Parteien."Dateien"} .= '
	<INPUT TYPE=TEXT NAME="'.$Feld.'" VALUE="'.$Daten{$Feld}.'" class="grund"><br>';
	 $Daten{$P."aktion"} = qq|onBlur="createname('|.$P.qq|',|.$i.qq|,this.name);"|;
         }

   }# Ende Partei


   ## Altfaelle
   if( $Daten{"Cstreitwert"} ) { $Daten{"Cswin"} = $Daten{"Cstreitwert"}; }
   elsif( $Daten{"CswEUR"} ) { $Daten{"Cswin"} = $Daten{"CswEUR"}; }
   if ( $Daten{"Cswin"} ) { $Daten{"Cswout"} = Form::Zahl($Daten{"Cswin"}); }
   else { $Daten{"Cswin"} = ""; }
   if( $Daten{"Cgebuehr"} ) { $Daten{"Cgbin"} = $Daten{"Cgebuehr"}; }
   elsif( $Daten{"CgbEUR"} ) { $Daten{"Cgbin"} = $Daten{"CgbEUR"}; }
   if ( $Daten{"Cgbin"} ) { $Daten{"Cgbout"} = Form::Zahl($Daten{"Cgbin"}); }
   else { $Daten{"Cgbin"} = ""; }
   if( Form::Zahl($Daten{"Cggb"})<=32 ) { $Daten{"Cggb"}="32"; }
   $Daten{"Gversicherungsname"} ||="";
   $Daten{"Gversicherungsnr"} ||="";

   ################# 


   $Daten{"Streitwertabfrage"}='			<TR style="display:none">
				<TD WIDTH=200 ALIGN=RIGHT class="hell" \>
				<TD WIDTH=426 ALIGN=LEFT class="hell">
					
					<INPUT TYPE=TEXT NAME="CswEUR" SIZE=8 MAXLENGtH=35 VALUE="">

				</TD>';
   unless( $Daten{"Crechtsgebiet"} eq "SR" || $Daten{"Crechtsgebiet"} eq "BG" || $Daten{"Crechtsgebiet"} eq "SN" || $Daten{"Crechtsgebiet"} eq "SG" ) { 
	$Daten{"Streitwertabfrage"} = '			<TR>
				<TD WIDTH=200 ALIGN=RIGHT class="hell">
					Streitwert (vorl.):&nbsp;&nbsp;
				</TD>
				<TD WIDTH=426 ALIGN=LEFT class="hell">
					
					<INPUT TYPE=TEXT NAME="Cswin" SIZE=8 MAXLENGtH=35 VALUE="'.$Daten{"Cswin"}.'" onChange=javascript:streitwert("Cswin") style="text-align:right">&nbsp;EUR
					<INPUT TYPE=HIDDEN NAME="Cswout" VALUE="'.$Daten{"Cswout"}.'">&nbsp;mit einer Geb&uuml;hr von&nbsp;
					<INPUT TYPE=TEXT NAME="Cgbin" SIZE=8 MAXLENGtH=35 VALUE="'.$Daten{"Cgbin"}.'" READONLY style="text-align:right">&nbsp;EUR
					<INPUT TYPE=HIDDEN NAME="Cgbout" SIZE=10 MAXLENGtH=35 VALUE="'.$Daten{"Cgbout"}.'">
				</TD>

			</TR>
';   
	my @Beteiligte="0#:#0 weitere Beteiligte";
	for(my $x=1;$x<=$Daten{"Cmzahl"};$x++) {
		push(@Beteiligte, "$x#:#$x weitere Beteiligte");
		}
	my $Auswahl=($Daten{"Cbet"})? $Daten{"Cbet"} : $Daten{"Cmzahl"};
	$Daten{"AuswahlBeteiligte"}=Form::Ausklappmenue(\@Beteiligte, "Cbet", $Auswahl, "", 127, 127, qq~onClick="javascript:VV1008('~.$Daten{"Crechtsgebiet"}.qq~')"~);
        $Daten{"Cvorschussin"} ||=($Daten{"Cgbout"}*1<=45 && $Auswahl<=1)?  Form::Zeigezahl((($Daten{"Cgbout"}*1.3+$Daten{"Cgbout"}*$Auswahl*0.3)*1.2*1.19),2) : Form::Zeigezahl((($Daten{"Cgbout"}*1.3+$Daten{"Cgbout"}*$Auswahl*0.3+20)*1.19),2) ;
	
	$Daten{"Streitwertabfrage"} .= '		<TR id="vorschuss" style="display:none">
				<TD WIDTH=200 ALIGN=RIGHT class="hell" \>
				<TD WIDTH=426 ALIGN=LEFT class="hell">
					'.$Daten{"AuswahlBeteiligte"}.'	&nbsp;&nbsp;
					Betrag im QR-Code:&nbsp;<INPUT TYPE=TEXT NAME="Cvorschussin" SIZE=8 MAXLENGtH=35 VALUE="'.$Daten{"Cvorschussin"}.'" style="text-align:right">&nbsp;EUR
				</TD>

			</TR>
';
	}
   if( $Daten{"Crechtsgebiet"} eq "SR" or $Daten{"Crechtsgebiet"} eq "SN" or $Daten{"Crechtsgebiet"} eq "BG") { 
        unless( $Daten{"Cvorschussin"} ) { 
		if( $Daten{"Crechtsgebiet"} eq "SR" ) { $Daten{"Cvorschussin"}= "126,24"; } 
		if( $Daten{"Crechtsgebiet"} eq "SN" ) { $Daten{"Cvorschussin"}= "645,08"; }
		if( $Daten{"Crechtsgebiet"} eq "BG" ) { $Daten{"Cvorschussin"}= "899,74"; }
		}
	$Daten{"Streitwertabfrage"} = '		<TR id="vorschuss" style="display:none">
				<TD WIDTH=200 ALIGN=RIGHT class="hell" \>
				<TD WIDTH=426 ALIGN=RIGHT class="hell">
					
					Betrag im QR-Code:&nbsp;<INPUT TYPE=TEXT NAME="Cvorschussin" SIZE=8 MAXLENGtH=35 VALUE="'.$Daten{"Cvorschussin"}.'" style="text-align:right">
				</TD>

			</TR>
';	}
   elsif( $Daten{"Crechtsgebiet"} eq "IK" ) { 
	$Daten{"Streitwertabfrage"} .= '			<TR>
				<TD WIDTH=200 ALIGN=RIGHT class="hell">
					Mahnkosten Ger.|Anwalt:&nbsp;&nbsp;
				</TD>
				<TD WIDTH=426 ALIGN=LEFT class="hell">
					<INPUT TYPE=TEXT NAME="Cgergebuehr" SIZE=8 MAXLENGtH=35 VALUE="'.$Daten{"Cgergebuehr"}.'" READONLY style="text-align:right"> |
					<INPUT TYPE=HIDDEN NAME="Cggb" SIZE=10 MAXLENGtH=35 VALUE="'.$Daten{"Cggb"}.'">
					<INPUT TYPE=TEXT NAME="Cmahngebuehr" SIZE=8 MAXLENGtH=35 VALUE="'.$Daten{"Cmahngebuehr"}.'" onChange=javascript:mahn(); style="text-align:right"> +
					<INPUT TYPE=TEXT NAME="Cmahnust" SIZE=8 MAXLENGtH=35 VALUE="'.$Daten{"Cmahnust"}.'" onChange=javascript:mahn(); style="text-align:right"> =
					<INPUT TYPE=TEXT NAME="Cmahngesamt" SIZE=8 MAXLENGtH=35 VALUE="'.$Daten{"Cmahngesamt"}.'" READONLY style="text-align:right">

				</TD>

			</TR>
';
	}


    $Daten{"fallvorhanden"} = ( -e "../../Documents/$Jahr/$Fall/data/stammdaten.cfg" )? 1 : 0; 


#####################################################

   my $fall=($Daten{"fallvorhanden"})? "$Fall/$Jahr" : "Neuer Fall";
   
   print $cgi->header(),
	 $cgi->start_html(-title =>"Lawsuit - $fall", -charset =>'utf8');

   print @{Form::HTML("stammdatenC1", \%Daten)};
   if( $Daten{"Crechtsgebiet"} eq "SR" or $Daten{"Crechtsgebiet"} eq "BG" or $Daten{"Crechtsgebiet"} eq "DR" ) {
         print @{Form::HTML("stammdatenC2", \%Daten)};
         }
   unless ( $Daten{"Crechtsgebiet"} eq "AB" or $Daten{"Crechtsgebiet"} eq "PI" ) {
         print @{Form::HTML("stammdatenC3", \%Daten)};
         }
   print @{Form::HTML("stammdatenC4", \%Daten)};
   print $cgi->end_html;



############################################################################################
} if( $cgi->param('stufe') eq "4" ) {
############################################################################################

   @Zeile="";

# Prozessregister um 1 erhoehen #######
   my $Register=$cgi->param('Cprozessregister');
   # Aus Altfall Inkassoakte auslagern
   if( $cgi->param('Auslagerung') eq "1" ) {
      $Register=$cgi->param('Cneuesprozessregister'); }
   ####
   $Register=~s/&#8260;/\//g;
   @Woerter = split(/\//, $Register);
   $Jahr=$Woerter[1];
   $Fall=$Woerter[0];
         $Woerter[0]++;
   if( $cgi->param('Prozessregister') eq "1" or $cgi->param('Auslagerung') eq "1" ) {
	@Zeile="var az = \"".$Woerter[0]."\/".$Woerter[1]."\";";
	open(DATEI, ">../javascript/prozessregister.js") || die "Datei prozessregister.js besteht nicht, oder Sie haben keine Schreibberechtigung:\n$!";
		print DATEI @Zeile;
	close(DATEI);
	chmod(0777, "../javascript/prozessregister.js");
	}

	
# Rechnungsnummer um 1 erhoehen #######
   if( $cgi->param('rechnung') eq "1" ) {
	@Zeile="var rn = \"".($cgi->param('Crechnungsnummer')+1)."\";";
	open(DATEI, ">../javascript/rechnungsnummer.js") || die "Datei rechnungsnummer.js besteht nicht, oder Sie haben keine Schreibberechtigung:\n$!";
		print DATEI @Zeile;
	close(DATEI);
	chmod(0777, "../javascript/rechnungsnummer.js");
	}

# Ablagenummer um 1 erhoehen, anderenfalls Cablagenummer fuer stammdaten.cfg loeschen#######
   @Woerter = split(/\//, $cgi->param('Cablagenummer'));
         $Woerter[0]++;
   my @Offen=glob "../../Documents/$Jahr/$Fall/\.~lock*";
   if( $cgi->param('Ablage') && $#Offen<1 ) {
	@Zeile="var an = \"".$Woerter[0]."\/".$Woerter[1]."\";";
	open(DATEI, ">../javascript/ablagenummer.js") || die "Datei ablagenummer.js besteht nicht, oder Sie haben keine Schreibberechtigung:\n$!";
		print DATEI @Zeile;
	close(DATEI);
	chmod(0777, "../javascript/ablagenummer.js");
	}
   else {
	$Daten{"Cablagenummer"}="";
	}

   # Neue Nummern ins Internet zurueckuebertragen gelingt auch mit Net::FTP nicht, deshalb Hilfsicon auf Desktop mit Skript prozessregisterabgleich

        open(DATEI, "<../../Desktop/Server.desktop") || die "die Datei Server.desktop besteht nicht, oder Sie haben keine Leseberechtigung:\n$!";
              @Zeilen = <DATEI>;
              foreach(@Zeilen) { $_ =~ s/online/offline/g; }
        close(DATEI);
        open(DATEI, ">../../Desktop/Server.desktop") || "die Datei Server.desktop besteht nicht, oder Sie haben keine Schreibberechtigung:\n$!";
	      print DATEI @Zeilen;
        close(DATEI);
	system("dcop kdesktop KDesktopIface refreshIcons"); 


#######################################

# Formulardaten aus cgi-param ermitteln
   foreach my $Feld (@Feldnamen) {
       if( $cgi->param($Feld) )  {
          $Daten{$Feld} = encode("utf8", $cgi->param($Feld));
	  $Daten{$Feld}=~s/undefined(&nbsp;)?//g;
       } else {
          $Daten{$Feld} = "";
       }
   }
   # Auslagerung
   if( $cgi->param('Auslagerung') eq "1" ) {
      $Daten{'Cprozessregister'}=$cgi->param('Cneuesprozessregister'); 
      $Daten{'Crechtsgebiet'} = "IK";
      }
   # Abbruch
   if( $Daten{"Cmfile"} eq "" || $Daten{"Cgfile"} eq "" ) { # Wo kein Field Cgfile in stammdatenC, auch keine Fehlermeldung
          print "Pragma: no-cache\nContent-type: text/html\n\n";
          print qq~<HEAD><TITLE>Error</TITLE></HEAD><BODY bgcolor="#ffffff"><BR><BR><BR><table align="center" width="500"><tr><td><B><FONT face="verdana" size="2" COLOR="#000080"><center><H2>Error!</h2><BR>Sie haben keinen Mandanten bzw. keinen Gegner eingetragen!<BR>Die Bearbeitung wird abgebrochen.<BR><BR>~;
          exit;
          }



  ###### Bezeichnungen aus Dateinameneingabe erzeugen, umwandeln ####


	@Woerter=split(/\.\/\./, $Daten{"Ckurzrubrum"});
	$Daten{"mrohname"}= $Woerter[0]; $Daten{"grohname"}= $Woerter[1];

   my @Partei=qw(M G);
   if( $Daten{"Crechtsgebiet"} eq "AB" or $Daten{"Crechtsgebiet"} eq "PI" ) {
	pop(@Partei);
	}
   foreach (@Partei) {


	my $P = $_;
	my $p = lc($P);
	my $Partei;
	my $Parteien;
	my $partei;
	my $verzeichnis;

	if( $P eq "M" ) { $Partei="Mandant"; $Parteien="Mandanten"; $verzeichnis="clients"; }
	if( $P eq "G" ) { $Partei="Gegner"; $Parteien="Gegner"; $verzeichnis="opponents"; }

	my $z=($Daten{$p."zaehler"}>0)? $Daten{$p."zaehler"} : "";  # fuer Cm?file

	$Partei = Form::utf82html($Daten{$p."rohname"});
	$Daten{$p."rohname"}=Stamm::Rubrumklar($Partei);

	if( $Daten{"C".$p.$z."file"} && $Daten{"C".$p.$z."file"} ne "vorlage" ) {    
					                # Uebergabae aus Hidden-Field, ansonsten neu zusammenstellen
	    $Partei = $Daten{"C".$p.$z."file"}; 
	    $partei = Form::html2utf8($Partei);
	    }	

	else {
	    $Partei=$Woerter[0].substr($Woerter[1],0,1);
	    $Partei =~ s/[\.\,\s ]//g;                      # Leer- und Hilfseichen entfernen: Atalan, &Ouml;.
	    $Partei =~ s/&nbsp;//g;
	    $Partei =  lc($Partei);                       # Standardnamen erzeuten Atalanö
	    $partei = "vorlage";
	    $Daten{$p."change"} = 1;                      # Wenn Datei fehlt, erst anlegen, bevor Typ Cmfile aufruft
	    }

	$Daten{"C".$p.$z."file"}=$Partei;                 # Gewaehlten Dateinamen in Eingabefeld sichtbar machen





# Mandanten und Gegner anlegen, Verzeichnisse anlegen

   if( $Daten{$p."change"} ) {
       unless ( -e "../$verzeichnis/$partei" ) {
          mkdir("../$verzeichnis/$partei") || die "Neuer $Partei $partei kann im Verzeichnis $verzeichnis nicht angelegt werden :\n$!";
          chmod(0777, "../$verzeichnis/$partei");
          }
       elsif ( -e "../$verzeichnis/$partei/adresse.cfg" ) {
          my @Zeilen = @{Form::Auslesen("../$verzeichnis/$partei/adresse.cfg")};
	  open(DATEI, ">>../$verzeichnis/$partei/adresse.old") || die "Die Datei adresse.old kann unter $partei nicht beschrieben werden :\n$!";
		print DATEI Form::Datum(3,0)," ########################################\n";
		print DATEI @Zeilen;
	  close(DATEI);
	  chmod(0777, "../$verzeichnis/$partei/adresse.old");
	  }
       Form::Speichern_Spiegel( \@Feldnamen, \%Daten, "../$verzeichnis/$partei/adresse.cfg", "$P");

       if( length($Daten{$P."name"})>0 ) {
		open(DATEI, "<../$verzeichnis/all.cfg") || die "Die Datei $verzeichnis/all besteht nicht, oder Sie haben keine Leseberechtigung:\n$!";
			@Zeilen = <DATEI>; 
		close(DATEI);
		$Zeile=Form::Liste($P, $z, \%Daten, \%Daten);
		# Userpasswort Online-Archiv#
		if(-e "../../Documents/$Jahr/$Fall/data/user.cfg") {
			@User=@{Form::Auslesen("../../Documents/$Jahr/$Fall/data/user.cfg")}; }
		$User[$Daten{$p."zaehler"}]=$Daten{$P."user"}.':'.crypt($Daten{$P."passwort"},"IN")."\n";
		if( $Daten{$P."online"} ) { Form::Speichern("../../Documents/$Jahr/$Fall/data/user.cfg", \@User, "In $Jahr/$Fall/data kann user.cfg nicht geschrieben werden oder Sie haben keine Schreibberechtigung:\n$!"); }
		# FritzBox #
		my $Wo=($Daten{$P."typ"} eq "Person" || $Daten{$P."typ"} eq "Mehrheit")? "home" : "work";
		$Fritzzeile="<contact><category>0</category><person><realName>".Form::fritzform($Daten{$P."name"})."</realName><ImageURL /></person><telephony>";
		if( $Daten{$P.'telefon'} ) { $Fritzzeile.='<number type="'.$Wo.'" quickdial="" vanity="" prio="1">'.Form::fritzform($Daten{$P.'telefon'}).'</number>'; }
		if( $Daten{$P.'handy'} ) { $Fritzzeile.='<number type="mobile" quickdial="" vanity="" prio="">'.Form::fritzform($Daten{$P.'handy'}).'</number>'; }
		$Fritzzeile.='</telephony><services /><setup /></contact>';
		unless( $Fritzzeile =~ /quickdial/m ) { $Fritzzeile=""; }  # nur Leute mit Telefon aufnehmen
		############
		foreach (@Zeilen) { @Woerter=split("#:#", $_); if( $Woerter[0] eq Form::utf82html($Partei) ) { $_=$Zeile; $Zeile="";} }
		if ( length($Zeile)>0 ) { 
			push (@Zeilen, $Zeile); 
			push (@Fritzzeilen, $Fritzzeile);
			}
		push (@Fritzzeilen, $Fritzzeile);
		@Zeilen=sort(@Zeilen);
		Form::Speichern("../$verzeichnis/all.cfg", \@Zeilen, "In $verzeichnis kann nicht geschrieben werden oder Sie haben keine Schreibberechtigung fuer die Liste all:\n$!");
		Stamm::Fritz(\@Fritzzeilen);
		}
   }

   if( $Daten{"C".$p."zahl"}*1>0 ) {
	@Zeilen=split(/\<BR\>/, $Daten{"C".$p."weiter_beteiligt"} );
	while( $#Zeilen>$Daten{"C".$p."zahl"}*1 ) { pop(@Zeilen); }            # Loeschen
	$Zeilen[0]="Auf ".$Parteien."seite&#58;";
	while( $#Zeilen<$Daten{"C".$p."zahl"}*1 ) { push(@Zeilen, "&nbsp;"); } # Weiterer
	if( $Daten{$p."zaehler"}*1>=1 ) {
		$Zeilen[($Daten{$p."zaehler"}*1)]=($Daten{$p."zaehler"}*1).". ".$Daten{$P."anrede"}." ".$Daten{$P."name"}."; ".$Daten{$P."strasse"}."; ".$Daten{$P."land"}."-".$Daten{$P."plz"}." ".$Daten{$P."stadt"}; }
	$Daten{"C".$p."weiter_beteiligt"}=join("<BR>", @Zeilen); 
	}
   else {
	$Daten{"C".$p."weiter_beteiligt"}="";
	}

   my $Ablagedatum=$cgi->param('Ablage')? $Daten{"Cablagedatum"}: "31.12.2100"; #Nur fuer faelle.cfg
   #Fallsafe: Falls versehentlich schon einmal abgelegt wurde, sind Parteien nach sechs  Monsten in parties verschoben worden
        unless(-d "../$verzeichnis/$partei") { $verzeichnis="parties"; } 
   open(DATEI, ">>../$verzeichnis/$partei/faelle.cfg") || die "Die Datei faelle.cfg kann unter $verzeichnis/$partei nicht erstellt bzw. beschrieben werden :\n$!";
        print DATEI "$Daten{'Cprozessregister'}#:#$Daten{'Canlagedatum'}#:#$Ablagedatum","\n";
   close(DATEI);
   chmod(0777, "../$verzeichnis/$partei/faelle.cfg");

   }# Ende Parteien


   unless ( -e "../courts" ) {
      mkdir("../courts",0777) || die "Gerichtsverzeichnis courts kann nicht angelegt werden :\n$!";
      chmod(0777, "../courts");
      }


   # Liste aller fuer Mandanten gefertigter Schreiben ( 1. alte Sortierung 2. neue Sortierung ) tut nicht!
   # unless ( -e "../clients/$mandant/schreiben.cfg" ) {

      # Alte Ziffern weiterbenutzen
      @Zeilen="";
      my $link;
      my $datei;
      my $legende;
      $Mandant = $Daten{"Cmfile"}; 
      $mandant = Form::html2utf8($Mandant);

      my $AktuellesJahr=Form::Datum(2,0);
         $AktuellesJahr=~s/^\d\d\.\d\d\.//g;

      for(my $j=2002;$j<=$AktuellesJahr;$j++) {
	#Auch in Ablagen suchen
	my @Faelle;
	my @Schreiben;
	my @AlleFaelle=glob("../../Documents/$j/*");
	foreach(@AlleFaelle) {
		if( $_ =~ /^*\/*\/Documents\/$j\/_?\d++$/ ) {
			push(@Faelle, $_); }
		elsif ( $_ =~ /^*\/*\/Documents\/$j\/$mandant[A-Z0-9].+\.*/ ) {
			push(@Schreiben, $_); }
		}
	foreach my $Fall (@Faelle) {
		my @NeueSchreiben=glob("$Fall/$mandant*.*");
		foreach (@NeueSchreiben) {
			if (  $_ =~ /^$Fall\/$mandant[A-Z0-9].+\.*/ ) {
				push(@Schreiben, $_); }
			}
		}
        foreach (@Schreiben) { 
		my @Teile = split(/\//, $_); 
		$datei= Form::utf82html(pop(@Teile)); 
		my $dat=$datei; $dat=~s/.\w\w\w+$//g;
		$link = Form::utf82html(join("/", @Teile));
		if( $dat=~ m/\&minus;ber(h)?$/ ) { $legende="Beratungshilfeantrag"; }
		if( $dat=~ m/\&minus;ema$/ ) { $legende="Einwohnermelderegisterauskunft"; }
		if( $dat=~ m/\&minus;ev$/ ) { $legende="Eidesstattliche Versicherung"; }
		if( $dat=~ m/\&minus;hv$/ ) { $legende="Honorarvereinbarung"; }
		if( $dat=~ m/\&minus;info$/ ) { $legende="Informationsschreiben an Mandanten"; }
		if( $dat=~ m/\&minus;kf$/ ) { $legende="Kostenfestsetzungsantrag"; }
		if( $dat=~ m/\&minus;kfpkh$/ ) { $legende="Kostenfestsetzungsantrag Prozesskostenhilfe"; }
		if( $dat=~ m/\&minus;mg$/ ) { $legende="Mahnung"; }
		if( $dat=~ m/\&minus;pkh$/ ) { $legende="Prozesskostenhilfe"; }
		if( $dat=~ m/\&minus;ra$/ ) { $legende="Schreiben an den Gegenanwalt"; }
		if( $dat=~ m/\&minus;re$/ ) { $legende="Rechnung"; }
		if( $dat=~ m/\&minus;rs$/ ) { $legende="Schreiben an die Rechtsschutzversicherung"; }
		if( $dat=~ m/\&minus;rz$/ ) { $legende="Ratenzahlungsvereinbarung"; }
		if( $dat=~ m/\&minus;voll$/ ) { $legende="Vollmacht"; }
		if( $dat=~ m/\&minus;vs$/ ) { $legende="Schreiben an die beteiligte Versicherung"; }
		$dat=~s/&minus;\w+$//g;
		if( $dat=~ /[A-Z](\d+)?$/ ) { 
			my $seite=( $dat=~ /_[A-Z]\d+$/ )? "gegner" : "mandant";
			my $buchstabe=$dat; $buchstabe=~s/\d//g; $buchstabe=substr($buchstabe,(length($buchstabe)-1),1);
			my $zahl=$dat; $zahl=~s/\D+//g; while(length($zahl)<4) { $zahl="0".$zahl; }
			if( ord($buchstabe)>=ord($FreiA) ) { $FreiA=$buchstabe; }
			if( $buchstabe==$FreiA && $zahl>$FreiA0 ) { $FreiA0=$zahl; }
			@Zeile = "1_".$buchstabe.$zahl."#\:#$j#\:#$legende#\:#$seite#\:#$_#\:#$link#\:#$datei\n"; }
		else { 
			my $seite=( $dat=~ /_\d+$/ )? "gegner" : "mandant";
			my $zahl=$dat; $zahl=~s/\D+//g; while(length($zahl)<4) { $zahl="0".$zahl; }
			if( $zahl>$Frei0 ) { $Frei0=$zahl; }
			@Zeile = "0_$zahl#\:#$j#\:#$legende#\:#$seite#\:#$_#\:##\:#$link#\:#$datei\n"; }
		push (@Zeilen, @Zeile);
		}
	}


      @Zeilen=sort(@Zeilen);
      $FreiA0++;
      $Frei0++;
      Form::Speichern("../clients/$mandant/schreiben.cfg", \@Zeilen, "Die Datei schreiben.cfg kann unter $mandant nicht erstellt werden :\n$!");
#      }
   #
   unless ( -e "../../Documents/$Jahr/$Fall" ) {
      mkdir("../../Documents/$Jahr/$Fall") || die "Neues Unterverzeichnis zum Fall $Fall kann in $Jahr nicht angelegt werden :\n$!";
      chmod(0777, "../../Documents/$Jahr/$Fall");
      }
   unless ( -e "../../Documents/$Jahr/$Fall/data" ) {
      mkdir("../../Documents/$Jahr/$Fall/data") || die "Neues Unterverzeichnis data kann zum Fall $Fall/$Jahr nicht angelegt werden :\n$!";
       chmod(0777, "../../Documents/$Jahr/$Fall/data");
     }

   $Daten{"Crubrum"}=$Daten{"Ckurzrubrum"}."&nbsp;".$Daten{"Cfolge"};
   Form::Speichern_Spiegel( \@Feldnamen, \%Daten, "../../Documents/$Jahr/$Fall/data/stammdaten.cfg", "C");
   # Alles neu ->

######################################## 

# Druck-Ausgabe

   # Alles neu <-
   if( $cgi->param("ablage") ) { 
	   %Daten=%{Form::Auslesen_Spiegel("../../Documents/$Jahr/_$Fall/data/stammdaten.cfg", "", "")}; }
   else {
	   %Daten=%{Form::Auslesen_Spiegel("../../Documents/$Jahr/$Fall/data/stammdaten.cfg", "", "")}; }

	# Alte Fehlvariablen loeschen
	  delete $Daten{"Csw"};
	  delete $Daten{"Cgb"};

   $Daten{"Cweiter_beteiligt"}=$Daten{"Cmweiter_beteiligt"}."<BR>".$Daten{"Cgweiter_beteiligt"};
   $Daten{"Cweiter_beteiligt"}=~s/\&#58;/\:/g;

   ### Jeweils ersten Beteiligten einer Partei fuer den Ausdruck waehlen
   my @Partei=qw(M G);
   if( $Daten{"Crechtsgebiet"} eq "AB" or $Daten{"Crechtsgebiet"} eq "PI" ) {
	pop(@Partei);
	}
   my @Offen=glob "../../Documents/$Jahr/$Fall/\.~lock*";
   if($cgi->param("Ablage") && @Offen ) { # Wenn noch in Bearbeitung, Ablage abbrechen
        my $Text="";
        foreach (@Offen) { $_=~s/\.\~lock.//g; $_=~s/#$//g; $Text.="<BR>$_"; } 
        print "Pragma: no-cache\nContent-type: text/html\n\n";
        print qq~<HEAD><TITLE>Error</TITLE></HEAD><BODY bgcolor="#ffffff"><BR><BR><BR><table align="center" width="500"><tr><td><B><FONT face="verdana" size="2" COLOR="#000080"><center><H2>Error!</h2><BR>Bitte schlie&szlig;en Sie alle in Bearbeitung <BR>befindlichen Dateien dieses Falles, bevor Sie <BR>den Fall selbst ablegen!<BR><BR>$Text<BR>~;
        exit;
        }

   foreach (@Partei) {

	my $P = $_;
	my $p = lc($P);
	my $Partei=$Daten{"C".$p."file"};
	my $partei = Form::html2utf8($Partei);
	my $verzeichnis=( $P eq "M" )? "clients" : "opponents";

	my %Adresse=%{Form::Auslesen_Spiegel("../$verzeichnis/$partei/adresse.cfg", "", "")};
	my @Schluessel = keys(%Adresse);
	foreach (@Schluessel) {
		$Daten{$_}=$Adresse{$_};
		}

	}

   my @Farben=@{Form::Auslesen("../stylesheets/$Daten{Crechtsgebiet}.css")};
   foreach(@Farben) {
	$_=~s/^.+:\s+//g;
	$_ =~s/;\s+\}(\s)?\n$//g;
	}

   print $cgi->header(),
	 $cgi->start_html(-title =>'Stammdaten', -BGCOLOR =>'#ffffff', -charset=>'utf8', -style=>{'media'=>'print', 'src'=>"../stylesheets/druck.css"}),
         $cgi->h1('Stammdatenausdruck');

   print $cgi->start_table({-border => '0' -width=> '80%'}),

         $cgi->Tr($cgi->td({-align=>'center' -valign => 'top' -BGCOLOR => '#abcdee' -width => '100%'},"<h4>Kurzrubrum:<nbsp;></h4>", $cgi->param('Ckurzrubrum'), " ", $cgi->param('Cfolge'))),
         $cgi->Tr($cgi->td({-align=>'center' -valign => 'top' -BGCOLOR => '#ffffff' -width => '100%'},"Prozessregister:<nbsp;><nbsp;> ", $Daten{'Cprozessregister'}, "<nbsp;><nbsp;><nbsp;>Anlagedatum:<nbsp;><nbsp;> ", $cgi->param('Canlagedatum'), Ablage($cgi->param("Ablage")))),
         $cgi->Tr($cgi->td({-align=>'center' -valign => 'top' -BGCOLOR => '#ffffff' -width => '100%'},"Wegen:<nbsp;><nbsp;> ", $cgi->param('Cwegen'))),

         $cgi->end_table(),
    	 $cgi->hr;


   print $cgi->start_table({-border => '0' -width=> '80%'}),

         $cgi->Tr($cgi->td({-align => 'center' -valign => 'top' -BGCOLOR => '#ffffff' -width => '100%'},"<h3>Mandant:  </h3>", $cgi->param('mandant'))),
         $cgi->Tr($cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, "Anrede:"), $cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, $Daten{"Manrede"}, $Daten{"Mtitel"} )),
         Name($Daten{"Mtyp"}, $Daten{"Mgebietskoerperschaft"}, $Daten{"Mname"}),
         $cgi->Tr($cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'},"Stra&szlig;e:"), $cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, $Daten{"Mstrasse"})),
         $cgi->Tr($cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'},"Stadt:"), $cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, $Daten{"Mland"}," - ", $Daten{"Mplz"}," ",$Daten{"Mstadt"})),
         $cgi->Tr($cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, "Beteiligten-Nr.:"), $cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, $Daten{"Mbeteiligten-Nr."})),
         Geburtsdatum("Mges"),
         $cgi->Tr($cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'},"Handy:"),  $cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, $Daten{"Mhandy"})),
         $cgi->Tr($cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'},"Telefon:"), $cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, $Daten{"Mtelefon"})),
         $cgi->Tr($cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, "Telefax:"), $cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, $Daten{"Mtelefax"})),
         $cgi->Tr($cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, "Mail:"),  $cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, $Daten{"Mmail"})),
         $cgi->Tr($cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, "Korrespondenzadresse:"), $cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, $Daten{"Mkorrespondenzadresse1"})),
         $cgi->Tr($cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, "&nbsp;"), $cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, $Daten{"Mkorrespondenzadresse2"}," ",$Daten{"Mkorrespondenzadresse3"})),
         $cgi->Tr($cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, "Rechtsschutzversicherung"), $cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, Rechtsschutz($Daten{"Mrechtsschutzversicherung"}))),
         $cgi->Tr($cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, "Prozesskostenhilfe"), $cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, Vordruck($Daten{"Mpkh"}))),
         $cgi->Tr($cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, "Beratungskostenhilfe"), $cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, Vordruck($Daten{"Mberatungshilfe"}))),
         $cgi->Tr($cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, "Bankverbindung:"), $cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, $Daten{"Mbankverbindung"})),
         $cgi->Tr($cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, "BLZ/Kontonummer:"), $cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, $Daten{"Mblz"}," ", $Daten{"Mkontonummer"})),
         $cgi->Tr($cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, "Umsatzsteuerfaktor:"), $cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, $Daten{"Mumsatzsteuerfaktor"})),
         $cgi->Tr($cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, "Gebuehrenerhoehungsfaktor:"), $cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, $Daten{"Mgeb&uuml;hrenerh&ouml;hungsfaktor"}));
      
   if( $Daten{"Crechtsgebiet"} eq "SR" or $Daten{"Crechtsgebiet"} eq "BG" or $Daten{"Crechtsgebiet"} eq "DR" ) {

	print 
		$cgi->Tr($cgi->td({-align => 'center' -valign => 'top' -BGCOLOR => '#ffffff' -width => '100%'},"<h3>Tatort:</h3>")),
		$cgi->Tr($cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, "Stra&szlig;e/Beschreibung:"), $cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, $Daten{"Cstrasse"})),
		$cgi->Tr($cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, "Stadt:"), $cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, $Daten{"Cland"}," - ", $Daten{"Cplz"}," ",$Daten{"Cstadt"}));
	}


   print 
	 $cgi->Tr($cgi->td({-align => 'center' -valign => 'top' -BGCOLOR => '#ffffff' -width => '100%'},"<h3>",Gegner(),"  </h3>", $cgi->param('gegner'))),
         $cgi->Tr($cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, "Anrede:"), $cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, $Daten{"Ganrede"}, $Daten{"Gtitel"} )),
         Name($Daten{"Gtyp"}, $Daten{"Ggebietskoerperschaft"}, $Daten{"Gname"}),
         $cgi->Tr($cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, "Stra&szlig;e:"), $cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, $Daten{"Gstrasse"})),
         $cgi->Tr($cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, "Stadt:"), $cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, $Daten{"Gland"}," - ", $Daten{"Gplz"}," ",$Daten{"Gstadt"})),
         $cgi->Tr($cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'},          "Beteiligten-Nr.:"), $cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, $Daten{"Gbeteiligtennr"})),
         Geburtsdatum("Gges"),
         $cgi->Tr($cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, "Telefon:"), $cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, $Daten{"Gtelefon"})),
         $cgi->Tr($cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, "Telefax:"), $cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, $Daten{"Gtelefax"})),
         $cgi->Tr($cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, "Korrespondenzadresse:"), $cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, $Daten{"Gkorrespondenzadresse1"})),
         $cgi->Tr($cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, "<nbsp;>"), $cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, $Daten{"Gkorrespondenzadresse2"}," ",$Daten{"Gkorrespondenzadresse3"})),

         $cgi->end_table(),
    	 $cgi->hr;

   print $cgi->start_table({-border => '0' -width=> '80%'}),
         $cgi->Tr($cgi->td({-align => 'center' -valign => 'top' -BGCOLOR => '#ffffff' -width => '100%'},"<h4>Weitere Beteiligte:  </h4>")),
         $cgi->Tr($cgi->td({-align => 'center' -valign => 'top' -BGCOLOR => '#ffffff' -width => '100%'}, $Daten{"Cweiter_beteiligt"})),
         $cgi->Tr($cgi->td({-align => 'center' -valign => 'top' -BGCOLOR => '#ffffff' -width => '100%'}, Form::umbruch($Daten{"Cweitere_beteiligte"}))),
         $cgi->end_table(),
    	 $cgi->hr;

   print $cgi->start_table({-border => '0' -width=> '80%'}),
         $cgi->Tr($cgi->td({-colspan => '2' -align => 'center' -valign => 'top' -BGCOLOR => '#ffffff' -width => '100%'},"<h4>Zusatzangaben:  </h4>")),
         $cgi->Tr($cgi->td({-colspan => '2' -align => 'center' -valign => 'top' -BGCOLOR => '#ffffff' -width => '100%'}, $cgi->param('Czusatzangaben')));

   $Daten{"Cstreitwert"}=$Daten{"Cswin"}; ## Altformulare
   $Daten{"Cgebuehr"}=$Daten{"Cgbout"};    ## Altformulare
   if( $Daten{"Crechtsgebiet"} eq "SR" || $Daten{"Crechtsgebiet"} eq "BG" || $Daten{"Crechtsgebiet"} eq "SN" || $Daten{"Crechtsgebiet"} eq "SG" || $Daten{"Cswin"} eq "") {
	$Daten{"Cswin"}="";
	$Daten{"Cswout"}=0;
   } else {
        print $cgi->Tr($cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'},"Streitwert:"), $cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, $cgi->param('Cswin')," EUR - Geb&uuml;hr: ", $cgi->param('Cgbin')," EUR", Rechnungsnummer($cgi->param("rechnung"))));
	}
   print $cgi->end_table();

   if( $cgi->param("Ablage") ) {
	   print '
	<script type="text/javascript">
	<!--
	function weg()
	// Tilgt Auswahlmenue, wenn nur ein Band
	{ 
		var s = document.getElementsByName("Ablagenauswahl")[0].value; 
		if( s == 0 )
		document.getElementsByName("ablagenband")[0].setAttribute("style", "display:none", false);
	}
        //-->
	</script>

	<DIV style="position:absolute; top:1080px; left:560px; width:250px; height:250px; border:solid; border-width:medium; border-color:silver; border-style:ridge; background-color:',$Farben[2],'; padding:10px; text-align:center;">
		<p><br><br><p>
		',$Daten{"Ckurzrubrum"},' ',$Daten{"Cfolge"},'<br>
		<h1>',$Daten{"Cablagenummer"},'</h1>
		<p name="ablagenband" style="display:inline">';
	   my @Ablage = qw(0#:# 1#:#Band&nbsp;1 2#:#Band&nbsp;2 3#:#Band&nbsp;3 4#:#Band&nbsp;4 5#:#Band&nbsp;5 6#:#Band&nbsp;6 7#:#Band&nbsp;7 8#:#Band&nbsp;8 I#:#Beiakte&nbsp;I II#:#Beiakte&nbsp;II III#:#Beiakte&nbsp;III IV#:#Beiakte&nbsp;IV V#:#Beiakte&nbsp;V VI#:#Beiakte&nbsp;VI VII#:#Beiakte&nbsp;VII VIII#:#Beiakte&nbsp;VIII IX#:#Beiakte&nbsp;IX X#:#Beiakte&nbsp;X);
	   print Form::Ausklappmenue(\@Ablage, "Ablagenauswahl", "1", "", 100, 100, qq~onChange="javascript:weg()"~);
	   print '
		</p>
	</DIV>';
	}

   print $cgi->hr;
   print '<pre> ', "\n";
   print ' ', "\n";
   print ' ', "\n";
   print ' </pre>', "\n";
   print '<div id="noprint">Freie Suffixe: ',$Frei0," / ",$FreiA.$FreiA0, "<br>\n";
   my $mfile=Form::html2utf8(encode("utf8",$cgi->param("goldfile")));
   if(-d "../clients/$mfile" && length($cgi->param("moldfile"))>0 && $cgi->param("moldfile") ne $Daten{"Cmfile"} ) {
        print $cgi->param("moldfile"), " -> ",$Daten{"Cmfile"},"<br>\n";
        print '<a href="../cgi-bin/umbenennen.pl?Cfile_alt=',$cgi->param("moldfile"),'&Cfile_neu=',$Daten{"Cmfile"}.'" target="_blank">Weitere Altdatenbest&auml;nde auf Mandantenseite ebenfalls umbenennen</a>',"<br>\n"; }
   my $gfile=Form::html2utf8(encode("utf8",$cgi->param("goldfile")));
   if(-d "../opponents/$gfile" && length($cgi->param("goldfile"))>0 && $cgi->param("goldfile") ne $Daten{"Cgfile"} ) {
        print $cgi->param("goldfile"), " -> ",$Daten{"Cgfile"},"<br>\n";
        print '<a href="../cgi-bin/umbenennen.pl?Cfile_alt=',$cgi->param("goldfile"),'&Cfile_neu=',$Daten{"Cgfile"}.'" target="_blank">Weitere Altdatenbest&auml;nde auf Gegnerseite ebenfalls umbenennen</a>',"<br>\n"; }
   
   print '</div><br>', "\n\n";
   if( $Daten{"Crechtsgebiet"} eq "IK" ) { 
	   print Form::Formular(\%Daten, "vollmacht_ag_abtr.odt"), "&nbsp;&nbsp;&nbsp;"; }
   elsif( $Daten{"Crechtsgebiet"} eq "SR" ) { 
	   print Form::Formular(\%Daten, "vollmacht_sr_lang.odt"), "&nbsp;&nbsp;&nbsp;"; }
   elsif( $Daten{"Gname"} =~ m/BAMF/ or $Daten{"Gname"} =~ m/Bundesamt.+Migration.+und.+Fl.+chtlinge/  or $Daten{"Gname"} =~ m/Ausl.+nder/ ) { 
	   print Form::Formular(\%Daten, "vollmacht_ag_g_engl.odt"), "&nbsp;&nbsp;&nbsp;"; }
   else {
	   print Form::Formular(\%Daten, "vollmacht_ag_g.odt"), "&nbsp;&nbsp;&nbsp;"; }
   if( $Daten{"Crechtsgebiet"} eq "VR" or $Daten{"Crechtsgebiet"} eq "DR"  or ($Daten{"Crechtsgebiet"} eq "VG" and $Daten{'Ckurzrubrum'}=~m/BAMF/) ) { 
	   print Form::Formular(\%Daten, "arztbefreiung.odt"), "&nbsp;&nbsp;&nbsp;"; }
   print Form::Formular(\%Daten, "wiedervorlagen.odt"), "&nbsp;&nbsp;&nbsp;";
   print Form::Formular(\%Daten, "kostenblatt.odt"), "&nbsp;&nbsp;&nbsp;";

   print '<a href="../cgi-bin/etikett.pl?Cprozessregister=',$Fall,'/',$Jahr,'" target="_blank">etikett.odt</a>&nbsp;&nbsp;&nbsp;';
   
   my %Adresszeilen=%{Form::Adresszeilen(\%Daten, "MG")};
		
   foreach( keys(%Adresszeilen) ) {
	$Daten{$_}=$Adresszeilen{$_};
	}
	
   #entfaellt fuer neues Beratungshilfeformular ab 2014, das nur noch ganzes Gebburtsdatum kennt
   #my @Woerter=split(/\./, $Daten{"Mgeboren"});  			# Geburtsjahr fuer Beratungshilfeformular isolieren;
   #$Daten{"Mjahr"} = pop(@Woerter);
   
   if( $cgi->param('Mrechtsschutzversicherung') ) { 
	my $Versicherung = $Daten{"Mversicherungsname"};
	$Versicherung =~ s/[\.\,-\s\/\/ ]//g;                    # Hilfszeichen entfernen: 
	$Versicherung =~ s/&minus;//g;                           # Bindestrich entfernen
	$Versicherung =~ s/&#8260;//g;                           # Schraegstrich entfernen
	$Versicherung =~ s/&frasl;//g;                           # Schraegstrich entfernen
	$Versicherung =~ s/&nbsp;//g;                            # Leerzeichen entfernen: 
	$Versicherung =  lc($Versicherung);                      # Standardnamen erzeuten Atalanö 

	$Versicherung=Form::html2utf8(encode("utf8", $Versicherung));
	unless(-e "../insurance/$Versicherung/adresse.cfg") {
		$Versicherung="vorlage"; }
	my %Versicherung=%{Form::Auslesen_Spiegel("../insurance/$Versicherung/adresse.cfg", "", "")};
	my %Adresszeilen=%{Form::Adresszeilen(\%Versicherung, "P")};
	foreach( keys(%Adresszeilen) ) {
	      $Daten{$_}=$Adresszeilen{$_};
	      }

	print Form::Formular(\%Daten, "rechtsschutz.odt"), "&nbsp;&nbsp;&nbsp;"; }
   if( $cgi->param('Mberatungshilfe') ) { 
	my $Gericht;
	my @Gericht=@{Form::Auslesen("../courts/ZR.cfg", "", "")};
	my @SGericht=@{Form::Auslesen("../courts/SR.cfg", "", "")};
	foreach (@SGericht) { push (@Gericht, $_); } 
	foreach(@Gericht) {
		@Zeile=split(/#:#/, $_);
		if( $Zeile[1] eq $Daten{"Mplz"} ) {
			$Gericht=$Zeile[2];
			$Gericht =~ s/[\.\,-\s\/\/ ]//g;                    # Hilfszeichen entfernen: 
			$Gericht =~ s/&#8260;//g;                      # Schraegstrich entfernen
			$Gericht =~ s/&frasl;//g;                      # Schraegstrich entfernen
			$Gericht =~ s/&nbsp;//g;                       # Leerzeichen entfernen: 
			$Gericht =  lc($Gericht);                      # Standardnamen erzeuten Atalanö 
			}
		}

	if( length($Gericht)<=0 ) { $Gericht="agm&uuml;nster"; }
	$Gericht=Form::html2utf8(encode("utf8", $Gericht));
	my %Gericht=%{Form::Auslesen_Spiegel("../courts/$Gericht/adresse.cfg", "", "")};
	foreach (keys %Gericht) { $Daten{$_}=$Gericht{$_}; }
	#Warnung Fristende nach Par. 6 aufnehmen
	$Daten{"Mfristende"} = Form::Zeigezeit(Form::Zeit($cgi->param('Canlagedatum'))+2419200);#Form::Datum(1,14);
	#Abtretungssumme
	$Daten{"Cgbberhilfein"} = ($Daten{"Cswout"}*1>500)? "121,38" : "83,54";
	print Form::Formular(\%Daten, "beratungshilfe.odt"), "&nbsp;&nbsp;&nbsp;"; 
	} 

   print Form::Formular(\%Daten, "brief.odt"), "&nbsp;&nbsp;&nbsp;";
   my $Rechnung="rechnung_".$Daten{"Crechtsgebiet"};
   if($Daten{"Cbet"}>0) { $Rechnung.="m"; } #bei mehreren Beteiligten Vorlage mit Suffix m waehlen
   if( $Daten{"Mberatungshilfe"}>0 ) { $Rechnung="rechnung_25"; }
   #Zusatzfelder fuer Ueberweisungstraeger
   foreach my $P ("M","P") {
	  $Daten{$P."cleariban"}=$Daten{$P."iban"};
	  $Daten{$P."cleariban"}=~s/&nbsp;//g;
	  $Daten{$P."shortiban"}=$Daten{$P."cleariban"};
	  $Daten{$P."shortiban"}=~s/\D//g; 
	  }
   if( $Daten{"Mrechtsschutzversicherung"} ) { 
          my $Vorschussout=Form::Zahl($Daten{'Cvorschussin'});
          $Daten{"qrbank"}="BCD\n001\n1\nSCT\nGENODEM1MSC\nKanzlei Hermanns\nDE08401600500081511101\nEUR$Vorschussout\n\n\n$Daten{'Mversicherungsnr'} - $Daten{'Cprozessregister'} RE";
          print Form::Formular(\%Daten, "re-versicherung.odt"), "&nbsp;&nbsp;&nbsp;"; }
   elsif( $Daten{"Crechtsgebiet"} eq "AV" or $Daten{"Crechtsgebiet"} eq "AB" or $Daten{"Crechtsgebiet"} eq "AG" or $Daten{"Crechtsgebiet"} eq "BG" or $Daten{"Crechtsgebiet"} eq "MP" or $Daten{"Crechtsgebiet"} eq "DR" or $Daten{"Crechtsgebiet"} eq "AR" or $Daten{"Crechtsgebiet"} eq "FR" or $Daten{"Crechtsgebiet"} eq "VR" or $Daten{"Crechtsgebiet"} eq "SG" or $Daten{"Crechtsgebiet"} eq "VG" or $Daten{"Crechtsgebiet"} eq "FG" or $Daten{"Crechtsgebiet"} eq "PI") { 
          my $Vorschussout=Form::Zahl($Daten{'Cvorschussin'}); 
          $Daten{"qrbank"}="BCD\n001\n1\nSCT\nGENODEM1MSC\nKanzlei Hermanns\nDE35401600500081511100\nEUR$Vorschussout\n\n\n$Daten{'Ckurzrubrum'} - $Daten{'Cprozessregister'} RE";
          print Form::Formular(\%Daten, "$Rechnung.odt"), "&nbsp;&nbsp;&nbsp;"; }
   elsif( $Daten{"Crechtsgebiet"} eq "SR" or $Daten{"Crechtsgebiet"} eq "SN" ) { 
          my $Vorschussout=Form::Zahl($Daten{'Cvorschussin'});  
          $Daten{"qrbank"}="BCD\n001\n1\nSCT\nGENODEM1MSC\nKanzlei Hermanns\nDE35401600500081511100\nEUR$Vorschussout\n\n\n$Daten{'Ckurzrubrum'} - $Daten{'Cprozessregister'} RE";
          print Form::Formular(\%Daten, "$Rechnung.odt"), "&nbsp;&nbsp;&nbsp;"; }
   else {
	  print Form::Formular(\%Daten, "$Rechnung.sxw"), "&nbsp;&nbsp;&nbsp;"; }
   print Form::Formular(\%Daten, "honorarv_ag.odt"), "&nbsp;&nbsp;&nbsp;";
   if( $Daten{"Cwegen"} =~ m/[Bb]escheid/ or $Daten{"Cwegen"} =~ m/Verwaltungsakt/ or $Daten{"Cwegen"} =~ m/VA/ or $Daten{"Cwegen"} =~ m/[Vv]erf&uuml;gung/) { 
	  print Form::Formular(\%Daten, "widerspruch.odt"), "&nbsp;&nbsp;&nbsp;"; 
	  }
   unless( $Daten{"Mmail"} ) { 
	  print Form::Formular(\%Daten, "uz_anbahnung.odt"), "&nbsp;&nbsp;&nbsp;"; 
	  }
   
   my $Mstadt=($cgi->param('Mstadt')=~m/M.+nster/)? "Muenster%20(Westf.)" : Form::html2uri($cgi->param("Mstadt"));
   if( $cgi->param('Mstadt')=~m/Telgte/ ) { $Mstadt="Telgte/Kr%20Warendorf"; }
   #print '<a href="http://efa.vrr.de/vrr/XSLT_TRIP_REQUEST2?language=de&sessionID=0&useRealtime=1&itdLPxx_transpCompany=stwms&lineRestriction=400&pt&OptionsActive=1&place_origin=Muenster%20(Westf.)&name_origin=Neutor&type_origin=stop&place_destination='.$Mstadt.'&name_destination='.Form::html2uri($Daten{"Mstrasse"}).'&type_destination=address&sessionID=0" target="_blank">Busse&nbsp;ab&nbsp;Neutor</a> ';
   print '<a href="http://efa.vrr.de/vrr/XSLT_TRIP_REQUEST2?language=de&sessionID=0&useRealtime=1&itdLPxx_transpCompany=stwms&lineRestriction=400&pt&OptionsActive=1&place_origin=Muenster%20(Westf)&name_origin=Hedwigstrasse%202&type_origin=address&place_destination=',$Mstadt,'&name_destination=',Form::html2uri($cgi->param("Mstrasse")),'&type_destination=address&sessionID=0" target="_blank">Bus</a>';


   print '<p align=center><input type=button height=5em value="Drucken" onClick="print()" class="noprint" style="width: 100%; height: 0.93cm">', "\n";


print $cgi->end_html();




    my $Rechtsgebiet=$Daten{"Crechtsgebiet"};

    # Vereinfachen, wenn Zivilrecht (ausser Familienrecht)
    if( $Rechtsgebiet eq "AV" || $Rechtsgebiet eq "AG" || $Rechtsgebiet eq "MP" || $Rechtsgebiet eq "DR" || $Rechtsgebiet eq "VR" || $Rechtsgebiet eq "ZV" || $Rechtsgebiet eq "IK" ) { $Rechtsgebiet="ZR"; }
    if( $Rechtsgebiet eq "SR" || $Rechtsgebiet eq "BG" || $Rechtsgebiet eq "SN" ) { $Rechtsgebiet="SR"; }

    if ( -e "../courts/$Rechtsgebiet.cfg" ) {

	open(DATEI, "<../courts/$Rechtsgebiet.cfg") || die "Die Datei courts/all besteht nicht, oder Sie haben keine Leseberechtigung:\n$!";
        	@Zeilen = <DATEI>; 
	close(DATEI);
	}
    else {
	@Zeilen = "";
	}

    
    ## Gerichtsverzeichnisse loeschen, wenn leer, ueberschreiben, wenn PLZ vorhanden, sonst anhaengen
    my $neu=1;
    foreach (@Zeilen) { $_ =~ s/.+#:##:##:#\n//; $_ =~ s/ /&nbsp;/; } #  Leere Zeilen loeschen und Altfaelle ueberarbeiten
    $Zeile="$Daten{'Mland'}#:#$Daten{'Mplz'}#:#$Daten{'Cminstanz1'}#:#$Daten{'Cminstanz2'}#:#$Daten{'Cminstanz3'}#:#$Daten{'Cminstanz4'}\n";
    $Zeile =~ s/ /&nbsp;/; ## nur mit kodierten Leerzeichen, sonst Fehler beim erneutem Speichern
    foreach (@Zeilen) { 
	@Woerter=split(/#?\:#?/,$_);
	if( $Woerter[0] eq $Daten{'Mland'} && $Woerter[1] eq $Daten{'Mplz'} ) { $neu=0; } 
	}
    if ( $neu ) { push (@Zeilen, $Zeile); }
    if( $Daten{'Cginstanz1'} ) {
    	$neu=1;
    	$Zeile="$Daten{'Gland'}#:#$Daten{'Gplz'}#:#$Daten{'Cginstanz1'}#:#$Daten{'Cginstanz2'}#:#$Daten{'Cginstanz3'}#:#$Daten{'Cginstanz4'}\n";
    	$Zeile =~ s/ /&nbsp;/;
    	foreach (@Zeilen) { 
		@Woerter=split(/#?\:#?/,$_);
		if( $Woerter[0] eq $Daten{'Gland'} && $Woerter[1] eq $Daten{'Gplz'} ) { $neu=0; }
		}
	if ( $neu ) { push (@Zeilen, $Zeile); }
	}
    if( $Daten{'Ccinstanz1'} ) {
    	$neu=1;
    	$Zeile="$Daten{'Cland'}#:#$Daten{'Cplz'}#:#$Daten{'Ccinstanz1'}#:#$Daten{'Ccinstanz2'}#:#$Daten{'Ccinstanz3'}#:#$Daten{'Ccinstanz4'}\n";
    	$Zeile =~ s/ /&nbsp;/;
    	foreach (@Zeilen) { 
		@Woerter=split(/#?\:#?/,$_);
		if( $Woerter[0] eq $Daten{'Cland'} && $Woerter[1] eq $Daten{'Cplz'} ) { $neu=0; }
		}
	if ( $neu ) { push (@Zeilen, $Zeile); }
	}
    @Zeilen=sort(@Zeilen);

    Form::Speichern("../courts/$Rechtsgebiet.cfg", \@Zeilen, "In courts kann nicht geschrieben werden oder Sie haben keine Schreibberechtigung fuer die Rechtsgebietsliste $Rechtsgebiet:\n$!");

   ## Online-Archiv bestuecken
   ###########################
   if( $Daten{"Monline"} ) {
	unless(-e "../../iustus-sec/d/archiv/$Jahr") {
		mkdir("../../iustus-sec/d/archiv/$Jahr") || die "Neues Verzeichnis $Jahr kann im Archiv nicht angelegt werden :\n$!";
		chmod(0777, "../../iustus-sec/d/archiv/$Jahr");
		mkdir("../../iustus-sec/cgi-bin/d/archiv/$Jahr") || die "Neues Verzeichnis $Jahr kann im Archiv nicht angelegt werden :\n$!";
		chmod(0777, "../../iustus-sec/cgi-bin/d/archiv/$Jahr");
		}
	unless(-e "../../iustus-sec/d/archiv/$Jahr/$Fall") {
		mkdir("../../iustus-sec/d/archiv/$Jahr/$Fall") || die "Neues Unterverzeichnis $Fall kann im Archiv unter $Jahr nicht angelegt werden :\n$!";
		chmod(0777, "../../iustus-sec/d/archiv/$Jahr/$Fall");
		mkdir("../../iustus-sec/d/archiv/$Jahr/$Fall/in") || die "Neues Untreverzeichnis in unter $$Jahr/$Fall kann im Archiv nicht angelegt werden :\n$!";
		chmod(0777, "../../iustus-sec/d/archiv/$Jahr/$Fall/in");
		mkdir("../../iustus-sec/d/archiv/$Jahr/$Fall/out") || die "Neues Untreverzeichnis out unter $$Jahr/$Fall kann im Archiv nicht angelegt werden :\n$!";
		chmod(0777, "../../iustus-sec/d/archiv/$Jahr/$Fall/out");
		mkdir("../../iustus-sec/d/archiv/$Jahr/$Fall/client") || die "Neues Untreverzeichnis client unter $$Jahr/$Fall kann im Archiv nicht angelegt werden :\n$!";
		chmod(0777, "../../iustus-sec/d/archiv/$Jahr/$Fall/cient");
		mkdir("../../iustus-sec/d/archiv/$Jahr/$Fall/court") || die "Neues Untreverzeichnis court unter $$Jahr/$Fall kann im Archiv nicht angelegt werden :\n$!";
		chmod(0777, "../../iustus-sec/d/archiv/$Jahr/$Fall/court");
		my @htaccess='# .htaccess-Datei fuer Online-Archiv
AuthType Basic
AuthName "Mandanten-Bereich"
AuthUserFile /var/www/web1329/html/d/archiv/'.$Jahr.'/'.$Fall.'/.htusers
require valid-user
';
		open(DATEI, ">../../iustus-sec/d/archiv/$Jahr/$Fall/.htaccess") || die "htaccess fuer $Fall/$Jahr kann nicht angelegt werden, oder Sie haben keine Schreibberechtigung:\n$!";
			print DATEI @htaccess;
		close(DATEI);
		mkdir("../../iustus-sec/cgi-bin/d/archiv/$Jahr/$Fall") || die "Neues Unterverzeichnis $Fall kann im Archiv unter $Jahr nicht angelegt werden :\n$!";
		chmod(0777, "../../iustus-sec/cgi-bin/d/archiv/$Jahr/$Fall");
		copy("../../iustus-sec/cgi-bin/d/archiv/vorlage/archivindex.pl", "../../iustus-sec/cgi-bin/d/archiv/$Jahr/$Fall/archivindex.pl");
		copy("../../iustus-sec/cgi-bin/d/archiv/vorlage/index.pl", "../../iustus-sec/cgi-bin/d/archiv/$Jahr/$Fall/index.pl");
		open(DATEI, ">../../iustus-sec/cgi-bin/d/archiv/$Jahr/$Fall/.htaccess") || die "htaccess fuer $Fall/$Jahr kann nicht angelegt werden, oder Sie haben keine Schreibberechtigung:\n$!";
			print DATEI @htaccess;
		close(DATEI);
		}
	my @User;
	if(-e "../../Documents/$Jahr/$Fall/data/user.cfg" ) {
		@User=@{Form::Auslesen("../../Documents/$Jahr/$Fall/data/user.cfg")}; }
	my @htusers='# Benutzerdatei fuer Online Archiv 
hermanns:'.crypt("4eLein","IN")."\n";
	foreach(@User) {
		push(@htusers, $_); 	
		exec "qrencode -o /home/matthias/lawsuit/clients/$_/$_.png -m 1 http://www.iustus-secure.eu/cgi-bin/d/mandant.pl?Mfile=$_";
		}
	open(DATEI, ">../../iustus-sec/d/archiv/$Jahr/$Fall/.htusers") || die "htusers fuer $Fall/$Jahr kann nicht angelegt werden, oder Sie haben keine Schreibberechtigung:\n$!";
			print DATEI @htusers;
	close(DATEI);
	copy("../../iustus-sec/d/archiv/$Jahr/$Fall/.htusers", "../../iustus-sec/cgi-bin/d/archiv/$Jahr/$Fall/.htusers");
	}

   ## Ablage #################
   ###########################
   if( $cgi->param("Ablage") ) {
      # Fuer Zweitaufruf bei Fehleingabe erste Eintragungen wieder loeschen, wenn Verzeichnis sonst noch leer
      if(-e "../../Documents/$Jahr/_$Fall/data/stammdaten.cfg" ) { 
	unlink("../../Documents/$Jahr/_$Fall/data/stammdaten.cfg"); }
      if(-e "../../Documents/$Jahr/_$Fall/data/users.cfg" ) {
	unlink("../../Documents/$Jahr/_$Fall/data/users.cfg"); }
      rmdir("../../Documents/$Jahr/_$Fall/data");
      rmdir("../../Documents/$Jahr/_$Fall");
      # Fuer Zweitaufruf verschieben
      if( -d "../../Documents/$Jahr/$Fall") {
      	Form::Move("../../Documents/$Jahr/$Fall", "../../Documents/$Jahr/_$Fall") || die "Datenbestand aus $Fall in $Jahr kann nicht in das \nabgelegte Verzeichnis verschoben werden. \nVielleicht ist das abgelegte schon vorhanden und nicht leer, \noder es sind einzelne Dateien des Verzeichnisses bearbeitet und \nhaben eine nicht zu entfernende Lockfile hinterlassen :\n$!"; }
      ########
    }

#


}


##################################################################################################################

##################################################################################################################


sub Ablage {
    my $Ablage = shift;
    if ($Ablage) {
      return("<nbsp;><nbsp;><nbsp;>Ablagedatum:<nbsp;><nbsp;> ", $cgi->param('Cablagedatum'));
    }
    else {
      return("");
    }
 }

sub Geburtsdatum {
    my $Ges = shift;
    my $P = substr($Ges,0,1);
    if ($Daten{$Ges}<3) {
      return($cgi->Tr($cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'},"Geburtsdatum:"),  $cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, $Daten{$P."geboren"})));
    }
 }

sub Name {
    my $Typ = shift;
    my $Koerper = shift;
    my $Name = shift;
    if ( $Typ eq "Verwaltungstraeger" ) {
      my @Woerter=split(/&nbsp;&minus;&nbsp;/, $Name);
      if( length($Woerter[1])<1 ) {
	  $Woerter[0]=$Koerper;
	  $Woerter[1]=$Name; }
      return($cgi->Tr($cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, "Name:"), $cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, $Woerter[0])),
      $cgi->Tr($cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'},"Abteilung/Amt:"),  $cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, $Woerter[1])));
    } else {
      return($cgi->Tr($cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, "Name:"),  $cgi->td({-align => 'left' -valign => 'top' -BGCOLOR => '#ffffff' -width => '50%'}, $Name)));
    }
 }

sub Rechtsschutz {
    my $Versicherung = shift;
    if ($Versicherung) {
      return($cgi->param('Mversicherungsname'), "&nbsp;&bull;&nbsp;Vers.-Nr.&nbsp;",$cgi->param('Mversicherungsnr'));
    }
    else {
      return("nicht vorhanden");
    }
 }

sub  Vordruck{
    my $Rechtshilfe = shift;
    if ($Rechtshilfe) {
      return("Formular wird ausgegeben");
    }
    else {
      return("soll nicht beantragt werden"); 
    }
 }

sub Rechnungsnummer {
    my $Rechnung = shift;
    if ($Rechnung) {
      return("- Rechnungs-Nr. ", $Daten{"Crechnungsnummer"});
    }
    else {
      return("- keine Rechnungsnummer vergeben"); 
    }
 }

sub Gegner {
   my $Gegner = "Gegner:";
   if( $Daten{"Crechtsgebiet"} eq "BG") { $Gegner = "Zust&auml;ndige Verfolgungsbeh&ouml;rde:"; }
   if( $Daten{"Crechtsgebiet"} eq "SR") { $Gegner = "Zust&auml;ndige Staatsanwaltschaft/Polbeh.:"; }
   return($Gegner);
}

sub From2Sort {
 if(ord(substr($a,1)) < ord(substr($b,1)))
  { return -1; }
 elsif(ord(substr($a,1)) == ord(substr($b,1)))
  { return 0; }
 else
  { return 1; }
}


