#!/usr/bin/perl -w 

   use Encode;    # fuer OpenOffice - Konvertierung in UTF-8     

   use strict;
   use CGI;
   my $cgi = new CGI;
   use CGI::Carp qw(fatalsToBrowser);

   use lib "/home/hedele/lawsuit/cgi-bin/LS";
   use LS::Form;
   use LS::Stamm;

   my @Feldnamen = $cgi->param();
   my %Daten;
   my @Zeile;
   my @Zeilen;
   my $Zeile;
   my $verzeichnis;
   my $partei;



############################################################################################
if( $ENV{CONTENT_LENGTH} <= 0 ) {
############################################################################################

   $verzeichnis = ( length($cgi->param("BG"))>0 )? $cgi->param("BG") : "vorlage";
   %Daten = %{Form::Auslesen_Spiegel("../data/BG/$verzeichnis/alle.cfg", "", "")};
   for(my $i=0;$i<=3;$i++ ) {
	$Daten{$i."mandantchecked"} = ( $Daten{$i."mandanten"} )? "checked" : ""; }

   print $cgi->header(),
	 $cgi->start_html(-title =>'Lawsuit - SGB II');
   print @{Form::HTML("sgb2menu", \%Daten)};


############################################################################################
} else {
############################################################################################

   foreach my $Feld (@Feldnamen) {
	if( $cgi->param($Feld) )  {
	    $Daten{$Feld} = $cgi->param($Feld);
	} else {
	    $Daten{$Feld} = "";
	    }
	}

   $verzeichnis=$Daten{"BG"};
   if( $Daten{"loeschen"} ) {
	my $loeschen=$Daten{"loeschen"};
	my @Loeschen = glob("../data/BG/$verzeichnis/$loeschen*.cfg");
	foreach (@Loeschen) {
		unlink( $_ );
		}
	}
   unless ( -e "../data/BG/$verzeichnis" ) {
	mkdir("../data/BG/$verzeichnis") || die "Neue Bedarfsgemeinschaft $verzeichnis kann im Verzeichnis data/BG nicht angelegt werden :\n$!";
	chmod(0777, "../$verzeichnis");
	}

   Form::Speichern_Spiegel( \@Feldnamen, \%Daten, "../data/BG/$verzeichnis/alle.cfg", "[a-zA-Z0-9_]");


   for(my $i=0;$i<=3;$i++ ) {

	$Daten{$i."mandantchecked"} = ( $Daten{$i."mandanten"} )? "checked" : ""; 

	my $nummer =( $i>0 )? $i : "";
	my $P="M";
	if ( $Daten{$i."mandanten"} ) {
		$verzeichnis="clients";
		$partei=encode("utf8", Form::utf82html($Daten{"Cm".$nummer."file"})); }
	else {
		$P="P";
		$verzeichnis="parties";
		$partei=encode("utf8", Form::utf82html($Daten{"Cp".$nummer."file"})); }
	if( -e "../$verzeichnis/$partei/adresse.cfg") {
		my %Adresse=%{Form::Auslesen_Spiegel("../$verzeichnis/$partei/adresse.cfg", "", "")};
		$Daten{$i."vorname"}=$Adresse{$P."vorname"};
		$Daten{$i."nachname"}=$Adresse{$P."nachname"};
		$Daten{$i."geboren"}=$Adresse{$P."geboren"}; }

	}


   print $cgi->header(),
	 $cgi->start_html(-title =>'Lawsuit - SGB II');
   print @{Form::HTML("sgb2menu", \%Daten)};

}

   my $BG=$Daten{"BG"};
   my @Liste = glob("../data/BG/$BG/*_*.cfg");
   my %Schonmal;

   foreach my $Eintrag (@Liste) {
	
	$Eintrag =~ s/\.cfg$//;
	$Eintrag =~ s/^.*\///g;
	my $Suffix = substr($Eintrag,0,6);
	my $Jahr   = substr($Eintrag,0,4);
	my $Monat  = substr($Eintrag,4,2);
	   $Monat  = $Monat*1; 
	my @Monatsnamen = ("","Januar","Februar","M&auml;rz","April","Mai","Juni",
           "Juli","August","September","Oktober","November","Dezember");
	   $Monat = $Monatsnamen[$Monat];

	unless( $Schonmal{substr($Eintrag,0,6)} ) {
	print '<TABLE WIDTH=100% BORDER=1 BORDERCOLOR="#000000" CELLPADDING=4 CELLSPACING=0 RULES=COLS>
	<COL WIDTH=72*>
	<COL WIDTH=37*>
	<COL WIDTH=37*>
	<COL WIDTH=37*>
	<COL WIDTH=37*>
	<COL WIDTH=37*>
	<TBODY>
		<TR>
			<TD WIDTH=28% VALIGN=MIDDLE BGCOLOR="#c0c0c0">
				<P STYLE="background: #c0c0c0"><FONT SIZE=2 STYLE="font-size: 10pt">',$Monat,'
				',$Jahr,'</FONT></P>
			</TD>	
			<TD WIDTH=14% VALIGN=MIDLLE BGCOLOR="#c0c0c0" ALIGN=RIGHT>
				<input type=button value="l&ouml;schen" onClick="document.alg2.loeschen.value=',$Suffix,';document.alg2.submit();" >
			</TD>
';
	for( my $i=0;$i<4;$i++ ) {
		my $display=(length($Daten{$i."vorname"})>0)? '' : 'style="display:none"';
		print '			<TD WIDTH=14% VALIGN=MIDLLE BGCOLOR="#c0c0c0" ALIGN=RIGHT>
				<input type=button value="berechnen" onClick="javascript:adresse(&quot;',$i,'berechnen',$Suffix,'&quot;)" ',$display,'>
			</TD>
'		}
	print '		</TR>
	</TBODY>
';
	my @Zeilen = qw(E B H A R U);
	foreach my $Z (@Zeilen) {
		my $Text;
		if( $Z eq "E" ) { $Text="Bereinigtes Erwerbseinkommen"; }
		if( $Z eq "B" ) { $Text="Bedarf"; }
		if( $Z eq "H" ) { $Text="Abzgl. Einkommen nach Verteilung"; }
		if( $Z eq "A" ) { $Text="Leistung ALG II"; }
		if( $Z eq "R" ) { $Text="Davon Lebensunterhalt"; }
		if( $Z eq "U" ) { $Text="Davon Unterkunft und Heizung"; }
		my $farbe=($Z eq "A")? 'BGCOLOR="#c0c0c0"' : '';
		print '<TBODY>
		<TR VALIGN=TOP>
			<TD WIDTH=28% ',$farbe,'>
				<FONT SIZE=2 STYLE="font-size: 10pt">',$Text,'</FONT></P>
			</TD>
			<TD WIDTH=14% ',$farbe,'>
				<DIV ALIGN=RIGHT>
					<INPUT TYPE=TEXT NAME="',$Z,$Suffix,'in" SIZE=11 MAXLENGTH=11 STYLE="text-align:right" ONCHANGE="javascript:adjust(&quot;',$Z,$Suffix,'out&quot;,2)" VALUE="',$Daten{$Z.$Suffix."in"},'"><INPUT TYPE=HIDDEN SIZE=16 NAME="',$Z,$Suffix,'out" VALUE="',$Daten{$Z.$Suffix."out"},'">
				</DIV>
			</TD>
';
		for( my $i=0;$i<4;$i++ ) {
			my $display=(length($Daten{$i."vorname"})>0)? '' : 'style="display:none"';
			print '			<TD WIDTH=14% ',$farbe,'>
				<DIV ALIGN=RIGHT ',$display,'>
					<INPUT TYPE=TEXT NAME="',$i,$Z,$Suffix,'in" SIZE=11 MAXLENGTH=11 STYLE="text-align:right" ONCHANGE="javascript:adjust(&quot;',$i,$Z,$Z,$Suffix,'&quot;,2)" VALUE="',$Daten{$i.$Z.$Suffix."in"},'"><INPUT TYPE=HIDDEN SIZE=16 NAME="',$i,$Z,$Suffix,'out" VALUE="',$Daten{$i.$Z.$Suffix."out"},'">
				</DIV>
			</TD>
';
			}
		print '		</TR>
	</TBODY>
';
		}
	$Schonmal{substr($Eintrag,0,6)}=1;
	}
	}

print '</TABLE>
';


   ## Fuer das Anlegen neuer Berechnungen
   my ($Sekunden, $Minuten, $Stunden, $Monatstag, $Monat,
        $Jahr, $Wochentag, $Jahrestag, $Sommerzeit) = localtime(time);
   my $Auswahl=$Monat+1;
   my @Monat = qw(1#:#Januar 2#:#Februar 3#:#M&auml;rz 4#:#April 5#:#Mai 6#:#Juni 7#:#Juli 8#:#August 9#:#September 10#:#Oktober 11#:#November 12#:#Dezember);
   $Daten{"AuswahlMonat"} = Form::Ausklappmenue(\@Monat, "Monat", $Auswahl, "", 90, 200, 'onChange=javascript:historisch()');
   $Auswahl=$Jahr+1900;
   my @Jahr = qw(2008#:#2008 2009#:#2009 2010#:#2010 2011#:#2011 2012#:#2012 2013#:#2013 2014#:#2014 2015#:#2015 2016#:#2016 2017#:#2017 2018#:#2018);
   $Daten{"AuswahlJahr"} = Form::Ausklappmenue(\@Jahr, "Jahr", $Auswahl, "", 90, 200, 'onChange=javascript:historisch()');
   #######################################

   print '	<P><BR></P>
	<CENTER>
		<TABLE WIDTH=100% BORDER=0 CELLPADDING=10 CELLSPACING=0>
			<TR>
				<TD BGCOLOR="#c0c0c0">
					<DIV ALIGN=LEFT>
						<P>Neuen Leistungszeitraum ',$Daten{"AuswahlMonat"},$Daten{"AuswahlJahr"},'
						<input type=button value="      berechnen      " onClick="javascript:adresse(this.value)">
					</DIV>
				</TD>
				<TD BGCOLOR="#c0c0c0">
					<DIV ALIGN=RIGHT>
						<input type=button value="   Aktualisieren   " onClick="javascript:postthis()">
					</DIV>
				</TD>
			</TR>
		</TABLE>
	</CENTER>
<P STYLE="margin-bottom: 0cm"><BR>
</P>
</FORM>
';
   print $cgi->end_html;

