#!/usr/bin/perl -w 

   use Encode; # fuer OpenOffice - Konvertierung in UTF-8 

   use strict;
   use CGI;
   my $cgi = new CGI;
   use CGI::Carp qw(fatalsToBrowser);

   use lib "/home/hedele/lawsuit/cgi-bin/LS";
   use LS::Form;
   use LS::Stamm;

   my  @Felddaten       = split("&", $ENV{'QUERY_STRING'}); # fuer Aufruf aus account.pl GET-Methode (Stufe1)
   my  @Feldnamen       = $cgi->param();                    # fuer Aufruf aus account.pl POST-Methode (Stufe2)
   my  %Daten;

   # Formulardaten aus Query-String (GET) ermitteln
   foreach (@Felddaten) {
      my @W = split("=", $_);
      $Daten{"$W[0]"}  = Form::utf82html(encode("utf8",Form::noURI($W[1])));
   }
   # Formulardaten mit cgi-Modul (POST) ermitteln
   foreach my $Feld (@Feldnamen) {
      $Daten{$Feld}  = Form::utf82html(encode("utf8",$cgi->param($Feld)));
   }

   my $verzeichnis;
   my $Jahr=$Daten{"Jahr"};
   my $Vorlage="sgb2_".$Jahr;
   my %NeueDaten;
   my $Auswahl;
   my $Wert;
   my @Teil;





############################################################################################
if( $ENV{CONTENT_LENGTH} <= 0 ) {
############################################################################################


   my $BG=$Daten{"BG"};
      $Daten{"Monat"}  = ($Daten{"Monat"}*1<10)?  "0".($Daten{"Monat"}*1)  : $Daten{"Monat"}*1;
      $Daten{"Spalte"} = ($Daten{"Spalte"}*1<10)? "0".($Daten{"Spalte"}*1) : $Daten{"Spalte"}*1;
   my $Name=$Daten{"Jahr"}.$Daten{"Monat"}."_".$Daten{"Spalte"};
   if( -e "../data/BG/$BG/$Name.cfg" ) {
	%NeueDaten=%{Form::Auslesen_Spiegel("../data/BG/$BG/$Name.cfg", "", "")}; }
   else {
	%NeueDaten=%{Form::Auslesen_Spiegel("../data/BG/vorlage/vorlage.cfg", "", "")}; }
   foreach my $Schluessel (keys %NeueDaten) {
	unless( $Schluessel=~/name/m ) {
		$Daten{$Schluessel} = Form::html2form($NeueDaten{$Schluessel}); } 
	}


   my @Monat = qw(1#:#Januar 2#:#Februar 3#:#M&auml;rz 4#:#April 5#:#Mai 6#:#Juni 7#:#Juli 8#:#August 9#:#September 10#:#Oktober 11#:#November 12#:#Dezember);
   $Auswahl=$Daten{"Monat"}*1;
   $Daten{"AuswahlMonat"} = Form::Ausklappmenue(\@Monat, "Monat", $Auswahl, "", 90, 200, 'onChange=javascript:historisch()');

   my @Jahr = qw(2008#:#2008 2009#:#2009 2010#:#2010 2011#:#2011 2012#:#2012 2013#:#2013 2014#:#2014 2015#:#2015 2016#:#2016 2017#:#2017 2018#:#2018);
   $Auswahl=$Daten{"Jahr"};
   $Daten{"AuswahlJahr"} = Form::Ausklappmenue(\@Jahr, "Jahr", $Auswahl, "", 90, 200, 'onChange=javascript:historisch()');

   my @hilfe = qw(1#:#Regelsatz&nbsp;Alleinstehende/r 0.9#:#Regelsatz&nbsp;Ehe-/Lebenspartner 0.6#:#Sozialgeld&nbsp;bis&nbsp;14&nbsp;Jahre 0.8#:#Sozialgeld&nbsp;15-J&auml;hrige/r&nbsp; 1.0#:#Sozialgeld&nbsp;Nichterwerbsf&auml;hige/r);
   $Auswahl=$Daten{"hilfewert"};
   $Daten{"Auswahlhilfe"} = Form::Ausklappmenue(\@hilfe, "hilfewert", $Auswahl, "", 425, 425, 'onChange="javascript:hilfesatz(&quot;B1out&quot;,2),bedarf(&quot;B1out&quot;,2)"');

   # Neu ab 2011
   my @hilfe = qw(0#:#Regelsatz&nbsp;Alleinstehende/r 1#:#Regelsatz&nbsp;Ehe-/Lebenspartner 2#:#Regelsatz&nbsp;unter&nbsp;25&nbsp;Jahre&nbsp;nach&nbsp;ungenehmigtem&nbsp;Umzug 3#:#Sozialgeld&nbsp;Nichterwerbsf&auml;hige/r&nbsp;mind.&nbsp;18&nbsp;Jahre&nbsp;alt  4#:#Sozialgeld&nbsp;Nichterwerbsf&auml;hige/r&nbsp;bis&nbsp;17&nbsp;Jahre&nbsp;alt 5#:#Sozialgeld&nbsp;15-J&auml;hrige/r&nbsp;  6#:#Sozialgeld&nbsp;von&nbsp;6&nbsp;bis&nbsp;14&nbsp;Jahren  7#:#Sozialgeld&nbsp;von&nbsp;0&nbsp;bis&nbsp;5&nbsp;Jahren);
   $Auswahl=$Daten{"hilfewert"};
   $Daten{"Auswahlhilfneu"} = Form::Ausklappmenue(\@hilfe, "hilfewert", $Auswahl, "", 425, 425, 'onChange="javascript:hilfesatz(&quot;B1out&quot;,2),bedarf(&quot;B1out&quot;,2)"');

   my @mehrs = qw(0#:#kein&nbsp;Mehrbedarf 0.17#:#17%&nbsp;Mehrbedarf&nbsp;f&uuml;r&nbsp;Schwangere&nbsp;ab&nbsp;der&nbsp;13.&nbsp;Woche  0.36#:#36%&nbsp;Mehrbedarf&nbsp;f&uuml;r&nbsp;1&nbsp;Kind&nbsp;unter&nbsp;7&nbsp;Jahren  0.53#:#53%&nbsp;Mehrbedarf&nbsp;f&uuml;r&nbsp;1&nbsp;Kind&nbsp;unter&nbsp;7&nbsp;und&nbsp;Schwangerschaft 0.12#:#12%&nbsp;Mehrbedarf&nbsp;f&uuml;r&nbsp;1&nbsp;Kind&nbsp;ab&nbsp;7&nbsp;Jahren  0.29#:#29%&nbsp;Mehrbedarf&nbsp;f&uuml;r&nbsp;1&nbsp;Kind&nbsp;ab&nbsp;7&nbsp;und&nbsp;Schwangerschaft 0.3600001#:#36%&nbsp;Mehrbedarf&nbsp;f&uuml;r&nbsp;2&nbsp;bis&nbsp;3&nbsp;Kinder&nbsp;unter&nbsp;16&nbsp;Jahren  0.53#:#53%&nbsp;Mehrbedarf&nbsp;f&uuml;r&nbsp;2&nbsp;bis&nbsp;3&nbsp;Kinder&nbsp;und&nbsp;Schwangerschaft  0.48#:#48%&nbsp;Mehrbedarf&nbsp;f&uuml;r&nbsp;4&nbsp;Kinder&nbsp;unter&nbsp;16&nbsp;Jahren  0.65#:#65%&nbsp;Mehrbedarf&nbsp;f&uuml;r&nbsp;4&nbsp;Kinder&nbsp;und&nbsp;Schwangerschaft  0.60#:#60%&nbsp;Mehrbedarf&nbsp;f&uuml;r&nbsp;mehr&nbsp;als&nbsp;4&nbsp;Kinder&nbsp;unter&nbsp;16&nbsp;Jahren  0.77#:#77%&nbsp;Mehrbedarf&nbsp;f&uuml;r&nbsp;mehr&nbsp;als&nbsp;4&nbsp;Kinder&nbsp;und&nbsp;Schwangerschaft 0.35#:#35%&nbsp;Mehrbedarf&nbsp;bei&nbsp;Eingliederungshilfe  0#:#Indiv.&nbsp;Mehrbedarf&nbsp;f&uuml;r&nbsp;medizinisch&nbsp;anerkannte&nbsp;Di&auml;t);
   $Auswahl=$Daten{"mehrs"};
   $Daten{"Auswahlmehrs"} = Form::Ausklappmenue(\@mehrs, "mehrs", $Auswahl, "", 400, 400, 'onChange="javascript:hilfesatz(&quot;B2out&quot;,2),bedarf(&quot;B2out&quot;,2)"');

   my @warmw = qw(0#:#Zentrale&nbsp;Warmwasserversorgung 2.3#:#Keine&nbsp;Zentrale&nbsp;Warmwasserversorgung  2.3#:#2,3%&nbsp;Erwachsenenmehrbedarf&nbsp;f&uuml;r&nbsp;Warmwassererzeugung&nbsp;in&nbsp;der&nbsp;Whg. 1.4#:#1,4%&nbsp;Jugendlichenmehrbedarf&nbsp;f&uuml;r&nbsp;Warmwassererzeugung&nbsp;in&nbsp;der&nbsp;Whg. 1.2#:#1,2%&nbsp;Sch&uuml;lermehrbedarf&nbsp;f&uuml;r&nbsp;Warmwassererzeugung&nbsp;in&nbsp;der&nbsp;Whg.  0.8#:#0,8%&nbsp;Vorschulkindermehrbedarf&nbsp;f&uuml;r&nbsp;Warmwassererzeugung&nbsp;in&nbsp;der&nbsp;Whg.);
   $Auswahl=$Daten{"wamwasser"};
   $Daten{"Auswahlwarmw"} = Form::Ausklappmenue(\@warmw, "warmwasser", $Auswahl, "", 400, 400, 'onChange="javascript:hilfesatz(&quot;B14out&quot;,2),bedarf(&quot;B14out&quot;,2)"');

   my @kind = qw(0#:#Kein&nbsp;Kindergeldanspruch 1#:#Kindergeld&nbsp;als&nbsp;1.&nbsp;Kind  2#:#Kindergeld&nbsp;als&nbsp;2.&nbsp;Kind 3#:#Kindergeld&nbsp;als&nbsp;3.&nbsp;Kind  4#:#Kindergeld&nbsp;als&nbsp;weiteres&nbsp;Kind);
   $Auswahl=$Daten{"kind"};
   $Daten{"Auswahlkg"} = Form::Ausklappmenue(\@kind, "kind", $Auswahl, "", 400, 400, 'onChange="javascript:kindergeld(&quot;B3out&quot;,2),bedarf(&quot;B3out&quot;,2)"');

   my @E = qw(1#:#alle&nbsp;Monate 2#:#&nbsp;2&nbsp;Monate 3#:#&nbsp;3&nbsp;Monate  4#:#&nbsp;4&nbsp;Monate 6#:#&nbsp;6&nbsp;Monate 12#:#12&nbsp;Monate);
   $Auswahl=$Daten{"E02out"};
   $Daten{"AuswahlE02"} = Form::Ausklappmenue(\@E, "E02out", $Auswahl, "", 90, 400, 'onChange="javascript: einzel(&quot;E03out&quot;,2),frei(&quot;E03out&quot;,2)"');
   $Auswahl=$Daten{"E05out"};
   $Daten{"AuswahlE05"} = Form::Ausklappmenue(\@E, "E05out", $Auswahl, "", 90, 400, 'onChange="javascript: einzel(&quot;E06out&quot;,2),frei(&quot;E06out&quot;,2)"');

   my @Eart1 = qw(1#:#Arbeitnehmer 2#:#Selbstst&auml;ndiger 0#:#Leistungsbezieher);
   $Auswahl=$Daten{"E1art"};
   $Daten{"AuswahlE1art"} = Form::Ausklappmenue(\@Eart1, "E1art", $Auswahl, "", 90, 400, 'onChange="javascript:show(),frei(&quot;E07out&quot;,2)"');

   my @Eart2 = qw(3#:#Arbeitnehmer 6#:#Selbstst&auml;ndiger 0#:#Leistungsbezieher);
   $Auswahl=$Daten{"E2art"};
   $Daten{"AuswahlE2art"} = Form::Ausklappmenue(\@Eart2, "E2art", $Auswahl, "", 90, 400, 'onChange="javascript:show(),frei(&quot;E08out&quot;,2)"');

   my @Grenze = qw(1200#:#1.200 1500#:#1.500);
   $Auswahl=$Daten{"Grenze"};
   $Daten{"AuswahlGrenze"} = Form::Ausklappmenue(\@Grenze, "Grenze", $Auswahl, "", 90, 400,"");
				
   my @Z06 = qw(1#:#1&nbsp;im&nbsp;1.&nbsp;Jahr 0.5#:#&frac12;&nbsp;im&nbsp;2.&nbsp;Jahr);
   $Auswahl=$Daten{"Z06"};
   $Daten{"AuswahlZ06"} = Form::Ausklappmenue(\@Z06, "Z06", $Auswahl, $Auswahl, 90, 400,'onChange="javascript:zuschlag(&quot;Z07out&quot;,2)"');

   my @Z08 = qw(160#:#Alleinstehende/n 320#:#Partner);
   $Auswahl=$Daten{"Z08"};
   $Daten{"AuswahlZ08"} = Form::Ausklappmenue(\@Z08, "Z08", $Auswahl, $Auswahl, 90, 400,'onChange="javascript:zuschlag(&quot;Z10out&quot;,2)"');

   my @Anspruch = qw(0#:#Arbeitslosengeld&nbsp;II 1#:#Sozialgeld);
   $Auswahl=$Daten{"Anspruch"};
   $Daten{"AuswahlAnspruch"} = Form::Ausklappmenue(\@Anspruch, "Anspruch", $Auswahl, $Auswahl, 90, 400,'');

   if( $Daten{"E03out"}>0 || $Daten{"E06out"}>0 ) {
	$Daten{"Periode"}=1; }
   else {
	$Daten{"Periode"}=0; }

   # wenn Freibetrag noch nicht veraendert
        $Daten{"E18out"}||=100;
        $Daten{"E18in"}||=100;
   ## Horizontale Einkommensverteilung - Speicherdaten ueberschreiben
	$Daten{"B5out"}=$Daten{"Geseinkommen"};
	$Daten{"B8out"}=$Daten{"Gesbedarf"};
   ##

	print $cgi->header(),
	     $cgi->start_html(-title =>"$Auswahl-$Vorlage - Lawsuit - Einzelberechnung", -charset =>'utf8');
	print @{Form::HTML($Vorlage, \%Daten)};
	print $cgi->end_html;

}

############################################################################################
else {
#############################################################################################

   my $BG=$Daten{"BG"};
      $Daten{"Monat"}  = ($Daten{"Monat"}*1<10)?  "0".($Daten{"Monat"}*1)  : ($Daten{"Monat"}*1);
      $Daten{"Spalte"} = ($Daten{"Spalte"}*1<10)? "0".($Daten{"Spalte"}*1) : ($Daten{"Spalte"}*1);
   my $Name=$Daten{"Jahr"}.$Daten{"Monat"}."_".$Daten{"Spalte"};

##   my @Monat = qw(1#:#Januar 2#:#Februar 3#:#M&auml;rz 4#:#April 5#:#Mai 6#:#Juni 7#:#Juli 8#:#August 9#:#September 10#:#Oktober 11#:#November 12#:#Dezember);
##   $Auswahl=$Daten{"Monat"}*1;
##   $Daten{"AuswahlMonat"} = Form::Ausklappmenue(\@Monat, "Monat", $Auswahl, "", 90, 200, 'onChange=javascript:historisch()');

##   my @Jahr = qw(2008#:#2008 2009#:#2009 2010#:#2010 2011#:#2011 2012#:#2012 2013#:#2013 2014#:#2014 2015#:#2015 2016#:#2016 2017#:#2017 2018#:#2018);
##   $Auswahl=$Daten{"Jahr"};
##   $Daten{"AuswahlJahr"} = Form::Ausklappmenue(\@Jahr, "Jahr", $Auswahl, "", 90, 200, 'onChange=javascript:historisch()');


		Form::Speichern_Spiegel( \@Feldnamen, \%Daten, "../data/BG/$BG/$Name.cfg" , "*");


  ## Auswahltext anzeigen (Auswahlvariabeln werden wiederverwendet)

   my @Monat = qw(1#:#Januar 2#:#Februar 3#:#M&auml;rz 4#:#April 5#:#Mai 6#:#Juni 7#:#Juli 8#:#August 9#:#September 10#:#Oktober 11#:#November 12#:#Dezember);
   $Auswahl=$Daten{"Monat"}*1;
   $Daten{"AuswahlMonat"} = Form::Ausklappmenue(\@Monat, "Monat", $Auswahl, "", 90, 200, 'onChange=javascript:historisch()');
   $Daten{"AuswahlMonat"}=@Monat[0];
   $Daten{"AuswahlMonat"}=~s/^.+#:#//;
   foreach $Wert (@Monat) {
	@Teil=split(/#:#/, $Wert);
	if( $Auswahl eq $Teil[0] ) {
 		$Daten{"AuswahlMonat"} = $Teil[1];
		}
	}

   my @hilfe = qw(1#:#Regelsatz&nbsp;Alleinstehende/r 0.9#:#Regelsatz&nbsp;Ehe-/Lebenspartner 0.6#:#Sozialgeld&nbsp;bis&nbsp;14&nbsp;Jahre 0.8#:#Sozialgeld&nbsp;15-J&auml;hrige/r&nbsp; 1.0#:#Sozialgeld&nbsp;Nichterwerbsf&auml;hige/r);
   $Daten{"Auswahlhilfe"}=@hilfe[0];
   $Daten{"Auswahlhilfe"}=~s/^.+#:#//;
   foreach $Wert (@hilfe) {
	@Teil=split(/#:#/, $Wert);
	if( $Daten{"hilfewert"} eq $Teil[0] ) {
 		$Daten{"Auswahlhilfe"} = $Teil[1];
		}
	}
 
   my @mehrs = qw(0#:#kein&nbsp;Mehrbedarf 0.17#:#17%&nbsp;Mehrbedarf&nbsp;f&uuml;r&nbsp;Schwangere&nbsp;ab&nbsp;der&nbsp;13.&nbsp;Woche  0.36#:#36%&nbsp;Mehrbedarf&nbsp;f&uuml;r&nbsp;1&nbsp;Kind&nbsp;unter&nbsp;7&nbsp;Jahren  0.53#:#53%&nbsp;Mehrbedarf&nbsp;f&uuml;r&nbsp;1&nbsp;Kind&nbsp;unter&nbsp;7&nbsp;und&nbsp;Schwangerschaft 0.12#:#12%&nbsp;Mehrbedarf&nbsp;f&uuml;r&nbsp;1&nbsp;Kind&nbsp;ab&nbsp;7&nbsp;Jahren  0.29#:#29%&nbsp;Mehrbedarf&nbsp;f&uuml;r&nbsp;1&nbsp;Kind&nbsp;ab&nbsp;7&nbsp;und&nbsp;Schwangerschaft 0.3600001#:#36%&nbsp;Mehrbedarf&nbsp;f&uuml;r&nbsp;2&nbsp;bis&nbsp;3&nbsp;Kinder&nbsp;unter&nbsp;16&nbsp;Jahren  0.53#:#53%&nbsp;Mehrbedarf&nbsp;f&uuml;r&nbsp;2&nbsp;bis&nbsp;3&nbsp;Kinder&nbsp;und&nbsp;Schwangerschaft  0.48#:#48%&nbsp;Mehrbedarf&nbsp;f&uuml;r&nbsp;4&nbsp;Kinder&nbsp;unter&nbsp;16&nbsp;Jahren  0.65#:#65%&nbsp;Mehrbedarf&nbsp;f&uuml;r&nbsp;4&nbsp;Kinder&nbsp;und&nbsp;Schwangerschaft  0.60#:#60%&nbsp;Mehrbedarf&nbsp;f&uuml;r&nbsp;mehr&nbsp;als&nbsp;4&nbsp;Kinder&nbsp;unter&nbsp;16&nbsp;Jahren  0.77#:#77%&nbsp;Mehrbedarf&nbsp;f&uuml;r&nbsp;mehr&nbsp;als&nbsp;4&nbsp;Kinder&nbsp;und&nbsp;Schwangerschaft 0.35#:#35%&nbsp;Mehrbedarf&nbsp;bei&nbsp;Eingliederungshilfe  0#:#Indiv.&nbsp;Mehrbedarf&nbsp;f&uuml;r&nbsp;medizinisch&nbsp;anerkannte&nbsp;Di&auml;t);
   $Daten{"Auswahlmehrs"}=@mehrs[0];
   $Daten{"Auswahlmehrs"}=~s/^.+#:#//;
   foreach $Wert (@mehrs) {
	@Teil=split(/#:#/, $Wert);
	if( $Daten{"mehrs"} eq $Teil[0] ) {
 		$Daten{"Auswahlmehrs"} = $Teil[1];
		}
	}

   my @kind = qw(0#:#Kein&nbsp;Kindergeldanspruch 1#:#Kindergeld&nbsp;als&nbsp;1.&nbsp;Kind  2#:#Kindergeld&nbsp;als&nbsp;2.&nbsp;Kind 3#:#Kindergeld&nbsp;als&nbsp;3.&nbsp;Kind  4#:#Kindergeld&nbsp;als&nbsp;weiteres&nbsp;Kind);
   $Daten{"Auswahlkg"}=@kind[0];
   $Daten{"Auswahlkg"}=~s/^.+#:#//;
   foreach $Wert (@kind) {
	@Teil=split(/#:#/, $Wert);
	if( $Daten{"kind"} eq $Teil[0] )  {
 		$Daten{"Auswahlkg"} = $Teil[1];
		}
	}

   my @E = qw(1#:#&nbsp;Monate 2#:#&nbsp;2&nbsp;Monate 3#:#&nbsp;3&nbsp;Monate  4#:#&nbsp;4&nbsp;Monate 6#:#&nbsp;6&nbsp;Monate 12#:#12&nbsp;Monate);
   $Daten{"AuswahlE02"}=@E[0];
   $Daten{"AuswahlE02"}=~s/^.+#:#//;
   foreach $Wert (@E) {
	@Teil=split(/#:#/, $Wert);
	if( $Daten{"E02out"} eq $Teil[0] )  {
 		$Daten{"AuswahlE02"} = $Teil[1];
		}
	}
   $Daten{"AuswahlE05"}=@E[0];
   $Daten{"AuswahlE05"}=~s/^.+#:#//;
   foreach $Wert (@E) {
	@Teil=split(/#:#/, $Wert);
	if( $Daten{"E05out"} eq $Teil[0] )  {
 		$Daten{"AuswahlE05"} = $Teil[1];
		}
	}

   my @Eart1 = qw(1#:#Arbeitnehmer 2#:#Selbstst&auml;ndiger 0#:#Leistungsbezieher);
   $Daten{"AuswahlE1art"}=@Eart1[0];
   $Daten{"AuswahlE1art"}=~s/^.+#:#//;
   foreach $Wert (@Eart1) {
	@Teil=split(/#:#/, $Wert);
	if( $Daten{"E1art"} eq $Teil[0] )  {
 		$Daten{"AuswahlE1art"} = $Teil[1];
		}
	}

   my @Eart2 = qw(3#:#Arbeitnehmer 6#:#Selbstst&auml;ndiger 0#:#Leistungsbezieher);
   $Daten{"AuswahlE2art"}=@Eart2[0];
   $Daten{"AuswahlE2art"}=~s/^.+#:#//;
   foreach $Wert (@Eart2) {
	@Teil=split(/#:#/, $Wert);
	if( $Daten{"E2art"} eq $Teil[0] )  {
 		$Daten{"AuswahlE2art"} = $Teil[1];
		}
	}

   my @Grenze = qw(1200#:#1.200 1500#:#1.5003);
   $Daten{"AuswahlGrenze"}=@Grenze[0];
   $Daten{"AuswahlGrenze"}=~s/^.+#:#//;
   foreach $Wert (@Grenze) {
	@Teil=split(/#:#/, $Wert);
	if( $Daten{"Grenze"} eq $Teil[0] )  {
 		$Daten{"AuswahlGrenze"} = $Teil[1];
		}
	}
				
   my @Z06 = qw(1#:#1&nbsp;im&nbsp;1.&nbsp;Jahr 0.5#:#&frac12;&nbsp;im&nbsp;2.&nbsp;Jahr);
   $Daten{"AuswahlZ06"}=@Z06[0];
   $Daten{"AuswahlZ06"}=~s/^.+#:#//;
   foreach $Wert (@Z06) {
	@Teil=split(/#:#/, $Wert);
	if( $Daten{"Z06"} eq $Teil[0] )  {
 		$Daten{"AuswahlZ06"} = $Teil[1];
		}
	}

   my @Z08 = qw(160#:#Alleinstehende/n 320#:#Partner);
   $Daten{"AuswahlZ08"}=@Z08[0];
   $Daten{"AuswahlZ08"}=~s/^.+#:#//;
   foreach $Wert (@Z08) {
	@Teil=split(/#:#/, $Wert);
	if( $Daten{"Z08"} eq $Teil[0] )  {
 		$Daten{"AuswahlZ08"} = $Teil[1];
		}
	}

   my @Anspruch = qw(0#:#Arbeitslosengeld&nbsp;II 1#:#Sozialgeld);
   $Daten{"AuswahlAnspruch"}=@Anspruch[0];
   $Daten{"AuswahlAnspruch"}=~s/^.+#:#//;
   foreach $Wert (@Anspruch) {
	@Teil=split(/#:#/, $Wert);
	if( $Daten{"Anspruch"} eq $Teil[0] )  {
 		$Daten{"AuswahlAnspruch"} = $Teil[1];
		}
	}


############################################################################################

#############################################################################################



#############################################

   print "Aragma: no-cache\nContent-type: text/html\n\n";
   print qq~<HEAD><TITLE>Lawsuit - Parteidaten aufgenommen</TITLE><link rel="stylesheet" type="text/css" href="../stylesheets/lawsuit.css"><link rel="stylesheet" type="text/css" href="../stylesheets/$Daten{"Crechtsgebiet"}.css">
</HEAD><BODY class="grund"><BR><BR><BR><fieldset><table align="center" width="100%"><tr><td class="hell"><center><B><H2>Daten aufgenommen!</h2><BR><BR><input type="button" value="Schlie&szlig;en" onclick="window.close()"><BR><BR></center></td></tr><tr><td>~, "\n";
   print Form::Formular(\%Daten, "$Vorlage.sxw"),
	 qq~</td></tr></table></fieldset></BODY></HTML>~;

}

sub From2Sort {
 if(ord(substr($a,1)) < ord(substr($b,1)))
  { return -1; }
 elsif(ord(substr($a,1)) == ord(substr($b,1)))
  { return 0; }
 else
  { return 1; }
}
