#!/usr/bin/perl -w 

   use Encode;    # fuer OpenOffice - Konvertierung in UTF-8     

   use strict;
   use CGI;
   my $cgi = new CGI;
   use CGI::Carp qw(fatalsToBrowser);

   use lib "/home/matthias/lawsuit/cgi-bin/LS";
   use LS::Form;
   use LS::Stamm;

   my $Stundenlohn=25.2100840336;

   my @Feldnamen = $cgi->param();
   my $Datei;
   my %Daten;
   my $Jahr;
   my $Fall;
   my %Adresse;
   my $Zeile;
   my %Zeilen;
   my @Zeilen;
   my @W;
   my $Kanzleidatei; 
   my $Anwaltsdatei;
   my $Anwalt;
   my @Namensteil;
   my $verzeichnis;
   my @Beteiligte;
   my $Zusatzzeile;
   my $Auswahl;
   my $Stufe="0";
   
   my $abgelegt=$cgi->param("abgelegt");

   my $Prozessregister = Form::noURI($cgi->param("Cprozessregister"));
      #$Prozessregister =~s/&frasl;/\//g;
	    @W = split(/\//, $Prozessregister);
      $Fall=$W[0];
      $Jahr=$W[1];
      unless(length($Prozessregister)>0) {
	    $Jahr=$cgi->param("Jahr");
	    }


   my @Ges = qw(2#:#Frau 1#:#Herr 3#:#An&nbsp;die 4#:#An&nbsp;das 5#:#An&nbsp;den 6#:#Eheleute 7#:#Familie);
   my @Land;
   my @Laender=@{Form::Auslesen("../data/land.cfg")};
   foreach (@Laender) {
	@W=split(/#?\:#?/,$_);
	$Zeile=$W[0].'#:#'.$W[0];
	push(@Land, $Zeile);
	}
	
############################################################################
#     Leseberechtigung fuer /var/log/messages muss eingerichtet werden
#     zeiten.cfg (leer) mit Lese/Schreibberechtigung muss in data bestehen
############################################################################
	
	# Servertest
	my $serverup=0;
	eval {
		my $ping = "iustus.eu";
		# Leise Pingen und aus der 1. "transmitted"-Zeile, auf "1 received"=1 testen, 1 sec warten
		unless( system("ping -q -c 1 -W 1 $ping | grep -P 1.received >/dev/null") ) { } #$serverup=1; }
	};
	if ( $serverup ) {
		$Daten{"server"} = "http://www.iustus.eu";
		$Daten{"hinweisaufserver"} = "";
	} else {
		$Daten{"server"} = 'http://k1/lawsuit';
		$Daten{"hinweisaufserver"} = '&nbsp;-- ohne Serveranbindung --&nbsp;';
	}

   # Rechnungsnummer um 1 erhoehen #######
   if( $cgi->param('rechnung') eq "1" ) {
	$Zeile="var rn = \"".($cgi->param('Crechnungsnummer')+1)."\";";
	open(DATEI, ">../javascript/rechnungsnummer.js") || die "Datei rechnungsnummer.js besteht nicht, oder Sie haben keine Schreibberechtigung:\n$!";
		print DATEI $Zeile;
	close(DATEI);
	chmod(0777, "../javascript/rechnungsnummer.js");
   # Neue Nummern ins Internet zurueckuebertragen gelingt auch mit Net::FTP nicht, deshalb Hilfsicon auf Desktop mit Skript prozessregisterabgleich

        open(DATEI, "<../../Desktop/Server.desktop") || die "die Datei Server.desktop besteht nicht, oder Sie haben keine Leseberechtigung:\n$!";
              @Zeilen = <DATEI>;
              foreach(@Zeilen) { $_ =~ s/online/offline/g; }
        close(DATEI);
        open(DATEI, ">../../Desktop/Server.desktop") || "die Datei Server.desktop besteht nicht, oder Sie haben keine Schreibberechtigung:\n$!";
	      print DATEI @Zeilen;
        close(DATEI);
	system("dcop kdesktop KDesktopIface refreshIcons"); 
	}


#########################################
# Grundeinstellungen
# Verzeichnisse cgi-bin, tmp, Clients nd Opponents (je mit Vorlage),
# javascript (insb. prozessregister) und html # muessen bestehen
#########################################

			# Datenabfrage
			%Daten=%{Form::Auslesen_Spiegel("../../Documents/$Jahr/$Fall/data/stammdaten.cfg". "", "")};
			unless( -e "../../Documents/$Jahr/$Fall/data/stammdaten.cfg" ) { # Hilfe, wenn in Ablage verirrt
				%Daten=%{Form::Auslesen_Spiegel("../../Documents/$Jahr/_$Fall/data/stammdaten.cfg". "", "")};
				} 
			$Daten{"Cprozessregister"}=~s/&frasl;/\//g;
			$Daten{"Ckurzrubrum"}=~s/&frasl;/\//g;
			$Daten{"Cmahndatum"}=Form::Datum(3,14);
			$Daten{"action"}="../cgi-bin/rechnung_hv.pl";
			
			# Uebergabedaten
			foreach my $Feld (@Feldnamen) {
				if( $cgi->param($Feld) )  {
			          $Daten{$Feld} = $cgi->param($Feld);
				} else {
			          $Daten{$Feld} = "";  }
				}

			# Buchfuehrung einbinden
			my @Zeilen;

			my @Dateien=glob("../data/*_L*.cfg");
			foreach $Datei (@Dateien) {
				my @Info = stat($Datei);
				# Letzte Aenderungsszeit:
				$Datei=~s/.+\///g;
				$Datei=~s/\.cfg//g;
				my $Name=$Datei;
				$Name=~s/_/\./g;
				$Datei=Form::utf82html($Datei);
				$Zeile="$Info[9]"."#:#".$Datei."#:#".$Name;
				#Bankdateien aussparen
				unless( $Datei=~m/\w\w\d\d\d\d\d\d\d\d\d\d\d\d\d\d\d\d\d\d\d\d_\w\d\d\d\d/ ) {
					push(@Zeilen, $Zeile); }
				}

			#Zuletzt bearbeitete zuerst
			@Dateien=reverse(@Zeilen);

			#Stat-Eintrag entfernen
			foreach (@Dateien) {
				$_=~s/^\d+#\:#//;
				}
			$Daten{"Datei"}=$Dateien[0];    $Daten{"Datei"}=~s/^.+#\:#//g;   $Daten{"Datei"}=~s/\n//g;
			$Daten{"Name"} =$Dateien[0];    $Daten{"Name"}=~s/^.+#\:#//g;    $Daten{"Name"}=~s/\./_/g;

			$Daten{"BuchungsdateienHTML"}=Form::Ausklappmenue(\@Dateien, "Buchungsdatei", "", 10, 180, 100,'onChange=datei("Buchungsdatei")');


			# Servertest
			my $serverup=0;
			eval {
				my $ping = "iustus.eu";
				# Leise Pingen und aus der 1. "transmitted"-Zeile, auf "1 received"=1 testen, 1 sec warten
				unless( system("ping -q -c 1 -W 1 $ping | grep -P 1.received >/dev/null") ) {  $serverup=1; }
			};
			if ( $serverup ) {
				$Daten{"server"} = "http://www.iustus.eu";
				$Daten{"hinweisaufserver"} = "";
			} else {
				$Daten{"server"} = '..';
				$Daten{"hinweisaufserver"} = '&nbsp;-- ohne Serveranbindung --&nbsp;';
			}

			#Auslesen in verschiedener Reihenfolge (re/kf)
			my @Partei=($cgi->param("Weg") eq "kf")? qw(M) : qw(G);
			if( $Daten{"Mrechtsschutzversicherung"} ) { push(@Partei, "R"); }
			if( $Daten{"Ghaftpflichtversicherung"} || $Daten{"Grechtsschutzversicherung"} ) { push(@Partei, "H"); }
			if( $cgi->param("Weg") eq "kf" ) { push(@Partei, "G"); } else { push(@Partei, "M"); }

			my $Anzeige=0;
			my @Adressen;
			foreach(@Partei) {
				my $P = $_;
				my $p = lc($P);
				my $K = $_; #fuer Kanzleidaten
				$Daten{$p."rohname"}=Stamm::Rubrumklar($Daten{$p."rubrum"});
				my $Partei=$Daten{"C".$p."file"};
				my $partei=Form::html2utf8($Partei);
				my $x=1;
				$Anzeige++;
				my @Beteiligte;
				my %Adresse;
				while( length($Daten{"C".$p.$x."file"})>0 ) {
					$Beteiligte[($x-1)]=$Daten{"C".$p.$x."file"}; $x++; }
				my $Bez="";
				if ($P eq "G") { $verzeichnis = "opponents"; $Bez="Gegner"; }
				if ($P eq "M") { $verzeichnis = "clients";   $Bez="Mandant"; }
				if ($P eq "R") { $verzeichnis = "insurance"; $Bez="Gegner"; }
				if ($P eq "H") { $verzeichnis = "insurance"; $Bez="Gegner"; }
				unless( -e "../$verzeichnis/$partei/adresse.cfg" ) { 
					unless($P eq "G" && ($Daten{"Crechtsgebiet"} eq "AB" or $Daten{"Crechtsgebiet"} eq "PI") or $P eq /RHA/ ) {
						$verzeichnis="parties"; $P="P"; }
					}
				if( length($Partei)>0 ) { # fuer all.cfg vor Klammer gezogen
					%Adresse=%{Form::Auslesen_Spiegel("../$verzeichnis/$partei/adresse.cfg", "", "")}; }

				$Zeile=$Adresse{$P.'mail'}.";&nbsp;".$Adresse{$P.'ansprache'}.";&nbsp;".$Adresse{$P.'gruss'}.";&nbsp;".$Adresse{$P.'ges'}.";&nbsp;".$Adresse{$P.'vorname'}.";&nbsp;".$Adresse{$P.'nachname'};
				$Adresse{"pr"}=$Daten{"Cprozessregister"};
				$Adresse{"pr"}=~s/\//_/g;
				my %Adresszeilen=%{Form::Adresszeilen(\%Adresse, $P)};
				foreach (keys %Adresszeilen) {
					$Adresse{$_}=$Adresszeilen{$_}; }
				for( my $i=0;$i<=5;$i++) {
					 $Zeile.=";&nbsp;".$Adresszeilen{$P."adresse".$i}; 
					 }
				$Auswahl=$Zeile;
				$Zeile.="#:#".$Partei;
				push(@Adressen, $Zeile);

				if($P eq "G" or $P eq "M") {
					my $y=0;
					my @Zusatzansprache=($Adresse{$P.'ges'}.$Adresse{$P.'ansprache'});
					my $Zusatzfamilie;
					my $Zusatznamen=$Adresse{$P.'vorname'}.";&nbsp;";
					   #$Zusatznamen[0]=$Adresse{$P.'vorname'}.";&nbsp;";
					my $Nachname=$Adresse{$P.'nachname'};
					my $Familie;
					my $z=0;
					for( my $i=3;$i<=5;$i++ ) {
						$Familie.=$Adresszeilen{$P."adresse".$i}.";&nbsp;"; }
						$Familie=~s/;&nbsp;$//g;
					foreach(@Beteiligte) { # Javascript-Adressliste fuer jeden weiteren Beteiligten erstellen
						#if( $Name eq $Daten{$_} ) { unless($Gefunden) {$Anzeige++;$Gefunden++;} }
						my $datei=Form::html2utf8($_);
						#FEHLER 2. Auslesen
						my %BAdresse=%{Form::Auslesen_Spiegel("../$verzeichnis/$datei/adresse.cfg", "", "")};
						if( $Anzeige>0 ) {
							#Altfaelle mit kurzer Ansprache
							if( $BAdresse{$P.'ansprache'} =~ m/^[r\&]/ ) {  # fangen mir r oder HTML-Leerzeichen an
								$BAdresse{$P.'ansprache'}="Sehr&nbsp;geehrte".$BAdresse{$P.'ansprache'}.","; }
							###
							$BAdresse{$P.'verfuegung'} = ( length($BAdresse{$P.'telefax'})>1 )? "-&nbsp;vorab&nbsp;per&nbsp;Fax&nbsp;".$BAdresse{$P.'fax'}."&nbsp;-" : "-&nbsp;per&nbsp;Einwurfeinschreiben&nbsp;-";
							$Zeile=$P.";&nbsp;".$BAdresse{$P.'mail'}.";&nbsp;".$BAdresse{$P.'ansprache'}.";&nbsp;".$BAdresse{$P.'gruss'}.";&nbsp;".$BAdresse{$P.'verfuegung'}.";&nbsp;".$BAdresse{$P.'ges'}.";&nbsp;".$BAdresse{$P.'name'}.";&nbsp;".$BAdresse{$P.'strasse'}.";&nbsp;".$BAdresse{$P.'land'}.";&nbsp;".$BAdresse{$P.'plz'}.";&nbsp;".$BAdresse{$P.'stadt'}."#:#".$_;
							$Zusatzfamilie=$BAdresse{$P.'strasse'}.";&nbsp;".$BAdresse{$P.'land'}.";&nbsp;".$BAdresse{$P.'plz'}.";&nbsp;".$BAdresse{$P.'stadt'}."#:#"."Eheleute";
							push(@Adressen, $Zeile);
							}
						# Familienzeile schaffen
						if( $Zusatzfamilie=~/$Familie/m ) {
							$Zusatznamen=~s/\sund/\./; # ueberfluessiges erstes "und" ersetzen
							$Zusatznamen.="&nbsp;und&nbsp;".$BAdresse{$P.'vorname'};
							if( $Zusatznamen=~/\.\s/m ) {
								 $Zusatzfamilie=~s/Eheleute/Familie/;
								}
							}
						}
					if( $P eq "G" && length($Daten{'Cganwalt'}) > 1  ) {
						### Anwaltsadressdaten auslesen
						my @Anwaltszeilen=@{Form::Auslesen("../attorney/all.cfg")};
						my $Kanzleidatei;
						my $Anwaltsdatei;
						foreach (@Anwaltszeilen) {
							@_=split("#:#", $_);
							if( @_[1] eq $Daten{'Cganwalt'} ) { 
								$Kanzleidatei = Form::html2utf8(@_[3]); 
								$Anwaltsdatei = Form::html2utf8(@_[0]); 
								}
							}
						my %KAdresse=%{Form::Auslesen_Spiegel("../attorney/$Kanzleidatei/adresse.cfg", "", "")};
						my %AAdresse=%{Form::Auslesen_Spiegel("../attorney/$Kanzleidatei/$Anwaltsdatei.cfg", "", "")};
						$AAdresse{'Aname'} =~ s/RA(.+)&nbsp;//;
						$AAdresse{'Aname'} =~ s/\,&nbsp;.+$//;
						$KAdresse{'Kname'} =~ s/\,/\./g;
						$KAdresse{'Kverfuegung'} = ( length($KAdresse{'Ktelefax'})>1 )? "-&nbsp;vorab&nbsp;per&nbsp;Fax&nbsp;".$KAdresse{'Ktelefax'}."&nbsp;-" : "-&nbsp;per&nbsp;Einwurfeinschreiben&nbsp;-";
						$AAdresse{'Aansprache'} = ($AAdresse{'Ages'}==2)? "Sehr&nbsp;geehrte&nbsp;Frau&nbsp;Kollegin&nbsp;".$AAdresse{'Aname'}.", " : "Sehr&nbsp;geehrter&nbsp;Herr&nbsp;Kollege&nbsp;".$AAdresse{'Aname'}.", ";
						$AAdresse{'Agruss'} = "Mit&nbsp;freundlichen&nbsp;kollegialen&nbsp;Gr&uuml;&szlig;en";
						$Zeile="A;&nbsp;".$KAdresse{'Kmail'}.";&nbsp;".$AAdresse{'Aansprache'}.";&nbsp;".$AAdresse{'Agruss'}.";&nbsp;".$KAdresse{'Kverfuegung'}.";&nbsp;3;&nbsp;".$KAdresse{'Kname'}.";&nbsp;".$KAdresse{'Kstrasse'}.";&nbsp;".$KAdresse{'Kland'}.";&nbsp;".$KAdresse{'Kplz'}.";&nbsp;".$KAdresse{'Kstadt'}."#:#".$Anwaltsdatei;
						push(@Adressen, $Zeile);
						}
                                        #Fuer Altdaten 1. Ansprache erweitern (weitere per Javascript)
					if( $Adresse{$P.'ansprache'} =~ m/^[r\&]/ ) {  # fangen mir r oder HTML-Leerzeichen an
						$Adresse{$P.'ansprache'}="Sehr&nbsp;geehrte".$Adresse{$P.'ansprache'}.","; }
					#####
					$Adresse{$P.'verfuegung'} = ( length($Adresse{$P.'telefax'})>1 )? "-&nbsp;vorab&nbsp;per&nbsp;Fax&nbsp;".$Adresse{$P.'fax'}."&nbsp;-" : "-&nbsp;per&nbsp;Einwurfeinschreiben&nbsp;-";
					$Zeile=$P.";&nbsp;".$Adresse{$P.'mail'}.";&nbsp;".$Adresse{$P.'ansprache'}.";&nbsp;".$Adresse{$P.'gruss'}.";&nbsp;".$Adresse{$P.'verfuegung'}.";&nbsp;".$Adresse{$P.'ges'}.";&nbsp;".$Adresse{$P.'name'}.";&nbsp;".$Adresse{$P.'strasse'}.";&nbsp;".$Adresse{$P.'land'}.";&nbsp;".$Adresse{$P.'plz'}.";&nbsp;".$Adresse{$P.'stadt'}."#:#".$Partei;
					push(@Adressen, $Zeile);
					$Zusatznamen=~s/\sund\s$//;
					if( $Zusatznamen=~/und/m ) {
						my $Ges = ( $Zusatzfamilie=~/Eheleute/m )? 6 : 7;
						$Zeile=$P.";&nbsp;".$Adresse{$P.'mail'}.";&nbsp;".$Adresse{$P.'ansprache'}.";&nbsp;".$Adresse{$P.'gruss'}.";&nbsp;".$Adresse{$P.'verfuegung'}.";&nbsp;".$Ges.";&nbsp;".$Adresse{$P.'nachname'}.",&nbsp;".$Zusatznamen.";&nbsp;".$Zusatzfamilie;
						push(@Adressen, $Zeile);
						}
					}
                                        #Fuer Altdaten 1. Ansprache erweitern (weitere per Javascript)
					if( $Adresse{$P."ansprache"} =~ m/^[r\&]/ ) {  # fangen mir r oder HTML-Leerzeichen an
						$Adresse{$P."ansprache"}="Sehr&nbsp;geehrte".$Adresse{$P."ansprache"}.","; }
					if( length($Adresse{$P."gruss"})<=0 ) {
						$Adresse{$P."gruss"}="Mit&nbsp;freundlichen&nbsp;Gr&uuml;&szlig;en"; }

					if($P eq "M") {
						foreach (keys %Adresse) {
							my $Wert=$_;
							$Wert=~s/^M/R/g;
							unless($Daten{$Wert}) { $Daten{$Wert}=$Adresse{$_} }; 
							}
						@Adressen=reverse(@Adressen);
						$Daten{$Bez."Auswahl"}=Form::Ausklappmenue(\@Adressen, "Madresswahl", $Auswahl, "", 250, 			, 'onChange=javascript:adresswahl(this.form.name)');	
						# Neue Auswahl beginnen
						if( $cgi->param("Weg") eq "kf" ) { @Adressen=""; }
						}
				
				if($Anzeige==$#Partei+1) {   

					foreach (keys %Adresse) {
						my $Wert=$_;
						$Wert=~s/^[GHR]/S/g;
						unless($Daten{$Wert}) { $Daten{$Wert}=$Adresse{$_} }; 
						}
					@Adressen=reverse(@Adressen);
					$Daten{$Bez."Auswahl"}=Form::Ausklappmenue(\@Adressen, "GAdresswahl", $Auswahl, "", 250, 100, 'onChange=javascript:adresswahl(this.form.name)');
					$Daten{"Auswahl"}=Form::Ausklappmenue(\@Adressen, "Adresswahl", $Auswahl, "", 250, 100, 'onChange=javascript:adresswahl(this.form.name)');


					#####
#					$Rubrumlink=~s/\.\/\.(\s)?$//;
#					$Rubrumlink=~s/^(\s)?\.\/\.//;
#					$Rubrumlink.=" ".$Daten{"Cfolge"};

					print $cgi->header(),
					$cgi->start_html(-title =>'Lawsuit - Rechnung',  -style  =>{'src'=>'../stylesheets/faelle.css'}, -charset =>'utf8');
  
					# Standardausgabe Rechnung wird mit Mandantendaten gefÃ¼llt, ansonsten Praefix beibehalten

					$Daten{"Streitwertabfrage"} = "";
					$Daten{"Streitwertaktuell"} = "";
					$Daten{"Szeichen"} ||= "";
					$Daten{"Sschadennummer"} ||= "";

					unless( $Daten{"Crechtsgebiet"} eq "SR" || $Daten{"Crechtsgebiet"} eq "BG" || $Daten{"Crechtsgebiet"} eq "SN" || $Daten{"Crechtsgebiet"} eq "SG" ) { 
						$Daten{"Streitwertaktuell"} = '
		<fieldset>
		<legend>Abweichender Streitwert</legend>
		<table id="case">
			<tr>
			<td>
				<input type="text" name="Sswin" size="10" maxlength="55" value="'.$Daten{"Sswin"}.'"  onChange=javascript:zahl(this.name,2);getElement("name","Cgbin",0).value=zeigzahl(ragebuehr(zahl(this.name,2)),1,2);zahl("Sgbin",2);getElement("name","Cpgin",0).value=zeigzahl(pkhgebuehr(zahl(this.name,2)),1,2);zahl("Spgin",2);getElement("name","Cggin",0).value=zeigzahl(gergebuehr(zahl(this.name,2)),1,2);zahl("Sggin",2); style="text-align:right"/>
				<input type="hidden" name="Sswout" value="'.$Daten{"Sswout"}.'">
				<br><div class="comment">Streitwert (Regress)</div>
			</td>
			<td>
				<input type="text" name="Sgbin" size="8" maxlength="35" value="'.$Daten{"Sgbin"}.'" readonly style="text-align:right"/>
				<input type="hidden" name="Sgbout" value="'.$Daten{"Sgbout"}.'">
				<br><div class="comment">Anwaltsgeb&uuml;hr</div>
			</td>
			<td>
				<input type="text" name="Spgin" size="8" maxlength="35" value="'.$Daten{"Spgin"}.'" readonly style="text-align:right"/>
				<input type="hidden" name="Spgout" value="'.$Daten{"Spgout"}.'">
				<br><div class="comment">PKH-Geb&uuml;hr</div>
			</td>
			</tr>
			<tr>
			<td colspan=2/>
			<td>
				<input type="text" name="Sggin" size="8" maxlength="35" value="'.$Daten{"Sggin"}.'" readonly style="text-align:right"/>
				<input type="hidden" name="Spgout" value="'.$Daten{"Sggout"}.'">
				<br><div class="comment">Gerichtsgeb&uuml;hr</div>
			</td>
			</tr>
		</table>
		</fieldset>
';
						}
					$Anzeige++;
					}
				
				#Zusatzfelder fuer Ueberweisungstraeger
				foreach my $P ("M","P") {
					$Daten{$P."cleariban"}=$Daten{$P."iban"};
					$Daten{$P."cleariban"}=~s/&nbsp;//g;
					$Daten{$P."shortiban"}=$Daten{$P."cleariban"};
					$Daten{$P."shortiban"}=~s/\D//g; 
					}
				}

########################################################################################################################################
     if( $cgi->param("stufe")==0 ) { 
########################################################################################################################################
	
	unless( $Daten{"Crechtsgebiet"} eq "SR" || $Daten{"Crechtsgebiet"} eq "BG" || $Daten{"Crechtsgebiet"} eq "SN" || $Daten{"Crechtsgebiet"} eq "SG" ) { 
	$Daten{"Streitwertabfrage"} = '
		<fieldset>
		<legend>Streitwert</legend>
		<table id="case">
			<tr>
			<td>
				<input type="text" name="Cswin" size="10" maxlength="55" value="'.$Daten{"Cswin"}.'"  onChange=javascript:zahl(this.name,2);getElement("name","Cgbin",0).value=zeigzahl(ragebuehr(zahl(this.name,2)),1,2);zahl("Cgbin",2);getElement("name","Cpgin",0).value=zeigzahl(pkhgebuehr(zahl(this.name,2)),1,2);zahl("Cpgin",2);getElement("name","Cggin",0).value=zeigzahl(gergebuehr(zahl(this.name,2)),1,2);zahl("Cggin",2); style="text-align:right"/>
				<input type="hidden" name="Cswout" value="'.$Daten{"Cswout"}.'">
				<br><div class="comment">Streitwert (vorl.)</div>
			</td>
			<td>
				<input type="text" name="Cgbin" size="8" maxlength="35" value="'.$Daten{"Cgbin"}.'" readonly style="text-align:right"/>
				<input type="hidden" name="Cgbout" value="'.$Daten{"Cgbout"}.'">
				<br><div class="comment">Anwaltsgeb&uuml;hr</div>
			</td>
			<td>
				<input type="text" name="Cpgin" size="8" maxlength="35" value="'.$Daten{"Cpgin"}.'" readonly style="text-align:right"/>
				<input type="hidden" name="Cpgout" value="'.$Daten{"Cpgout"}.'">
				<br><div class="comment">PKH-Geb&uuml;hr</div>
			</td>
			</tr>
			<tr>
			<td colspan=2/>
			<td>
				<input type="text" name="Cggin" size="8" maxlength="35" value="'.$Daten{"Cggin"}.'" readonly style="text-align:right"/>
				<input type="hidden" name="Cpgout" value="'.$Daten{"Cggout"}.'">
				<br><div class="comment">Gerichtsgeb&uuml;hr</div>
			</td>
			</tr>
		</table>
		</fieldset>
';
	}
	if( $cgi->param("Weg") eq "kf" ) {
		print @{Form::HTML("rechnung_kf", \%Daten)}; }
	else {
		print @{Form::HTML("rechnung_re", \%Daten)}; }
	}

########################################################################################################################################
     elsif( $cgi->param("stufe")==1 ) { 
########################################################################################################################################
	
	unless( $Daten{"Crechtsgebiet"} eq "SR" || $Daten{"Crechtsgebiet"} eq "BG" || $Daten{"Crechtsgebiet"} eq "SN" || $Daten{"Crechtsgebiet"} eq "SG" ) { 
	$Daten{"Streitwertabfrage"} = '
		<fieldset>
		<legend>Streitwert</legend>
		<table id="case">
			<tr>
			<td>
				'.$Daten{"Cswin"}.'
				<br><div class="comment">Streitwert (vorl.)</div>
			</td>
			<td>
				'.$Daten{"Cgbin"}.'
				<br><div class="comment">Anwaltsgeb&uuml;hr</div>
			</td>
			<td>
				'.$Daten{"Cpgin"}.'
				<br><div class="comment">PKH-Geb&uuml;hr</div>
			</td>
			</tr>
			<tr>
			<td colspan=2/>
			<td>
				'.$Daten{"Cggin"}.'
				<br><div class="comment">Gerichtsgeb&uuml;hr</div>
			</td>
			</tr>
		</table>
		</fieldset>
';
	}
	if( $cgi->param("Weg") eq "kf" ) {
		print @{Form::HTML("rechnung_kf1", \%Daten)}; }
	else {
		print @{Form::HTML("rechnung_re1", \%Daten)}; }
		}

				
#########################################
# Fallzeiten
# auslesen
#########################################
			
     #Zeittallen bereinigen und Zeiten auslesen
     my ($Sekunden, $Minuten, $Stunden, $Monatstag, $Monat,
	$Jahr, $Wochentag, $Jahrestag, $Sommerzeit) = localtime(time);
     my @Info = stat("../data/zeit.cfg");
     my ($sekunden, $minuten, $stunden, $monatstag, $monat,
	$jahr, $wochentag, $jahrestag, $sommerzeit) = localtime($Info[9]);
     my $Aufschlag=($Sommerzeit)? 7200 : 3600;
     my @Shutdown;
     my $Down;
     my @NeueZeilen;
  
     # Allgemeine Zeitentabelle
     @Zeilen=@{Form::Auslesen("../data/zeiten.cfg")};
     foreach(@Zeilen) {
		@W=split(/#:#/, $_);
		my $zeit=shift(@W);
		$Zeilen{$zeit}=join("#:#",@W);
		}
     
     #Heutige Zeitentabelle
     open(DATEI, "<../data/zeit.cfg") || die "die Datei zeit.cfg nicht gefunden\n$!";
	@NeueZeilen = <DATEI>;
     close(DATEI);
		
     # Doppel in zeiten.cfg mit zeit.cfg ueberschreiben
     foreach(@NeueZeilen) {
		@W=split(/#:#/, $_);
		my $zeit=shift(@W);
		$Zeilen{$zeit}=join("#:#",@W);
		}
		
     # Zeiten.cfg auf den aktuellen stand von gestern Abend bringen
     if($monatstag < $Monatstag) {
        #Offenbar versehentlich nicht "Pause" gedrueckt-> Ende wird aus Shutdownzeit errechnet
	open(DATEI, "<../data/messages.txt") || die "die Ausgabe von journalctl in ../data/messages.txt konnte nicht geöffnet werden\n$!";
		@Zeilen = <DATEI>;
	close(DATEI);
        foreach (@Zeilen) {
		if( $_=~m/Stopping/) {
			@Shutdown=split(/\s/,$_);
			}
		}
	my @Month=qw(Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec);
	my $x=0;
        foreach (@Month) {
		my @time=split(/\:/,$Shutdown[2]);
		if( $Shutdown[0] eq $_ ) { $Down=timelocal($time[2],$time[1],($time[0]-1-$Sommerzeit),$Shutdown[1],$x,$Jahr); }
		$x++;
		}

	push(@Zeilen, $Down.'#:#Pause#:#'.localtime($Down).'#:# '."\n");
	push(@Zeilen, '########################################################################################'."\n");
	open(DATEI, ">>../data/zeiten.cfg") || die "die Datei zeit.cfg konnte nicht beschrieben werden\n$!";
		print DATEI @NeueZeilen;
	close(DATEI); 
	}
	
     # Bereinigten Zeilen-Hash wieder in Tabelle umwandeln
     @Zeilen="";
     foreach(keys(%Zeilen)) {
              unless($_=~m/######/) {
			push(@Zeilen,$_."#:#".$Zeilen{$_}); }
			}
     @Zeilen=sort(@Zeilen);

     #Tabellenmuster in nur einer einheitlichen Verfahrensstufe darstellen
     my @Zeiten = '
<CENTER>
<fieldset class="hell">
<fieldset>
<legend>Zeitentabelle</legend>

<TABLE WIDTH=90% BORDER=1 CELLPADDING=4 CELLSPACING=0> 

  <TR> 
   <TD width=27% style="background-color:#c0c0c0"> 
    Honorarv. &sect; 3a RVG</TD> 
   <TD width=9% style="background-color:#c0c0c0"> 
    Satz:</TD> 
   <TD width=17% style="background-color:#c0c0c0;text-align:right"><input type=text name="Stunde" value="'.Form::Zeigezahl($Stundenlohn,2).'" style="width:70px;text-align:right" onChange=&quot;adjust("Stundeout",2)&quot;><input type=hidden name="Stundeout" value="'.$Stundenlohn.'">EUR</TD> 
   <TD width=9% style="text-align:center"> 
    von</TD> 
   <TD width=11% style="text-align:center"> 
    bis</TD> 
   <TD width=10% style="text-align:center"> 
    h</TD> 
   <TD width=17%> 
    <BR> 
   </TD> 
  </TR>'; 

     #Auslesen
        my @W=split(/#:#/, @Zeilen[0], );
        my $Anfang=$W[0];
        my $Fall=$W[1];
	my %Arbeit;
        my $aktiv=0;
        my $x=2;
        my @Z;
	foreach(@Zeilen) {
		my @Z=split(/#:#/, $_);
		if( $Z[1] ne $Fall ) {
			if( $Z[1] eq $Prozessregister && $#W<4 ) { # nur wenn Treffer und noch nicht gebucht
				$aktiv=1; }
			if( $Z[1] eq "Pause" && $aktiv ) { # nur, wenn aktive Taetigkeit zum Fall beendet
			        $Z[3]=~s/^.+\/\w+\.pl(?)//; #Text ohne Pfad
			        if( $Daten{"Tabelle2_B".$x} ) { $Z[3] = $Daten{"Tabelle2_B".$x}; } # wenn anderer Text eingegeben wurde, diesen nehmen
			        push( @Zeiten, '
  <TR> 
   <TD colspan=3 width=53%><input type=text name="Tabelle2_A'.$x.'" value="'.Form::Datum(1,0,$Anfang).'" style="width:70px;text-align:center" onChange="datum(this.name,1,0)">
    <input type=text name="Tabelle2_B'.$x.'" value="'.$Z[3].'"></TD> 
   <TD width=9% style="text-align:center"><input type=text name="Tabelle2_C'.$x.'" value="'.Zeigezeit((($Anfang+$Aufschlag) % 86400)).'" style="width:70px;text-align:center" onChange="zeit(this.name,3);rechne('.$x.')"></TD> 
   <TD width=11% style="text-align:center"><input type=text name="Tabelle2_D'.$x.'" value="'.Zeigezeit((($Z[0]+$Aufschlag) % 86400)).'" style="width:70px;text-align:center" onChange="zeit(this.name,3);rechne('.$x.')"></TD> 
   <TD width=10% style="text-align:center"><input type=text name="Tabelle2_E'.$x.'" value="'.Zeigezeit(($Z[0]-$Anfang)).'" style="width:70px;text-align:center" onChange="zeit(this.name,3);rechne('.$x.')"></TD> 
   <TD width=17% style="text-align:right"><input type=text name="Tabelle2_H'.$x.'EURin" value="'.Form::Zeigezahl((($Z[0]-$Anfang)/3600*$Stundenlohn),2).'" readonly style="width:70px;text-align:right"><input type=hidden name="Tabelle2_H'.$x.'EUR" value="'.(($Z[0]-$Anfang)/3600*$Stundenlohn).'">EUR</TD> 
  </TR>' );
				$Arbeit{$Prozessregister}+=$Z[0]-$Anfang;
				$x++; $aktiv=0;
				}
			$Fall=$Z[1]; $Anfang=$Z[0];
			}
		}
     push( @Zeiten, ' 
  <TR> 
   <TD colspan=3 width=53%> 
    Zwischensumme</TD> 
   <TD width=9%> 
    <BR> 
   </TD> 
   <TD width=11%> 
    <BR> 
   </TD> 
   <TD width=10%> 
    <BR> 
   </TD> 
   <TD width=17% style="text-align:right"><input type=text name="Tabelle2_E'.$x.'EURin" value="'.Form::Zeigezahl(($Arbeit{$Prozessregister}/3600*$Stundenlohn),2).'" style="width:70px;text-align:right"><input type=hidden name="Tabelle2_E'.$x.'EUR" value="'.$Arbeit{$Prozessregister}/3600*$Stundenlohn.'">EUR</TD> 
  </TR> 
  <TR> 
   <TD colspan=3 width=53%> 
    19 % Umsatzsteuer 
    VV 7008 RVG</TD> 
   <TD width=9%> 
    <BR> 
   </TD> 
   <TD width=11%> 
    <BR> 
   </TD> 
   <TD width=10%> 
    <BR> 
   </TD> 
   <TD width=17% style="text-align:right"><input type=text name="Tabelle2_E'.($x+1).'EURin" value="'.Form::Zeigezahl(($Arbeit{$Prozessregister}/3600*$Stundenlohn*0.19),2).'" style="width:70px;text-align:right"><input type=hidden name="Tabelle2_E'.($x+1).'EUR" value="'.$Arbeit{$Prozessregister}/3600*$Stundenlohn*0.19.'">EUR</TD> 
  </TR> 
  <TR> 
   <TD colspan=3 width=53%> 
    Summe<A HREF="#sdfootnote1sym">
<SUP>1</SUP>
</A>
</TD> 
   <TD width=9% style="background-color:#c0c0c0"> 
    <BR> 
   </TD> 
   <TD width=11% style="background-color:#c0c0c0"> 
    <BR> 
   </TD> 
   <TD width=10% style="background-color:#c0c0c0"> 
    <BR> 
   </TD> 
   <TD width=17% style="background-color:#c0c0c0;text-align:right"><input type=text name="Tabelle2_E'.($x+2).'EURin" value="'.Form::Zeigezahl(($Arbeit{$Prozessregister}/3600*$Stundenlohn*1.19),2).'" style="width:70px;text-align:right"><input type=hidden name="Tabelle2_E'.($x+2).'EUR" value="'.$Arbeit{$Prozessregister}/3600*$Stundenlohn*1.19.'">EUR</TD> 
  </TR> 
</TABLE> 
<BR> 
<DIV ID="sdfootnote1"> 
 <A CLASS="sdfootnotesym" NAME="sdfootnote1sym" HREF="#sdfootnote1anc">1</A> 
 Hinweis gem. &sect; 286 III BGB: Der Schuldner einer 
 Entgeltforderung kommt sp&auml;testens in Verzug, wenn er nicht 
 innerhalb von 30 Tagen nach F&auml;lligkeit und Zugang einer 
 Rechnung oder gleichwertigen Zahlungsaufstellung leistet.</DIV> 

</fieldset>
</fieldset>
<CENTER>
<br><p>
');


########################################################################################################################################
        if( $cgi->param("stufe")==1 ) {
########################################################################################################################################

           
                # Gesamtzeilen neu ermitteln
                $x=2;
                while( length($Daten{"Tabelle2_H".$x."EURin"}) > 0 ) {
			$x++; }
		
		# ODT-Ueberweisungstraeger richtig fuellen
		$Daten{"Betrag"}=$Daten{"Tabelle2_E".($x+2)."EURin"};
		$Daten{"Ergebnisfeld"}=$x+2;
        
               	# ODT-Ausgabe
               	$Daten{"Tabellenstyle"} = '  <style:style style:name="Tabelle2.A1" style:family="table-cell">
   <style:table-cell-properties fo:background-color="#c0c0c0" fo:padding="0.108cm" fo:border-left="0.002cm solid #000000" fo:border-right="none" fo:border-top="0.002cm solid #000000" fo:border-bottom="none">
    <style:background-image/>
   </style:table-cell-properties>
  </style:style>
  <style:style style:name="Tabelle2.D1" style:family="table-cell" style:data-style-name="N108">
   <style:table-cell-properties style:vertical-align="bottom" fo:background-color="#c0c0c0" fo:padding="0.108cm" fo:border-left="none" fo:border-right="0.002cm solid #000000" fo:border-top="0.002cm solid #000000" fo:border-bottom="none">
    <style:background-image/>
   </style:table-cell-properties>
  </style:style>
  <style:style style:name="Tabelle2.E1" style:family="table-cell">
   <style:table-cell-properties style:vertical-align="bottom" fo:padding="0.108cm" fo:border="none"/>
  </style:style>
';

                $Daten{"Tabelleneinschub"} = '    <table:table table:name="Tabelle2" table:style-name="Tabelle2">
     <table:table-column table:style-name="Tabelle2.A"/>
     <table:table-column table:style-name="Tabelle2.B"/>
     <table:table-column table:style-name="Tabelle2.C"/>
     <table:table-column table:style-name="Tabelle2.D"/>
     <table:table-column table:style-name="Tabelle2.E"/>
     <table:table-column table:style-name="Tabelle2.F"/>
     <table:table-column table:style-name="Tabelle2.G"/>
     <table:table-column table:style-name="Tabelle2.H"/>
     <table:table-row>
      <table:table-cell table:style-name="Tabelle2.A1" table:number-columns-spanned="2" office:value-type="string">
       <text:p text:style-name="P57">Honorar § 3a RVG</text:p>
      </table:table-cell>
      <table:covered-table-cell/>
      <table:table-cell table:style-name="Tabelle2.A1" office:value-type="string">
       <text:p text:style-name="P58">Satz:</text:p>
      </table:table-cell>
      <table:table-cell table:style-name="Tabelle2.D1" office:value-type="currency" office:currency="EUR" office:value="'.$Daten{"Stundeout"}.'">
       <text:p text:style-name="P58">'.$Daten{"Stunde"}.' EUR</text:p>
      </table:table-cell>
      <table:table-cell table:style-name="Tabelle2.E1" office:value-type="string">
       <text:p text:style-name="P60">von</text:p>
      </table:table-cell>
      <table:table-cell table:style-name="Tabelle2.E1" office:value-type="string">
       <text:p text:style-name="P60">bis</text:p>
      </table:table-cell>
      <table:table-cell table:style-name="Tabelle2.E1" office:value-type="string">
       <text:p text:style-name="P60">h</text:p>
      </table:table-cell>
      <table:table-cell table:style-name="Tabelle2.E1" office:value-type="string">
       <text:p text:style-name="P61"/>
      </table:table-cell>
     </table:table-row>
';
     
		for( my $zeile=2;$zeile<$x; $zeile++ ) {
                
                # Ohne Linie 
                my                     $Style = 'fo:border-top="none" fo:border-bottom="none"';
                # Linie oben
                if( $zeile == 2 )    { $Style = 'fo:border-top="0.002cm solid #000000" fo:border-bottom="none"'; }
                # Linie unten
                if( $zeile+1 == $x ) { $Style = 'fo:border-top="none" fo:border-bottom="0.002cm solid #000000"'; }
                # Linie oben und unten
                if( $x == 3 )        { $Style = 'fo:border-top="0.002cm solid #000000" fo:border-bottom="0.002cm solid #000000"'; } 
                
                $Daten{"Tabellenstyle"} .= '  <style:style style:name="Tabelle2.A'.$zeile.'" style:family="table-cell" style:data-style-name="N37">
   <style:table-cell-properties fo:padding="0.108cm" fo:border-left="0.002cm solid #000000" fo:border-right="none" '.$Style.'/>
  </style:style>
  <style:style style:name="Tabelle2.B'.$zeile.'" style:family="table-cell">
   <style:table-cell-properties style:vertical-align="bottom" fo:padding="0.108cm" fo:border-left="none" fo:border-right="none" '.$Style.'/>
  </style:style>
  <style:style style:name="Tabelle2.E'.$zeile.'" style:family="table-cell" style:data-style-name="N40">
   <style:table-cell-properties style:vertical-align="bottom" fo:padding="0.108cm" fo:border-left="none" fo:border-right="none" '.$Style.'/>
  </style:style>
  <style:style style:name="Tabelle2.H'.$zeile.'" style:family="table-cell" style:data-style-name="N108">
   <style:table-cell-properties style:vertical-align="bottom" fo:padding="0.108cm" fo:border-left="none" fo:border-right="0.002cm solid #000000" '.$Style.'/>
  </style:style>
';

		$Daten{"Tabelleneinschub"} .= '     <table:table-row>
      <table:table-cell table:style-name="Tabelle2.A'.$zeile.'" office:value-type="date" office:date-value="'.ODTDatum($Daten{"Tabelle2_A".$zeile}).'">
       <text:p text:style-name="P64">'.$Daten{"Tabelle2_A".$zeile}.'</text:p>
      </table:table-cell>
      <table:table-cell table:style-name="Tabelle2.B'.$zeile.'" table:number-columns-spanned="3" office:value-type="string">
       <text:p text:style-name="P64">'.$Daten{"Tabelle2_B".$zeile}.'</text:p>
      </table:table-cell>
      <table:covered-table-cell/>
      <table:covered-table-cell/>
      <table:table-cell table:style-name="Tabelle2.E'.$zeile.'" office:value-type="time" office:time-value="'.ODTTime($Daten{"Tabelle2_C".$zeile}).'">
       <text:p text:style-name="P65">'.$Daten{"Tabelle2_C".$zeile}.'</text:p>
      </table:table-cell>
      <table:table-cell table:style-name="Tabelle2.E'.$zeile.'" office:value-type="time" office:time-value="'.ODTTime($Daten{"Tabelle2_D".$zeile}).'">
       <text:p text:style-name="P65">'.$Daten{"Tabelle2_D".$zeile}.'</text:p>
      </table:table-cell>
      <table:table-cell table:style-name="Tabelle2.E'.$zeile.'" table:formula="ooow:&lt;D'.$zeile.'&gt;-&lt;C'.$zeile.'&gt;" office:value-type="time" office:time-value="'.ODTTime($Daten{"Tabelle2_E".$zeile}).'">
       <text:p text:style-name="P65">'.$Daten{"Tabelle2_E".$zeile}.'</text:p>
      </table:table-cell>
      <table:table-cell table:style-name="Tabelle2.H'.$zeile.'" table:formula="ooow:&lt;E'.$zeile.'&gt;*1440*&lt;C1&gt;/60" office:value-type="currency" office:currency="EUR" office:value="'.$Daten{"Tabelle2_H".$zeile."EUR"}.'">
       <text:p text:style-name="P56">'.$Daten{"Tabelle2_H".$zeile."EURin"}.' EUR</text:p>
      </table:table-cell>
     </table:table-row>
';
		}
                # zu wenig Musterzeilen
                my $y=$x;
                if( $x<5 ) {  
                        $Daten{"Tabellenstyle"} .= '  <style:style style:name="Tabelle2.B3" style:family="table-cell">
   <style:table-cell-properties style:vertical-align="bottom" fo:padding="0.108cm" fo:border="none"/>
  </style:style>
  <style:style style:name="Tabelle2.B4" style:family="table-cell">
   <style:table-cell-properties style:vertical-align="bottom" fo:padding="0.108cm" fo:border-top="none" fo:border-bottom="0.002cm solid #000000"/>
  </style:style>
';
                        $y=5;
                        }

		        
                $Daten{"Tabellenstyle"} .= '  <style:style style:name="Tabelle2.E'.$x.'" style:family="table-cell" style:data-style-name="N109">
   <style:table-cell-properties style:vertical-align="bottom" fo:padding="0.108cm" fo:border="none"/>
  </style:style>
  <style:style style:name="Tabelle2.G'.$x.'" style:family="table-cell" style:data-style-name="N108">
   <style:table-cell-properties style:vertical-align="bottom" fo:padding="0.108cm" fo:border="none"/>
  </style:style>
  <style:style style:name="Tabelle2.E'.($x+1).'" style:family="table-cell">
   <style:table-cell-properties style:vertical-align="top" fo:padding="0.108cm" fo:border-left="none" fo:border-right="none" fo:border-top="none" fo:border-bottom="0.002cm solid #000000"/>
  </style:style>
  <style:style style:name="Tabelle2.G'.($x+1).'" style:family="table-cell" style:data-style-name="N108">
   <style:table-cell-properties style:vertical-align="bottom" fo:padding="0.108cm" fo:border-left="none" fo:border-right="none" fo:border-top="none" fo:border-bottom="0.002cm solid #000000"/>
  </style:style>
  <style:style style:name="Tabelle2.E'.($x+2).'" style:family="table-cell" style:data-style-name="N108">
   <style:table-cell-properties style:vertical-align="bottom" fo:background-color="#c0c0c0" fo:padding="0.108cm" fo:border-left="none" fo:border-right="none" fo:border-top="none" fo:border-bottom="0.002cm solid #000000">
    <style:background-image/>
   </style:table-cell-properties>
  </style:style>';
  
                my $Additionsfelder=($x>3)? 'F2:F'.($x-1) : 'F2'; # vereinfachen, falls nur eine Zeile
                $Daten{"Tabelleneinschub"} .= '     <table:table-row>
      <table:table-cell table:style-name="Tabelle2.B'.($y-2).'" table:number-columns-spanned="4" office:value-type="string">
       <text:p text:style-name="P64">Zwischensumme</text:p>
      </table:table-cell>
      <table:covered-table-cell/>
      <table:covered-table-cell/>
      <table:covered-table-cell/>
      <table:table-cell table:style-name="Tabelle2.E'.$x.'">
       <text:p text:style-name="P62"/>
      </table:table-cell>
      <table:table-cell table:style-name="Tabelle2.E'.$x.'">
       <text:p text:style-name="P62"/>
      </table:table-cell>
      <table:table-cell table:style-name="Tabelle2.G'.$x.'">
       <text:p text:style-name="P66"/>
      </table:table-cell>
      <table:table-cell table:style-name="Tabelle2.G'.$x.'" table:formula="ooow:sum(&lt;'.$Additionsfelder.'&gt;)" office:value-type="currency" office:currency="EUR" office:value="'.$Daten{"Tabelle2_E".$x."EUR"}.'">
       <text:p text:style-name="P66">'.$Daten{"Tabelle2_E".$x."EURin"}.' EUR</text:p>
      </table:table-cell>
     </table:table-row>
     <table:table-row>
      <table:table-cell table:style-name="Tabelle2.B'.($y-1).'" table:number-columns-spanned="4" office:value-type="string">
       <text:p text:style-name="P64">19 % Umsatzsteuer VV 7008 RVG</text:p>
      </table:table-cell>
      <table:covered-table-cell/>
      <table:covered-table-cell/>
      <table:covered-table-cell/>
      <table:table-cell table:style-name="Tabelle2.E'.($x+1).'" office:value-type="string">
       <text:p text:style-name="P62"/>
      </table:table-cell>
      <table:table-cell table:style-name="Tabelle2.E'.($x+1).'" office:value-type="string">
       <text:p text:style-name="P62"/>
      </table:table-cell>
      <table:table-cell table:style-name="Tabelle2.G'.($x+1).'">
       <text:p text:style-name="P66"/>
      </table:table-cell>
      <table:table-cell table:style-name="Tabelle2.G'.($x+1).'" table:formula="ooow:&lt;E'.$x.'&gt;*0,19" office:value-type="currency" office:currency="EUR" office:value="'.$Daten{"Tabelle2_E".($x+1)."EUR"}.'">
       <text:p text:style-name="P66">'.$Daten{"Tabelle2_E".($x+1)."EURin"}.' EUR</text:p>
      </table:table-cell>
     </table:table-row>
     <table:table-row>
      <table:table-cell table:style-name="Tabelle2.B'.($y-1).'" table:number-columns-spanned="4" office:value-type="string">
       <text:p text:style-name="P57">Summe<text:span text:style-name="T9"><text:note text:id="ftn1" text:note-class="footnote"><text:note-citation>1</text:note-citation><text:note-body>
           <text:p text:style-name="P73"><text:span text:style-name="T8"><text:s/>Hinweis gem. § 286 III BGB:</text:span> Der Schuldner einer Entgeltforderung kommt spätestens in Verzug, wenn er nicht innerhalb von 30 Tagen nach Fälligkeit und Zugang einer Rechnung oder gleichwertigen Zahlungsaufstellung leistet.</text:p></text:note-body></text:note></text:span></text:p>
      </table:table-cell>
      <table:covered-table-cell/>
      <table:covered-table-cell/>
      <table:covered-table-cell/>
      <table:table-cell table:style-name="Tabelle2.E'.($x+2).'">
       <text:p text:style-name="P63"/>
      </table:table-cell>
      <table:table-cell table:style-name="Tabelle2.E'.($x+2).'">
       <text:p text:style-name="P63"/>
      </table:table-cell>
      <table:table-cell table:style-name="Tabelle2.E'.($x+2).'">
       <text:p text:style-name="P58"/>
      </table:table-cell>
      <table:table-cell table:style-name="Tabelle2.E'.($x+2).'" table:formula="ooow:sum(&lt;E'.$x.':E'.($x+1).'&gt;)" office:value-type="currency" office:currency="EUR" office:value="'.$Daten{"Tabelle2_E".($x+2)."EUR"}.'">
       <text:p text:style-name="P58">'.$Daten{"Tabelle2_E".($x+2)."EURin"}.' EUR</text:p>
      </table:table-cell>
     </table:table-row>
    </table:table>';

                my $Betragout=Form::Zahl($Daten{"Tabelle2_E".($x+2)."EURin"});
                $Daten{"qrbank"}="BCD\n001\n1\nSCT\nGENODEM1MSC\nKanzlei Hermanns\nDE35401600500081511100\nEUR$Betragout\n\n\n$Daten{'Ckurzrubrum'} - $Daten{'Cprozessregister'} RE";

		# HTML-Endausgabe entschlacken
                foreach(@Zeiten) {
			$_=~s/<input\stype=hidden.+\">EUR<\/TD>/ EUR<\/TD>/g; # Zusatzfelder
			$_=~s/<input.+value=\"//g;                            # alle Felder
			$_=~s/\"\sstyle=.+datum\(this.name,1,0\)\">/&nbsp;/g; # Datum
			$_=~s/\"><\/TD>/<\/TD>/g;                             # Datumsrest
			$_=~s/\"\s(readonly\s)?style=.+EUR<\/TD>/ EUR<\/TD>/g;# Hauptfelder             
			$_=~s/\"\sstyle=.+<\/TD>/<\/TD>/g;                    # Zeitfelder
			}
		}
 
        print @Zeiten;
        print '<input type="hidden" name="stufe" value="0">',"\n";

        
 	if( $cgi->param("stufe") eq "1" ) {
		print Form::Formular(\%Daten, "rechnung_HV.odt"), "&nbsp;&nbsp;&nbsp;"; 
		print '	
			<TABLE width=80%>
				<tr>
				<td align=right><input type=button value="Drucken" onClick="print()" class="noprint"></td>
				</tr>
			</TABLE>', "\n";

		}
        else {
		print '
			<TABLE width=80%>
				<tr>
				<td align=right><input type=button value="Buchen" onClick="javascript:getElementsByName(&quot;stufe&quot;)[0].value=1;document.rechnung.submit()"></td>
				</tr>
			</TABLE>', "\n";
		}
	print '</FORM>', "\n";
	print $cgi->end_html;


sub NummernSort {
 if($a > $b)
  { return -1; }
 elsif($a == $b)
  { return 0; }
 else
  { return 1; }
}

sub Zeigezeit {
  my $zeit=shift;
  my @null;
     $null[0] = (int($zeit/3600)/10<1)? "0" : "" ;
     $null[1] = ((int($zeit/60)-int($zeit/3600)*60)/10<1)? "0" : "" ;
     $null[2] = (($zeit-int($zeit/60)*60)/10<1)? "0" : "" ;
     
  return  $null[0].int($zeit/3600).':'.$null[1].(int($zeit/60)-int($zeit/3600)*60).':'.$null[2].($zeit-int($zeit/60)*60);
}

sub ODTDatum {
  my $mydatum=shift;
  my @oodatum=split(/\./, $mydatum);
  if(length($oodatum[2])<4) { $oodatum[2]="20".$oodatum[2]; }
  
  return $oodatum[2]."-".$oodatum[1]."-".$oodatum[0];
}

sub ODTTime {
  my $mytime=shift;
  my @ootime=split(/\:/, $mytime);
  
  return "PT".$ootime[0]."H".$ootime[1]."M".$ootime[0]."S";
}

