#!/usr/bin/perl -w 

   use Encode; # fuer OpenOffice - Konvertierung in UTF-8 

   use strict;
   use CGI;
   my $cgi = new CGI;
   use CGI::Carp qw(fatalsToBrowser);

   use lib "/home/hedele/lawsuit/cgi-bin/LS";
   use LS::Form;
   use LS::Stamm;

   my @Feldnamen = $cgi->param();
   my %Daten;
   my $Partei;
   my $partei;
   my $verzeichnis;
   my $Error;
   my @Option;
   my $Ueberspringe=0;   
   my $Rechtsgebiet=$cgi->param("Crechtsgebiet");
   my @Woerter;
   my @Zeilen;
   my $Zeile;	
   my @Fritzzeilen;
   my $Fritzzeile;

   foreach my $Feld (@Feldnamen) {
	if( $cgi->param($Feld) )  {
		$Daten{$Feld} = Form::utf82html(encode("utf8", $cgi->param($Feld)));
		$Daten{$Feld}=~s/undefined(&nbsp;)?//g;
	} else {
		$Daten{$Feld} = "";
		}
	}

   my @Ges = qw(2#:#Frau 1#:#Herr 3#:#An&nbsp;die 4#:#An&nbsp;das 5#:#An&nbsp;den);
   my @Titel = qw(#:# Dr.#:#Dr. Prof.#:#Prof. Prof.&nbsp;Dr.#:#Prof.&nbsp;Dr. Mtre#:#Mtre Msgr.#:#Msgr. Dott.#:#Dott. Dott.ssa#:#Dott.ssa);
   my @Land;
   my @Laender=@{Form::Auslesen("../data/land.cfg")};
   foreach (@Laender) {
	@Woerter=split(/#?\:#?/,$_);
	$Zeile=$Woerter[0].'#:#'.$Woerter[0];
	push(@Land, $Zeile);
	}

############################################################################################
if( $ENV{CONTENT_LENGTH} <= 0 ) {
############################################################################################


   ###### Partei suchen #####################
   $Daten{"mandantanlegen"}=0; ## nichts verschieben
   $verzeichnis="parties"; $partei="vorlage";
   if ( length($cgi->param($cgi->param("wo")))>0 ) {
	$Partei = Stamm::Rubrumklar(Form::noURI($cgi->param($cgi->param("wo"))));
	$Daten{"Cmfile"}=$Partei;

	if ( $cgi->param("wo") =~ /Cm/m ) {
	    $partei = encode("utf8", Form::utf82html($Partei)); 
	    if ( -e "../clients/$partei" ) { $verzeichnis="clients"; $Daten{"Cmquelle"}="M"; $Ueberspringe=1; }
	    else { $Daten{"mandantanlegen"}=1; }  ## Mandant war angeklickt aber in parties
	} elsif( $cgi->param("wo") =~ /Cp/m ) {
	    $partei = encode("utf8", Form::utf82html($Partei)); 
	    if ( -e "../parties/$partei" ) { $verzeichnis="parties";  $Daten{"Cmquelle"}="P";
	 	 $Ueberspringe=1;}
 	    if ( -e "../clients/$partei" ) { $verzeichnis="clients"; $Daten{"Cmquelle"}="M"; 
	         $Error="Partei wurde als Mandant gefunden, bitte kreuzen Sie das K&auml;stchen an!"; }
 	    }
	}


  unless( $Ueberspringe>0 ) {

     my @Partei=qw(M W);

     foreach my $P (@Partei) {


	my $Nachname=$Daten{"Mnachname"};
	my $parteiname;
	my $parteien;
	my $javaclick="onClick";

	if( $P eq "M" ) { $parteiname="mandant"; $parteien="mandanten"; }
	if( $P eq "W" ) { $parteiname="widerstreitmandant"; $parteien="widerstreit"; }

	my $Auswahl="Person";
	$Daten{"auswahlhinweisHTML"}="&nbsp;";
	if( $Daten{"Crechtsgebiet"} eq "SR" and ( $P eq "G" or $P eq "X" ) ) {
		$Daten{"auswahlhinweisHTML"}="Zust&auml;ndige Staatsanwaltschaft:"; $Auswahl="Staatsanwaltschaft"; 
		$javaclick="onChange"; }
 	if( $Daten{"Crechtsgebiet"} eq "BG" and ( $P eq "G" or $P eq "X" ) ) {
		$Daten{"auswahlhinweisHTML"}="Zust&auml;ndige Verfolgungsbeh&ouml;rde";	$Auswahl="Verwaltungstraeger";
		$javaclick="onChange"; }

        my @Adressen=@{Stamm::Adressliste($Nachname, "P", "$Auswahl")}; # mit Altadressen vergleichen
	my @Options =@{Stamm::Adressliste($Nachname, $P, "$Auswahl")}; # aktuelle Faelle anhaengen
	if( $P eq "M" or $P eq "G" ) {
		foreach (@Adressen) { push(@Options, $_); }
		@Options=sort(From2Sort @Options);
		}

        $Daten{$parteiname."HTML"}=Form::Ausklappmenue(\@Options, "$parteien", "", 10, 200, 200, $javaclick.'=javascript:found("'.$parteien.'")');
	
	}


  } else {

      $Daten{"mandantHTML"} = " ";
      $Daten{"widerstreitmandantHTML"} = " ";

      }

  if ( length($Daten{"widerstreitmandantHTML"})>1 ) { 
      $Daten{"widerstreitmandantHTML"} = '			<P>
			<FONT FACE="Helvetica, sans-serif" COLOR="red">M&ouml;gliche widerstreitende Interessen mit:</FONT><BR>'."\n".$Daten{"widerstreitmandantHTML"};
      }


#####################################################


  if ( length($Error)>0 ) {
       print "Pragma: no-cache\nContent-type: text/html\n\n";
       print qq~<HEAD><TITLE>Error</TITLE></HEAD><BODY bgcolor="#ffffff"><BR><BR><BR><table align="center" width="500"><tr><td><B><FONT face="verdana" size="2" COLOR="#000080"><center><H2>Error!</h2><BR>$Error<BR>Die Bearbeitung wird abgebrochen.<BR><BR>~;
       exit;
       }
  elsif ( length($Daten{"mandantHTML"})>1 || length($Daten{"widerstreitgegnerHTML"})>1) { 
	print $cgi->header(),
	     $cgi->start_html(-title =>'Lawsuit - Parteien', -charset =>'utf8');
	print @{Form::HTML("parteiA", \%Daten)};
	print $cgi->end_html;
	}
  else  {
	$Ueberspringe++;
	}

}

############################################################################################
if( $Ueberspringe>0 or $cgi->param("stufe") eq "2" ) {
#############################################################################################

	# Servertest
	my $serverup=0;
	eval {
		my $ping = "adiuvo.org";
		# Leise Pingen und aus der 1. "transmitted"-Zeile, auf "1 received"=1 testen, 1 sec warten
		unless( system("ping -q -c 1 -W 1 $ping | grep -P 1.received >/dev/null") ) { } #$serverup=1; }
	};
	if ( $serverup ) {
		$Daten{"server"} = "http://www.adiuvo.org";
		$Daten{"hinweisaufserver"} = "";
	} else {
		$Daten{"server"} = '..';
		$Daten{"hinweisaufserver"} = '&nbsp;-- ohne Serveranbindung --&nbsp;';
	}

        my $P="M";
	my $p="m";

	if( $Ueberspringe>1 ) {
		$verzeichnis="parties";
		$Partei = Stamm::Rubrumklar($Daten{"Cmfile"});
		$partei = encode("utf8", Form::utf82html($Partei)); 

		if ( $Daten{"Cmquelle"} eq "M" ) {
		    if ( -e "../clients/$partei" ) { $verzeichnis="clients"; $Daten{"Cmquelle"}="M"; }
		    else { $Daten{"mandantanlegen"}=1; }  ## Mandant war angeklickt	aber in parties
		} elsif( $Daten{"Cmquelle"} eq "P" ) {
		    if ( -e "../parties/$partei" ) { $Daten{"Cmquelle"}="P"; }
		    }
	}


	elsif( $Ueberspringe==0 ) {
		$verzeichnis = ($Daten{"Cmquelle"} eq "M")? "clients" : "parties";
		$Daten{"Cmfile"}=($Daten{"Cmfile"})? $Daten{"Cmfile"} : "vorlage";
		$Partei = Stamm::Rubrumklar($Daten{"Cmfile"});
		$partei = encode("utf8", Form::utf82html($Partei)); 
		}

	else {
		$verzeichnis="parties";
		$Partei =~ s/[\.\,\- ]//g;                    # Leer- und Hilfseichen entfernen: Atalan, &Ouml;.
		$Partei =  lc($Partei);                      # Standardnamen erzeuten Atalanö 
		$partei="vorlage";
		}

	if( $Daten{"C".$p."quelle"} eq "P" && $Daten{"mandantanlegen"} ) { ## wenn Daten aus Parties geholt werden, dann all.cfg anpassen, sofern nicht leeres Vorlagenfeld
		move("../parties/$partei", "../$verzeichnis/$partei") || die "$Partei kann nicht aus parties in $verzeichnis verschoben werden: $!";
		my @Parteien=@{Form::Auslesen("../parties/all.cfg")};
		my $x=0; my $y; foreach (@Parteien) { if( $_=~/^$Partei\#*/) {$y=$x;} $x++; }
		$Zeile=splice(@Parteien, $y, 1)."\n";
		Form::Speichern("../parties/all.cfg", \@Parteien, "die Datei parties/all.cfg kann nicht beschrieben werden :\n$!");
		my @Parteien=@{Form::Auslesen("../$verzeichnis/all.cfg")};
		push(@Parteien, $Zeile); @Parteien=sort(@Parteien);
		Form::Speichern("../$verzeichnis/all.cfg", \@Parteien, "die Datei $verzeichnis/all.cfg kann nicht beschrieben werden :\n$!");
		}


 #  unless (-e "../$verzeichnis/$partei" || $partei eq "vorlage") { $verzeichnis="parties"; } 

   my %Adresse=%{Form::Auslesen_Spiegel("../$verzeichnis/$partei/adresse.cfg", "", "")};
   foreach (keys(%Adresse)) {
	my $neu = $_;
	   $neu =~s/^P/$P/; 
	# Vorlage nur einlesen, wo kein Vorschlag
	if( length($Daten{$neu})<=1 ) { $Daten{$neu} = $Adresse{$_}; } 
	}

   my %NeueDaten = %{Stamm::Typ($P, \%Daten, \@Ges, \@Land, \@Titel)};
	foreach (keys(%NeueDaten)) {
		$Daten{$_} = $NeueDaten{$_};
	}
   $Daten{"Cueberschrift"} = ( $verzeichnis eq "clients" )? "Mandant" : "Partei";
   $Daten{"Cmanwalt"}="Hermanns"; 

   # Vereinfachen, wenn Zivilrecht (ausser Familienrecht)
   if( $Rechtsgebiet eq "AV" || $Rechtsgebiet eq "AG" || $Rechtsgebiet eq "MP" || $Rechtsgebiet eq "DR" || $Rechtsgebiet eq "ZV" || $Rechtsgebiet eq "AB" || $Rechtsgebiet eq "IK" ) { $Rechtsgebiet="ZR"; }
   if( $Rechtsgebiet eq "SR" || $Rechtsgebiet eq "BG" || $Rechtsgebiet eq "SN" ) { $Rechtsgebiet="SR"; }
   my @Gerichte = @{Form::Auslesen("../courts/$Rechtsgebiet.cfg", "", "")};
   for( my $i=0; $i<=$#Gerichte; $i++ ) {
        @_ = split(/#:#/, $Gerichte[$i]);
	foreach (@_) { $_=~ s/\n//g; }
	$Daten{"GerichteHTML"}.= "
	     gerichte[$i] = new Object();
	     gerichte[$i]".'["land"] = "'.@_[0].'";
	     '."gerichte[$i]".'["plz"] = "'.@_[1].'";';
   	for( my $k=1; $k<=4; $k++ ) {
	     $Daten{"GerichteHTML"}.= "
	     gerichte[$i]".'["'.$k.'"] = "'.@_[($k+1)].'";';
	     }
	}

   my $Auswahl;

   $Auswahl=$Daten{$P."ges"} ||= 1;
   $Daten{"MandantGes"}=Form::Ausklappmenue(\@Ges, $P."ges", $Auswahl, "", 40, 150, 'onChange=javascript:anrede("'.$P.'")');

   $Auswahl=$Daten{$P."titel"} ||="";
   $Daten{"MandantTitel"}=Form::Ausklappmenue(\@Titel, $P."titel", $Auswahl, "", 40, 150, 'onChange=javascript:anrede("'.$P.'")');
      
   $Auswahl=$Daten{$P."land"} ||= "D";
   $Daten{"MandantLand"}=Form::Ausklappmenue(\@Land, $P."land", $Auswahl, "", 30, 100, "");

   my @Repnummer = qw(0#:#Alleinvertretungsberechtigten 1#:#zwei&nbsp;gemeinschaftlich 2#:#drei&nbsp;gemeinschaftlich 3#:#vier&nbsp;gemeinschaftlich 4#:#f&uuml;nf&nbsp;gemeinschaftlich 5#:#sechs&nbsp;gemeinschaftlich 6#:#sieben&nbsp;gemeinschaftlich);
   $Auswahl=$Daten{$P."repnummer"} ||= 0;
   $Daten{$P."Repnummer"}=Form::Ausklappmenue(\@Repnummer, $P."repnummer", $Auswahl, "", 100, 300, 'onChange=javascript:addrepresentation("'.$P.'vertreten")' );


   # Angezeigte Gerichtslinks an Rechtsgebiet anpassen
   if( $Daten{"Crechtsgebiet"} eq "VG" )  {
	$Daten{"MandantGericht"}='&nbsp;&nbsp;<a href="http://www.deutschejustiz.de/dj_vg.html" target="_blank"><img src="../img/court.gif" height=15 width=15 border=""></a>';
	}	
   elsif( $Daten{"Crechtsgebiet"} eq "AR" )  {
	$Daten{"MandantGericht"}='&nbsp;&nbsp;<a href="http://www.deutschejustiz.de/dj_arb.html" target="_blank"><img src="../img/court.gif" height=15 width=15 border=""></a>';
	}	
   elsif( $Daten{"Crechtsgebiet"} eq "FG" )  {
	$Daten{"MandantGericht"}='&nbsp;&nbsp;<a href="http://www.deutschejustiz.de/dj_fin.html" target="_blank"><img src="../img/court.gif" height=15 width=15 border=""></a>';
	}	
   else {
	$Daten{"MandantGericht"}='&nbsp;&nbsp;<a href=javascript:justizadresse("Mplz")><img src="../img/court.gif" height=15 width=15 border=""></a>'; 
	}

   # Booleans fuellen
   $Daten{"Mrechtsschutzversicherung"}=($Daten{"Mrechtsschutzversicherung"})? "checked" : "";
   $Daten{"Mpkh"}=($Daten{"Mpkh"})? "checked" : "";
   $Daten{"Mberatungshilfe"}=($Daten{"Mberatungshilfe"})? "checked" : "";
   $Daten{"Mhiddenonline"}=($Daten{"Monline"})? "table-row" : "none";
   $Daten{"Monline"}=($Daten{"Monline"})? "checked" : "";
   $Daten{"Muser"}||="";     # kann entfallen, nur fuer Altdateien, jetzt durch vorlage.cfg geloest
   $Daten{"Mpasswort"}||=""; # kann entfallen, nur fuer Altdateien, jetzt durch vorlage.cfg geloest

   $Daten{"Cmfile"}=($Daten{"Cmfile"} eq "vorlage")? "" : $Daten{"Cmfile"};


#####################################################

   print $cgi->header(),
	 $cgi->start_html(-title =>'Lawsuit - Partei', -charset =>'utf8');
   print @{Form::HTML("parteiB", \%Daten)};
   print $cgi->end_html;





############################################################################################
} elsif( $cgi->param("stufe")>=3 ) {
#############################################################################################

        my $P="M";
	my $p="m";

   ###### Verzeichnisse anlegen, wenn nocht nicht vorhanden, adresse.cfg ueberschreiben ######

   if ( length($cgi->param("Cmfile"))>0 ) { # nurmehr Cmfile
	    $Partei = Stamm::Rubrumklar(Form::noURI($cgi->param("Cmfile")));
	    $partei = encode("utf8", Form::utf82html($Partei)); 
	    #if ( -e "../clients/$partei" ) { $verzeichnis="clients"; } # falsch, weil auch Neuanlage erlaubt sein soll!
	    $verzeichnis="clients";
	    if( $Daten{"Cmquelle"} ne "M" ) { $verzeichnis="parties"; $P="P"}
	    }

$Fritzzeile="hoho";
   if( $Daten{$p."change"} && $partei ne "vorlage") {

       unless ( -e "../$verzeichnis/$partei" ) {
          mkdir("../$verzeichnis/$partei") || die "Neuer $Partei $partei kann im Verzeichnis $verzeichnis nicht angelegt werden :\n$!";
          chmod(0777, "../$verzeichnis/$partei");
          }
       elsif ( -e "../$verzeichnis/$partei/adresse.cfg" ) {
          my @Zeilen = @{Form::Auslesen("../$verzeichnis/$partei/adresse.cfg")};
	  open(DATEI, ">>../$verzeichnis/$partei/adresse.old") || die "Die Datei adresse.old kann unter $partei nicht beschrieben werden :\n$!";
		print DATEI Form::Datum(3,0)," ########################################\n";
		print DATEI @Zeilen;
	  close(DATEI);
	  chmod(0777, "../$verzeichnis/$partei/adresse.old");
	  }   

	## Praefixe austauschen
	if( $Daten{"C".$p."quelle"} eq "P" or $verzeichnis eq "parties" ) {
		$verzeichnis="parties"; $P="P";
		foreach (keys(%Daten)) {
			my $neu = $_;
			   $neu =~s/^$P/P/; 
			$Daten{$neu} = $Daten{$_};
			}
		foreach (@Feldnamen) {
			$_ =~s/^$P/P/; 
			}
		}

       Form::Speichern_Spiegel( \@Feldnamen, \%Daten, "../$verzeichnis/$partei/adresse.cfg", "$P");

        ## hier Praefixe egal
       if( length($Daten{"Mname"})>0 ) {
		open(DATEI, "<../$verzeichnis/all.cfg") || die "Die Datei $verzeichnis/all besteht nicht, oder Sie haben keine Leseberechtigung:\n$!";
			@Zeilen = <DATEI>; 
		close(DATEI);
		# Hilfsparameter, um dem Modul Liste einen weiteren Beteiligten vorzutäuschen
		$Daten{"Cm1file"}=$Daten{"Cmfile"};
		$Zeile=Form::Liste("M", 1, \%Daten, \%Daten);

		my $Wo=($Daten{$P."typ"} eq "Person" || $Daten{$P."typ"} eq "Mehrheit")? "home" : "work";
		$Fritzzeile="<contact><category>0</category><person><realName>".Form::fritzform($Daten{$P."name"})."</realName><ImageURL /></person><telephony>";
		if( $Daten{$P.'telefon'} ) { $Fritzzeile.='<number type="'.$Wo.'" quickdial="" vanity="" prio="1">'.Form::fritzform($Daten{$P.'telefon'}).'</number>'; }
		if( $Daten{$P.'handy'} ) { $Fritzzeile.='<number type="mobile" quickdial="" vanity="" prio="">'.Form::fritzform($Daten{$P.'handy'}).'</number>'; }
		$Fritzzeile.='</telephony><services /><setup /></contact>';
		unless( $Fritzzeile =~ /quickdial/m ) { $Fritzzeile=""; }  # nur Leute mit Telefon aufnehmen
		############
		foreach (@Zeilen) { @Woerter=split("#:#", $_); if( $Woerter[0] eq $Partei ) { $_=$Zeile; $Zeile="";} }
		if ( length($Zeile)>0 ) { 
			push (@Zeilen, $Zeile); 
			push (@Fritzzeilen, $Fritzzeile);
			}
		@Zeilen=sort(@Zeilen);
		Form::Speichern("../$verzeichnis/all.cfg", \@Zeilen, "In $verzeichnis kann nicht geschrieben werden oder Sie haben keine Schreibberechtigung fuer die Liste all:\n$!");
		Stamm::Fritz(\@Fritzzeilen);
		}

    ## Gerichtsverzeichnisse loeschen, wenn leer, ueberschreiben, wenn PLZ vorhanden, sonst anhaengen
    if ( -e "../courts/$Rechtsgebiet.cfg" ) {

	open(DATEI, "<../courts/$Rechtsgebiet.cfg") || die "Die Datei courts/all besteht nicht, oder Sie haben keine Leseberechtigung:\n$!";
        	@Zeilen = <DATEI>; 
	close(DATEI);
	}
    else {
	@Zeilen = "";
	}
    my $neu=1;
    foreach (@Zeilen) { $_ =~ s/.+#:##:##:#\n//; $_ =~ s/ /&nbsp;/; } #  Leere Zeilen loeschen und Altfaelle ueberarbeiten
    $Zeile="$Daten{'Mland'}#:#$Daten{'Mplz'}#:#$Daten{'Cminstanz1'}#:#$Daten{'Cminstanz2'}#:#$Daten{'Cminstanz3'}#:#$Daten{'Cminstanz4'}\n";
    $Zeile =~ s/ /&nbsp;/; ## nur mit kodierten Leerzeichen, sonst Fehler beim erneutem Speichern
    foreach (@Zeilen) { 
	@Woerter=split(/#?\:#?/,$_);
	if( $Woerter[0] eq $Daten{'Mland'} && $Woerter[1] eq $Daten{'Mplz'} ) { $neu=0; } 
	}
    if ( $neu ) { push (@Zeilen, $Zeile); }
    @Zeilen=sort(@Zeilen);

    Form::Speichern("../courts/$Rechtsgebiet.cfg", \@Zeilen, "In courts kann nicht geschrieben werden oder Sie haben keine Schreibberechtigung fuer die Rechtsgebietsliste $Rechtsgebiet:\n$!");

   }

#############################################

   print "Aragma: no-cache\nContent-type: text/html\n\n";
   print qq~<HEAD><TITLE>Lawsuit - Parteidaten aufgenommen</TITLE><link rel="stylesheet" type="text/css" href="../stylesheets/lawsuit.css"><link rel="stylesheet" type="text/css" href="../stylesheets/$Daten{"Crechtsgebiet"}.css">
</HEAD><BODY class="grund"><BR><BR><BR><fieldset><table align="center" width="100%"><tr><td class="hell"><center><B><H2>Daten aufgenommen!</h2><BR><BR><input type="button" value="Schlie&szlig;en" onclick="window.close()"><BR><BR></center></td></tr></table></fieldset>
</BODY></HTML>~;

}

sub From2Sort {
 if(ord(substr($a,1)) < ord(substr($b,1)))
  { return -1; }
 elsif(ord(substr($a,1)) == ord(substr($b,1)))
  { return 0; }
 else
  { return 1; }
}
