#!/usr/bin/perl -w 

   use Encode; # fuer OpenOffice - Konvertierung in UTF-8 

   use strict;
   use CGI;
   my $cgi = new CGI;
   use CGI::Carp qw(fatalsToBrowser);

   use lib "/home/hedele/lawsuit/cgi-bin/LS";
   use LS::Form;

   my @Feldnamen = $cgi->param();
   my %Daten;
   my $Versicherung;
   my @Woerter;
	

############################################################################################
if( $ENV{CONTENT_LENGTH} <= 0 ) {
############################################################################################


   ###### Dateinamen kreieren #####################


	if ( length($cgi->param("Pkurzname"))>0 ) {
	    $Versicherung = Form::noURI($cgi->param("Pkurzname")); # Update Vrwirrung decode utf8 entfernt 
	    #Mozilla erkennt URI und aendert ungefragt in utf8 -> rueckgaengig
	    $Versicherung =~ s/[\.\,-\s\/\/ ]//g;                    # Hilfszeichen entfernen: 
	    $Versicherung =~ s/&minus;//g;                      # Bindestrich entfernen
	    $Versicherung =~ s/&#8260;//g;                      # Schraegstrich entfernen
	    $Versicherung =~ s/&frasl;//g;                      # Schraegstrich entfernen
	    $Versicherung =~ s/&nbsp;//g;                       # Leerzeichen entfernen: 
	    $Versicherung =  lc($Versicherung);                      # Standardnamen erzeuten Atalanö 
	    }
	else {
	    $Versicherung="vorlage";
	    }

   ###### Adressdaten auslesen, wenn vorhanden, Langnamen bilden #####################


	my $Versicherungsdatei =  Form::html2utf8($Versicherung);
	unless ( -e "../insurance/$Versicherungsdatei" ) { $Versicherungsdatei="vorlage"; }
	my %Versicherung_Adresse=%{Form::Auslesen_Spiegel("../insurance/$Versicherungsdatei/adresse.cfg", "", "")};
	foreach my $Schluessel (keys %Versicherung_Adresse) {
		$Daten{$Schluessel}=$Versicherung_Adresse{$Schluessel};
		}
	$Daten{"Crechtsgebiet"}=$cgi->param("Crechtsgebiet");
	$Daten{"Pfile"}=$Versicherung;
	unless( $Daten{"Pkurzname"} ) { $Daten{"Pkurzname"} = Form::noURI($cgi->param("Pkurzname")); }
	unless( $Daten{"Pname"} ) { $Daten{"Pname"} = $Daten{"Pkurzname"}; }



   my @Land;
   my @Laender=@{Form::Auslesen("../data/land.cfg")};
   foreach (@Laender) {
	@Woerter=split(/#?\:#?/,$_);
	push(@Land, $Woerter[0].'#:#'.$Woerter[0]);
	}
   my $Auswahl=$Daten{"Pland"}||"D";
   $Daten{"VersicherungLand"}=Form::Ausklappmenue(\@Land, "Pland", $Auswahl, "", 30, 100, "");

#####################################################

   print $cgi->header(),
	 $cgi->start_html(-title =>'Lawsuit - Versicherungsdaten');
   if($cgi->param("Ansicht") eq "Krankenversicherung" ) {
	  print @{Form::HTML("krankenversicherung", \%Daten)}; }
   else {  
          print @{Form::HTML("versicherung", \%Daten)}; }

   print $cgi->end_html;


############################################################################################
} else {
############################################################################################


  foreach my $Feld (@Feldnamen) {
       if( $cgi->param($Feld) )  {
          $Daten{$Feld} = $cgi->param($Feld);
       } else {
          $Daten{$Feld} = "";
       }
   }

	if ( $Daten{"Pfile"} ) {
	    $Versicherung = $Daten{"Pfile"};
	    $Versicherung =~ s/[\.\,\-\/\/ ]//g;                  # Leer- und Hilfseichen entfernen: Atalan, &Ouml;.
	    $Versicherung =~ s/&#8260;//g;                        # Schraegstrich entfernen
	    $Versicherung =~ s/&frasl;//g;                        # Schraegstrich entfernen
	    $Versicherung =  lc($Versicherung);                   # Standardnamen erzeuten Atalanö 
	    }
	$Daten{"Pfile"}=$Versicherung;                            # Gewaehlten Dateinamen in Eingabefeld sichtbar machen

   ###### Verzeichnisse anlegen, wenn nocht nicht vorhanden, adresse.cfg ueberschreiben ######

	my $Versicherungsdatei = Form::html2utf8($Versicherung);    # Update-Verirrung war mit encode korrigiert;
	unless ( -e "../insurance/$Versicherungsdatei" ) {
		mkdir("../insurance/$Versicherungsdatei") || die "Neues Versicherung $Versicherungsdatei kann im Verzeichnis clients nicht angelegt werden :\n$!";
		chmod(0777, "../insurance/$Versicherungsdatei");
		}
	else {
		rename("../insurance/$Versicherungsdatei/adresse.cfg", "../insurance/$Versicherungsdatei/adresse.old");
		}
	Form::Speichern_Spiegel( \@Feldnamen, \%Daten, "../insurance/$Versicherungsdatei/adresse.cfg", "[AP]");


#####################################################

   print "Pragma: no-cache\nContent-type: text/html\n\n";
   if( $cgi->param("Ansicht") eq "Krankenversicherung" ) {
	print qq~<HEAD><TITLE>Lawsuit - Versicherungsdaten aufgenommen</TITLE><link rel="stylesheet" type="text/css" href="../stylesheets/lawsuit.css"><link rel="stylesheet" type="text/css" href="../stylesheets/accountingG.css">
</HEAD><BODY class="grund"><BR><BR><BR><fieldset><table align="center" width="100%"><tr><td class="hell"><center><B><H2>Daten aufgenommen!</h2><BR><BR><input type="button" value="Schlie&szlig;en" onclick="window.close()"><BR><BR></center></td></tr></table></fieldset>
</BODY></HTML>~; 
	}
   else {
	print qq~<HEAD><TITLE>Lawsuit - Versicherungsdaten aufgenommen</TITLE><link rel="stylesheet" type="text/css" href="../stylesheets/lawsuit.css"><link rel="stylesheet" type="text/css" href="../stylesheets/$Daten{"Crechtsgebiet"}.css">
</HEAD><BODY class="grund"><BR><BR><BR><fieldset><table align="center" width="100%"><tr><td class="hell"><center><B><H2>Daten aufgenommen!</h2><BR><BR><input type="button" value="Schlie&szlig;en" onclick="window.close()"><BR><BR></center></td></tr></table></fieldset>
</BODY></HTML>~;
	}
   

}

