#!/usr/bin/perl -w 

   use Encode; # fuer OpenOffice - Konvertierung in UTF-8 

   use strict;
   use CGI;
   my $cgi = new CGI;
   use CGI::Carp qw(fatalsToBrowser);

   use lib "/home/hedele/lawsuit/cgi-bin/LS";
   use LS::Form;

   my @Feldnamen = $cgi->param();
   my %Daten;
   my $Gericht;
   my @Woerter;
	

############################################################################################
if( $ENV{CONTENT_LENGTH} <= 0 ) {
############################################################################################

    # Vereinfachen, wenn Zivilrecht (außer Familienrecht)
    $Daten{"Crechtsgebiet"}=$cgi->param("Crechtsgebiet");
    if( $Daten{"Crechtsgebiet"} eq "AV" || $Daten{"Crechtsgebiet"} eq "AG" || $Daten{"Crechtsgebiet"} eq "MP" || $Daten{"Crechtsgebiet"} eq "DR" || $Daten{"Crechtsgebiet"} eq "VR" || $Daten{"Crechtsgebiet"} eq "ZV" ) { $Daten{"Crechtsgebiet"}="ZR"; $Daten{"Kammer"}="Zivilkammer"; $Daten{"Senat"}="Zivilsenat"; $Daten{"Suffix"}="z" }
    elsif( $Daten{"Crechtsgebiet"} eq "SR" || $Daten{"Crechtsgebiet"} eq "BG" || $Daten{"Crechtsgebiet"} eq "SN" ) { $Daten{"Crechtsgebiet"}="SR"; $Daten{"Kammer"}="Strafkammer"; $Daten{"Senat"}="Strafsenat"; $Daten{"Suffix"}="s" }
    else { $Daten{"Kammer"}="Kammer"; $Daten{"Senat"}="Senat"; $Daten{"Suffix"}=""}

   ###### Dateinamen kreieren #####################


	if ( length($cgi->param("Pkurzname"))>0 ) {
	    $Gericht = Form::noURI($cgi->param("Pkurzname")); # Update Vrwirrung decode utf8 entfernt 
	    #Mozilla erkennt URI und aendert ungefragt in utf8 -> rueckgaengig
	    $Gericht =~ s/[\.\,\–\-\s\/\/ ]//g;                    # Hilfszeichen entfernen: 
	    $Gericht =~ s/&minus;//g;                      # Bindestrich entfernen: 
	    $Gericht =~ s/&#8260;//g;                      # Schraegstrich entfernen
	    $Gericht =~ s/&frasl;//g;                      # Schraegstrich entfernen
	    $Gericht =~ s/&nbsp;//g;                       # Leerzeichen entfernen: 
	    $Gericht =  lc($Gericht);                      # Standardnamen erzeuten Atalanö 
	    }
	else {
	    $Gericht="vorlage";
	    }

   ###### Adressdaten auslesen, wenn vorhanden, Langnamen bilden #####################


	my $Gerichtsdatei =  Form::html2utf8($Gericht);
	unless ( -e "../courts/$Gerichtsdatei" ) { $Gerichtsdatei="vorlage"; }
	my %Gericht_Adresse=%{Form::Auslesen_Spiegel("../courts/$Gerichtsdatei/adresse.cfg", "", "")};
	foreach my $Schluessel (keys %Gericht_Adresse) {
		$Daten{$Schluessel}=$Gericht_Adresse{$Schluessel};
		}
	$Daten{"Crechtsgebiet"}=$cgi->param("Crechtsgebiet");
	$Daten{"Pfile"}=$Gericht;
	unless( $Daten{"Pkurzname"} ) { $Daten{"Pkurzname"} = Form::noURI($cgi->param("Pkurzname")); }
	unless( $Daten{"Pname"} ) { $Daten{"Pname"} = $Daten{"Pkurzname"}; }
	unless( $Daten{"Pstadt"} ) { $Daten{"Pstadt"} = $Daten{"Pname"}; }


	my @kuerzel = qw(AG LG OLG BGH ArbG LAG BAG VG OVG VGH BVerwG FG BFH SG LSG BSG BPatG BVerfG StA GStA);
	my @bezeichnung = qw(Amtsgericht Landgericht Oberlandesgericht Bundesgerichtshof Arbeitsgericht Landesarbeitsgericht Bundesarbeitsgericht Verwaltungsgericht Oberverwaltungsgericht Verwaltungsgerichtshof Bundesverwaltungsgericht Finanzgericht Bundesfinanzhof Sozialgericht Landessozialgericht Bundessozialgericht Bundespatentgericht Bundesverfassungsgericht Staatsanwaltschaft Generalstaatsanwaltschaft);
	for(my $i=19;$i>=0;$i--) {
		my $e=$kuerzel[$i];
		my $r=$bezeichnung[$i];
		$Daten{"Pstadt"}=~s/$e&nbsp;//g;
		$Daten{"Pstadt"}=~s/I$//g;
		$Daten{"Pname"}=~s/$e/$r/g;
		}

   my @Land;

   @Land = qw(A#:#A B#:#B BG#:#BG CH#:#CH CY#:#CY CZ#:#CZ D#:#D DK#:#DK E#:#E EST#:#EST F#:#F FIN#:#FIN GB#:#GB GR#:#GR H#:#H I#:#I IRL#:#IRL L#:#L LT#:#LT LV#:#LV M#:#M NL#:#NL P#:#P PL#:#PL RO#:#RO S#:#S SLO#:#SLO SK#:#SK);
   my $Auswahl=$Daten{"Pland"}|"D";
   $Daten{"GerichtLand"}=Form::Ausklappmenue(\@Land, "Pland", $Auswahl, "", 30, 100, "");

#####################################################

   print $cgi->header(),
	 $cgi->start_html(-title =>'Lawsuit - Gerichtsdaten');
   print @{Form::HTML("gericht", \%Daten)};

   print $cgi->end_html;


############################################################################################
} else {
############################################################################################


  foreach my $Feld (@Feldnamen) {
       if( $cgi->param($Feld) )  {
          $Daten{$Feld} = $cgi->param($Feld);
       } else {
          $Daten{$Feld} = "";
       }
   }

	if ( $Daten{"Pfile"} ) {
	    $Gericht = $Daten{"Pfile"};
	    $Gericht =~ s/[\.\,\–\-\s\/\/ ]//g;                  # Leer- und Hilfseichen entfernen: Atalan, &Ouml;.
	    $Gericht =~ s/&minus;//g;                      # Bindestrich entfernen: 
	    $Gericht =~ s/&#8260;//g;                      # Schraegstrich entfernen
	    $Gericht =~ s/&frasl;//g;                      # Schraegstrich entfernen
	    $Gericht =  lc($Gericht);                      # Standardnamen erzeuten Atalanö 
	    }
	$Daten{"Pfile"}=$Gericht;                          # Gewaehlten Dateinamen in Eingabefeld sichtbar machen

   ###### Verzeichnisse anlegen, wenn nocht nicht vorhanden, adresse.cfg ueberschreiben ######

	my $Gerichtsdatei = Form::html2utf8($Gericht);    # Update-Verirrung war mit encode korrigiert;
	unless ( -e "../courts/$Gerichtsdatei" ) {
		mkdir("../courts/$Gerichtsdatei") || die "Neues Gericht $Gerichtsdatei kann im Verzeichnis clients nicht angelegt werden :\n$!";
		chmod(0777, "../courts/$Gerichtsdatei");
		}
	else {
		rename("../courts/$Gerichtsdatei/adresse.cfg", "../courts/$Gerichtsdatei/adresse.old");
		}
	Form::Speichern_Spiegel( \@Feldnamen, \%Daten, "../courts/$Gerichtsdatei/adresse.cfg", "P");


#####################################################

   print "Pragma: no-cache\nContent-type: text/html\n\n";
   print qq~<HEAD><TITLE>Lawsuit - Gerichtsdaten aufgenommen</TITLE><link rel="stylesheet" type="text/css" href="../stylesheets/lawsuit.css"><link rel="stylesheet" type="text/css" href="../stylesheets/$Daten{"Crechtsgebiet"}.css">
</HEAD><BODY class="grund"><BR><BR><BR><fieldset><table align="center" width="100%"><tr><td class="hell"><center><B><H2>Daten aufgenommen!</h2><BR><BR><input type="button" value="Schlie&szlig;en" onclick="window.close()"><BR><BR></center></td></tr></table></fieldset>
</BODY></HTML>~;

}

