#!/usr/bin/perl -w

###########################################################################
#
#  Hinweis: Berechtigungen fuer PB_Kontoauszug_Giro_2007-??-??_??-??.txt 
#           muessen freigegeben werden, sonst scheitert Ueberschreiben! 
#
###########################################################################

   use Encode; # fuer Konvertierung in UTF-8 
   use strict;
   use CGI;
   my $cgi = new CGI;
   use CGI::Carp qw(fatalsToBrowser); 
   use LS::Form;

   my  @Felddaten       = split("&", $ENV{'QUERY_STRING'}); # fuer Aufruf aus account.pl GET-Methode (Stufe1)
   my  @Feldnamen       = $cgi->param();                    # fuer Aufruf aus account.pl POST-Methode (Stufe2)
   my  %Daten;
   my  %Eintraege;


   # Formulardaten aus Query-String (GET) ermitteln
   foreach (@Felddaten) {
      my @W = split("=", $_);
      $Daten{"$W[0]"}  = $W[1];
   }
   # Formulardaten mit cgi-Modul (POST) ermitteln
   foreach my $Feld (@Feldnamen) {
      $Daten{$Feld}  = Form::utf82html(encode("utf8",$cgi->param(Form::utf82html(encode("utf8",$Feld)))));
      $Daten{$Feld}  =~s/\"/&quot;/g; # insofern ist keine Kodierung durch utf82html erfolgt, noetig fuer Sparkasse
   }
      $Daten{"Datei"} ||= $Daten{"Name"};
   my $Quellpfad="/home/matthias/Download/";
   my $neu;
   my $Meinzeile;
   my @Meinzeilen;


   print $cgi->header(),
	 $cgi->start_html(-title =>'Lawsuit - Bankkonten',  -style =>{'src'=>'../stylesheets/accountingG.css'}, -bgcolor =>'grund', -charset =>'utf8');

   print '	<script language="JavaScript" type="text/javascript" src="../javascript/dhtml.js"></script>
	<script language="JavaScript" type="text/javascript" src="../javascript/formular.js"></script>

	<script language="JavaScript" type="text/javascript">
	<!--
	function postit(dateiname, konto) {
	
		// Pfad zerlegen (Pfad wird seltsamerweise nicht mituebergeben)
		var datei=getElement("name", dateiname, 0).value; 
		var muster = /(\/?.+)\.(.+)$/g;
		datei.match(muster);
		var feld = konto+"quelldatei";
		getElement("name", feld, 0).value=RegExp.$1.replace(/\//, "");
		var feld = konto+"suffix";
		getElement("name", feld, 0).value=RegExp.$2;

		// Kodieren
		for( var i=0; i<getNumberof("tagname", "input"); ++i ) {
			s = getElement ("tagname", "input", i).value;	
			if ( s.length>0 && getAttribute ("tagname", "input", i, "type")!="file" ) {
				s = kodiere(s);
				getElement ("tagname", "input", i).value=s;
			}
		}
		for( var i=0; i<getNumberof("tagname", "textarea"); ++i ) {
			s = getElement ("tagname", "textarea", i).value;
			if( s.length>0 ) {
				s = kodiere(s);
				getElement ("tagname", "textarea", i).value=s;
			}
		}

		// Abschicken
		document.Konten.submit();
	}
	function formatbelegung(konto) {
	
	        konto=konto.replace(/1$/,""); // aut. Auswahlergaenzung wieder streichen
		var auswahlkonto = getElement("name", konto+"vorbelegung1", 0).value;
		
		for( var i=0; i<=21; ++i ) {

			var pos = getElement("name", auswahlkonto+i, 0).selectedIndex;
			var f = getElement("name", auswahlkonto+i, 0).options[pos].value;

			getElement ("name", konto+i, 0).value=pos;

			var f=getElement ("name", auswahlkonto+"format"+i, 0).value;
			getElement ("name", konto+"format"+i, 0).value=f;
		}
	}
	//-->
	</script>
';
   my $Settings=$Daten{"Datei"};
   my %Settings=%{Form::Auslesen_Spiegel("../settings/$Settings", "[GKSU]", "")};

   ##Speichern
   if( $ENV{CONTENT_LENGTH} > 0 ) {
	Form::Speichern_Spiegel( \@Feldnamen, \%Daten, "../settings/Konten_$Settings", "*");
	}
   else {
	%Daten = (-e "../settings/Konten_$Settings")? %{Form::Auslesen_Spiegel("../settings/Konten_$Settings", "", "")} : "";
	}

   my @Konten;
   my @Banken;
   my @Bankprefix = qw(P B);
   my $j=0;
   foreach (@Bankprefix) {
	for(my $k=0; $k<=21; $k++) {
		if( $Settings{$_."aktiv".$k} &&  $Settings{$_."csv".$k} ) {
		        # Kontenrahmen Sk03 erweitern
			$Konten[$j]= $Settings{$_."konto".$k}."#:#".$Settings{$_."bezeichnung".$k};
			$Daten{$Settings{$_."konto".$k}."zieldatei"} ||= $Settings{$_."iban".$k};
			$j++;
			}
		}
	}
   # 0110000#:#Postbank#:#G#:#+#:#1#:#1
   # 0111000:#Postbank-Anderkonto#:#G#:#+#:#1#:#1
   # 0120000#:#Visa-Karte#:#G#:#+#:#1#:#1
   # 0121000#:#Sparkasse#:#G#:#+#:#1#:#1
   # 0122000#:#Cortal Consors#:#G#:#+#:#1#:#1

   my @Trenner= qw(t#:#[tab] .#:#. ,#:#, ;#:#;);

   my @Inhalt = qw(0#:#frei 1#:#Kontonummer 2#:#Buchungsdatum 3#:#Wertstellungstag 4#:#Art 5#:#Buchungstext 6#:#Auftraggeber 7#:#Empf&auml;nger 8#:#Auftraggeber/Empf&auml;nger 9#:#Auftragg./Empf.-Konto 10#:#Auftragg./Empf.-BLZ 11#:#VWZ&nbsp;1 12#:#VWZ&nbsp;2 13#:#VWZ&nbsp;3 14#:#VWZ&nbsp;4 15#:#VWZ&nbsp;5 16#:#VWZ&nbsp;6 17#:#VWZ&nbsp;7 18#:#VWZ&nbsp;8 19#:#VWZ&nbsp;9 20#:#VWZ&nbsp;10 21#:#VWZ&nbsp;11 22#:#VWZ&nbsp;12 23#:#VWZ&nbsp;13 24#:#VWZ&nbsp;14 25#:#Betrag 26#:#Saldo 27#:#W&auml;hrung 28#:#Info);

   print '<FORM action="./bankaccounts.pl" method="post" enctype="multipart/form-data" name="Konten">
';

   my $x=0;
   
   foreach(@Konten) {
	my @Woerter=split("#:#", $_);
	my $Konto=$Woerter[0];
	my $Bankname=Form::utf82html($Woerter[1]);
	for(my $i=0; $i<=21; $i++) {
		my $Auswahl=$Daten{$Konto.$i};
		$Daten{$Konto."_HTML".$i}= Form::Ausklappmenue(\@Inhalt, $Konto.$i, $Auswahl, "", 80, 50);
		my $Auswahl=$Daten{$Konto."trenner"};	
		$Daten{$Konto."trenner_HTML"}= Form::Ausklappmenue(\@Trenner, $Konto."trenner", $Auswahl, "", 10, 50);
		}
	$Daten{$Konto."vorbelegung"}= Form::Ausklappmenue(\@Konten, $Konto."vorbelegung", "", 30, 100, 210, qq~onClick=formatbelegung("$Konto")~ );


	print '		<FIELDSET class="hell">
		<legend>',$Bankname,'</legend>

		<TABLE CELLPADDING=1 CELLSPACING=0>
			<TR>
				<TD COLSPAN=2 ALIGN=LEFT class="grund">
					Dateimuster:&nbsp;&nbsp;
				</TD>
				<TD>
					&nbsp;
				</TD>
				<TD ALIGN=LEFT class="grund">
					aus Dateiname:&nbsp;&nbsp;
				</TD>
				<TD>
					&nbsp;
				</TD>
				<TD ALIGN=LEFT class="grund">
					Trennzeichen:&nbsp;&nbsp;
				</TD>
				<TD>
					&nbsp;
				</TD>
				<TD ALIGN=LEFT class="grund">
					Zus&auml;tzliche Erkennungszeichen im Dateinamen:&nbsp;&nbsp;
				</TD>
				<TD>
					&nbsp;
				</TD>
				<TD ALIGN=LEFT class="grund">
					Zieldatei:&nbsp;&nbsp;
				</TD>
			</TR>
			<TR>
				<TD ALIGN=LEFT VALIGN=TOP class="hell">
					<INPUT TYPE=hidden NAME="',$Konto,'pfad" MAXSIZE=100>
					<INPUT TYPE=text NAME="',$Konto,'quelldatei" SIZE=30 MAXSIZE=50 VALUE="',$Daten{$Konto."quelldatei"},'">*.
					<div class="comment">Datei</div>
				</TD>
				<TD ALIGN=LEFT VALIGN=TOP class="hell">
					
					<INPUT TYPE=text NAME="',$Konto,'suffix" SIZE=5 MAXSIZE=11 VALUE="',$Daten{$Konto."suffix"},'">
					<div class="comment">Suffix</div>
				</TD>
				<TD>
					&nbsp;
				</TD>
				<TD ALIGN=LEFT VALIGN=TOP class="hell">
					<input type="file" name="',$Konto,'file" size="20" maxlength="600" value="',$Daten{$Konto."file"},'" onChange=postit(this.name,"',$Konto,'") />
					<br><div class="comment">Beispielsdatei als Muster</div>
				</TD>
				<TD>
					&nbsp;
				</TD>
				<TD ALIGN=LEFT VALIGN=TOP class="hell">
					',$Daten{$Konto."trenner_HTML"},'
					<div class="comment">Sonderzeichen</div>
				</TD>
				<TD>
					&nbsp;
				</TD>
				<TD ALIGN=LEFT VALIGN=TOP class="hell">
					<input type="text" name="',$Konto,'erkennung" size="30" maxlength="600" value="',$Daten{$Konto."erkennung"},'" />
					<div class="comment">Zeichenfolge (z.B. Kontonummer)</div>
				</TD>
				<TD>
					&nbsp;
				</TD>
				<TD ALIGN=LEFT VALIGN=TOP class="hell">
					<input type="text" name="',$Konto,'zieldatei" size="30" maxlength="600" value="',$Daten{$Konto."zieldatei"},'" />
					<div class="comment">Dateiname</div>
				</TD>
			</TR>
			<TR>
				<TD COLSPAN=7 ALIGN=LEFT class="grund">
					Tabelleninhalte:&nbsp;&nbsp;
				</TD>
				<TD COLSPAN=10 ALIGN=LEFT class="grund">
					&Uuml;bernehme aus:&nbsp;&nbsp;',$Daten{$Konto."vorbelegung"},'
				</TD>
			</TR>
			<TR>
		</TABLE>
';
	if( length($Daten{$Konto."file"})>0 ) {
		my $Datei = Form::html2utf8(encode("utf8",$Quellpfad.$Daten{$Konto."file"}));
		my @Pfad=split(/\//,$Datei);
		my $Name=pop(@Pfad);
 		my $Verzeichnis=pop(@Pfad);
                my @Zeilen;
                my $Zeile;
                
                $Datei=~s/-/-/g; # utf-Problem mit ascii-Bindestrich
		open(DATEI, "<$Datei") || die "die Datei $Datei besteht nicht, oder Sie haben keine Leseberechtigung im Verzeichnis $Verzeichnis:\n$!";
			@Zeilen = <DATEI>;
		close(DATEI);
		print '<TEXTAREA name="',$Konto,'auszug" cols="250" rows="15">', "\n";
		for(my $i=0; $i<=21; $i++) {
			$Zeile=$Zeilen[$i];
			$Zeile=~s/\t/\.\t/g;
			print $Zeile;
			}
		print '</TEXTAREA>', "\n";
	}
	print '
		<TABLE CELLPADDING=1 CELLSPACING=0>
			<TR>';
			
	for(my $i=0; $i<=21; $i++) {
		print '
				<TD ALIGN=LEFT VALIGN=TOP class="hell">
					',$Daten{$Konto."_HTML".$i},'
				</TD>';
		}
		print '
			</TR>
			<TR>';
	for(my $i=0; $i<=21; $i++) {
		print'
				<TD ALIGN=LEFT VALIGN=TOP class="hell">
					<INPUT TYPE=text NAME=',$Konto,'format',$i,' SIZE=7 MAXSIZE=40 VALUE="',$Daten{$Konto."format".$i},'">
					<div class="comment">Datenfomat</div>
				</TD>';
		}
	print '
			</TR>
			<TR>
				<TD COLSPAN=21 ALIGN=LEFT class="hell">
				</TD>
			</TR>
		</TABLE>
		</FIELDSET>
		<br>
';
	
	$x++;
	
	}#Ende Konten

  print ' 	<INPUT TYPE=hidden NAME="Name" VALUE="',$cgi->param("Name"),'"><INPUT TYPE=hidden NAME="Suffix" VALUE="',$cgi->param("Suffix"),'">
	<INPUT TYPE=button VALUE="Aktualisieren" onClick="window.open(&quot;../cgi-bin/warten.pl&quot;,&quot;Bitte bis zu einer Minute warten!&quot;,&quot;dependent=yes,location=no,menubar=no,resizable=no,toolbar=no,status=no,width=400,height=50,left=100,top=10&quot;);document.submit();" style="width:100%;height:30px">
</FORM>
';


   my @Buchungen="";
   my $Aelteste=time();
   my $x=1;
   
   foreach(@Konten) {
	my @Woerter=split("#:#", $_);
	my $Konto=$Woerter[0];
	my $Bankname=Form::utf82html($Woerter[1]);
	my %AlleZeilen;
	my $iban   = $Daten{$Konto."zieldatei"};
	my $suffix = $Daten{$Konto."suffix"};
#	my @Folge;
#	my $Muster="";
#	my $t=$Daten{$Konto."trenner"};
#	for(my $i=0; $i<=21; $i++) {
#		$Folge[$i]=$Daten{$Konto.$i};
#		$Muster.=$Daten{$Konto."format".$i}."\\".$t; 
#		}
#	$Muster=~s/(\\$t)+$//g;

        print '<p><table style="color:white">',"\n";
        print '<tr><td>Quelldatei:</td><td>',$Daten{$Konto."quelldatei"},'*.',$Daten{$Konto."suffix"},'</td></tr>',"\n";
	print '<tr><td>Zieldatei:</td><td>',$Daten{$Konto."zieldatei"},'</td></tr>',"\n";

###########################################################################
#
#  VISA/Volksbank/Sparkasse/Postbank - Abfrage fuer mehrere Konten
#
###########################################################################
   if( $Daten{$Konto."quelldatei"} ) {
        
	my $alle   = Form::html2utf8(encode"utf8",$Daten{$Konto."quelldatei"});
	my $vorletzt=1;
	my $zuletzt=1;
	my $letztezeile="nochkeineeingabe";
	my $erstezeile="nochkeineeingabe";
	
	# Bank-CSV-Dateien suchen und sortieren
	my @CSV_Dateien = glob("../../Download/$alle*.$suffix");
	my @CSV_Sortiert;
	foreach (@CSV_Dateien) {
	        my $Dateimuster = (length($Daten{$Konto."erkennung"})>0)? Form::html2utf8(encode("utf8",$Daten{$Konto."erkennung"})) : ".*";
	        if( $_=~m/$Dateimuster/ ) {
			my @Info = lstat($_); 
			push(@CSV_Sortiert, $Info[9]."#:#".$_);
			if( $Info[9] > $zuletzt ) { $zuletzt = $Info[9]; }
			}
		}
	# Hauptprogramm ueber aeltesten Datenstand informieren
	if( $Aelteste>$zuletzt ) { $Aelteste=$zuletzt; }
	print '<tr><td>Datenstand:</td><td>',Form::Datum(4,0,$zuletzt),'</td></tr>',"\n";
	print '</table>';
	
	# Letzter Auslesestand, Anschluss heraussuchen
	print '<div class="hell">',"\n";
	if(-e "../data/$iban") {
	print "<b>Die Bankdatei &quot;","../data/$iban","&quot; hat nach der Suche nun den folgenden aktuellen Inhalt:</b> <br>";
		$letztezeile=pop(@{Form::Auslesen("../data/$iban")});
		my @Inhalt= @{Form::Auslesen("../data/$iban")};
		foreach (@Inhalt) { print "<font size=-2>",$_,"</font><br>"; }
		$letztezeile=~s/^\d+#:#//g; # Infos entfernen
		print "<b>Letzte Zeile darin:</b><font size=-2> ",$letztezeile,"</font><br>\n";
		}
	my $Zeilenmuster="";
	my $i=0;
	while( length($Daten{$Konto."format".$i}) > 0 ) {
		$Zeilenmuster.=Form::html2utf8(encode("utf8",$Daten{$Konto."format".$i})).$Daten{$Konto."trenner"};
		$i++
		}
	chop($Zeilenmuster); 		#Trenner am Ende entfernen
	$Zeilenmuster=~s/&quot;/\"/g; 	#in html2utf8 nicht enthalten (fuer Sparkasse noetig)
	
	print "<br>Suchformat f&uuml;r Zeile: &quot;",$Zeilenmuster,"&quot;\n";
	print "<br>Suchformat f&uuml;r Datei: &quot;",Form::utf82html($alle),"*.",$suffix,"&quot; findet mit der Begrenzung auf das Dateimuster &quot;",$Daten{$Konto."erkennung"},"&quot; die Dateien:<br>";
	
	# Neu auslesen bis Anschluss, neueste CSV-Datei zuerst
	my @NeueZeilen;
	my $Durchlauf=0;
	my $gefunden=0;
	foreach my $Csv (reverse(sort(@CSV_Sortiert))) {
	        $Csv =~s/^.+#:#//g; # Zeitstempel entfernen
	        print Form::utf82html($Csv), "<br>";
	        my @CSV_Zeilen = @{Form::Auslesen($Csv)};
	           @CSV_Zeilen = grep(/$Zeilenmuster/, @CSV_Zeilen);
	        
	   	# Kalenderjahr der aktuellen Bearbeitung ermitteln, um verkuerzte Bankdaten zu ergaenzen
		        my $Jahr = $Daten{"Datei"};
		        $Jahr =~s/^.*_//g;
		        $Jahr =~s/\D//g;
		        my $AktuellesJahr = Form::Datum(2,0,time);
		        $AktuellesJahr =~s/^\d+\.\d+\.//; 
	        
	        # Alle bankindividuell sortierten Zeilen neu ordnen, neueste zuletzt
	        my $y=0;
	        foreach(@CSV_Zeilen) {
	           $_=(Form::Zeit(Wert(3,$_,$Konto,\%Daten,$Jahr))+($x * 100 + $y % 100))."#:#".$_;
	           $y++;
	           }
	        @CSV_Zeilen = sort(@CSV_Zeilen); 
	        
	        # Kodierung vereinheitlichen
	        foreach (@CSV_Zeilen) { 	
			$_=Form::utf82html($_); 
			$_=Form::utf82html(encode("utf8",$_));
			$_=$_."\n";
			$_=~s/\"/&quot;/g;	# in utf82html nicht enthalten (fuer Sparkasse noetig)
			}	        
	        	       
	        my $y=0;
	        
	        # Auch, wenn erste Datenanlage ueberhaupt
	        if( grep(/$erstezeile/, @CSV_Zeilen) > 0 || $erstezeile eq "nochkeineeingabe" ) { 
	                 # wenn Anschluss vorhanden, weiterschreiben, ansonsten neu anlegen, abfangen bei 2000 Zeilen
			 while( $CSV_Zeilen[$y] !=~m/$erstezeile/ && $y<=$#CSV_Zeilen ) {
			        if( $CSV_Zeilen[$y] =~ m/$letztezeile/ ) { 
					$gefunden=1; print "<br>mit Anschluss an:<br>"; @NeueZeilen=""; }
			        else {
					# vor jede Zeile einen Zeitidentifikator setzen, wobei er nochmals fuer jede Bank individuell mit ihrem $x-fachen von 100 Sekunden addiert wird zzgl. den letzten beiden Zahlen der Zeile, um eine einheitliche Listenfolge zu bekommen
					push(@NeueZeilen, $CSV_Zeilen[$y]); 
					}
				$y++;
				}
			if($#NeueZeilen>0) { $erstezeile = $CSV_Zeilen[0]; }
			}

		# Wenn erste Datenanlage ueberhaupt, dann ueber fehlende Daten am Anfang informieren, falls letzter Durchgang
		elsif( $letztezeile eq "nochkeineeingabe" && $Durchlauf==$#CSV_Sortiert ) {
		        # Fehlerhinweis, wenn im gesuchten Jahr gar keine Daten vorhanden, sofern es nicht das noch laufende Jahr ist
		        if( Form::Zeit(Wert(3,$CSV_Zeilen[$#CSV_Zeilen],$Konto,\%Daten,$Jahr)) < Form::Zeit("01.01.$Jahr") && $Jahr < $AktuellesJahr ) {
				push (@NeueZeilen, (Form::Zeit("01.01.".$Jahr)+($x*100 + 99))."#:#"."### L&uuml;cke im Datenbestand f&uuml;r die $Bankname vom 01.01.$Jahr bis 31.12.$Jahr ###\n");
				}
		        # Fehlerhinweis, wenn nur fuer Teile des Jahres Daten vorhanden
		        elsif( Form::Zeit(Wert(3,$NeueZeilen[$#NeueZeilen],$Konto,\%Daten,$Jahr))+($x*100) > Form::Zeit("01.01.$Jahr") ) {
				push (@NeueZeilen, (Form::Zeit("01.01.".$Jahr)+($x*100 + 99))."#:#".'### L&uuml;cke im Datenbestand f&uuml;r die '.$Bankname.' vom 01.01.'.$Jahr.' bis '.Wert(3,@NeueZeilen[0],$Konto,\%Daten,$Jahr)." ###\n");
				}
			}
	        
		# Fehlerhinweis einfuegen, wenn kein Anschluss
		elsif( $gefunden==0 ) {  
		        push (@NeueZeilen, (Form::Zeit(Wert(3,$erstezeile,$Konto,\%Daten,$Jahr))+($x*100))."#:#".'### L&uuml;cke im Datenbestand f&uuml;r die '.$Bankname.' vom '.Wert(3,$CSV_Zeilen[$#CSV_Zeilen],$Konto,\%Daten,$Jahr).' bis '.Wert(3,$erstezeile,$Konto,\%Daten,$Jahr)." ###\n");
		        # die ganze restliche Datei vor jede Zeile einen Zeitidentifikator setzen, wobei er nochmals fuer jede Bank individuell mit ihrem §x-fachen von 100 Sekunden addiert wird, um eine einheitliche Listenfolge zu bekommen
		        foreach (@CSV_Zeilen) { push ( @NeueZeilen, $_ ); $y++; }
		        $erstezeile = $CSV_Zeilen[0]; 
		      }
		$Durchlauf++;
		}
 
        # Ausgelesenen Datenbestand ueberschreiben, dabei Doppel herausfiltern
	if(-e "../data/$iban") { %AlleZeilen=%{Form::Auslesen_Spiegel("../data/$iban", "", "")}; }
	foreach(@NeueZeilen) {
	        my @Zeile=split(/#\:#/,$_);
	        $AlleZeilen{$Zeile[0]}=$Zeile[1];
	        }
	my @AlleZeilen=sort(keys(%AlleZeilen));
	foreach(@AlleZeilen) {
		$_.="#:#".$AlleZeilen{$_};
		}
	Form::Speichern("../data/$iban", \@AlleZeilen, "In Verzeichnis /data kann nicht geschrieben werden oder Sie haben keine Schreibberechtigung fuer die Buchungsliste $iban:\n$!");
	chmod(0777, "../data/$iban");
	# Zeitstempel auf letzte CSV-Datei setzen, damit das Hauptprogramm weiss, wie alt die Daten jeweils sind.
	utime($zuletzt,$zuletzt,"../data/$iban");
	
	
	} # Ende Quelldatei
	
	# Zuweisungstabellle fuer jede kontenspezifische Spalte bilden
        print "<p>Zuweisung: ";
        my @Zuweisung;   
        for(my $i=0; $i<=21; $i++) {
  		# Spalten vereinfachen
                # 1Buchungsdatum 2Wertstellung 3Art 4Auftraggeber 5Buchnungstext 6Konto 7Betrag 8Waehrung
		my $gefunden=0;
		if(    $Daten{$Konto.$i} eq "2" ) { push(@Zuweisung, 1); $gefunden=1; }
		  elsif( $Daten{$Konto.$i} eq "3" ) { push(@Zuweisung, 2); $gefunden=1; }
		  elsif( $Daten{$Konto.$i} eq "4" ) { push(@Zuweisung, 3); $gefunden=1; }
		  elsif( $Daten{$Konto.$i}*1>5 and $Daten{$Konto.$i}*1<10 ) { push(@Zuweisung, 4); $gefunden=1; }
		  elsif( $Daten{$Konto.$i} eq "5" or ( $Daten{$Konto.$i}*1>10 and $Daten{$Konto.$i}*1<25 ) ) { push(@Zuweisung, 5); $gefunden=1; }
		  elsif( $Daten{$Konto.$i} eq "1" ) { push(@Zuweisung, 6); $gefunden=1; }
		  elsif( $Daten{$Konto.$i} eq "25") { push(@Zuweisung, 7); $gefunden=1; }
		  elsif( $Daten{$Konto.$i} eq "27") { push(@Zuweisung, 8); $gefunden=1; }
		
		if( $gefunden ) { print $Daten{$Konto.$i}." "; }
		unless($gefunden) { push(@Zuweisung, 0); print "0 "; } 
		}
	
	print '</div>',"\n"; # Ende Dateidarstellung
	
	# Zuweisung einsetzen	
	foreach(keys(%AlleZeilen)) {
		$Eintraege{$_}=$AlleZeilen{$_}; }

	my @Eintraege=sort( keys (%Eintraege));
	foreach (@Eintraege) {

	        #Trenner irritierende Kodierung aufheben
	        $Eintraege{$_}=~s/&quot;/\"/g;
	        $Eintraege{$_}=Form::html2utf8($Eintraege{$_});	        
	        
	        my $trenner=$Daten{$Konto."trenner"}; 
	        my @Bankspalte=split(/$trenner/,$Eintraege{$_});
		
	        # Dekodierung wieder rueckgaengig machen
		foreach(@Bankspalte) {
			$_=~s/\"/&quot;/g;
			$_=Form::utf82html($_); }
			
		my @Meinspalte="";
		for(my $i=0; $i<=21; $i++) {
			$Meinspalte[$Zuweisung[$i]] .= $Bankspalte[$i]." "; 
			}
		
		# Kontobezeichnung mit Iban ueberschreiben
		$Meinspalte[6]=$Daten{$Konto."quelldatei"};
		
		#Zeile bilden, Zusatzfeld am Ende fuer Marker einfuehren
		my $Meinzeile; 
		for(my $k=1; $k<=8; $k++) {
			$Meinzeile.=$Meinspalte[$k]."#:#";
			}

	        $Eintraege{$_}=$Konto."#:#".$Bankname."#:#".$iban."#:#".$Meinzeile;
	        print $_,"#:#",$Eintraege{$_},"<br>\n";
	        }
	
        
#	        my @CSV_Zeilen = @{Form::Auslesen($_)};
#	        if( $zeile )
#		if( $Info[9]>$zuletzt && $Info[9]>$vorletzt ) { 
#			$vorletzt=$zuletzt;
#			$zuletzt=$Info[9];
#			}
#		elsif( $Info[9]>$vorletzt && $Info[9]<$zuletzt) {
#			$vorletzt=$Info[9];
#			}
		#else {
		#	unlink $_;
		#	}
  $x++;		
 
 } # Ende Konten
#	foreach(@CSV_Dateien) {
#	if( length($Daten{$Konto."erkennung"})>0 ) {
#		my @NeueZeilen = @{Form::Auslesen("$_")};
#		my $Suche = $Daten{$Konto."erkennung"};
#		my @Suchzeile = grep(/$Suche/,@NeueZeilen);
#		if( length(pop(@Suchzeile))>1 ) {
#		   $aktuell=Aktualisieren($_, $iban, \@Folge, $t, $Muster); }
#	} else {
#		$aktuell=Aktualisieren($_, $iban, \@Folge, $t, $Muster);
#	       	}
#	}
	my ($Sekunden, $Minuten, $Stunden, $Monatstag, $Monat,
	      $Jahr, $Wochentag, $Jahrestag, $Sommerzeit) = gmtime($Aelteste);
	      $Monat++;
	      $Monat = $Monat < 10 ? $Monat = "0".$Monat : $Monat;
	      $Monatstag = $Monatstag < 10 ? $Monatstag = "0".$Monatstag : $Monatstag;
	my    $Datum = $Monatstag.'.'.$Monat.'.'.($Jahr+1900)." / ";
#  }
###########################################################################

    my %Buchungen;
    if( -e "../data/bankenauszuege.cfg" ) {
	  %Buchungen = %{Form::Auslesen_Spiegel("../data/bankenauszuege.cfg", "", "")};
	  }

    # Markierungszeichen erhalten
    foreach ( keys (%Buchungen) ) {
	  $Eintraege{$_} = $Buchungen{$_};
	  }
	
    # Chronologische Liste
    my @Eintraege;
    foreach ( keys(%Eintraege) ) {
	  push (@Eintraege, $_."#:#".$Eintraege{$_});
	  }
    @Eintraege = sort (@Eintraege);	  

    Form::Speichern("../data/bankenauszuege.cfg", \@Eintraege, "In /data kann nicht geschrieben werden oder Sie haben keine Schreibberechtigung fuer die Liste bankenauszuege.cfg:\n$!");

    print $cgi->h1('Auszug vom  '.$Datum),
	 $cgi->hr,
         $cgi->p;


### Ueberschreiben der bereits gebuchten Eintraege mit einer Leerzeile in der PB-Datei

#   print '
#   <script type="text/javascript">
#   <!--
#   text = new Array();
#';
#   my $Zeilennummer=0;
#   foreach $Zeile (@Buchungen) {
#      $Zeile=~s/\n//gi;
#      print '  text[',$Zeilennummer,'] = "',$Zeile,'";', "\n";
#      $Zeilennummer++;
#      } 
#   print'
#   function buchung(Zeile, Wertstellung, Buchungshinweis, Auftraggeber, Empfaenger, Betrag)
#       {
#       if( Betrag.match(/^-/) ) {
#          Fensterout=window.open("http: lawsuit?Wertstellung, Buchungshinweis, Auftraggeber, Betrag", "Zahlungsausgang", "width=400,height=500,left=100,top=200");
#          Fensterout.focus(); }
#       else {
#          Fensterin=window.open("http: lawsuit?Wertstellung, Buchungshinweis, Empfaenger, Betrag", "Zahlungseingang", "width=400,height=500,left=100,top=200");
#          Fensterin.focus(); }
#       text.splice((Zeile-1), 1);
#       document.open("'.$aktuell.'", "replace")
#       for (var i = 0; i <= text.length; i++)
#          document.writeln(text[i]);
#       document.close();
#        }
#   // -->
#   </script>
#   ';

###

   #print '<font color=#00046a>';
   print $cgi->start_table({-border=>"0", -bgcolor=>"#dee6ee", -width=>"100%", -cellpadding=>"10"});


### Darstellung als HTML-Seite

   my $Zeilennummer=0;
   my $Hintergrund="white";
   foreach my $Zeile (@Eintraege) {
	my @Woerter = split(/#\:#/,$Zeile);
	my ($Zeit, $Buchungskonto, $Bankname, $Iban, $Datum, $Wertstellung, $Art, $Auftraggeber, $Buchnungstext, $Bankkonto, $Betrag, $Waehrung) = @Woerter;
	$Bankname='<a href style="background-color:#'.substr($Iban,2,6).'" title="'.$Bankname.'">&nbsp;</a>';
	@Woerter = split(/&nbsp;/,$Auftraggeber);
	$Auftraggeber="";
	my $Linie=$Woerter[0];
	foreach (@Woerter) {
	      if( length($Linie)<=15 ) { $_.=" "; $Linie.=$_; }
	      else { $_.="<br>"; $Linie="";}
	      $Auftraggeber.=$_;
	      }
	@Woerter = split(/&nbsp;/,$Buchnungstext);
	$Buchnungstext="";
	$Linie=$Woerter[0];
	foreach (@Woerter) {
	      if( length($Linie)<=15 ) { $_.=" "; $Linie.=$_; }
	      else { $_.="<br>"; $Linie="";}
	      $Buchnungstext.=$_;
	      }
	my $Cleanhinweis=$Buchnungstext; $Cleanhinweis=~s/,/\./g; $Cleanhinweis=~s/<br>/ \n/gi;
	my $Cleanbetrag=$Betrag; $Cleanbetrag=~s/,/\./g;

	# Link fuer den Buchungseintrag in SQL-Ledger

	my $Link='<a href="javascript:buchung('.$Zeilennummer.', '.$Wertstellung.', '.$Cleanhinweis.', '.$Auftraggeber.',  '.$Cleanbetrag.')"><img src="../../img/buchung.gif" border=""></a>';
	#

	my $Hintergrund = ($Hintergrund eq "white")? "#dee6ee" : "white";
	my $Textfarbe= ( $Betrag=~/^-/ || $Betrag=~/^&minus;/ )?  "red" : "green"; 
	$Betrag="<font color=".$Textfarbe.">".$Betrag."</font>";
	print  $cgi->Tr($cgi->td({-align => 'center', -bgcolor => $Hintergrund}, $Bankname),
			$cgi->td({-align => 'left', -bgcolor => $Hintergrund}, $Wertstellung),
			$cgi->td({-align => 'left', -bgcolor => $Hintergrund}, $Art),
			$cgi->td({-align => 'left', -bgcolor => $Hintergrund}, $Buchnungstext),
			$cgi->td({-align => 'left', -bgcolor => $Hintergrund}, $Auftraggeber),
			$cgi->td({-align => 'right', -bgcolor => $Hintergrund}, $Betrag),
			$cgi->td({-align => 'right', -bgcolor => $Hintergrund}, $Waehrung),
			$cgi->td({-align => 'right', -bgcolor => $Hintergrund}, $Link));
       $Zeilennummer++;
       }

   print $cgi->end_table();
   print '</font>';

###

   print '<pre> ', "\n";
   print ' ', "\n";
   print ' ', "\n";
   print ' </pre>', "\n";

   print $cgi->end_html;

   
sub Wert {

   my $suche  = shift;
   my $zeile  = shift;
   my $konto  = shift;
   my $daten  = shift;
   my %daten  = %{$daten};
   my $jahr   = shift;
   my $k=0;
   
      for(my $i=0; $i<=21; $i++) {
	if( $daten{$konto.$i} eq $suche ) { $k=$i; }
	}
      
      my $trenner = $daten{$konto."trenner"};
      
      # Zeitstempel entfernen
	 $zeile=~s/^\d+#:#//
	 ;
      # Anfuehrungsstriche rigoros loeschen
	 $zeile=~s/\"//g;
 	 $zeile=~s/&quot;$trenner&quot;/$trenner/g;
 	 $zeile=~s/^&quot;//;
 	 $zeile=~s/&quot;$//g;

      my @tabellenwerte = split(/$trenner/,$zeile);
	  
      # Falsches Datumsformat
      if( ($suche eq 3) or ($suche eq 4) and $tabellenwerte[$k]!=m/\d\d\.\d\d\.\d\d\d\d/ ) {
	 my @datum=split(/\D/,$tabellenwerte[$k]);
	 if( length($datum[0])<2 ) { $datum[0]="0".$datum[0]; }
	 if( length($datum[1])<2 ) { $datum[1]="0".$datum[1]; }
	 if( length($datum[2])<=0 ) { $datum[2]=$jahr; }
	 if( length($datum[2])<3 ) { $datum[2]=2000+$datum[2]*1; }
	 $tabellenwerte[$k]=join(".",@datum);
	 }

   return $tabellenwerte[$k];
   
}


sub Aktualisieren {

   my $neu    = shift;
   my $iban   = shift;
      $iban   =~ s/\.\w\w\w(\w)?$/\.cfg/g;
   my $folge  = shift;
   my @folge  = @{$folge};
   my $t      = shift;
   my $muster = shift;
   my %daten;
   my @altezeilen = (-e "../data/$iban")? @{Form::Auslesen("../data/$iban")} : "";
   my @zeilen = (-e "../data/$neu")? @{Form::Auslesen("../data/$neu")} : "";
   my @neuezeilen;

   # Ueberfluessige Anfuehrungszeichen entfernen
      foreach(@zeilen) {
	$_=~s/^[\"\']//;
	$_=~s/[\"\']\n$/\n/;
	$_=~s/[\"\']$t[\"\']/$t/g;
	}

   $t = "\\".$t;
   my @buchungen_kaufm = grep(/$muster/,@zeilen);
   my $zeile;
   my @zeilen="";
   foreach(@buchungen_kaufm) {             # Dekodieren und chronologisch anfuegen
       $zeile = decode("iso-8859-1", $_);
#      $zeile = encode("utf8", $zeile); 
       $zeile =~ s/$t/#\:#/g;
       my @zeile = split("#:#", $zeile);
       for(my $i=0; $i<=21; $i++) {
		$daten{"F".$folge[$i]}=Form::utf82html($zeile[$i]); }
       if( length($daten{"F2"})<=6 ) { $daten{"F2"}.=substr((Form::Datum(2,0)),6,4); }
       if( length($daten{"F2"})<=8 ) { $daten{"F2"}=substr($daten{"F2"},0,5).".20".substr($daten{"F2"},6,2); }
       if( length($daten{"F3"})<=6 ) { $daten{"F3"}.=substr((Form::Datum(2,0)),6,4); }
       if( length($daten{"F3"})<=8 ) { $daten{"F3"}=substr($daten{"F2"},0,5).".20".substr($daten{"F3"},6,2); }
       $daten{"Auftraggeber"} = ( $daten{"F11"}=~m/&minus;/ )? $daten{"F7"} : $daten{"F6"};
       $daten{"Auftraggeber"} ||= $daten{"F8"};
       $daten{"Art"} = $daten{"F4"};
       $daten{"Art"} ||= $daten{"F14"};
       $daten{"Kto"}=substr($iban, 12, 10);
       my $neuezeile = $daten{"F2"}."#:#".$daten{"F3"}."#:#".$daten{"Art"}."#:#".$daten{"F5"}."#:#".$daten{"Auftraggeber"}."#:#".$daten{"Kto"}."#:#".$daten{"F11"}."#:#".$daten{"F12"}."\n";
       push(@zeilen, $neuezeile);
       }

   foreach my $new (@zeilen) {
	my $vorhanden=0;
	foreach my $old (@altezeilen) {
		if($old eq $new) { $vorhanden=1; }
	}
	unless( $vorhanden ) { 
		push(@neuezeilen, $new); 
	}
   }



  return $iban;

}

