#!/usr/bin/perl -w 

   use Encode; # fuer OpenOffice - Konvertierung in UTF-8 
   
   use strict;
   use CGI;
   my $cgi = new CGI;
   use CGI::Carp qw(fatalsToBrowser);

   use lib "/home/hedele/lawsuit/cgi-bin/LS";
   use LS::Form;
   use LS::Stamm;

   my @Feldnamen = $cgi->param();
   my %Daten;
   my $Partei;
   my $partei;
   my $P;
   my $verzeichnis;
   my $Error;
   my @Option;
   my @Woerter;
   my @Zeilen;
   my $Zeile;
   my @Fritzzeilen;
   my $Fritzzeile;
   my @Wochentage = qw( MO TU WE TH FR SA SU );

   foreach my $Feld (@Feldnamen) {
	if( $cgi->param($Feld) )  {
		$Daten{$Feld} = Form::utf82html(encode("utf8", Form::noURI($cgi->param($Feld))));
		$Daten{$Feld}=~s/undefined(&nbsp;)?//g;
	} else {
		$Daten{$Feld} = "";
		}
	}

   my @Ges = qw(2#:#Frau 1#:#Herr);
   my @Titel = qw(#:# Dr.#:#Dr. Prof.#:#Prof. Prof.&nbsp;Dr.#:#Prof.&nbsp;Dr. Mtre#:#Mtre Msgr.#:#Msgr. Dott.#:#Dott. Dott.ssa#:#Dott.ssa);
   my @Kontakt;
   my @Kontakte = @{Form::Auslesen("../data/kontakt.cfg")};
   foreach (@Kontakte) {
	@Woerter=split(/#?\:#?/,$_);
	$Zeile=$Woerter[0].'_'.$Woerter[1].'_'.$Woerter[2].'_'.$Woerter[3].'#:#'.$Woerter[0];
	push(@Kontakt, $Zeile);
	}
   my @Land;
   my @Laender=@{Form::Auslesen("../data/land.cfg")};
   foreach (@Laender) {
	@Woerter=split(/#?\:#?/,$_);
	$Zeile=$Woerter[0].'#:#'.$Woerter[0];
	push(@Land, $Zeile);
	}
   my @Bankland;
   my @Banklaender=@{Form::Auslesen("../data/bankland.cfg")};
   foreach (@Banklaender) {
	@Woerter=split(/#?\:#?/,$_);
	$Zeile=$Woerter[0].'#:#'.$Woerter[0];
	push(@Bankland, $Zeile);
	}
   my @Laender = qw( #:#-&nbsp;bitte&nbsp;Bundesland&nbsp;ausw&auml;hlen&nbsp;- bw#:#Land&nbsp;Baden-W&uuml;rttemberg by#:#Freistaat&nbsp;Bayern bb#:#Land&nbsp;Brandenburg be#:#Land&nbsp;Berlin hb#:#Freie&nbsp;Hansestadt&nbsp;Bremen hh#:#Freie&nbsp;Hansestadt&nbsp;Hamburg he#:#Land&nbsp;Hessen mv#:#Land&nbsp;Mecklenburg-Vorpommern ns#:#Land&nbsp;Niedersachsen nw#:#Land&nbsp;Nordrhein-Westfalen rp#:#Land&nbsp;Rheinland-Pfalz sa#:#Land&nbsp;Sachsen-Anhalt sh#:#Land&nbsp;Schleswig-Holstein sl#:#Land&nbsp;Saarland sn#:#Freistaat&nbsp;Sachsen th#:#Freistaat&nbsp;Th&uuml;ringen );
	
   #Aktuelle UTC-Zeit ermitteln
   my ($Sekunden, $Minuten, $Stunden, $Monatstag, $Monat, $Jahr, $Wochentag, $Jahrestag, $Sommerzeit) = gmtime(time);
   $Monat+=1;
   $Jahrestag+=1;
   $Jahr+=1900;
   $Monat = $Monat < 10 ? $Monat = "0".$Monat : $Monat;
   $Monatstag = $Monatstag < 10 ? $Monatstag = "0".$Monatstag : $Monatstag;
   $Stunden = $Stunden < 10 ? $Stunden = "0".$Stunden : $Stunden;
   $Minuten = $Minuten < 10 ? $Minuten = "0".$Minuten : $Minuten;
   $Sekunden = $Sekunden < 10 ? $Sekunden = "0".$Sekunden : $Sekunden;
   my $Jetzt = $Jahr.$Monat.$Monatstag."T".$Stunden.$Minuten.$Sekunden."Z";


############################################################################################
if( $ENV{CONTENT_LENGTH} <= 0 && $cgi->param("stufe") ne "2" ) {
############################################################################################



	my $parteiname="angestellt";
	my $parteien="angestellte";
	my $Auswahl="Person";
	my @Adressen=@{Stamm::Adressliste($Partei, "A", "$Auswahl")}; # mit Altadressen vergleichen
	my @Options;
	foreach (@Adressen) { 
		push(@Options, $_); 
		}
	
	@Options=sort(From2Sort @Options);

        $Daten{$parteiname."HTML"}=Form::Ausklappmenue(\@Options, "$parteien", "", 10, 200, 200, q~onClick='javascript:foundparty("~.$parteien.q~");getElement("name","stufe",0).value="3";window.open("../cgi-bin/warten.pl","Bitte warten!","dependent=yes,location=no,menubar=no,resizable=no,toolbar=no,status=no,width=400,height=50,left=100,top=10");document.angestellte.submit()'~);
	

	
	
	
  ### Zwischenseite immer auswerfen
   print $cgi->header(),
	     $cgi->start_html(-title =>'Angestelltenauswahl', -charset =>'utf8');
   print @{Form::HTML("angestellterA", \%Daten)};
   print $cgi->end_html;


}

############################################################################################
if( $cgi->param("stufe") eq "2" ) {
#############################################################################################


	my $Partei=Stamm::Rubrumklar($Daten{"Ckurzrubrum"});    $Partei=~s/\,\&nbsp\;/\,/g;
	   @Woerter=split(/\,/, $Partei);     $Partei=$Woerter[0].",&nbsp;".substr($Woerter[1],0,1);



	if( length($Daten{"Cpfile"}) > 1 ) {
		$Partei = $Daten{"Cpfile"};
		$partei=lc(Form::html2utf8($Partei)); 
		$P="A";
		}
        elsif( $Partei =~ m/Neuer.*Angestellter/g or length($Partei) < 1 ) {
		$Partei="vorlage";
		$partei="vorlage";
		}
	else {
		my @Adressen;
	        $verzeichnis="staff";

		my @Partei=qw(P M A);
	        foreach my $P (@Partei) {

			my $Auswahl=Stamm::Rubrumklar($Daten{"Ckurzrubrum"});
			my @Options =@{Stamm::Adressliste($Partei, $P, "Person")}; # aktuellste Verdaechtige zum Schluss anhaengen
			foreach (@Options) {
				push(@Adressen, $_); }
				}
		$Partei=pop(@Adressen);		
		$P=substr($Partei,0,1);
		$Partei=substr($Partei,1);
		$Partei=~s/#:#.*//g;
		$partei=lc(Form::html2utf8($Partei)); 
		}

	if( $P eq "P" ) { $verzeichnis="parties" }
	if( $P eq "M" ) { $verzeichnis="clients" }
	if( $P eq "A" ) { $verzeichnis="staff"  }

	unless(-e "../$verzeichnis/$partei/data/adresse.cfg") { $partei="vorlage"; } # Auffangregelung fals Nutzer Feld ausgefuellt hat
	
	my %Adresse=%{Form::Auslesen_Spiegel("../$verzeichnis/$partei/data/adresse.cfg", "", "")};
	foreach (keys(%Adresse)) {
		my $neu = $_;
		$neu =~s/^[A-Z]/A/; 
	# Vorlage nur einlesen, wo kein Vorschlag
	if( length($Daten{$neu})<=1 ) { $Daten{$neu} = $Adresse{$_}; } 
	}

	my %NeueDaten = %{Stamm::Typ($P, \%Daten, \@Ges, \@Land, \@Titel)};
		foreach (keys(%NeueDaten)) {
			$Daten{$_} = $NeueDaten{$_};
	}

   my $Auswahl;

   $P="A";

   $Auswahl=$Daten{$P."ges"} ||= 1;
   $Daten{"AngestGes"}=Form::Ausklappmenue(\@Ges, $P."ges", $Auswahl, "", 40, 150, 'onChange=javascript:klaeren(this.name);anrede("'.$P.'")');

   $Auswahl=$Daten{$P."titel"} ||="";
   $Daten{"AngestTitel"}=Form::Ausklappmenue(\@Titel, $P."titel", $Auswahl, "", 40, 150, 'onChange=javascript:klaeren(this.name);anrede("'.$P.'")');
      
   $Auswahl=$Daten{$P."kontakt"} ||="formell_Sehr geehrter Herr_Sehr geehrte Frau_Mit freundlichen Gr&uuml;&szlig;en";
   $Daten{"AngestKontakt"}=Form::Ausklappmenue(\@Kontakt, $P."kontakt", $Auswahl, "", 40, 300, q~onChange="javascript:anrede('~.$P.q~')"~);

   $Auswahl=$Daten{$P."land"} ||= "D";
   $Daten{"AngestLand"}=Form::Ausklappmenue(\@Land, $P."land", $Auswahl, "", 30, 100, "");

   $Auswahl=$Daten{$P."bankland"} ||="DE";
   $Daten{"AngestBankland"}=Form::Ausklappmenue(\@Bankland, $P."bankland", $Auswahl, "", 40, 200, q~onChange="javascript:ibanfinde('~.$P.q~')"~);

   my @Zuzweikind = qw( 0#:#keine&nbsp;Kinder 0.5#:#0,5&nbsp;-&nbsp;ein&nbsp;Kind 1#:#1,0&nbsp;-&nbsp;zwei&nbsp;Kinder 1.5#:#1,5&nbsp;-&nbsp;drei&nbsp;Kinder 2#:#2,0&nbsp;-&nbsp;vier&nbsp;Kinder 2.5#:#2,5&nbsp;-&nbsp;f&uuml;nf&nbsp;Kinder 3#:#3,0&nbsp;-&nbsp;sechs&nbsp;Kinder 3.5#:#3,5&nbsp;-&nbsp;sieben&nbsp;Kinder 4#:#4,0&nbsp;-&nbsp;acht&nbsp;Kinder&nbsp;4.5#:#4,5&nbsp;-&nbsp;neun&nbsp;Kinder 5#:#5,0&nbsp;-&nbsp;zehn&nbsp;Kinder );
   $Auswahl=$Daten{$P."zkf1"} ||= 0;
   $Daten{"AngestZuzweiKind"}=Form::Ausklappmenue(\@Zuzweikind, $P."zkf1", $Auswahl, "", 280, 280, "onChange=javascript:getElementsByName('Azkf')[0].value=eval(getElementsByName('Azkf1')[0].value)+eval(getElementsByName('Azkf2')[0].value)");

   my @Alleinkind = qw( 0#:#keine&nbsp;Kinder 1#:#1,0&nbsp;-&nbsp;ein&nbsp;Kind 2#:#2,0&nbsp;-&nbsp;zwei&nbsp;Kinder 3#:#3,0&nbsp;-&nbsp;drei&nbsp;Kinder 4#:#4,0&nbsp;-&nbsp;vier&nbsp;Kinder 5#:#5,0&nbsp;-&nbsp;f&uuml;nf&nbsp;Kinder 6#:#6,0&nbsp;-&nbsp;sechs&nbsp;Kinder 7#:#7,0&nbsp;-&nbsp;sieben&nbsp;Kinder 8#:#8,0&nbsp;-&nbsp;acht&nbsp;Kinder 9#:#9,0&nbsp;-&nbsp;neun&nbsp;Kinder 10#:#10,0&nbsp;-&nbsp;zehn&nbsp;Kinder );
   $Auswahl=$Daten{$P."zkf1"} ||= 0;
   $Daten{"AngestAlleinKind"}=Form::Ausklappmenue(\@Alleinkind, $P."zkf2", $Auswahl, "", 280, 280, "onChange=javascript:getElementsByName('Azkf')[0].value=eval(getElementsByName('Azkf1')[0].value)+eval(getElementsByName('Azkf2')[0].value)");

   my @Reli = qw(0#:#keine&nbsp;Religionszugeh&ouml;rigkeit rk#:#r&ouml;misch&minus;katholisch ev#:#evangelisch lt#:#evangelisch&minus;lutherisch rf#:#evangelisch&minus;reformiert fr#:#franz&ouml;sisch&minus;reformiert ak#:#altkatholisch isnw#:#israelitisch&frasl;j&uuml;disch&nbsp;in&nbsp;NRW fa#:#freie&nbsp;Religionsgemeinschaft&nbsp;Alzey fb#:#freireligi&ouml;se&nbsp;Landesgemeinde&nbsp;Baden fm#:#freireligi&ouml;se&nbsp;Gemeinde&nbsp;Mainz fs#:#freireligi&ouml;se&nbsp;Gemeinde&nbsp;Offenbach ib#:#israelitische&nbsp;Religionsgemeinschaft&nbsp;Baden iw#:#israelitische&nbsp;Religionsgemeinschaft&nbsp;W&uuml;rttemberg isby#:#Verband&nbsp;d.&nbsp;israelitischen&nbsp;Kultusgemeinden&nbsp;Bayern jh#:#J&uuml;dische&nbsp;Gemeinde&nbsp;Hamburg ishe#:#J&uuml;dische&nbsp;Gemeinde&nbsp;Frankfurt&nbsp;&lang;HE&rang; il#:#J&uuml;dische&nbsp;Gemeinden&nbsp;Hessen isrp#:#J&uuml;dische&nbsp;Kultusgem.&nbsp;Bad&nbsp;Kreuznach&nbsp;und&nbsp;Koblenz&nbsp;&lang;RP&rang; isslp#:#israelitisch&nbsp;im&nbsp;Saarland);
   my $Auswahl=$Daten{"Areligion"};
   $Daten{"AngestReligion"}=Form::Ausklappmenue(\@Reli, "Areligion", $Auswahl, "", 40, 280, "");

   my @Repnummer = qw(0#:#Alleinvertretungsberechtigten 1#:#zwei&nbsp;gemeinschaftlich 2#:#drei&nbsp;gemeinschaftlich 3#:#vier&nbsp;gemeinschaftlich 4#:#f&uuml;nf&nbsp;gemeinschaftlich 5#:#sechs&nbsp;gemeinschaftlich 6#:#sieben&nbsp;gemeinschaftlich);
   $Auswahl=$Daten{$P."repnummer"} ||= 0;
   $Daten{$P."Repnummer"}=Form::Ausklappmenue(\@Repnummer, $P."repnummer", $Auswahl, "", 100, 300, 'onChange=javascript:addrepresentation("'.$P.'vertreten")' );

   my @RV = qw( bund#:#RV&nbsp;Bund knappschaft#:#RV&nbsp;Knappschaft&minus;Bahn&minus;See bw#:#RV&nbsp;Baden-W&uuml;rttemberg by#:#RV&nbsp;Bayern&nbsp;S&uuml;d bb#:#RV&nbsp;Berlin&minus;Brandenburg ns#:#RV&nbsp;Braunschweig&minus;Hannover he#:#RV&nbsp;Hessen sa#:#RV&nbsp;Mitteldeutschland sh#:#RV&nbsp;Nord nb#:#RV&nbsp;Nordbayern hb#:#RV&nbsp;Oldenburg&minus;Bremen rh#:#RV&nbsp;Rheinland rp#:#RV&nbsp;Rheinland-Pfalz sl#:#RV&nbsp;Saarland sb#:#RV&nbsp;Schwaben wf#:#RV&nbsp;Westfalen so#:#sonstige&nbsp;Versorgung );
   my $Auswahl=$Daten{"Arv"};
   $Daten{"AngestRentenversicherung"}=Form::Ausklappmenue(\@RV, "Arv", $Auswahl, "", 40, 200, "onChange=javascript:getElement('name','Arentenversicherungsname',0).value=this.options[this.selectedIndex].text;if(this.value.match(/so/))getElement('name','rvshow',0).setAttribute('style','display:inline',0);");

   #Betreibliche Altersvorsorge
   my @bav = qw( keine#:#keine&nbsp;betriebliche&nbsp;Altersvorsorge DZ#:#Direktzusage UK#:#Unterst&uuml;tzungskasse PK#:#Pensionskasse DV#:#Direktversicherung PF#:#Pensionsfond );
   my $Auswahl;
   $Daten{"AngestBetriebsvorsorge"}=Form::Ausklappmenue(\@bav, "ABAV", $Auswahl, 20, 330, 330, "");

   my $Auswahl=$Daten{"Abundesland"};
   $Daten{"AngestBundesland"}=Form::Ausklappmenue(\@Laender, "Abundesland", $Auswahl, "", 40, 330, 'onChange="javascript:klaeren(this.name)"');
   
   my @SKL = qw( 1#:#I 2#:#II 3#:#III 4#:#IV 5#:#V 6#:#VI );
   my $Auswahl = $Daten{"Astkl"};
   $Daten{"AngestSteuerklasse"} = Form::Ausklappmenue(\@SKL, "Astkl", $Auswahl, "", 100, 100, "onChange=if(this.value==4)getElementsByName('faktorverfahren')[0].setAttribute('style','display:table-row',false);else{getElementsByName('faktorverfahren')[0].setAttribute('style','display:none',false);getElementsByName('Aaf')[0].checked=false;}");

   
   $Daten{"Cpfile"}=($partei eq "vorlage")? "" : Form::utf82html($partei);
   $Daten{"Aenderungsdatum"}=$Monatstag.".".$Monat.".".$Jahr;

   
   # Boolens fuellen
   $Daten{"Akinder"}=($Daten{"Akinder"})? "checked" : "";
   $Daten{"Azkf"}=($Daten{"Akinder"})? "0" : $Daten{"Azkf"};
   $Daten{"kindershow"}=($Daten{"Akinder"})? "table-row" : "none";
   $Daten{"faktorverfahren"}=($Daten{"Astkl"}==4)? "table-row" : "none";
   $Daten{"AF"}=($Daten{"Aaf"})? "checked" : "";
   $Daten{"Amini"}=($Daten{"Amini"})? "checked" : "";
   $Daten{"Aazubi"}=($Daten{"Aazubi"})? "checked" : "";
   $Daten{"Astudent"}=($Daten{"Astudent"})? "checked" : "";
   $Daten{"Aermaessigt"}=($Daten{"Aermaessigt"})? "checked" : "";


#####################################################

   print "Pragma: no-cache\nContent-type: text/html\n\n";
   print @{Form::HTML("angestellterB", \%Daten)};
   print $cgi->end_html;





############################################################################################
} elsif( $cgi->param("stufe")==3 ) {
#############################################################################################



        my $P="A";
	my $p="a";
	$verzeichnis="staff";

   ###### Verzeichnisse anlegen, wenn nocht nicht vorhanden, adresse.cfg ueberschreiben ######

	$Partei=$Daten{"Anachname"}.",&nbsp;".substr($Daten{"Avorname"},0,1);
	if ( length($cgi->param("Cpfile"))>0 ) { # nurmehr Cpfile
		$partei = Form::html2utf8($Daten{"Cpfile"}); 
		}
	else {
		$partei = Form::html2utf8($Daten{"Cafile"}); 
		}

   my $Fritzzeile="";
   if( $Daten{$p."change"} && $partei ne "vorlage") {

       unless ( -e "../$verzeichnis/$partei" ) {
          mkdir("../$verzeichnis/$partei") || die "Neuer $Partei $partei kann im Verzeichnis $verzeichnis nicht angelegt werden :\n$!";
          chmod(0777, "../$verzeichnis/$partei");
          }
       unless ( -e "../$verzeichnis/$partei/data" ) {
          mkdir("../$verzeichnis/$partei/data") || die "Neuer $Partei $partei kann im Verzeichnis $verzeichnis nicht angelegt werden :\n$!";
          chmod(0777, "../$verzeichnis/$partei/data");
          }
       elsif ( -e "../$verzeichnis/$partei/data/adresse.cfg" ) {
          my @Zeilen = @{Form::Auslesen("../$verzeichnis/$partei/data/adresse.cfg")};
	  open(DATEI, ">>../$verzeichnis/$partei/data/adresse.old") || die "Die Datei adresse.old kann unter $partei nicht beschrieben werden :\n$!";
		print DATEI Form::Datum(3,0)," ########################################\n";
		print DATEI @Zeilen;
	  close(DATEI);
	  chmod(0777, "../$verzeichnis/$partei/adresse.old");
	  }   


       Form::Speichern_Spiegel( \@Feldnamen, \%Daten, "../$verzeichnis/$partei/data/adresse.cfg", "$P");

        ## hier Praefixe egal
       if( length($Daten{"Anachname"})>0 ) {
		open(DATEI, "<../$verzeichnis/all.cfg") || die "Die Datei $verzeichnis/all besteht nicht, oder Sie haben keine Leseberechtigung:\n$!";
			@Zeilen = <DATEI>; 
		close(DATEI);
		# wenn Uebernahme Cpfile aus Altdaten, sonst auf Skript creatfile und Cafile verlassen
		if( length($cgi->param("Cpfile"))>1 && $cgi->param("Cpfile") ne "vorlage" ) {
			$Daten{"Cafile"}=$cgi->param("Cpfile"); 
			}
		# Hilfsparameter, um dem Modul Liste einen weiteren Beteiligten vorzutäuschen
		$Daten{"Ca1file"}=$Daten{"Cafile"};
		$Daten{"arohname"}=$Daten{"Anachname"}.",&nbsp;".substr($Daten{"Avorname"}, 0,1);
		$Daten{"Atyp"}="Person";
		$Zeile=Form::Liste("A", 1, \%Daten, \%Daten);

		my $Wo="work";
		$Fritzzeile="<contact><category>0</category><person><realName>".Form::fritzform($Daten{$P."name"})."</realName><ImageURL /></person><telephony>";
		if( $Daten{$P.'telefon'} ) { $Fritzzeile.='<number type="'.$Wo.'" quickdial="" vanity="" prio="1">'.Form::fritzform($Daten{$P.'telefon'}).'</number>'; }
		if( $Daten{$P.'handy'} ) { $Fritzzeile.='<number type="mobile" quickdial="" vanity="" prio="">'.Form::fritzform($Daten{$P.'handy'}).'</number>'; }
		$Fritzzeile.='</telephony><services /><setup /></contact>';
		unless( $Fritzzeile =~ /quickdial/m ) { $Fritzzeile=""; }  # nur Leute mit Telefon aufnehmen
		############
		$Partei=Form::utf82html($partei);
		foreach (@Zeilen) { if( $_=~m/$Partei/g ) { $Zeilen[$.]=$Zeile; $Zeile=""; } }
		if ( length($Zeile)>0 ) { 
			push (@Zeilen, $Zeile); 
			push (@Fritzzeilen, $Fritzzeile);
			}
		Form::Speichern("../$verzeichnis/all.cfg", \@Zeilen, "In $verzeichnis kann nicht geschrieben werden oder Sie haben keine Schreibberechtigung fuer die Liste all:\n$!");
		Stamm::Fritz(\@Fritzzeilen);
		}

    
   }
   unless ( -e "../$verzeichnis/$partei/arbeitszeiten.ics" ) {
	 my @Zeilen='BEGIN:VCALENDAR
PRODID:-//K Desktop Environment//NONSGML libkcal 4.3//EN
VERSION:2.0
BEGIN:VTIMEZONE
TZID:Europe/Berlin
BEGIN:DAYLIGHT
TZNAME:CEST
TZOFFSETFROM:+0100
TZOFFSETTO:+0200
DTSTART:19810329T020000
RRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=3
END:DAYLIGHT
BEGIN:DAYLIGHT
TZNAME:CEST
TZOFFSETFROM:+0100
TZOFFSETTO:+0200
DTSTART:19160501T220000
RDATE;VALUE=DATE-TIME:19160501T220000
RDATE;VALUE=DATE-TIME:19170416T010000
RDATE;VALUE=DATE-TIME:19180415T010000
RDATE;VALUE=DATE-TIME:19400401T010000
RDATE;VALUE=DATE-TIME:19430329T010000
RDATE;VALUE=DATE-TIME:19440403T010000
RDATE;VALUE=DATE-TIME:19450402T010000
RDATE;VALUE=DATE-TIME:19460414T010000
RDATE;VALUE=DATE-TIME:19470407T020000
RDATE;VALUE=DATE-TIME:19480418T010000
RDATE;VALUE=DATE-TIME:19490410T010000
RDATE;VALUE=DATE-TIME:19800406T020000
END:DAYLIGHT
BEGIN:STANDARD
TZNAME:CET
TZOFFSETFROM:+0200
TZOFFSETTO:+0100
DTSTART:19800928T030000
RRULE:FREQ=YEARLY;COUNT=16;BYDAY=-1SU;BYMONTH=9
END:STANDARD
BEGIN:STANDARD
TZNAME:CET
TZOFFSETFROM:+0200
TZOFFSETTO:+0100
DTSTART:19961027T030000
RRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=10
END:STANDARD
BEGIN:STANDARD
TZNAME:CET
TZOFFSETFROM:+0200
TZOFFSETTO:+0100
DTSTART:19161001T230000
RDATE;VALUE=DATE-TIME:19161001T230000
RDATE;VALUE=DATE-TIME:19170917T020000
RDATE;VALUE=DATE-TIME:19180916T020000
RDATE;VALUE=DATE-TIME:19421102T020000
RDATE;VALUE=DATE-TIME:19431004T020000
RDATE;VALUE=DATE-TIME:19441002T020000
RDATE;VALUE=DATE-TIME:19451118T020000
RDATE;VALUE=DATE-TIME:19461007T020000
RDATE;VALUE=DATE-TIME:19471005T020000
RDATE;VALUE=DATE-TIME:19481003T020000
RDATE;VALUE=DATE-TIME:19491002T020000
END:STANDARD
BEGIN:DAYLIGHT
TZNAME:CEMT
TZOFFSETFROM:+0200
TZOFFSETTO:+0300
DTSTART:19450525T000000
RDATE;VALUE=DATE-TIME:19450525T000000
RDATE;VALUE=DATE-TIME:19470511T020000
END:DAYLIGHT
BEGIN:DAYLIGHT
TZNAME:CEST
TZOFFSETFROM:+0300
TZOFFSETTO:+0200
DTSTART:19450925T000000
RDATE;VALUE=DATE-TIME:19450925T000000
RDATE;VALUE=DATE-TIME:19470630T000000
END:DAYLIGHT
END:VTIMEZONE   
END:VCALENDAR
';
		open(DATEI, ">../$verzeichnis/$partei/arbeitszeiten.ics") || die "In /$verzeichnis/$partei kann der Kalender arbeitszeiten.ics nicht angelegt werden, vielleicht haben Sie keine Schreibberechtigung:\n$!";
			print DATEI @Zeilen;
		close(DATEI);
		chmod(0777, "../$verzeichnis/$partei/arbeitszeiten.ics");
		}

	foreach my $Tag (@Wochentage) {
		if( $Daten{"A".$Tag."_change"} ) {
		
			
			#Alten Wiederholungstermin ab Aenderung stoppen
			my @Aenderungsdatum = split(/\./, $Daten{"Aenderungsdatum"});
			my $Aenderungsdatum = $Aenderungsdatum[2].$Aenderungsdatum[1].$Aenderungsdatum[0];
			my $Aenderungszeit = $Aenderungsdatum."T020000Z";
			my $Startzeit=Form::html2utf8($Daten{"A".$Tag."_start"})."00"; $Startzeit=~s/://g;
			my $Endezeit=Form::html2utf8($Daten{"A".$Tag."_ende"})."00"; $Endezeit=~s/://g;
			my @Zeilen=@{Form::Auslesen("../$verzeichnis/$partei/arbeitszeiten.ics")};
			foreach (@Zeilen) {
				$_=~s/RRULE:FREQ=WEEKLY;BYDAY=$Tag\n/RRULE:FREQ=WEEKLY;UNTIL=$Aenderungszeit;BYDAY=$Tag\n/g;
				}
			#Neuen Wiederholungstermin eintragen
			my $guid = (int(rand(899999999))+100000000).".".(int(rand(899))+100);
			my @NeueZeilen = 'BEGIN:VEVENT
CREATED:'.$Jetzt.'
DTSTAMP:'.$Aenderungszeit.'
UID:libkcal-'.$guid.'
SEQUENCE:1
LAST-MODIFIED:'.$Jetzt.'
SUMMARY:'.Form::html2utf8($Daten{"Avorname"})." ".Form::html2utf8($Daten{"Anachname"})." im Büro".'
LOCATION:Büro
STATUS:CONFIRMED
CATEGORIES:'.Form::html2utf8($Daten{"Ahaupttaetigkeit"}).'
RRULE:FREQ=WEEKLY;BYDAY='.$Tag.'
DTSTART;TZID=Europe/Berlin:'.$Aenderungsdatum."T".$Startzeit.'
DTEND;TZID=Europe/Berlin:'.$Aenderungsdatum."T".$Endezeit.'
TRANSP:TRANSPARENT
END:VEVENT
';
			my $Journalstart=0;
			my $Zeilen=@Zeilen;
			for(my $i=0;$i<=$Zeilen;$i++ ) {
				if( index("BEGIN:VJOURNAL", $Zeilen[$i]) > 0 ) {
					$Journalstart=$i; }
				}
			# Einschub entweder vor BEGIN:VJOURNAL oder sonst vor END:VCALENDAR
			if( $Journalstart>0 ) {
				splice(@Zeilen,$Journalstart,0,@NeueZeilen); }
			else {
				splice(@Zeilen,($Zeilen-1),0,@NeueZeilen); }
			
			open(DATEI, ">../$verzeichnis/$partei/arbeitszeiten.ics") || die "In /$verzeichnis/$partei kann der Kalender arbeitszeiten.ics nicht angelegt werden, vielleiccht haben Sie keine Schreibberechtigung:\n$!";
				print DATEI @Zeilen;
			close(DATEI);
			chmod(0777, "../$verzeichnis/$partei/arbeitszeiten.ics");

			}
		}

   
   #Lohnzahlungszeitraum
   my @LZ = qw( 4#:#Tag&nbsp;&nbsp;&nbsp; 3#:#Woche&nbsp;&nbsp;&nbsp; 2#:#Monat&nbsp;&nbsp;&nbsp; 1#:#Jahr&nbsp;&nbsp;&nbsp; );
   my $Auswahl = $Daten{"LZZ1"}||=2;
   $Daten{"AngestLZZ"} = Form::Ausklappmenue(\@LZ, "LZZ", $Auswahl, 20, 150, 150, "onChange=javascript:tabwechsel();createfilename();");

   
   my @Monat;
   my $Febend;
   my $Vorfebend;
   my $Vorjahr=$Jahr-1;
   my $Folgejahr=$Jahr+1;
   if( ($Vorjahr % 4 == 0 && $Vorjahr % 100 != 0) || ($Vorjahr % 1000 == 0) ) { $Vorfebend=29; }
   else { $Vorfebend=28; }
   if( ($Jahr % 4 == 0 && $Jahr % 100 != 0) || ($Jahr % 1000 == 0) ) { $Febend=29; }
   else { $Febend=28; }
   
   $Monat[0] =  [ "Januar",    Form::Zeit("01.01.$Vorjahr"), Form::Zeit("31.01.$Vorjahr") ]; 
   $Monat[1] =  [ "Februar",   Form::Zeit("01.02.$Vorjahr"), Form::Zeit("$Vorfebend.02.$Vorjahr") ]; 
   $Monat[2] =  [ "M&auml;rz", Form::Zeit("01.03.$Vorjahr"), Form::Zeit("31.03.$Vorjahr") ];
   $Monat[3] =  [ "April",     Form::Zeit("01.04.$Vorjahr"), Form::Zeit("30.04.$Vorjahr") ];
   $Monat[4] =  [ "Mai",       Form::Zeit("01.05.$Vorjahr"), Form::Zeit("31.05.$Vorjahr") ];
   $Monat[5] =  [ "Juni",      Form::Zeit("01.06.$Vorjahr"), Form::Zeit("30.06.$Vorjahr") ];
   $Monat[6] =  [ "Juli",      Form::Zeit("01.07.$Vorjahr"), Form::Zeit("31.07.$Vorjahr") ];
   $Monat[7] =  [ "August",    Form::Zeit("01.08.$Vorjahr"), Form::Zeit("31.08.$Vorjahr") ];
   $Monat[8] =  [ "September", Form::Zeit("01.09.$Vorjahr"), Form::Zeit("30.09.$Vorjahr") ];
   $Monat[9] =  [ "Oktober",   Form::Zeit("01.10.$Vorjahr"), Form::Zeit("31.10.$Vorjahr") ];
   $Monat[10] = [ "November",  Form::Zeit("01.11.$Vorjahr"), Form::Zeit("30.11.$Vorjahr") ];
   $Monat[11] = [ "Dezember",  Form::Zeit("01.12.$Vorjahr"), Form::Zeit("31.12.$Vorjahr") ];
   $Monat[12] =  [ "Januar",    Form::Zeit("01.01.$Jahr"), Form::Zeit("31.01.$Jahr") ]; 
   $Monat[13] =  [ "Februar",   Form::Zeit("01.02.$Jahr"), Form::Zeit("$Febend.02.$Jahr") ]; 
   $Monat[14] =  [ "M&auml;rz", Form::Zeit("01.03.$Jahr"), Form::Zeit("31.03.$Jahr") ];
   $Monat[15] =  [ "April",     Form::Zeit("01.04.$Jahr"), Form::Zeit("30.04.$Jahr") ];
   $Monat[16] =  [ "Mai",       Form::Zeit("01.05.$Jahr"), Form::Zeit("31.05.$Jahr") ];
   $Monat[17] =  [ "Juni",      Form::Zeit("01.06.$Jahr"), Form::Zeit("30.06.$Jahr") ];
   $Monat[18] =  [ "Juli",      Form::Zeit("01.07.$Jahr"), Form::Zeit("31.07.$Jahr") ];
   $Monat[19] =  [ "August",    Form::Zeit("01.08.$Jahr"), Form::Zeit("31.08.$Jahr") ];
   $Monat[20] =  [ "September", Form::Zeit("01.09.$Jahr"), Form::Zeit("30.09.$Jahr") ];
   $Monat[21] =  [ "Oktober",   Form::Zeit("01.10.$Jahr"), Form::Zeit("31.10.$Jahr") ];
   $Monat[22] = [ "November",  Form::Zeit("01.11.$Jahr"), Form::Zeit("30.11.$Jahr") ];
   $Monat[23] = [ "Dezember",  Form::Zeit("01.12.$Jahr"), Form::Zeit("31.12.$Jahr") ];

   my @Monate = qw(0#:#Januar&nbsp;Vorjahr&nbsp; 1#:#Februar&nbsp;Vorjahr&nbsp; 2#:#M&auml;rz&nbsp;Vorjahr&nbsp; 3#:#April&nbsp;Vorjahr&nbsp; 4#:#Mai&nbsp;Vorjahr&nbsp; 5#:#Juni&nbsp;Vorjahr&nbsp; 6#:#Juli&nbsp;Vorjahr&nbsp; 7#:#August&nbsp;Vorjahr&nbsp; 8#:#September&nbsp;Vorjahr&nbsp; 9#:#Oktober&nbsp;Vorjahr&nbsp; 10#:#November&nbsp;Vorjahr&nbsp; 11#:#Dezember&nbsp;Vorjahr&nbsp; 12#:#Januar&nbsp; 13#:#Februar&nbsp; 14#:#M&auml;rz&nbsp; 15#:#April&nbsp; 16#:#Mai&nbsp; 17#:#Juni&nbsp; 18#:#Juli&nbsp; 19#:#August&nbsp; 20#:#September&nbsp; 21#:#Oktober&nbsp; 22#:#November&nbsp; 23#:#Dezember&nbsp;);
   my $Vorjahr=$Jahr-1;
   foreach (@Monate) {
	  $_=~s/Vorjahr/$Vorjahr/;
	  $_=~s/Jahr/$Jahr/;
	  my $Welchermonat=$_;
	  $Welchermonat=~s/#\:#.+//g;
	  $_=~s/^\d+//g;
	  $_=$Monat[$Welchermonat][1].'-'.(($Monat[$Welchermonat][2])*1+86400).$_;	  
	  }
	  
   my @Wochen;
   # Ersten Sonntag im Jahr finden
   my $ErsterSonntag=(Form::Zeit("$Monatstag.$Monat.$Jahr")-$Wochentag*86400-Form::Zeit("01.01.$Jahr")) % (7*86400);
   my $kw;
   my $Sonntag=Form::Zeit("01.01.$Jahr")+$ErsterSonntag+86400;
   if( $ErsterSonntag<4*86400 ) {
	  $Wochen[0]=Form::Zeit("01.01.$Jahr")."-".$Sonntag."#:#52.&nbsp;KW&nbsp;ab&nbsp;01.01.".$Jahr; $kw=1; }
   else {
 	  $Wochen[0]=Form::Zeit("01.01.$Jahr")."-".$Sonntag."#:#01.&nbsp;KW&nbsp;ab&nbsp;01.01.".$Jahr; $kw=2; }
   my $Wzeit=0;
   for( my $x=1;$x<=52;$x++ ) {
	  my ($Sek, $Min, $Stu, $Mtag, $Mon, $J, $Wtag, $Jtag, $Szeit) = gmtime($Sonntag+3600);
	  $Mon+=1;
	  $Jtag+=1;
	  $J+=1900;
	  $Mon = $Mon < 10 ? $Mon = "0".$Mon : $Mon;
	  $Mtag = $Mtag < 10 ? $Mtag = "0".$Mtag : $Mtag;
          my $KW = $kw<10? "0".$kw : $kw; 
          if( $kw>52 ) {
		push(@Wochen, $Sonntag."-".Form::Zeit("31.12.$Jahr")."01.&nbsp;KW&nbsp;ab&nbsp;$Mtag.$Mon.$J"); }
	  else {
		push(@Wochen, $Sonntag."-".($Sonntag+7*86400)."#:#".$KW.".&nbsp;KW&nbsp;ab&nbsp;$Mtag.$Mon.$J"); }
	  $Sonntag=$Sonntag+7*86400;
	  $kw++;
	  }	  
   
   my @Jahre = (Form::Zeit("01.01.$Vorjahr")."-".(Form::Zeit("31.12.$Vorjahr")+86400)."#:#".$Vorjahr, Form::Zeit("01.01.$Jahr")."-".(Form::Zeit("31.12.$Jahr")+86400)."#:#".$Jahr);

   
   $Daten{"Arbeitszeit"}=$cgi->param("Arbeitszeit");
   
   # Vorgabe aktueller Monat, wenn keine Uebergabe:
   if( length($Daten{"Arbeitszeit"})<1 ) {
	$Daten{"Arbeitszeit"} = $Monat[($Monat)*1+11][1]."-".(($Monat[($Monat)*1+11][2])*1+86400); 
	}
   
   #Fuer Beitragsbemessungsgrenzen	
   $Daten{"Arbeitsbeginn"} = (Form::Zeit($Daten{"Aeintritt"}) > Form::Zeit("01.01.$Jahr"))? Form::Zeit($Daten{"Aeintritt"}) : Form::Zeit("01.01.$Jahr");

   #Abrechnungsperiode waehlen
   my $Zeit = $Daten{"Arbeitszeit"};
   my @Zeiten=split(/-/,$Zeit);
   my $Zeigedatum="display:none"; my $Zeigewoche="display:none"; my $Zeigemonat="display:none"; my $Zeigejahr="display:none";
   if( $Zeiten[1]*1-$Zeiten[0]*1 <= 86400 ) { $Zeigedatum="display:inline"; }
   elsif( $Zeiten[1]-$Zeiten[0] <= 608400 ) { $Zeigewoche="display:inline"; }
   elsif ( $Zeiten[1]-$Zeiten[0] >= (86400*365) ) { $Zeigejahr="display:inline"; }
   else { $Zeigemonat="display:inline"; }
   $Daten{"datumHTML"}='<span id="zeigedatum" style="'.$Zeigedatum.'"><input type="text" name="Arbeitsdatum" size="10" maxlength="10" value="'.$Daten{"Arbeitsdatum"}.'" onChange="javascript:datum(this.name,0,0);zeitnahme(this.name);createfilename();submit();" /></span>';
   $Daten{"wocheHTML"}='<span id="zeigewoche" style="'.$Zeigewoche.'">'.Form::Ausklappmenue(\@Wochen, "Arbeitswoche", $Zeit, "53", "150", "150", 'onChange="javascript:zeitnahme(this.name);createfilename();submit();"').'</span>';
   $Daten{"monatHTML"}='<span id="zeigemonat" style="'.$Zeigemonat.'">'.Form::Ausklappmenue(\@Monate, "Arbeitsmonat", $Zeit, "50", "150", "150", 'onChange="javascript:zeitnahme(this.name);createfilename();submit();"' ).'</span>';
   $Daten{"jahrHTML"}='<span id="zeigejahr" style="'.$Zeigejahr.'">'.Form::Ausklappmenue(\@Jahre, "Arbeitsjahr", $Zeit, "50", "150", "150", 'onChange="javascript:zeitnahme(this.name);createfilename();submit();"').'</span>';

   #Sozialversicherungsdaten einlesen 
   my $Auswahljahr = $Jahr;
   my @Auswahlzeit = split(/-/, $Daten{"Arbeitszeit"});
   my %SVDaten;
   if( $Auswahlzeit[0]<Form::Zeit("01.01.$Jahr") ) {
	  $Auswahljahr=$Vorjahr; }
   if(-e "../data/sozialversicherungsdaten_$Auswahljahr.cfg" ) {
	%SVDaten = %{Form::Auslesen_Spiegel("../data/sozialversicherungsdaten_$Auswahljahr.cfg", "", "")};
	foreach (keys(%SVDaten)) {
		$Daten{$_}=$SVDaten{$_}; }
	}
   else {
   #Falls Sozialversicherungsdaten noch in erster Lohnsteuerberechnung fehlen
	my @SVDaten = qw( RVmaxwest RVmaxost KVmax AGrvquot AGrvminiquot AGrvminihnquot ANrvquot AGkvermquot AGkvquot AGkvminiquot AGkvminihnquot ANpvermquot ANkvquot ANkvermquot AGpvquot AGpverhquot ANpvquot ANpverhquot ANpvzusatzquot STPminiquot RVmin SVazubimin KFaktor );
	foreach(@SVDaten) {
		if( length($Daten{$_})<1 ) { $Daten{$_}=0; }
		}
	if( length($Daten{"KVbezug"})<1 ) { $Daten{"KVbezug"}=3000; }
	if( length($Daten{"SVGleitfaktor"})<1 ) { $Daten{"SVGleitfaktor"}=0.75; }
	}

   #Angestelltendaten einlesen
   my %Adresse=%{Form::Auslesen_Spiegel("../$verzeichnis/$partei/data/adresse.cfg", "", "")};
   foreach (keys(%Adresse)) {
	$Daten{$_}=$Adresse{$_}; }
   
   #Kinderfreibetraege
   $Daten{"ZKF"}=($Daten{"Azkf"})? $Daten{"Azkf"} : "0.0";
 
   #in diesem Monat schon Zusatzbeitrag PV?
   $Daten{"Apvz"}="0,00"; #fuer Gehaltszettel
   my @Geburtsdatum=split(/\./, $Daten{"Ageboren"});
   $Geburtsdatum[1]++;
   $Geburtsdatum[2]+=23;
   my @Startarbeit=split(/-/, $Daten{"Arbeitszeit"});
   if( Form::Zeit("01.$Geburtsdatum[1].$Geburtsdatum[2]" ) <= $Startarbeit[0] && $Daten{"Akinder"} ne "1" ) {
	$Daten{"PVZ"} = "checked";
	$Daten{"Apvz"} = $Daten{"ANpvzusatzquotEUR"}; #aus Sozialversicherungsdaten
	}

   #in diesem Jahr schon Rentner?
   $Geburtsdatum[2]+=42;
   $Daten{"rentnershow"} = ( Form::Zeit("01.01.$Geburtsdatum[2]" ) <= $Startarbeit[0] )?  "table-row" : "none";
  
   #Rentenbeginn
   my @Rentenjahr;
   foreach( my $x=$Vorjahr;$x<=$Jahr;$x++ ) {
        push(@Rentenjahr, "$x#:#$x");
        }
   my $Auswahl=$Daten{"AJAHR"};
   if( length($Auswahl)<1 ) { $Auswahl= $Jahr+1; }
   $Daten{"AngestinRente"}=Form::Ausklappmenue(\@Rentenjahr, "AJAHR", $Auswahl, "", 100, 100, "");


   #Umlagefaktoren der Versicherung einlesen
   my $Versicherung=$Adresse{"Aversicherungsname"};
	$Versicherung =~ s/[\.\,-\s\/\/ ]//g;                    # Hilfszeichen entfernen: 
	$Versicherung =~ s/&minus;//g;                           # Bindestrich entfernen
	$Versicherung =~ s/&#8260;//g;                           # Schraegstrich entfernen
	$Versicherung =~ s/&frasl;//g;                           # Schraegstrich entfernen
	$Versicherung =~ s/&nbsp;//g;                            # Leerzeichen entfernen: 
	$Versicherung =  lc($Versicherung);                      # Standardnamen erzeuten atalanö 

	$Versicherung=Form::html2utf8(encode("utf8", $Versicherung));
	my %Umlage=%{Form::Auslesen_Spiegel("../insurance/$Versicherung/adresse.cfg", "P", "")};
   foreach (keys(%Umlage)) {
	$Daten{$_}=$Umlage{$_}; }

   #Auswahlmenue Sonstige Bezuege
   my @Sonstige = qw( L00#:# 
		      P30#:#30%&nbsp;Pauschalsteuer&nbsp;Sachbez&uuml;ge 
		      P25#:#25%&nbsp;Pauschalsteuer&nbsp;Verpflegungsmehraufwandpauschalen
		      P26#:#25%&nbsp;Pauschalsteuer&nbsp;Saisonkr&auml;fte&nbsp;&le;&nbsp;18&nbsp;Tage
		      P15#:#15%&nbsp;Pauschalsteuer&nbsp;Fahrtkostenzuschuss
		      P00#:#0%&nbsp;Pauschalsteuer&nbsp;Geschenke&nbsp;&le;&nbsp;44&nbsp;&euro;/Monat
		      P05#:#&nbsp;5%&nbsp;Pauschalsteuer&nbsp;Saisonkr&auml;fte&nbsp;i.d.&nbsp;Landwirtschaft
		      S01#:#S&#058;&nbsp;Sonntags-/Nacht-/Feiertagszuschl&auml;ge&nbsp;zu&nbsp;Lohn&nbsp;&le;&nbsp;50&nbsp;&euro;/&nbsp;h
		      S00#:#S&#058;&nbsp;Sonntags-/Nacht-/Feiertagszuschl&auml;ge&nbsp;zu&nbsp;Lohn&nbsp;&le;&nbsp;25&nbsp;&euro;/&nbsp;h
		      E01#:#E&#058;&nbsp;Weihnachtsgratifikation&nbsp;&#040;13./14.&nbsp;Gehalt&#041;
		      E02#:#E&#058;&nbsp;frw.&nbsp;Urlaubsgeld&nbsp;zggl.&nbsp;zum&nbsp;lfd.&nbsp;Urlaubsentgelt 
		      E03#:#E&#058;&nbsp;Urlaubsentsch&auml;digung&nbsp;bei&nbsp;Vers&auml;umnis/Austritt
		      E04#:#E&#058;&nbsp;Tantiemen
		      E05#:#E&#058;&nbsp;Abfindung/Aussch&uuml;ttung&nbsp;f&uuml;&nbsp;lfd.&nbsp;Jahr
		      E06#:#E&#058;&nbsp;Sterbegeld
		      E07#:#E&#058;&nbsp;Sonstige&nbsp;Einmalzahlung&nbsp;bei&nbsp;Versorgungsbeginn&nbsp;&#040;nur&nbsp;f&uuml;&nbsp;lfd.&nbsp;Jahr&#041;
		      M01#:#M&#058;&nbsp;Jubil&auml;umszuwendungen
		      M02#:#M&#058;&nbsp;Verg&uuml;tungen&nbsp;f&uuml;r&nbsp;Erfindungen
		      M03#:#M&#058;&nbsp;Einmalige&nbsp;Entsch&auml;digung/Verg&uuml;tung
		      M04#:#M&#058;&nbsp;Versorgungsabfindung&nbsp;f&uuml;&nbsp;mehrere&nbsp;Jahre
		      M05#:#M&#058;&nbsp;Sonstige Abfindung/Aussch&uuml;ttung&nbsp;f&uuml;&nbsp;mehrere&nbsp;Jahre
		      M06#:#M&#058;&nbsp;Nachzahlungen&nbsp;f&uuml;r&nbsp;Vorjahreszeitraum
		      M07#:#M&#058;&nbsp;Vorauszahlungen&nbsp;f&uumlr;&nbsp;Folgejahr );
   
   #Einnahmezuordnung
   my @steuer = qw( L#:#L 0#:# P#:#P E#:#E S#:#S M#:#M V#:#V ); # Steuer
   my @abgabe = qw( L#:#L 0#:# P#:#P E#:#E S#:#S V#:#V R#:#R ); # Abgaben
   my @zkasse = qw( 0#:# Z#:#Z ); # ZVK
   my @Zuordnung = ([@steuer],[@abgabe],[@zkasse]);
   
   for(my $x=0;$x<10;$x++ ) {
	for(my $y=0;$y<3;$y++ ) {
		$Auswahl = $Daten{"Liste".$x."_".$y};
		if( ($Daten{"Amini"} || $Daten{"Abeitragsschluessel"} =~m/^6/) && $y<2 ) {
			$Auswahl="P"; } # Rest erledigt Javascript blur: Hidden Pauschale auf 2%, bzw. jahresaktuellen Wert setzen und Pauschalsteuerzeile anzeigen. 
		my @Ordnung = @{$Zuordnung[$y]};
		$Daten{"zeigListe".$x."_".$y}=Form::Ausklappmenue(\@Ordnung, "Liste".$x."_".$y, $Auswahl, 10, 30, 30, 'onChange="javascript:kalk();lst2013t();sv();"' );
		}
	}
	
   # hier kein Zeitwechsel von UTC auf MSZ, weil Form::Zeit keine Sommerzeit kennt, auch wenn Wiederholungstermine in lokaler Zeit eingetragen werden
   my ($Sek, $Min, $Stu, $Mtag, $Mon, $J, $Wtag, $Jtag, $Szeit) = gmtime($Zeiten[0]+3600);

   my %Wochenstart;
   my $x=1;
   foreach my $Tag (@Wochentage) {
	$Wochenstart{$Tag} = $Zeiten[0] - ($Wtag-$x)*(86400);
	$x++;
	}
   my %Zeiten;
   my $Kategorie;
   my $Lesen=1;
   my $Gefunden=0;
   my $Regel=0;
   my $Wochentag;
   my $Regelend;
   my @Exdates="";
   my $Startzeit;
   my $Startdatum;
   my $Rstartzeit;
   my $Endzeit;
   my $Rendzeit;
   my %Arbeitstag;
   my %Versicherungstag;
   my @Arbeitszeiten = @{Form::Auslesen("../$verzeichnis/$partei/arbeitszeiten.ics")};
   foreach my $Zeile (@Arbeitszeiten) {
        if( $Zeile =~ m/BEGIN\:VEVENT/ ) { $Lesen++; }
	
	#CATEGORIES:Bueroarbeiten (An-/Ablegen von Akten)
	if( $Zeile =~ m/CATEGORIES/ ) {
		$Gefunden=$Lesen;
	        $Zeile =~ s/CATEGORIES\://g;
	        $Zeile =~ s/\n//g;
		$Kategorie=$Zeile;
		}

	#RRULE:FREQ=WEEKLY;UNTIL=20131001T133000Z;BYDAY=WE
	if( $Zeile =~ m/FREQ=WEEKLY;/ && $Lesen==$Gefunden ) {
		$Regel=1;
		$Wochentag=$Zeile;
		$Wochentag=~s/^.+BYDAY\=//g;
		$Wochentag=~s/[\s\n]//g;
		if( $Zeile =~ m/UNTIL/ ) {
			$Zeile =~s /.+\UNTIL=//g;
			$Zeile =~s /;BYDAY=\w\w//g;
			$Zeile =~s /\n//g;
			#20131001T133000Z
			$Regelend=Form::Zeit(substr($Zeile,6,2).".".substr($Zeile,4,2).".".substr($Zeile,0,4))+3600*substr($Zeile,9,2)+60*substr($Zeile,11,2);
			}
		else {  #Ende: 31.12.2037
		        $Regelend=2145897900; }
		}
	#EXDATE;VALUE=DATE:20130918
	elsif( $Zeile =~ m/EXDATE\;/ && $Lesen==$Gefunden ) {# Liste mit Ausnahmedaten zu diesem Wiederholungstermin
			$Zeile =~s /\D//g;
			push(@Exdates, Form::Zeit(substr($Zeile,6,2).".".substr($Zeile,4,2).".".substr($Zeile,0,4)) );  
			}
	elsif( $Zeile =~ m/END\:VEVENT/ && $Lesen==$Gefunden ) { #Ergebnisse speichern
		if( $Regel>0 ) { #Wiederholungstermin 
			if( $Regelend>$Zeiten[0] ) { 
				while( $Wochenstart{$Wochentag}<$Zeiten[0] || $Wochenstart{$Wochentag}<$Startdatum ) { $Wochenstart{$Wochentag}+=(86400*7); } #je eine Woche vorruecken
				while( $Wochenstart{$Wochentag} >= $Zeiten[0]  && $Wochenstart{$Wochentag} < $Zeiten[1] && $Wochenstart{$Wochentag} < $Regelend ) { 
					$Daten{"Protokoll1"}.=$Wochentag.":".$Wochenstart{$Wochentag}."-".gmtime($Wochenstart{$Wochentag}+3600+$Rstartzeit)."&nbsp";
					my $gesperrt=0; 
				        foreach(@Exdates) { # Ausnahmedaten zu Wiederholungstermin
						if(  $Wochenstart{$Wochentag} == $_ ) { $gesperrt=1; $Daten{"Protokoll1"}.="geblockt<br>"; }
				                }
					unless($gesperrt>0) { 
						$Zeiten{$Kategorie}+=($Rendzeit-$Rstartzeit); 
						$Arbeitstag{Form::Zeigezeit($Wochenstart{$Wochentag}+3600)}=$Kategorie;
						unless( $Kategorie=~m/fehlt/ ) { $Versicherungstag{Form::Zeigezeit($Wochenstart{$Wochentag}+3600)}=$Kategorie; }
						$Daten{"Protokoll1"}.="gebucht zu &quot;".Form::utf82html($Kategorie)."&quot; mit ".(($Rendzeit-$Rstartzeit)/3600)."h <br>"; }
					$Wochenstart{$Wochentag}+=(86400*7); }
					}
			}
		else { #Einzeltermin
			if( $Startzeit >= $Zeiten[0] && $Endzeit <= $Zeiten[1] ) {
				$Zeiten{$Kategorie}+=($Endzeit-$Startzeit); 
				$Arbeitstag{Form::Zeigezeit($Startzeit)}=$Kategorie;
				unless( $Kategorie=~m/fehlt/ ) { $Versicherungstag{Form::Zeigezeit($Startzeit)}=$Kategorie; }
				$Daten{"Protokoll2"}.=$Startzeit."-".gmtime($Startzeit+3600)."&nbsp;gebucht zu &quot;".Form::utf82html($Kategorie)."&quot; mit ".(($Endzeit-$Startzeit)/3600)."h<br>";
				}
			}
		$Regel=0;@Exdates="";
	        }
	
	# DTSTART;TZID=Europe/Berlin:20131011T163000
	if( $Zeile =~ m/DTSTART;/ && $Lesen==$Gefunden ) {
		$Zeile =~s /.+\://g;
		$Zeile =~s /\n//g;
		# 20131011T163000
		$Startzeit=Form::Zeit(substr($Zeile,6,2).".".substr($Zeile,4,2).".".substr($Zeile,0,4))+3600*substr($Zeile,9,2)+60*substr($Zeile,11,2)+substr($Zeile,13,2);
		$Startdatum=Form::Zeit(substr($Zeile,6,2).".".substr($Zeile,4,2).".".substr($Zeile,0,4));
		$Rstartzeit=3600*substr($Zeile,9,2)+60*substr($Zeile,11,2)+substr($Zeile,13,2);
		}
	# DTEND;TZID=Europe/Berlin:20131011T183000
	if( $Zeile =~ m/DTEND;/ && $Lesen==$Gefunden ) {
		$Zeile =~s /.+\://g;
		$Zeile =~s /\n//g;
		$Endzeit=Form::Zeit(substr($Zeile,6,2).".".substr($Zeile,4,2).".".substr($Zeile,0,4))+3600*substr($Zeile,9,2)+60*substr($Zeile,11,2)+substr($Zeile,13,2);
		$Rendzeit=3600*substr($Zeile,9,2)+60*substr($Zeile,11,2)+substr($Zeile,13,2);
		}
        }

   #Zeiten zusammenfassen fuer Gehaltszettel
   $Daten{"Ausf"}=0; $Daten{"Soll"}=0; $Daten{"Ueb"}=0; $Daten{"Ist"}=0;
   foreach my $kat (keys(%Zeiten)) {
	if( $kat=~m/fehlt/ || $kat=~m/krank/ ) { 
		$Daten{"Ausf"}+=$Zeiten{"$kat"}*1/3600; 
	        $Daten{"Soll"}+=$Zeiten{"$kat"}*1/3600; }
	elsif( $kat=~m/&Uuml;berstunden/ ) { 
		$Daten{"Ueb"}+=$Zeiten{"$kat"}*1/3600; }
	else {	$Daten{"Ist"}+=$Zeiten{"$kat"}*1/3600; 
	        $Daten{"Soll"}+=$Zeiten{"$kat"}*1/3600; }
	}
   $Daten{"Ausf"}=Form::Zeigezahl($Daten{"Ausf"},1);
   $Daten{"Soll"}=Form::Zeigezahl($Daten{"Soll"},1);
   $Daten{"Ueb"}=Form::Zeigezahl($Daten{"Ueb"},1);
   $Daten{"Ist"}=Form::Zeigezahl($Daten{"Ist"},1);
   
   
   
   my $x=0;
   my @TABELLE="";
   # Kalendereintraege nach Arbeitszeitlaenge jeder Kategorie absteigend sortieren
   my @Tabellenzeiten;
   foreach (keys(%Zeiten)) {
        #119700->0000119700
        while( length($Zeiten{$_})<10 ) { $Zeiten{$_}="0".$Zeiten{$_}; }
        push(@Tabellenzeiten, $Zeiten{$_}."#:#".$_);
        }
   @Tabellenzeiten = reverse(sort(@Tabellenzeiten));
   # Kalendereintraege in Liste fuellen
   foreach (@Tabellenzeiten) {
   
                my @Z = split(/#:#/, $_);
		$Z[0] = int($Z[0]*100 / 3600)/100;
		
		unless( $Z[1]=~m/fehlt/ ) {
		push(@TABELLE, '<TR>
			<TD WIDTH=5% CLASS="grund">
				<INPUT TYPE=TEXT NAME="ListeA'.$x.'" VALUE="°ListeA'.$x.'" SIZE=1 MAXSIZE=3 STYLE="text-align:center" onChange="javascript:zahl(this.name,0);">
			</TD>
			<TD WIDTH=30% CLASS="grund">
				<INPUT TYPE=TEXT NAME="ListeB'.$x.'"  VALUE="'.Form::utf82html($Z[1]).'" SIZE=37 MAXSIZE=45 STYLE="text-align:left" >
				<INPUT TYPE=HIDDEN NAME="Pauschale'.$x.'"  VALUE="°Pauschale'.$x.'" SIZE=5 >
			</TD>
			<TD WIDTH=20% CLASS="grund" STYLE="text-align:center">
				  '.$Daten{"zeigListe".$x."_0"}.'
				  '.$Daten{"zeigListe".$x."_1"}.'
				  '.$Daten{"zeigListe".$x."_2"}.'
			</TD>
			<TD WIDTH=10% CLASS="grund">
				<INPUT TYPE=TEXT NAME="LISTED'.$x.'EUR"  VALUE="'.Form::Zeigezahl($Z[0],2).'" SIZE=5 MAXSIZE=7 STYLE="text-align:right" onChange="javascript:adjust(this.name,1);kalk(this.name);lst2013t();sv()">h
				<INPUT TYPE=HIDDEN NAME="LISTED'.$x.'" VALUE="'.$Z[0].'">
			</TD>
			<TD WIDTH=10% CLASS="grund">
				<INPUT TYPE=TEXT NAME="LISTEE'.$x.'EUR" VALUE="°LISTEE'.$x.'EUR" SIZE=5 MAXSIZE=10 STYLE="text-align:right" onChange="javascript:adjust(this.name,2);kalk(this.name);lst2013t();sv()">&euro;
				<INPUT TYPE=HIDDEN NAME="LISTEE'.$x.'" VALUE="°LISTEE'.$x.'">
			</TD>
			<TD WIDTH=10% CLASS="grund">
				<INPUT TYPE=TEXT NAME="LISTEF'.$x.'EUR" VALUE="°LISTEF'.$x.'EUR" SIZE=5 MAXSIZE=10 STYLE="text-align:right;color:red" onChange="javascript:adjust(this.name,2);kalk(this.name);lst2013t();sv()">&euro;
				<INPUT TYPE=HIDDEN NAME="LISTEF'.$x.'" VALUE="°LISTEF'.$x.'">
			</TD>
			<TD WIDTH=15% CLASS="grund">
				<INPUT TYPE=TEXT NAME="LISTEG'.$x.'EUR" VALUE="°LISTEG'.$x.'EUR" SIZE=10 MAXSIZE=15 STYLE="text-align:right" onChange="javascript:adjust(this.name,2);kalk(this.name);lst2013t();sv()">&euro;
				<INPUT TYPE=HIDDEN NAME="LISTEG'.$x.'" VALUE="°LISTEG'.$x.'">
			</TD>
		</TR>
		');
		$x++;
		}
	}
   for(my $y=$x;$y<10;$y++ ) {
		$Auswahl=$Daten{"Sonstige_$y"};
		$Daten{"SonstigeBezuege_$y"}=Form::Ausklappmenue(\@Sonstige, "Sonstige_$y", $Auswahl, "", 30, 120, 'onClick="javascript:sonstige(this.name,'.$y.')"');
		push(@TABELLE, '<TR>
			<TD WIDTH=5% CLASS="grund">
				<INPUT TYPE=TEXT NAME="ListeA'.$y.'" VALUE="°ListeA'.$y.'" SIZE=1 MAXSIZE=3 STYLE="text-align:center" onChange="javascript:zahl(this.name,0);">
			</TD>
			<TD WIDTH=30% CLASS="grund">
				'.$Daten{"SonstigeBezuege_$y"}.'
				<INPUT TYPE=TEXT NAME="ListepubB'.$y.'" VALUE="°ListepubB'.$y.'" SIZE=18 MAXSIZE=35 STYLE="text-align:left" onChange=javascript:sonstige("Sonstige_'.$y.'",'.$y.');>
				<INPUT TYPE=HIDDEN NAME="ListeB'.$y.'" VALUE="°ListeB'.$y.'" SIZE=37 STYLE="text-align:left">
				<INPUT TYPE=HIDDEN NAME="Pauschale'.$y.'"  VALUE="°Pauschale'.$y.'" SIZE=5 >
			</TD>
			<TD WIDTH=20% CLASS="grund" STYLE="text-align:center">
				  '.$Daten{"zeigListe".$y."_0"}.'
				  '.$Daten{"zeigListe".$y."_1"}.'
				  '.$Daten{"zeigListe".$y."_2"}.'
			</TD>
			<TD WIDTH=10% CLASS="grund">
				<INPUT TYPE=TEXT NAME="LISTED'.$y.'EUR" VALUE="°LISTED'.$y.'EUR" SIZE=5 MAXSIZE=7 STYLE="text-align:right" onChange="javascript:adjust(this.name,1);kalk(this.name);lst2013t();sv()">h
				<INPUT TYPE=HIDDEN NAME="LISTED'.$y.'" VALUE="°LISTED'.$y.'">
			</TD>
			<TD WIDTH=10% CLASS="grund">
				<INPUT TYPE=TEXT NAME="LISTEE'.$y.'EUR" VALUE="°LISTEE'.$y.'EUR" SIZE=5 MAXSIZE=10 STYLE="text-align:right" onChange="javascript:adjust(this.name,2);kalk(this.name);lst2013t();sv()">&euro;
				<INPUT TYPE=HIDDEN NAME="LISTEE'.$y.'" VALUE="°LISTEE'.$y.'">
			</TD>
			<TD WIDTH=10% CLASS="grund">
				<INPUT TYPE=TEXT NAME="LISTEF'.$y.'EUR" VALUE="°LISTEF'.$y.'EUR" SIZE=5 MAXSIZE=10 STYLE="text-align:right;color:red" onChange="javascript:adjust(this.name,2);kalk(this.name);lst2013t();sv()">&euro;
				<INPUT TYPE=HIDDEN NAME="LISTEF'.$y.'" VALUE="°LISTEF'.$y.'">
			</TD>
			<TD WIDTH=15% CLASS="grund">
				<INPUT TYPE=TEXT NAME="LISTEG'.$y.'EUR" VALUE="°LISTEG'.$y.'EUR" SIZE=10 MAXSIZE=15 STYLE="text-align:right" onChange="javascript:adjust(this.name,2);kalk(this.name);lst2013t();sv()">&euro;
				<INPUT TYPE=HIDDEN NAME="LISTEG'.$y.'" VALUE="°LISTEG'.$y.'">
			</TD>
		</TR>
		');
	}
   $Daten{"AngestTabelle"}=join(/\n/,@TABELLE);	
   
   # Steuertage und Arbeitstage
   $Daten{"STag"} = (int(($Zeiten[1]-$Zeiten[0])/86400)>30)? 30 : int(($Zeiten[1]-$Zeiten[0])/86400);
   $Daten{"ATag"} = keys(%Arbeitstag);
   $Daten{"VTag"} = keys(%Versicherungstag);
 	
   #Steuerklasse
   my @SKL = qw( 1#:#I 2#:#II 3#:#III 4#:#IV 5#:#V 6#:#VI );
   my $Auswahl = $Daten{"Astkl"};
   $Daten{"AngestSteuerklasse"} = Form::Ausklappmenue(\@SKL, "STKL", $Auswahl, 20, 100, 100, "onChange=if(this.value==4)getElementsByName('faktorverfahren')[0].setAttribute('style','display:table-row',false);else{getElementsByName('faktorverfahren')[0].setAttribute('style','display:none',false);}lst2013t();");
   $Daten{"AngestSteuerklasse"} =~s/STKL1/STKL/g; # unbedingt Lohnsteuervariablen einhalten
 
   # Kirchensteuersaetze aus Sozialversicherungsdaten vorhaengen
   shift(@Laender);
   my $Auswahl=$Daten{"Abundesland"};
   $Daten{"ANksquot"}=$Daten{"ANksquot"};

   foreach my $wert (keys(%SVDaten)) {        
	if( $wert=~m/^KS/ && $wert!=~m/EUR$/ ) {
		my $satz=$Daten{$wert};
		$wert=~s/^KS//g;
		foreach (@Laender) {
			$_=~s/$wert#:#/$satz-$wert#:#/g; 
			}
		$Auswahl=~s/$wert/$satz-$wert/g;
		}
	}
   @Woerter=split("-",$Auswahl);
   $Daten{"ANksquot"}=$Woerter[0];
   $Daten{"ANksquotEUR"}=Form::Zeigezahl($Woerter[0],1);

   $Daten{"KirchenBundesland"}=Form::Ausklappmenue(\@Laender, "KSbundesland", $Auswahl, 20, 220, 220, 'onChange="javascript:sv()"' );

   #Rentenversicherungsart
   my @rv = qw( 0#:#bund 0#:#knappschaft 0#:#bw 0#:#by 1#:#bb 0#:#ns 0#:#he 1#:#sa 0#:#sh 0#:#nb 0#:#hb 0#:#rh 0#:#rp 0#:#sl 0#:#sb 0#:#wf 2#:#so );
   my $Auswahl;
   foreach (@rv) {
	@Woerter=split(/#:#/, $_);
	if( $Woerter[1] eq $Daten{"Arv"} ) {
	      $Auswahl=$Woerter[0]; }
	}
   my @RVart = qw(0#:#West 1#:#Ost 2#:#Sonstige);
   $Daten{"AngestRentenversicherungsart"}=Form::Ausklappmenue(\@RVart, "KRV", $Auswahl, 20, 100, 100, "");
   
   #Krankenversicherung
   my $Auswahl = $Daten{"PKV"};
   if( length($Daten{"PKV"})<1 ) {
	my @KValle = qw( Actimonda actimonda AOK Betriebs BKK Barmer Bergische BIG Continentale DAK DeBeKa Debeka DBK GEK Hanseatische HEAG Heimat HKK IKK KKH Knappsch Krankenkasse krankenkasse mhplus SKD SVLFG Techniker TK );
	foreach (@KValle) {
		if( $Daten{"Aversicherungsname"}=~m/$_/ ) {
			$Auswahl = 0; } # gesetzlich 
		}
	if( $Auswahl!=0 ) { $Auswahl = 2; }
        }   
   my @KV = qw( 0#:#gesetzlich 2#:#nur&nbsp;privat,&nbsp;mit&nbsp;AG&minus;Zuschuss 1#:#nur&nbsp;privat,&nbsp;ohne&nbsp;AG&minus;Zuschuss&nbsp;&lang;Ausnahme&rang; );
   $Daten{"AngestKrankenversicherungsart"}=Form::Ausklappmenue(\@KV, "PKV", $Auswahl, 20, 100, 100, q~onChange="javascript:if(this.value>=2){getElementById('zuschuss').setAttribute('style','display:inline',false);getElementsByName('kvpv')[0].value=32780;}else{getElementById('zuschuss').setAttribute('style','display:none',false);getElementsByName('kvpv')[0].value=0;}"~);
   
   #Reiligionszugehoerigkeit
   my @Reli = qw(0#:#keine&nbsp;Religionszugeh&ouml;rigkeit rk#:#r&ouml;misch&minus;katholisch ev#:#evangelisch lt#:#evangelisch&minus;lutherisch rf#:#evangelisch&minus;reformiert fr#:#franz&ouml;sisch&minus;reformiert ak#:#altkatholisch isnw#:#israelitisch&frasl;j&uuml;disch&nbsp;in&nbsp;NRW fa#:#freie&nbsp;Religionsgemeinschaft&nbsp;Alzey fb#:#freireligi&ouml;se&nbsp;Landesgemeinde&nbsp;Baden fm#:#freireligi&ouml;se&nbsp;Gemeinde&nbsp;Mainz fs#:#freireligi&ouml;se&nbsp;Gemeinde&nbsp;Offenbach ib#:#israelitische&nbsp;Religionsgemeinschaft&nbsp;Baden iw#:#israelitische&nbsp;Religionsgemeinschaft&nbsp;W&uuml;rttemberg isby#:#Verband&nbsp;d.&nbsp;israelitischen&nbsp;Kultusgemeinden&nbsp;Bayern jh#:#J&uuml;dische&nbsp;Gemeinde&nbsp;Hamburg ishe#:#J&uuml;dische&nbsp;Gemeinde&nbsp;Frankfurt&nbsp;&lang;HE&rang; il#:#J&uuml;dische&nbsp;Gemeinden&nbsp;Hessen isrp#:#J&uuml;dische&nbsp;Kultusgem.&nbsp;Bad&nbsp;Kreuznach&nbsp;und&nbsp;Koblenz&nbsp;&lang;RP&rang; isslp#:#israelitisch&nbsp;im&nbsp;Saarland);
   my $Auswahl=$Daten{"Areligion"};
   $Daten{"AngestReligion"}=Form::Ausklappmenue(\@Reli, "R", $Auswahl, 20, 220, 220, "");

   #Adresse bilden fuer Gehaltszettel
   my %Adresszeilen=%{Form::Adresszeilen(\%Adresse, "A")};
   foreach( keys(%Adresszeilen) ) {
	$Daten{$_}=$Adresszeilen{$_};
	}
	

   # Booleans fuellen
   $Daten{"Akinder"}=($Daten{"Akinder"})? "checked" : "";
   $Daten{"kindershow"}=($Daten{"Akinder"})? "table-row" : "none";
   $Daten{"Amini"}=($Daten{"Amini"})? "checked" : "";
   $Daten{"Aazubi"}=($Daten{"Aazubi"})? "checked" : "";
   $Daten{"Astudent"}=($Daten{"Astudent"})? "checked" : "";
   $Daten{"AF"}=($Daten{"Aaf"})? "checked" : "";
   $Daten{"F"}=$Daten{"Af"};
   $Daten{"PVS"}=($Daten{"Abundesland"}=="sn" || $Daten{"PVS"})? "checked" : "";
   $Daten{"VBEZEUR"}||="0,00";
   $Daten{"VBEZ"}||=0;
   
   $Daten{"Cpfile"} = Form::utf82html($partei);
   $Daten{"Akodiert"} = Form::html2uri(Form::utf82html($partei));
   
   $Daten{"Ueberschreiben"}="";
   #Alle Abrechnungen des Kalenderjahres bis vor dem Abrechnungsmonat aufaddieren und in Hidden-Feldern anbieten
   my @Abrechnungen=glob "../$verzeichnis/$partei/data/*-*.cfg";
   $Daten{"STgesamt"}=0; $Daten{"STegesamt"}=0; $Daten{"SVgesamt"}=0; $Daten{"SVegesamt"}=0;
   $Daten{"gesamtLSTLZZ"}=0; $Daten{"gesamtSTS"}=0; $Daten{"gesamtSOLZLZZ"}=0; $Daten{"gesamtANKS"}=0;	
   $Daten{"ANrvgesamt"}=0; $Daten{"ANavgesamt"}=0; $Daten{"ANkvgesamt"}=0; $Daten{"ANpvgesamt"}=0; $Daten{"AGulgesamt"}=0; $Daten{"AGzvgesamt"}=0;
   foreach (@Abrechnungen) {
        my $Datei = $_;
           $Datei =~s/.+\/data\///g;
           $Datei =~s/\.cfg//g;
        my @Altzeiten = split("-",$Datei);
        if( $Altzeiten[0]>=Form::Zeit("01.01.$Jahr") && $Altzeiten[1]<=$Zeiten[0] ) {
		my @SVDaten = grep(/^[A-Z1-9]+(brutto)?(einmal)?#\:#/,@{Form::Auslesen("$_")});
		my %Altdaten;
		foreach my $zeile (@SVDaten) {
			unless( $zeile=~m/EUR#\:#/ ) {
				@Woerter=split(/#\:#/, $zeile); $Woerter[1]=~s/\n//g;
				$Altdaten{$Woerter[0]}=$Woerter[1]; }
			}
		$Daten{"STgesamt"} += $Altdaten{"STbrutto"}*1;
		$Daten{"STegesamt"} += $Altdaten{"STeinmal"}*1;
		$Daten{"SVgesamt"} += $Altdaten{"SVbrutto"}*1;
		$Daten{"SVegesamt"} += $Altdaten{"SVeinmal"}*1;
	
		$Daten{"gesamtLSTLZZ"} += $Altdaten{"LSTLZZ"}*1;
		$Daten{"gesamtSTS"} += $Altdaten{"STS"}*1;
		$Daten{"gesamtSOLZLZZ"} += $Altdaten{"SOLZLZZ"}*1;
		$Daten{"gesamtANKS"} += $Altdaten{"ANKS"}*1;
	
		$Daten{"ANrvgesamt"} += $Altdaten{"ANRV"}*1;
		$Daten{"ANavgesamt"} += $Altdaten{"ANAV"}*1;
		$Daten{"ANkvgesamt"} += $Altdaten{"ANKV"}*1;
		$Daten{"ANpvgesamt"} += $Altdaten{"ANPV"}*1;
		$Daten{"AGulgesamt"} += $Altdaten{"AGU1"}*1 +$Altdaten{"AGU2"}*1 + $Altdaten{"AGU3"}*1;
		$Daten{"AGzvgesamt"} += $Altdaten{"AGZV"}*1;

		}
        elsif( $Altzeiten[1]>=$Zeiten[0] && $Altzeiten[0]<=$Zeiten[1] ) { #Abrechnungszeitraeume ueberschneiden sich
              $Daten{"Ueberschreiben"}.=$_."#:#";
              }
	}
   $Daten{"Ueberschreiben"}=~s/#\:#$//g;

#####################################################

   print "Pragma: no-cache\nContent-type: text/html\n\n";
   print @{Form::HTML("angestellterC", \%Daten)};
   #print $Daten{"Abundesland"}."<BR>";
   #foreach(keys (%Arbeitstag)) {
   #print Form::utf82html($_),"&nbsp;",$Arbeitstag{$_},"<br>"; }
   print $cgi->start_table({-width => '80%', -border => '0'}),
         $cgi->Tr($cgi->th({-align => 'left'}),
                 $cgi->td({-align => 'right'}, '<input type="button" value="Abrechnung anlegen" style="width:250px;height:30px;" onClick=javascript:getElement("name","stufe",0).value="4";document.angestellter.submit(); >')),
         $cgi->end_table();


   print $cgi->end_html;

   
############################################################################################
} elsif( $cgi->param("stufe")>=4 ) {
#############################################################################################

   #Datumseintraege abkuerzen fuer Gehaltszettel
   foreach (qw(Adatum Ageboren Aeintritt Aaustritt)) {
        @Woerter=split(/\D/,$Daten{$_});
	$Daten{$_}=($Daten{$_})? $Woerter[0].".".$Woerter[1].".".substr($Woerter[2],2,2) : "";
	}
   
   $Daten{"brutto"} = Form::Zeigezahl($Daten{"SVbrutto"},2);
   
   $Daten{"STsumme"} = Form::Zeigezahl(($Daten{"LSTLZZ"}+$Daten{"STS"}+$Daten{"SOLZLZZ"}+$Daten{"ANKS"})/100,2);
   
   $Daten{"STBRUTTO"} = Form::Zeigezahl($Daten{"STBRUTTO"},2);
   $Daten{"STGESAMT"} = Form::Zeigezahl(($Daten{"STgesamt"}+$Daten{"STegesamt"}+$Daten{"STbrutto"}+$Daten{"STeinmal"}),2);
   $Daten{"STEINMAL"} = Form::Zeigezahl(($Daten{"STegesamt"}+$Daten{"STeinmal"}),2);

   $Daten{"GESAMTLSTLZZ"} = Form::Zeigezahl(($Daten{"gesamtLSTLZZ"}+$Daten{"LSTLZZ"}),2);
   $Daten{"GESAMTSTS"} = Form::Zeigezahl(($Daten{"gesamtSTS"}+$Daten{"STS"}),2);
   $Daten{"GESAMTSOLZLZZ"} = Form::Zeigezahl(($Daten{"gesamtSOLZLZZ"}+$Daten{"SOLZLZZ"}),2);
   $Daten{"GESAMTANKS"} = Form::Zeigezahl(($Daten{"gesamtANKS"}+$Daten{"ANKS"}),2);
   $Daten{"STSUMME"} = Form::Zeigezahl(($Daten{"GESAMTLSTLZZ"}+$Daten{"GESAMTSTS"}+$Daten{"GESAMTSOLZLZZ"}+$Daten{"GESAMTANKS"}),2);

   
   $Daten{"SVsumme"} = Form::Zeigezahl(($Daten{"ANRV"}+$Daten{"ANAV"}+$Daten{"ANKV"}+$Daten{"ANPV"}+$Daten{"AGZV"})/100,2);
   
   $Daten{"SVBRUTTO"} = Form::Zeigezahl($Daten{"SVBRUTTO"},2);
   $Daten{"SVGESAMT"} = Form::Zeigezahl(($Daten{"SVgesamt"}+$Daten{"SVegesamt"}+$Daten{"SVbrutto"}+$Daten{"SVeinmal"}),2);
   $Daten{"SVEINMAL"} = Form::Zeigezahl(($Daten{"SVegesamt"}+$Daten{"SVeinmal"}),2);

   $Daten{"GESAMTANRV"} = Form::Zeigezahl(($Daten{"ANrvgesamt"}/100+$Daten{"ANRV"}/100),2);
   $Daten{"GESAMTANAV"} = Form::Zeigezahl(($Daten{"ANavgesamt"}/100+$Daten{"ANAV"}/100),2);
   $Daten{"GESAMTANKV"} = Form::Zeigezahl(($Daten{"ANkvgesamt"}/100+$Daten{"ANKV"}/100),2);
   $Daten{"GESAMTANPV"} = Form::Zeigezahl(($Daten{"ANpvgesamt"}/100+$Daten{"ANPV"}/100),2);
   $Daten{"GESAMTAGZV"} = Form::Zeigezahl(($Daten{"AGzvgesamt"}/100+$Daten{"AGZV"}/100),2);
   $Daten{"SVSUMME"} = Form::Zeigezahl((Form::Zahl($Daten{"GESAMTANRV"})+Form::Zahl($Daten{"GESAMTANAV"})+Form::Zahl($Daten{"GESAMTANKV"})+Form::Zahl($Daten{"GESAMTANPV"})+Form::Zahl($Daten{"GESAMTAGZV"})),2);
   
   $Daten{"netto"} = Form::Zeigezahl((Form::Zahl($Daten{"SVbrutto"}) - Form::Zahl($Daten{"STsumme"}) - Form::Zahl($Daten{"SVsumme"})),2);
   $Daten{"abzuege"}=0;
   for( my $k=1;$k<=10; $k++ ) {
	  $Daten{"abzuege"}+=$Daten{"LISTEF".$k}; }
   $Daten{"auszahl"} = Form::Zeigezahl((Form::Zahl($Daten{"netto"}) - Form::Zahl($Daten{"abzuege"})),2);
   $Daten{"abzuege"} = Form::Zeigezahl($Daten{"abzuege"},2);
   

   Form::Formular(\%Daten, "gehaltsabrechnung.odt");

   #Kodierten Filenamen fuer utf8-Umgebung aufloesen
   $Daten{"Zieldatei"}=Form::html2utf8($Daten{"Zieldatei"});
   $Daten{"Zielpfad"}=Form::html2utf8($Daten{"Zielpfad"});

   unless( $Daten{"Zieldatei"} =~ m/\.odt$/ ) {
	$Daten{"Zieldatei"}.=".odt";
	}
   my $Dateinahme=$Daten{"Zieldatei"};

   my $Ziel = $Daten{"Zielpfad"}."/".$Daten{"Zieldatei"};
   system("mv ../cgi-bin/tmp/gehaltsabrechnung.odt $Ziel | chmod 777 ../$Ziel");
   my $Datei = $Daten{"Zielpfad"}."/data/".Form::html2utf8($Daten{"Arbeitszeit"}).".cfg";
   Form::Speichern_Spiegel( \@Feldnamen, \%Daten, "$Datei", "[A-Z]");
   
   my $Url = Form::html2uri(Form::utf82html($Daten{"Zielpfad"}))."/".Form::utf82html($Daten{"Zieldatei"});
   $Daten{"Zieldatei"} = '<a href="'.$Url.'">'.Form::utf82html($Daten{"Zieldatei"}).'</a>';

   
   $Daten{"AARVEUR"} = Form::Zeigezahl(($Daten{"ANRV"}+$Daten{"AGRV"})/100,2);
   $Daten{"AAAVEUR"} = Form::Zeigezahl(($Daten{"ANAV"}+$Daten{"AGAV"})/100,2);
   $Daten{"AAKVEUR"} = Form::Zeigezahl(($Daten{"ANKV"}+$Daten{"AGKV"})/100,2);
   $Daten{"AAPVEUR"} = Form::Zeigezahl(($Daten{"ANPV"}+$Daten{"AGPV"})/100,2);
   if( $Daten{"SVgesamt"}*0.02<$Daten{"ANkvzusatz"} ) {
	  $Daten{"ANsolKVEUR"} = Form::Zeigezahl(($Daten{"ANKV"}/100-($Daten{"ANkvzusatz"}-$Daten{"SVgesamt"}*0.02)+$Daten{"AGKV"}/100),2); }
   else { $Daten{"ANsolKVEUR"} = $Daten{"AAKVEUR"}; }
   
   # Datumseingabe fuer Beitragsnachweis
   my @Zeiten = split(/&minus;/, $Daten{"Arbeitszeit"});
   $Daten{"Anfangsdatum"} = Form::Zeigezeit($Zeiten[0]);
   my $Hilfszeit=$Zeiten[1]-3601;
   $Daten{"Enddatum"} = Form::Zeigezeit(($Zeiten[1]-3601)); 
   
   # Rechtskreis fuer Beitragsnachweis (Berlin bleibt leer)
   my @West = qw ( bw by hb hh he ns nw rp sh sl );
   my @Ost  = qw ( bb mv sa sn th );
   $Daten{"West"}=""; $Daten{"Ost"}="";   
   foreach(@West) { if( $Daten{"KSbundesland1"}=~m/.+$_/ ) { $Daten{"West"}="checked"; } }
   foreach(@Ost ) { if( $Daten{"KSbundesland1"}=~m/.+$_/ ) { $Daten{"Ost"}="checked"; } }
   
   # Aufspaltung in Einzelzeilen fuer Beitragsnachweis
   $Daten{"AAKV".substr($Daten{"Abeitragsschluessel"},0,1)."EUR"} = $Daten{"AAKVEUR"};
   $Daten{"AAsolKV".substr($Daten{"Abeitragsschluessel"},0,1)."EUR"} = $Daten{"ANsolKVEUR"};
   $Daten{"AARV".substr($Daten{"Abeitragsschluessel"},1,1)."EUR"} = $Daten{"AARVEUR"};
   $Daten{"AAAV".substr($Daten{"Abeitragsschluessel"},2,1)."EUR"} = $Daten{"AAAVEUR"};
 
   open(DATEI, ">../cgi-bin/tmp/Beitragsnachweis.html") || die "Alter Beitragsnachweis kann nicht ueberschrieben werden:\n$!";
       print DATEI @{Form::HTML("Beitragsnachweis", \%Daten)};
   close(DATEI);
   $Daten{"Bnachweis"} = '<a href="../cgi-bin/tmp/Beitragsnachweis.html" target="_blank">Beitragsnachweis</a>';
 
#####################################################

   print $cgi->header(),
	     $cgi->start_html(-title =>'Lohnabrechnungsausgabe', -charset =>'utf8');
   print @{Form::HTML("angestellterD", \%Daten)};
   print $cgi->end_html;

############################################################################################
} 
#############################################################################################


sub From2Sort {
 if(ord(substr($a,1)) < ord(substr($b,1)))
  { return -1; }
 elsif(ord(substr($a,1)) == ord(substr($b,1)))
  { return 0; }
 else
  { return 1; }
}
