#!/usr/bin/perl -w 

   use Encode; # fuer OpenOffice - Konvertierung in UTF-8 

   use strict;
   use CGI;
   my $cgi = new CGI;
   use CGI::Carp qw(fatalsToBrowser);

   use lib "/home/hedele/lawsuit/cgi-bin/LS";
   use LS::Form;

   my @Feldnamen       = $cgi->param();                    # fuer Aufruf aus $Name_ac.html nur POST-Methode
   my %Daten;
   my $Datei = (length($ENV{QUERY_STRING})>0)? Form::html2utf8(encode("utf8",Form::noURI($cgi->param("Datei")))) :
		Form::html2utf8(encode("utf8",$cgi->param("Datei")));
   my $Css = ( $Datei =~ m/.+privat.+/ )? 'accountingP' : 'accountingG';    # Privat- oder Geschaeftskonto?
   my $Name = (length($ENV{QUERY_STRING})>0)? Form::html2utf8(encode("utf8",Form::noURI($cgi->param("Name")))) :
		Form::html2utf8(encode("utf8",$cgi->param("Name")));
   my @Zeile;
   my $Zeile;
   my @Zeilen;
   my @Woerter;
   my @return;

   # Formulardaten mit cgi-Modul (POST) ermitteln
   foreach my $Feld (@Feldnamen) {
      $Daten{$Feld}  = Form::utf82html(encode("utf8",$cgi->param($Feld)));
      # Uebertragungsfehler bei Hidden-Fields
      if( $Feld =~ m/hidden/ ) {
                $Daten{$Feld}  = $cgi->param($Feld); }
      $Daten{$Feld}  =~ s/&nbsp;/\40/g	 if defined $Daten{$Feld}; # Besonderheit fuer accounting -> keine &nbsp;
   }


################################################################################################################
## Eingabe #####################################################################################################
################################################################################################################


   my $checkbox = ( $Daten{"Ustinklusive"} )? "X" : "";

   @Zeile;
   # Fremdgelddaten
   if( $Daten{"komplex"} ) { 
	for(my $i=1;$i<=4;$i++) {
	    if( $Daten{"F".$i."betragEUR"} ) {
		$Zeile = $Daten{"Eingabenummer"}."#:#".$Daten{"Anzeigenummer"}."#:#".$Daten{"Datum"}."#:#".$Daten{"Belegnummer"}."#:#".$Daten{"Art"}."#:#".$Daten{"F".$i."konto"}."#:#".$Daten{"F".$i."hidden"}."#:#".$Daten{"Ftext"}."#:#".$Daten{"F".$i."betragEUR"}."#:##:#".$Daten{"F".$i."betragEUR"}."#:#".$Daten{"Gkonto"}."#:#".$Daten{"Ghidden"}."#:##:##:#"."#:#".$Daten{"Cprozessregister"}."\n";
		push(@Zeile, $Zeile);
		$Daten{"Eingabenummer"}++;
 	    }
	}
   }
   # Kerndaten
   $Daten{"Uhidden"} =~ s/Abziehbare Vorsteuer/VorSt./g;       # VorSt. abkuerzen
   $Daten{"Uhidden"} =~ s/Umsatzsteuer/UmSt./g;                # UmSt. abkuerzen
   if( !$Daten{"komplex"} or length($Daten{"BetragEUR"})>0 ) { # sofern komplex, nur neue Zeile, wenn Inhalt vorhanden
	$Zeile = $Daten{"Eingabenummer"}."#:#".$Daten{"Anzeigenummer"}."#:#".$Daten{"Datum"}."#:#".$Daten{"Belegnummer"}."#:#".$Daten{"Art"}."#:#".$Daten{"Ekonto"}."#:#".$Daten{"Ehidden"}."#:#".$Daten{"Buchungstext"}."#:#".$Daten{"BetragEUR"}."#:#".$checkbox."#:#".$Daten{"Betrag"}."#:#".$Daten{"Gkonto"}."#:#".$Daten{"Ghidden"}."#:#".$Daten{"Ukonto"}."#:#".$Daten{"Uhidden"}."#:#".$Daten{"UstEUR"}."#:#".$Daten{"Cprozessregister"}."\n";
	push(@Zeile, $Zeile);
	}
 
   # Zinsdaten
   if( $Daten{"komplex"} ) { 
	if( $Daten{"ZinsenEUR"} ) {
		$Daten{"Eingabenummer"}++;
   		$Zeile =  $Daten{"Eingabenummer"}."#:#".$Daten{"Anzeigenummer"}."#:#".$Daten{"Datum"}."#:#".$Daten{"Belegnummer"}."#:#".$Daten{"Art"}."#:#".$Daten{"Zkonto"}."#:#".$Daten{"Zhidden"}."#:#".$Daten{"Buchungstext"}."#:#".$Daten{"ZinsenEUR"}."#:##:#".$Daten{"ZinsenEUR"}."#:#".$Daten{"Gkonto"}."#:#".$Daten{"Ghidden"}."#:##:##:#"."#:#".$Daten{"Cprozessregister"}."\n";
		push(@Zeile, $Zeile);
	}
   }

   # Privatentnahme/-einlage - Geschaeftskontodaten auslesen und GZeile erzeugen
   my $Gzeile;
   my $Gdatei=$Datei;
      $Gdatei=~s/_privat//g;
   my $Privatart = ($Daten{"Art"} eq "A")? "180000#:#Privatentnahme allgemein" : "189000#:#Privateinlagen" ;
   if( $Daten{"privat"} ) { 
	my @Zeilen=@{Form::Auslesen("../data/$Gdatei")};
	$Gzeile=pop(@Zeilen);
	my @Listen=split(/#:#/, $Gzeile);
	$Gzeile =  ($Listen[0]+1)."#:#".($Listen[1]+1)."#:#".$Daten{"Datum"}."#:#".$Daten{"Belegnummer"}."#:#".$Daten{"Art"}."#:#".$Privatart."#:#".$Daten{"Buchungstext"}."#:#".$Daten{"BetragEUR"}."#:##:#".$Daten{"BetragEUR"}."#:#".$Daten{"Gkonto"}."#:#".$Daten{"Ghidden"}."#:##:##:#\n";
   }
   #############


   if( $cgi->param("Befehl")=~"Speichern" or $cgi->param("JSBefehl")=~"Speichern") {
	if ( -e "../data/$Datei" ) {
		open(DATEI, ">>../data/$Datei") || die "die Datei $Datei ist nicht vorhanden oder es fehlt die Schreibberechtigung in data:\n$!";
		     print DATEI @Zeile;
		close(DATEI);
	} else {
		open(DATEI, ">../data/$Datei") || die "die Datei $Datei ist nicht vorhanden oder es fehlt die Schreibberechtigung in data:\n$!";
		     print DATEI @Zeile;
		close(DATEI);
		chmod(0777, "../data/$Datei");
		#$Daten{"Reload"}="<script> parent.Liste.location.reload(); </script>";
	}
	if( $Daten{"privat"} ) { 
		if ( -e "../data/$Datei" ) {
			open(DATEI, ">>../data/$Gdatei") || die "die Datei $Datei ist nicht vorhanden oder es fehlt die Schreibberechtigung in data:\n$!";
			     print DATEI $Gzeile;
			close(DATEI);
		} else {
			open(DATEI, ">../data/$Gdatei") || die "die Datei $Datei ist nicht vorhanden oder es fehlt die Schreibberechtigung in data:\n$!";
			     print DATEI $Gzeile;
			close(DATEI);
			chmod(0777, "../data/$Gdatei");
		}
	}
   }

   my $Altezeile;
   my @AlteZeilen;
   if( $cgi->param("Befehl")=~"ndern" or $cgi->param("Befehl")=~"schen" ) {
	@AlteZeilen=@{Form::Auslesen("../data/$Datei")};
	my $x=0;
	my $y=-1;
	my $z=0;
	foreach $Altezeile (@AlteZeilen) {
		my @Listen = split (/#:#/, $Altezeile);
		if( $Listen[1] eq $cgi->param("Anzeigenummer") ) {
		    if( $y<0 ) { $y=$x; }                 # Start Ersetzungszeilen
		    $z++;                                 # Ende  Ersetzungszeilen
		}
		$x++;
	}
	if( $y>=0 ) {
		splice (@AlteZeilen,$y,$z);               # Zeile loeschen
		if ( $cgi->param("Befehl")=~"ndern" ) {
			splice(@AlteZeilen,$y,0,@Zeile);  # Zeile einfuegen
		}
	}
	open(DATEI, ">../data/$Datei") || die "die Datei $Datei ist nicht vorhanden oder es fehlt die Schreibberechtigung in data:\n$!";
	     print DATEI @AlteZeilen;
	close(DATEI);
	chmod(0777, "../data/$Datei");

	if( $Daten{"privat"} ) {
		@AlteZeilen=@{Form::Auslesen("../data/$Gdatei")};
		$y=-1;
		$z=0;
		my $Eingabenummer;
		my $Anzeigenummer;
		my @Listen;
		foreach $Altezeile (@AlteZeilen) {
			@Listen = split (/#:#/, $Altezeile);
			if( $Listen[2] eq $cgi->param("Datum") && $Listen[8] eq $cgi->param("BetragEUR") ) {
				$y=$z;
				$Eingabenummer=$Listen[0];
				$Anzeigenummer=$Listen[1];
			}
			$z++;
		}
		unless( $Anzeigenummer) {
				$Eingabenummer=$Listen[0];
				$Anzeigenummer=$Listen[1];
		}
		if( $y>=0 ) {   #gefunden
			if ( $cgi->param("Befehl")=~"ndern" ) {
				splice(@AlteZeilen,$y,1, $Eingabenummer."#:#".$Anzeigenummer."#:#".$Daten{"Datum"}."#:#".$Daten{"Belegnummer"}."#:#".$Daten{"Art"}."#:#".$Privatart."#:#".$Daten{"Buchungstext"}."#:#".$Daten{"BetragEUR"}."#:##:#".$Daten{"Betrag"}."#:#".$Daten{"Gkonto"}."#:#".$Daten{"Ghidden"}."#:##:##:##:#\n");
			}
			else {  #loeschen
				splice (@AlteZeilen,$y,1);
			}
		}
		open(DATEI, ">../data/$Gdatei") || die "die Datei $Gdatei ist nicht vorhanden oder es fehlt die Schreibberechtigung in data:\n$!";
		     print DATEI @AlteZeilen;
		close(DATEI);
		chmod(0777, "../data/$Gdatei");
	}

   }





################################################################################################################
## Ausgabe ## Buchungsliste ####################################################################################
################################################################################################################




   my @Liste = "";
   my $Startbyte = ($Daten{"privat"})? $Daten{"Startbyte_privat"} : $Daten{"Startbyte"}; 
   my $Startzeile = ($Daten{"privat"})? $Daten{"Startzeile_privat"} : $Daten{"Startzeile"};

   my @Zeilenbyte = "";
   if ( -e "../data/$Datei" ) {

	# Daten ab Startbyte auslesen
	@Liste=@{Form::Auslesen_Teil("../data/$Datei", $Startbyte)};
	# Neue Zeilenanfaenge finden
	open(DATEI, "<../data/$Datei") || die "$Datei: $!";
		$Zeilenbyte[0] = tell(DATEI);
		my $i = 0;
		while(<DATEI>) {
		   $i++;
		   $Zeilenbyte[$i] = tell(DATEI);
		   }
	close(DATEI);

   my @Listen;
   for(my $i=0;$i<=$#Liste;$i++) {
         @_ = split(/#:#/, $Liste[$i]);
	 foreach (@_) { $_=~ s/\n//g; }
	 push( @Listen, [@_] ); 
         }



  # print ACCOUNTLIST "Content-type: text/html\n\n";
   @Zeilen = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
       "http://www.w3.org/TR/html4/loose.dtd">

<HTML>
<HEAD>  <TITLE>Lawsuit - Buchungsliste</TITLE>

	<link rel="icon" href="../favicon.ico" type="image/x-icon">
	<link rel="stylesheet" type="text/css" href="../stylesheets/lawsuit.css">
	<link rel="stylesheet" type="text/css" id="CSS" href="../stylesheets/'.$Css.'.css">

	<style>
	TH { font-size : 9px; }
	TD { font-size : 8px; }
	INPUT { border-style : none;
		font-size    : 9px; 
		background-color : dunkel;}
	</style>

	<script language="JavaScript" type="text/javascript" src="../javascript/dhtml.js"></script>
	<script language="JavaScript" type="text/javascript" src="../javascript/formular.js"></script>
	<script language="JavaScript" type="text/javascript" src="../javascript/accounting.js"></script>

	<script language="JavaScript" type="text/javascript">

	function wegbis(privat, zeile, byte) {

		var wo = (privat)? "Startzeile_privat" : "Startzeile";
		var z=(zeile>=0)? new Number(parent.Buchungen.getElement("name", wo, 0).value) : 0;
		z+=zeile; 
		parent.Buchungen.getElement("name", wo, 0).value=z;

		var wo = (privat)? "Startbyte_privat" : "Startbyte";
		parent.Buchungen.getElement("name", wo, 0).value=(byte>=0)? byte : 0;

		parent.Buchungen.document.ac.submit();
	}

	</script>
</HEAD>
';

   push (@Zeilen, '
<BODY class="grund">
<FORM NAME="li">
<TABLE WIDTH=790 BORDER=1 CELLPADDING=0 CELLSPACING=0 ALIGN=CENTER>

		<TR>
			<TH class="rahmen"><a href=javascript:wegbis("'.$Daten{"privat"}.'",-1,-1) title="Alles einblenden">&dArr;</a></TH><TH class="rahmen">Eing.</TH><TH class="rahmen">Anz.</TH><TH class="rahmen">Datum</TH><TH class="rahmen">Beleg</TH><TH class="rahmen">Art</TH><TH class="rahmen">B/E-Konto</TH><TH class="rahmen">Bezeichnung</TH><TH class="rahmen">Buchungstext</TH><TH class="rahmen">Betrag</TH><TH class="rahmen">inkl.</TH><TH class="rahmen">netto</TH><TH class="rahmen">Gegenkonto</TH><TH class="rahmen">Bezeichnung</TH><TH class="rahmen">USt-Konto</TH><TH class="rahmen">Umsatzsteuer</TH><TH class="rahmen">USt-Betrag</TH><TH class="rahmen">&nbsp;&nbsp;&equiv;&nbsp;&nbsp;</TH>
		</TR>
');

#  Einstellungen fuer Input-Felder, vorerst keine Deklaraton fuer TD
   my @Width = qw( 2 2 9 2 2 6 18 33 7 1 7 6 10 6 10 5); 
   my @Align = qw( center center center center center center left left right center right center left center left right); 


   my $i;
   my $z=0;
   for ($i=0; $i<=$#Liste; $i++) {
	if( length($Liste[$i])>0 ) {
		my $Farbe = ( $Listen[$i][1] % 2 == 0 )?  "dunkel" : "hell"; 
		push (@Zeilen, '		<TR class='.$Farbe.' onClick="show('.$Listen[$i][1].')">
			<TD><a href=javascript:wegbis("'.$Daten{"privat"}.'",'.($i+$Startzeile).','.$Zeilenbyte[($i+$Startzeile)].') title="Bis zur Zeile '.($i+1).' ausblenden">&uArr;</a></TD>
			');
		for (my $k=0; $k<=15; $k++) {                           # Zeile auswerfen
			push (@Zeilen, '<TD class=""><INPUT id="'.$Listen[$i][1].'_'.$z.'_'.$k.'" SIZE="'.$Width[$k].'" VALUE="'.$Listen[$i][$k].'" class="'.$Farbe.'" style="text-align:'.$Align[$k].'"></TD>');
		}
	my $Copy=($Listen[$i][1] == $Listen[($i-1)][1])? '' : '<a href="javascript:copy('.$Listen[$i][1].')"><img src="../img/copy.gif" border=0 TITLE="Kopiere '.$Listen[$i][1].'"></a>';
	push (@Zeilen, '
			<TD class="'.$Farbe.'" align=center>'.$Copy.'</TD>
		</TR>
');
	$z=($Listen[$i][1] eq $Listen[($i+1)][1])? $z+1 : 0; 
	}
   }

  push (@Zeilen, '		<TR>
			<TD colspan=17>
					<INPUT TYPE=HIDDEN NAME="Eingabenummer" VALUE="'.($Listen[$#Liste][0]+1).'">
					<INPUT TYPE=HIDDEN NAME="Anzeigenummer" VALUE="'.($Listen[$#Liste][1]+1).'">
			</TD>
		</TR>
<script language="JavaScript" type="text/javascript">
	getElement("id", "'.$Listen[$#Liste][1].'_0_0", 0).focus();
	var process=parent.Liste.getElement("name", "Eingabenummer",0).value;
	var list   =parent.Liste.getElement("name", "Anzeigenummer",0).value; 
	parent.Buchungen.getElement("name", "Eingabenummer", 0).value=process;
	parent.Buchungen.getElement("name", "Anzeigenummer", 0).value=list;
</script>

</TABLE>
</FORM>
</HTML>
');


   } else {

	@Zeilen = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
       "http://www.w3.org/TR/html4/loose.dtd">

<HTML>
<HEAD>  <TITLE>Lawsuit - Buchungsliste</TITLE>

	<link rel="icon" href="../favicon.ico" type="image/x-icon">
	<link rel="stylesheet" type="text/css" href="../stylesheets/lawsuit.css">
	<link rel="stylesheet" type="text/css" href="../stylesheets/'.$Css.'.css">

	<script language="JavaScript" type="text/javascript" src="../javascript/dhtml.js"></script>
	<script language="JavaScript" type="text/javascript" src="../javascript/formular.js"></script>
	<script language="JavaScript" type="text/javascript" src="../javascript/accounting.js"></script>

</HEAD>

<BODY class="grund">
	<FORM name="li">
	<TABLE WIDTH=790 BORDER=0 CELLPADDING=50 CELLSPACING=0 STYLE="page-break-before: always; page-break-inside: avoid" ALIGN=CENTER>
			<TR>
				<TD ALIGN=CENTER>
				<DIV class="hell"> <h1>Bislang keine Buchungen<h1> </DIV>
				</TD>
			</TR>
	<INPUT TYPE=HIDDEN NAME="Eingabenummer" MAXSIZE=10 VALUE="1">
	<INPUT TYPE=HIDDEN NAME="Anzeigenummer" MAXSIZE=10 VALUE="1">
	</TABLE>
	<BR><BR>
	</FORM>
	
</BODY>
</HTML>
';

   }

   my $HTML="../html/".$Name."_li.html";
   open(ACCOUNTLIST, ">$HTML") || die "Sie haben keine Schreibrechte im Verzeichnis ../html\n$!";
	print ACCOUNTLIST @Zeilen;
   close(ACCOUNTLIST);




################################################################################################################
## Ausgabe ## Buchungsformular #################################################################################
################################################################################################################


## Auslesen DATEV SKR03 -- Stand 2008 --
## B: Bestandskonten --
## A: Erfolgskonten - Aufwandskonten --
## E: Erfolgskonten - Ertragskonten --
## U: Umsatzsteuerkonten --
## G: Gegenkonten --

my $A=$Daten{"Art"};

#################################################################################
## Vorauswahl der anzuzeigenden, am meisten benutzten Konten ohne fuehrende Null
$Daten{"Aertragskonto"}  = "493000"; 
$Daten{"Eertragskonto"}  = "840000";
$Daten{"Gegenkonto"}     = $Daten{"Gkonto"}|| "100000";
#Unkommentiere, um Gegenkonto immer einheitlich vorzugeben:
#$Daten{"Gegenkonto"}     = "110000"; #Postbank
#$Daten{"Gegenkonto"}     = "123000"; #Volksbank
$Daten{"Austeuerkonto"}  = "157600";
$Daten{"Eusteuerkonto"}  = "177600";
$Daten{"Azinsenkonto"}   = "211000";
$Daten{"Ezinsenkonto"}   = "865000";
if( $Daten{"privat"} ) {                                      #Vorauswahl private Konten
	$Daten{"Aertragskonto"}  = "230701";
	$Daten{"Eertragskonto"}  = "860004";                  #Unterhalt / ALGII 
	$Daten{"Austeuerkonto"}  = "157100";
	$Daten{"Eusteuerkonto"}  = "177800";
}
$Daten{"Ertragskonto"} = $Daten{$A."ertragskonto"};	      #fuer HTML-Ausgabe
$Daten{"Usteuerkonto"} = $Daten{$A."usteuerkonto"};	      #fuer HTML-Ausgabe
$Daten{"Zinsenkonto"}  = $Daten{$A."zinsenkonto"};	      #fuer HTML-Ausgabe

$Daten{"F1hidden"} |= "Fremdgeld - Hauptforderung";           #Vorauswahl komplexe Hiddenfields
$Daten{"F2hidden"} |= "Fremdgeld - fremde Zinsen";
$Daten{"F3hidden"} |= "Fremdgeld - fremde Kosten";
$Daten{"F4hidden"} |= "Fremdgeld - vorgelegte Kosten";
unless($Daten{"Zhidden"}) {
    if   ( $A eq "A" ) { $Daten{"Zhidden"}  = "Zinsaufwendung f. kurzf. Verbindlichkeiten"; }
    else               { $Daten{"Zhidden"}  = "Erl&ouml;se Zinsen und Diskontspesen"; }
    }
#################################################################################


   my $Konten    = $Name;
   my @Allekonten=@{Form::Auslesen("../data/$Konten.cfg")};

   my @Konten;
   my $Aktiv = ( $Datei =~ "privat" )?  5 : 4;          # Privatkonto oder Geschaeftskonto?
   for(my $i=0;$i<=$#Allekonten;$i++) {
	 $Allekonten[$i] =~ s/\n//g;
         @_ = split(/#:#/, $Allekonten[$i]);
	 if(@_[$Aktiv] eq "1") {                        # nur ausgewaehlte Konten gesch./privat auslesen
	    push( @Konten, "@_[1]#:#@_[0]#:#@_[2]" );   # Umstellen zum Sortieren
         }
   }
   @Konten = sort (@Konten);
   my @Zkonto;
   my @Fkonto;
   my @Ekonto;
   my @Gkonto;
   my @Ukonto;
   my $Z;
   my $V;
   my $E;
   foreach (@Konten) {
	my @k=split(/#:#/, $_);
	$k[1] =~ s/^0//g;                       # Ueberfluessige Null entfernen und aufsplitten nach Ausgabe/Einnahme/Gegenkonto
	if( ($k[1] =~ /^21/ or $k[1] =~ /^8650/) and ( $k[2] =~ $A) ) { 
			push( @Zkonto, "$k[1]#:#$k[0]" ); 
		}
	if( $k[1] =~ /^1592/ ) { 
			if( $k[2] =~ $A or $k[2] =~ "B" ) { 
				push( @Fkonto, "$k[1]#:#$k[0]" ); 
				$V="$k[1]";
			}
		}
	if( $k[2] =~ $A or $k[2] =~ "B" ) { 
			push( @Ekonto, "$k[1]#:#$k[0]" ); }                # Bestandskonten koennen beides sein
	if( $k[2] =~ "G" ) { push( @Gkonto, "$k[1]#:#$k[0]" ); }
	if( $k[2] =~ "U" ) {
		if( $A eq "A" && $k[1]*1 < 158000 ) {                      # USteuerkonten sind nicht nach A/E aufgeschluesselt
			$k[0]=~s/VorSt./Abziehbare Vorsteuer/g;            # Aneige in Langform
			push( @Ukonto, "$k[1]#:#$k[0]" );                  # Sortierumstellung aufheben
		} elsif( $A eq "E" && $k[1]*1 >= 158000 ) { 
			$k[0]=~s/UmSt./Umsatzsteuer/g;
			push( @Ukonto, "$k[1]#:#$k[0]" ); 
		}
	}
   }

   $Daten{"FremdhauptHTML"}=Form::Ausklappmenue(\@Fkonto, "F1", "159201", 80, 400, 400, 'onchange="javascript:auswahl(&quot;F1&quot;)" TITLE="Text des ausgew&auml;hlten Fremdgeldkontos"');
   $Daten{"FremdzinsHTML"}=Form::Ausklappmenue(\@Fkonto, "F2", "159202", 80, 400, 400, 'onchange="javascript:auswahl(&quot;F2&quot;)" TITLE="Text des ausgew&auml;hlten Fremdgeldkontos"');
   $Daten{"FremdkostHTML"}=Form::Ausklappmenue(\@Fkonto, "F3", "159203", 80, 400, 400, 'onchange="javascript:auswahl(&quot;F3&quot;)" TITLE="Text des ausgew&auml;hlten Fremdgeldkontos"');
   $Daten{"VorgelegtHTML"}=Form::Ausklappmenue(\@Fkonto, "F4", "$V", 80, 400, 400, 'onchange="javascript:auswahl(&quot;F4&quot;)"');

   my $E = $Daten{$A."ertragskonto"};
   my $G = $Daten{"Gegenkonto"};
   my $U = $Daten{$A."usteuerkonto"};
   $Daten{"ErfolgsHTML"}=Form::Ausklappmenue(\@Ekonto, "E", "$E", 80, 400, 400, 'onchange="javascript:auswahl(&quot;E&quot;),relation(&quot;E&quot;),rechne(&quot;E&quot;);" TITLE="Text des ausgew&auml;hlten Ertrags-/Bestandskontos"');
   $Daten{"GegenHTML"}=Form::Ausklappmenue(\@Gkonto, "G", "$G", 80, 400, 400, 'onchange="javascript:auswahl(&quot;G&quot;)" TITLE="Text des ausgew&auml;hlten Gegenkontos"');
   $Daten{"UstHTML"}=Form::Ausklappmenue(\@Ukonto, "U", "$U", 80, 400, 400, 'onchange="javascript:rechne(&quot;U&quot;),auswahl(&quot;U&quot;);" TITLE="Text des ausgew&auml;hlten Umsatzsteuerkontos"');
   my $Z = $Daten{$A."zinsenkonto"};
   $Daten{"ZinsenHTML"}=Form::Ausklappmenue(\@Zkonto, "Z", "$Z", 80, 400, 400, 'onchange="javascript:auswahl(&quot;Z&quot;)"');

   my $Achecked =( $A eq "A" )? "checked" : "" ;
   my $Echecked =( $A eq "E" )? "checked" : "" ;
   $Daten{"AuswahlHTML"} ='
				<TD WIDTH=220>
					<LABEL FOR="Aus"><INPUT TYPE=radio NAME="Art" ID="Aus" VALUE="A" '.$Achecked.' onChange="javascript:artwahl()" TITLE="Handelt es sich um eine Ausgabe oder eine Einnahme?">&nbsp;Ausgabe</LABEL>
				</TD>
				<TD WIDTH=190>
					<LABEL FOR="Ein"><INPUT TYPE=radio NAME="Art" ID="Ein" VALUE="E" '.$Echecked.' onChange="javascript:artwahl()" TITLE="Handelt es sich um eine Ausgabe oder eine Einnahme?">&nbsp;Einnahme</LABEL>
				</TD>
';
   $Daten{"Geldflusses"} = ( $A eq "A" )? "Geldabflusses" : "Geldzuflusses";
   $Daten{"gezahlten"} = ( $A eq "A" )? "gezahlten" : "vereinnahmten";

   # Komplexe Eingabe fuer Privatkonto ausschalten, um Kongruenz zu Hauptkonto zu wahren
   if( $Daten{"privat"} ) { $Daten{"komplex"}=""; }
   # Komplexeinstellungen
   my $komplex = ($Daten{"komplex"})? 'style="display:table-row"' : 'style="display:none"';
   $Daten{"komplex"}=($Daten{"komplex"})? "checked" : "";
   $Daten{"privat"}=($Daten{"privat"})? "checked" : "";

   my $HTML="../html/".$Name."_ac.html";
   open(ACCOUNTING, ">$HTML") || die "Sie haben keine Schreibrechte im Verzeichnis ../html";


   print ACCOUNTING ' <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
       "http://www.w3.org/TR/html4/loose.dtd">

<HTML>
<HEAD>  <TITLE>Lawsuit - Buchungen</TITLE>

	<link rel="icon" href="../favicon.ico" type="image/x-icon">
	<link rel="stylesheet" type="text/css" href="../stylesheets/lawsuit.css">
	<link rel="stylesheet" type="text/css" id="CSS" href="../stylesheets/',$Css,'.css">

	<script language="JavaScript" type="text/javascript" src="../javascript/dhtml.js"></script>
	<script language="JavaScript" type="text/javascript" src="../javascript/formular.js"></script>
	<script language="JavaScript" type="text/javascript" src="../javascript/accounting.js"></script>

<BODY class="grund" onLoad="javascript:set(),Event_init()',$Daten{"show"},';">


<FORM NAME="ac" action="../cgi-bin/accounting.pl" target="_parent" method=post>
	<TABLE WIDTH=790 BORDER=0 CELLPADDING=0 CELLSPACING=0 STYLE="page-break-before: always; page-break-inside: avoid" ALIGN=CENTER>
		<COL WIDTH=55>
		<COL WIDTH=125 ALIGN=right>
		<COL WIDTH=220>
		<COL WIDTH=190>
		<COL WIDTH=200>
			<TR>
				<TD WIDTH=55>
					<INPUT TYPE=HIDDEN NAME="Eingabenummer" MAXSIZE=10><INPUT TYPE=TEXT NAME="Anzeigenummer" SIZE=3 MAXSIZE=10  style="text-align:right" TITLE="Laufende Buchungsnummer">
				</TD>
				<TD WIDTH=125 ALIGN=right>
					<INPUT TYPE=TEXT NAME="Datum" SIZE=10 MAXSIZE=10 style="text-align:right" onChange="datum(&quot;Datum&quot;,1,0)"  value="',$Daten{"Datum"},'" TITLE="Datum des ',$Daten{"Geldflusses"},'" >
				</TD>
				<TD COLSPAN=2 WIDTH=410>
				</TD>
				<TD WIDTH=200>
					<INPUT TYPE=TEXT NAME="Belegnummer" SIZE=3 MAXSIZE=10 style="text-align:right" TITLE="Belegnummer">
				</TD>
			</TR>
			<TR>
				<TD WIDTH=55 />
				<TD WIDTH=125 />
',$Daten{"AuswahlHTML"},'
				<TD WIDTH=200>
					<LABEL FOR="Komplex"><INPUT TYPE=CHECKBOX NAME="komplex" ID="Komplex" VALUE="1" ',$Daten{"komplex"},' onChange="javascript:artwahl()">&nbsp;komplex</LABEL>
				</TD>
			</TR>
			<TR id="komplex_1" ',$komplex,'>
				<TD WIDTH=55 />
				<TD WIDTH=125 ALIGN=right>
					<INPUT TYPE=TEXT NAME="F1konto" SIZE=6 MAXSIZE=14 VALUE="159201" TITLE="Nummer des zugeh&ouml;rigen Fremdgeldkontos">
				</TD>
				<TD COLSPAN=2 WIDTH=410>
				<INPUT TYPE=HIDDEN NAME="F1hidden" MAXSIZE=100 value="',$Daten{"F1hidden"},'">
',$Daten{"FremdhauptHTML"},'				
				</TD>
				<TD WIDTH=200 />
			</TR>
			<TR id="komplex_2" ',$komplex,'>
				<TD WIDTH=55 />
				<TD WIDTH=125 />
				<TD COLSPAN=2 WIDTH=410>
					<INPUT TYPE=TEXT NAME="Ftext" SIZE=54 MAXSIZE=100 value="',$Daten{"Ftext"},'" onBlur="javascript:regfound(this.name)" TITLE="Pers&ouml;nlicher Buchungstext">
				</TD>
				<TD WIDTH=200 />
			</TR>
			<TR id="komplex_3" ',$komplex,'>
				<TD WIDTH=55 />
				<TD WIDTH=125 />
				<TD WIDTH=220>
					<INPUT TYPE=TEXT NAME="F1betragEUR" SIZE=14 MAXSIZE=14 class="eur" onChange="javascript:zusatzzahl(&quot;F1betragEUR&quot;)"  value="',$Daten{"F1betragEUR"},'" TITLE="Hauptforderungsbetrag in EUR"> EUR
				</TD>
				<TD WIDTH=190>
					<DIV id="rest" style="display:none"><INPUT TYPE=TEXT NAME="F1rest" SIZE=14 maxsize=14 value="',$Daten{"F1rest"},'"> EUR Restbetrag</DIV>
				</TD>
				<TD WIDTH=200 />
			</TR>
			<TR id="komplex_4" ',$komplex,'>
				<TD WIDTH=55 />
				<TD WIDTH=125 ALIGN=right>
					<INPUT TYPE=TEXT NAME="F2konto" SIZE=6 MAXSIZE=14 VALUE="159202" TITLE="Nummer des zugeh&ouml;rigen Fremdgeldkontos">
				</TD>
				<TD COLSPAN=2 WIDTH=410>
				<INPUT TYPE=HIDDEN NAME="F2hidden" MAXSIZE=100 value="',$Daten{"F2hidden"},'">
',$Daten{"FremdzinsHTML"},'				
				</TD>
				<TD WIDTH=200 />
			</TR>
			<TR id="komplex_5" ',$komplex,'>
				<TD WIDTH=55 />
				<TD WIDTH=125 />
				<TD WIDTH=220>
					<INPUT TYPE=TEXT NAME="F2betragEUR" SIZE=14 MAXSIZE=14 class="eur" onChange="javascript:zusatzzahl(&quot;F2betragEUR&quot;)" value="',$Daten{"F2betragEUR"},'" TITLE="Zinsforderungsbetrag in EUR"> EUR
				</TD>
				<TD WIDTH=190>
					<DIV id="rest" style="display:none"><INPUT TYPE=TEXT NAME="F2rest" SIZE=14 maxsize=14 value="',$Daten{"F2rest"},'" > EUR Restbetrag</DIV>
				</TD>
				<TD WIDTH=200 />
			</TR>
			<TR id="komplex_6" ',$komplex,'>
				<TD WIDTH=55 />
				<TD WIDTH=125 ALIGN=right>
					<INPUT TYPE=TEXT NAME="F3konto" SIZE=6 MAXSIZE=14 VALUE="159203" TITLE="Nummer des zugeh&ouml;rigen Fremdgeldkontos">
				</TD>
				<TD COLSPAN=2 WIDTH=410>
				<INPUT TYPE=HIDDEN NAME="F3hidden" MAXSIZE=100 value="',$Daten{"F3hidden"},'">
',$Daten{"FremdkostHTML"},'				
				</TD>
				<TD WIDTH=200 />
			</TR>
			<TR id="komplex_7" ',$komplex,'>
				<TD WIDTH=55 />
				<TD WIDTH=125 />
				<TD WIDTH=220>
					<INPUT TYPE=TEXT NAME="F3betragEUR" SIZE=14 MAXSIZE=14 class="eur" onChange="javascript:zusatzzahl(&quot;F3betragEUR&quot;)" value="',$Daten{"F3betragEUR"},'" TITLE="Fremdkostenbetrag in EUR"> EUR
				</TD>
				<TD WIDTH=190>
					<DIV id="rest" style="display:none"><INPUT TYPE=TEXT NAME="F3rest" SIZE=14 maxsize=14 value="',$Daten{"F3rest"},'" > EUR Restbetrag</DIV>
				</TD>
				<TD WIDTH=200 />
			</TR>
			<TR id="komplex_8" ',$komplex,'>
				<TD WIDTH=55 />
				<TD WIDTH=125 ALIGN=right>
					<INPUT TYPE=TEXT NAME="F4konto" SIZE=6 MAXSIZE=14 VALUE="',substr($V, 0, 6),'" TITLE="Konto f&uuml;r vom Anwalt vorgelegte Kosten">
				</TD>
				<TD COLSPAN=2 WIDTH=410>
				<INPUT TYPE=HIDDEN NAME="F4hidden" MAXSIZE=100 value="',$Daten{"F4hidden"},'">
',$Daten{"VorgelegtHTML"},'				
				</TD>
				<TD WIDTH=200 />
			</TR>
			<TR id="komplex_9" ',$komplex,'>
				<TD WIDTH=55 />
				<TD WIDTH=125 />
				<TD WIDTH=220>
					<INPUT TYPE=TEXT NAME="F4betragEUR" SIZE=14 MAXSIZE=14 class="eur" onChange="javascript:zusatzzahl(&quot;F4betragEUR&quot;)" value="',$Daten{"F4betragEUR"},'" TITLE="Vorgelegte Gerichts-/GK-Kosten in EUR"> EUR
				</TD>
				<TD WIDTH=190>
					<DIV id="rest" style="display:none"><INPUT TYPE=TEXT NAME="F4rest" value="',$Daten{"F4rest"},'" SIZE=14 maxsize=14> EUR Restbetrag</DIV>
				</TD>
				<TD WIDTH=200 />
			</TR>
			<TR>
				<TD WIDTH=55 />
				<TD WIDTH=125 ALIGN=right>
					<INPUT TYPE=TEXT NAME="Ekonto" SIZE=6 MAXSIZE=14 VALUE="',$Daten{"Ertragskonto"},'" TITLE="Nummer des zugeh&ouml;rigen Ertrags-/Bestandskontos">
				</TD>
				<TD COLSPAN=2 WIDTH=410>
				<INPUT TYPE=HIDDEN NAME="Ehidden" MAXSIZE=100>
',$Daten{"ErfolgsHTML"},'				
				</TD>
				<TD WIDTH=200>
					<LABEL FOR="Privat"><INPUT TYPE=CHECKBOX NAME="privat" ID="Privat" VALUE="1" ',$Daten{"privat"},' onChange="javascript:artwahl()">&nbsp;privat</LABEL>
				</TD>
			</TR>
			<TR>
				<TD WIDTH=55 />
				<TD WIDTH=125 />
				<TD COLSPAN=2 WIDTH=410>
					<INPUT TYPE=TEXT NAME="Buchungstext" SIZE=54 MAXSIZE=100 TITLE="Pers&ouml;nlicher Buchungstext" onBlur="javascript:regfound(this.name)" onChange=getElement("name","change",0).value=1; >
				</TD>
				<TD WIDTH=200 />
			</TR>
			<TR>
				<TD WIDTH=55 />
				<TD WIDTH=125 />
				<TD WIDTH=220>
					<INPUT TYPE=TEXT NAME="BetragEUR" SIZE=14 MAXSIZE=14 class="eur" onChange=rechne("BetragEUR") TITLE="Gezahlter Betrag in EUR"> EUR<INPUT TYPE=HIDDEN NAME="Betrag" SIZE=14>
				</TD>
				<TD WIDTH=190>
					<LABEL FOR="ustinklusive"><INPUT TYPE=CHECKBOX NAME="Ustinklusive" ID="ustinklusive" VALUE="1" checked onChange=rechne("Ustinklusive") TITLE="Wurde links ein Brutto- oder Nettobetrag eingegeben?"> Inklusive
					UmSt.</LABEL>
				</TD>
				<TD WIDTH=200 />
			</TR>
			<TR>
				<TD WIDTH=55 />
				<TD WIDTH=125 ALIGN=right>
					<INPUT TYPE=TEXT NAME="Gkonto" SIZE=6 MAXSIZE=14 VALUE="',$Daten{"Gegenkonto"},'" TITLE="Nummer des zugeh&ouml;rigen Gegenkontos">
				</TD>
				<TD COLSPAN=2 WIDTH=410>
				<INPUT TYPE=HIDDEN NAME="Ghidden" MAXSIZE=100>
',$Daten{"GegenHTML"},'
				</TD>
				<TD WIDTH=200 />
			</TR>
			<TR>
				<TD WIDTH=55 />
				<TD WIDTH=125 ALIGN=right>
					<INPUT TYPE=TEXT NAME="Ukonto" SIZE=6 MAXSIZE=14 VALUE="',$Daten{"Usteuerkonto"},'" TITLE="Nummer des gegenzubuchenden Umsatzsteuerkontos">
				</TD>
				<TD COLSPAN=2 WIDTH=410>
				<INPUT TYPE=HIDDEN NAME="Uhidden" MAXSIZE=100>
',$Daten{"UstHTML"},'
				</TD>
				<TD WIDTH=200 >
					<INPUT TYPE=TEXT NAME="UstEUR" SIZE=14 MAXSIZE=14 class="eur" TITLE="Betrag der ',$Daten{"gezahlten"},' Umsatzsteuer">&nbsp;EUR
				</TD>
			</TR>
			<TR id="komplex_10" ',$komplex,'>
				<TD WIDTH=55 />
				<TD WIDTH=125 ALIGN=right>
					<INPUT TYPE=TEXT NAME="Zkonto" SIZE=6 MAXSIZE=14 VALUE="',$Daten{"Zinsenkonto"},'" TITLE="Nummer des Zinsenkontos">
				</TD>
				<TD COLSPAN=2 WIDTH=410>
				<INPUT TYPE=HIDDEN NAME="Zhidden" MAXSIZE=100 value="',$Daten{"Zhidden"},'">
',$Daten{"ZinsenHTML"},'
				</TD>
				<TD WIDTH=200 />
			</TR>
			<TR id="komplex_11" ',$komplex,'>
				<TD WIDTH=55 />
				<TD WIDTH=125 />
				<TD WIDTH=220>
					<INPUT TYPE=TEXT NAME="ZinsenEUR" SIZE=14 MAXSIZE=14 class="eur" onChange="javascript:zusatzzahl(&quot;ZinsenEUR&quot;)" TITLE="Betrag der ',$Daten{"gezahlten"},' Zinsen"> EUR
				</TD>
				<TD WIDTH=190>
					<DIV id="rest" style="display:none"><INPUT TYPE=TEXT NAME="Zinsenrest" SIZE=14 maxsize=14 value="',$Daten{"Zinsenrest"},'" > EUR Restbetrag</DIV>
				</TD>
				<TD WIDTH=200 />
			</TR>
			<TR>
				<TD WIDTH=55>
					<INPUT TYPE=SUBMIT NAME="Befehl" onClick="javascript:reset()"   ACCESSKEY="N" TITLE="Neu [Alt-N]" VALUE="  Neu  " class="button">
				</TD>
				<TD WIDTH=125 ALIGN=right>
					<INPUT TYPE=SUBMIT NAME="Befehl"  onClick="javascript:encodeall()"  ACCESSKEY="L" TITLE="L&ouml;schen [Alt-L]" VALUE="   L&ouml;schen   " class="button">
				</TD>
				<TD COLSPAN=2 WIDTH=410>
					<INPUT TYPE=SUBMIT NAME="Befehl" onClick="javascript:encodeall(),regfound(&quot;Buchungstext&quot;);"   ACCESSKEY="L" TITLE="Speichern [Alt-S]" VALUE="   Speichern   "   class="button">
				</TD>
				<TD WIDTH=200>
					<LABEL FOR="muster"><INPUT TYPE=CHECKBOX NAME="Muster" ID="muster" VALUE="" TITLE="Soll diese Buchung zugleich als Muster f&uuml;r sp&auml;tere &auml;hnliche Buchungen dienen?"> als
					Muster</LABEL>
				</TD>
			</TR>
	</TABLE>
	<INPUT TYPE="hidden" name="Cprozessregister" value="">
	<INPUT TYPE="hidden" name="change" value="0">
	<INPUT TYPE="hidden" name="JSBefehl" value="">
	<INPUT TYPE="hidden" name="Target" value="">
	<INPUT TYPE="hidden" name="Datei" value="',Form::utf82html($Datei),'">
	<INPUT TYPE="hidden" name="Startbyte" value="',$Daten{"Startbyte"},'">
	<INPUT TYPE="hidden" name="Startbyte_privat" value="',$Daten{"Startbyte_privat"},'">
	<INPUT TYPE="hidden" name="Startzeile" value="',$Daten{"Startzeile"},'">
	<INPUT TYPE="hidden" name="Startzeile_privat" value="',$Daten{"Startzeile_privat"},'">
	<INPUT TYPE="hidden" name="Name" value="',Form::utf82html($Name),'">
	<BR><BR>

	<DIV id="Nav" style="background-color:#555599">
		 <DIV id="NavLinks">
		  <ul>
		  <li><a href="../cgi-bin/accountsets.pl?Datei=',Form::html2uri($Daten{"Datei"}),'&Name=',Form::html2uri($Daten{"Name"}),'" target="_parent">Einstellungen</a><br>
		  <li><a href="../cgi-bin/assessment.pl?Datei=',Form::html2uri($Daten{"Datei"}),'&Name=',Form::html2uri($Daten{"Name"}),'" target="_parent">Auswertung</a><br>
		  <li><a href="../cgi-bin/tax.pl?Datei=',Form::html2uri($Daten{"Datei"}),'&Name=',Form::html2uri($Daten{"Name"}),'" target="_parent">Umsatzsteuer- voranmeldung</a><br>
		  <li><a href="../cgi-bin/accountstate.pl?Datei=',Form::html2uri($Daten{"Datei"}),'&Name=',Form::html2uri($Daten{"Name"}),'" target="_parent">Kontoausz&uuml;ge</a><br>
		  <li><a href="../cgi-bin/accountdiagram.pl?Datei=',Form::html2uri($Daten{"Datei"}),'&Name=',Form::html2uri($Daten{"Name"}),'" target="_parent">Diagrammtabelle</a><br>
		  <li><a href="../cgi-bin/account6mstate.pl?Datei=',Form::html2uri($Daten{"Datei"}),'&Name=',Form::html2uri($Daten{"Name"}),'" target="_parent">JC-Bilanz</a><br>
		  </ul>
		 </DIV>
	</DIV>

	<DIV id="Reg" style="background-color:#555599">
		 <DIV id="RegLinks">
		  <a href="../cgi-bin/falle.pl?Cprozessregister=" target="_blank" name="Regnummer"></a>
		 </DIV>
	</DIV>


</FORM>
</BODY>
</HTML>';

   close(ACCOUNTING);



if( $Daten{"Target"} eq "Buchungen" )  {
   
	print $cgi->header();
		print @{Form::HTML($Name."_ac", \%Daten)};

} else {

	my $Pixel=($Daten{"komplex"})? 200 : 500;

	print $cgi->header();
	print'
<html>
<title>Lawsuit - Buchungen - ',decode("utf8",$Datei),'</title>
<frameset id="account" rows="',$Pixel,',*" >
 <!-- Dadurch ergeben sich zwei horizontale Hauptframefenster, deren Inhalt hier bestimmt wird -->
         <frame src="../html/',decode("utf8",$Name),'_li.html" name="Liste">
         <frame src="../html/',decode("utf8",$Name),'_ac.html" name="Buchungen">
       <noframes>
	  <body>
          Malheureusement votre navigateur n&acute;est pas en mesure d&acute;afficher cette page!
          Ihr Browser kann diese Seite leider nicht anzeigen!
	  </body>
       </noframes>
</frameset>
</html>';

}



