#!/usr/bin/perl -w 

   use Encode; # fuer OpenOffice - Konvertierung in UTF-8 

   use strict;
   use CGI;
   my $cgi = new CGI;
   use CGI::Carp qw(fatalsToBrowser);

   use lib "/home/matthias/lawsuit/cgi-bin/LS";
   use LS::Form;


   my $Datei=$cgi->param("Datei");
   my $Datei_privat=$Datei;
      $Datei_privat=~s/\.L/_privat\.L/;
   my $Datei_vorjahr=$cgi->param("Datei_vorjahr1");
   my $Datei_vorjahr_privat=$Datei_vorjahr;
      $Datei_vorjahr_privat=~s/\.L/_privat\.L/;
   my $Css = ( $Datei =~ m/.+privat.+/ )? 'accountingP' : 'accountingG';    # Privat- oder Geschaeftskonto?
   my $Name=$cgi->param("Name");
   my $Name_vorjahr=$cgi->param("Name_vorjahr");
   my %Daten;
 
   my @Wort= split(/\./, $Datei);
   my $Jahr = $Wort[1];
      $Jahr =~ s/L//g; 
      $Jahr *=1;
      
   my @Monat;
   my $Febend;
   my $Folgefebend;
   my $Vorjahr=$Jahr-1;
   my $Folgejahr=$Jahr+1;
   if( ($Jahr % 4 == 0 && $Jahr % 100 != 0) || ($Jahr % 1000 == 0) ) { $Febend=29; }
   else { $Febend=28; }
   if( ($Folgejahr % 4 == 0 && $Folgejahr % 100 != 0) || ($Folgejahr % 1000 == 0) ) { $Folgefebend=29; }
   else { $Folgefebend=28; }

   $Monat[0] =  [ "August",    Form::Zeit("01.08.$Vorjahr"), Form::Zeit("31.08.$Vorjahr") ];
   $Monat[1] =  [ "September", Form::Zeit("01.09.$Vorjahr"), Form::Zeit("30.09.$Vorjahr") ];
   $Monat[2] =  [ "Oktober",   Form::Zeit("01.10.$Vorjahr"), Form::Zeit("31.10.$Vorjahr") ];
   $Monat[3] = [ "November",  Form::Zeit("01.11.$Vorjahr"), Form::Zeit("30.11.$Vorjahr") ];
   $Monat[4] = [ "Dezember",  Form::Zeit("01.12.$Vorjahr"), Form::Zeit("31.12.$Vorjahr") ];
   $Monat[5] =  [ "Januar",    Form::Zeit("01.01.$Jahr"), Form::Zeit("31.01.$Jahr") ]; 
   $Monat[6] =  [ "Februar",   Form::Zeit("01.02.$Jahr"), Form::Zeit("$Febend.02.$Jahr") ]; 
   $Monat[7] =  [ "M&auml;rz", Form::Zeit("01.03.$Jahr"), Form::Zeit("31.03.$Jahr") ];
   $Monat[8] =  [ "April",     Form::Zeit("01.04.$Jahr"), Form::Zeit("30.04.$Jahr") ];
   $Monat[9] =  [ "Mai",       Form::Zeit("01.05.$Jahr"), Form::Zeit("31.05.$Jahr") ];
   $Monat[10] =  [ "Juni",      Form::Zeit("01.06.$Jahr"), Form::Zeit("30.06.$Jahr") ];
   $Monat[11] =  [ "Juli",      Form::Zeit("01.07.$Jahr"), Form::Zeit("31.07.$Jahr") ];
   $Monat[12] =  [ "August",    Form::Zeit("01.08.$Jahr"), Form::Zeit("31.08.$Jahr") ];
   $Monat[13] =  [ "September", Form::Zeit("01.09.$Jahr"), Form::Zeit("30.09.$Jahr") ];
   $Monat[14] =  [ "Oktober",   Form::Zeit("01.10.$Jahr"), Form::Zeit("31.10.$Jahr") ];
   $Monat[15] = [ "November",  Form::Zeit("01.11.$Jahr"), Form::Zeit("30.11.$Jahr") ];
   $Monat[16] = [ "Dezember",  Form::Zeit("01.12.$Jahr"), Form::Zeit("31.12.$Jahr") ];
   $Monat[17] =  [ "Januar",    Form::Zeit("01.01.$Folgejahr"), Form::Zeit("31.01.$Folgejahr") ]; 
   $Monat[18] =  [ "Februar",   Form::Zeit("01.02.$Folgejahr"), Form::Zeit("$Folgefebend.02.$Folgejahr") ]; 
   $Monat[19] =  [ "M&auml;rz", Form::Zeit("01.03.$Folgejahr"), Form::Zeit("31.03.$Folgejahr") ];
   $Monat[20] =  [ "April",     Form::Zeit("01.04.$Folgejahr"), Form::Zeit("30.04.$Folgejahr") ];
   $Monat[21] =  [ "Mai",       Form::Zeit("01.05.$Folgejahr"), Form::Zeit("31.05.$Folgejahr") ];
   $Monat[22] =  [ "Juni",      Form::Zeit("01.06.$Folgejahr"), Form::Zeit("30.06.$Folgejahr") ];
   $Monat[23] =  [ "Juli",      Form::Zeit("01.07.$Folgejahr"), Form::Zeit("31.07.$Folgejahr") ];


########################################################################################
if( length($cgi->param("Start1"))<=0 or length($cgi->param("Name_vorjahr"))>3 ) {
########################################################################################


   # Auswahl von Vorjahresdateien
   my @Selected;
   my @Dateien = glob("../data/*.L*");
   my @AuswahlDateien = "";
      foreach (@Dateien) {
		my $Short=$_;
		$Short=~s/.*\///g;
		unless( $_=~m/~$/ or $_=~m/_/ ) { push(@AuswahlDateien, $_."#:#".$Short); }
		}
      $Daten{"dateienHTML"}=Form::Ausklappmenue(\@AuswahlDateien, "Datei_vorjahr", $Datei_vorjahr, 20, 200, 200, 'onChange=shufflelastyear("Datei_vorjahr")');

   print "Content-type: text/html\n\n";
   print '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
       "http://www.w3.org/TR/html4/loose.dtd">

<HTML>
<HEAD>  <TITLE>Lawsuit - JC-Auswertung</TITLE>

	<link rel="icon" href="../favicon.ico" type="image/x-icon">
	<link rel="stylesheet" type="text/css" href="../stylesheets/lawsuit.css">
	<link rel="stylesheet" type="text/css" href="../stylesheets/',$Css,'.css">

	<script language="JavaScript" type="text/javascript" src="../javascript/dhtml.js"></script>
	<script language="JavaScript" type="text/javascript" src="../javascript/formular.js"></script>
	<script language="JavaScript" type="text/javascript" src="../javascript/accounting.js"></script>

	<style>
	.List TH { font-size : 9px; }
	.List TD { font-size : 8px; }
	.List INPUT { border-style : none;
		font-size    : 9px; 
		background-color : dunkel;}
	</style>

</HEAD>
<BODY class="grund">
';

   ## Ausklappmenues schreiben und aktuelle Jahre einbauen
   my @Ziel = qw(5#:#Januar&nbsp;-&nbsp;Juni 6#:#Februar&nbsp;-&nbsp;Juli 7#:#M&auml;rz&nbsp;-&nbsp;August 8#:#April&nbsp;-&nbsp;September 9#:#Mai&nbsp;-&nbsp;Oktober 10#:#Juni&nbsp;-&nbsp;November 11#:#Juli&nbsp;-&nbsp;Dezember 12#:#August&nbsp;-&nbsp;Januar&nbsp;Folgejahr 13#:#September&nbsp;-&nbsp;Febuar&nbsp;Folgejahr 14#:#Oktober&nbsp;-&nbsp;M&auml;rz&nbsp;Folgejahr 15#:#November&nbsp;-&nbsp;April&nbsp;Folgejahr 16#:#Dezember&nbsp;-&nbsp;Mai&nbsp;Folgejahr);
   my $Folgejahr=$Jahr+1;
   foreach (@Ziel) {
	  $_=~s/Folgejahr/$Folgejahr/; }
   my $Ziel = $cgi->param("Ziel1");
   $Daten{"zielHTML"}=Form::Ausklappmenue(\@Ziel, "Ziel", $Ziel, "20", "200", "200", q~onChange="createfilename('Ziel')"~);
   my @Start = qw(0#:#August&nbsp;Vorjahr&nbsp;-&nbsp;Januar&nbsp;Jahr 1#:#September&nbsp;Vorjahr&nbsp;-&nbsp;Febuar&nbsp;Jahr 2#:#Oktober&nbsp;Vorjahr&nbsp;-&nbsp;M&auml;rz&nbsp;Jahr 3#:#November&nbsp;Vorjahr&nbsp;-&nbsp;April&nbsp;Jahr 4#:#Dezember&nbsp;Vorjahr&nbsp;-&nbsp;Mai&nbsp;Jahr 5#:#Januar&nbsp;-&nbsp;Juni 6#:#Februar&nbsp;-&nbsp;Juli 7#:#M&auml;rz&nbsp;-&nbsp;August 8#:#April&nbsp;-&nbsp;September 9#:#Mai&nbsp;-&nbsp;Oktober 10#:#Juni&nbsp;-&nbsp;November 11#:#Juli&nbsp;-&nbsp;Dezember);
   my $Vorjahr=$Jahr-1;
   foreach (@Start) {
	  $_=~s/Vorjahr/$Vorjahr/;
	  $_=~s/Jahr/$Jahr/; }
	
   # Anfangswerte bei fehlender Eingabe setzen
   my $Start = ( $cgi->param("Start1") ne "")? $cgi->param("Start1") : 5;
   $Daten{"Zieldatei"} = ( $cgi->param("Zieldatei") )?  $cgi->param("Zieldatei") : $Name."_Januar-Juni";
   $Daten{"startHTML"}=Form::Ausklappmenue(\@Start, "Start", $Start, "20", "200", "200", 'onChange=insertfile()');
   my $Show=($Start<5)? "table-row" : "none"; 

   print q~<BR><BR><BR>
	<FORM name="as" method="post">

	<TABLE cellpadding="50" cellspacing="0" align="center" width="1000">
		<TR>
		<TD class="hell" align="center"><left><H2>ALG II - Einkommen ~,$Jahr,q~<br> ermittelt f&uuml;r folgende sechs Monate:</h2>
			<table align="center">
				<tr>
					<td class="hell" align="center">
			~,$Daten{"zielHTML"},q~
					<br>aus folgenden sechs Monaten der Buchungen: <br>
			~,$Daten{"startHTML"},q~


				<tr id="vorjahr" style="display:~,$Show,q~">
					<td class="hell" align="center">
					<br>unter Verwendung der folgenden Vorjahresdatei: <br>
			~,$Daten{"dateienHTML"},q~
					<br>
					</td>
				</tr>
			</table>
		</TD>
		</TR>
		<TR>
		<TD class="auswahl" align="left">
			<table align=center>
				<tr>
					<td>
						<input type="radio" name="typ" value="Bilanz" onChange="createfilename('Ziel')">&nbsp; Abschlie&szlig;ende Aufstellung zum abgelaufenen Bewilligungszeitraum<br>
						<input type="radio" name="typ" value="Prognose" onChange="createfilename('Ziel')">&nbsp; Prognose f&uuml;r Restjahr ~,$Jahr,q~ bzw. neues Jahr ~,($Jahr+1),q~<br>
					</td>
				</tr>
			</table>
		</TD>
		</TR>
	</TABLE>
~;

   #Unternehmerdaten auslesen
   my %NeueDaten=%{Form::Auslesen_Spiegel("../settings/$Name.cfg", "[BCGKPS].+", "")};
   foreach (keys (%NeueDaten)) {
	$Daten{$_}=Form::html2form($NeueDaten{$_});
	}

   my $Klein=($Daten{"Ukleinunternehmer"})? "checked" : "";

   print '
	<TABLE cellpadding="0" cellspacing="0" align="center" width="1000px">
		<tr>
		<td class="hell" width="90px" rowspan="7" >
				&nbsp;
		</td>
		<td class="hell" colspan="3">
				<h4>Angaben zum Selbstst&auml;ndigen:</h4>
		</td>
		<td class="hell" width="90px" rowspan="7">
				&nbsp;
		</td>
		</tr><tr>
		<td class="hell" colspan="2">
				<input type="text" name="Uvorname" size="35" maxlength="40" value="',$Daten{"Uvorname"},'"/>
				<br><div class="comment">Vorname</div>
		</td>
		<td class="hell">
				<input type="text" name="Ubedarfsgemeinschaft" size="35" maxlength="40" value="',$Daten{"Ubedarfsgemeinschaft"},'" />
				<br><div class="comment">Nummer der Bedarfsgemeinschaft</div>
		</td>
		</tr><tr>
		<td class="hell" colspan="2">
				<input type="text" name="Unachname" size="35" maxlength="40" value="',$Daten{"Unachname"},'"/>
				<br><div class="comment">Nachname</div>
		</td>
		<td class="hell">
				<input type="checkbox" name="Ukleinunternehmer" size="25" maxlength="35" value=1 ',$Klein,'/>
				Kleinunternehmer nach &sect; 19 UstG
		</td>
		</tr><tr>
		<td class="hell" colspan="2">
				<input type="text" name="Ugeboren" size="10" maxlength="10" value="',$Daten{"Ugeboren"},'" onChange=datum("Ugeboren",1,0) />
				<br><div class="comment">Geburtsdatum</div>
		</td>
		<td class="hell" rowspan="4" />
		</tr><tr>
		<td class="hell" colspan="2">
				<input type="text" name="Ufirma" size="35" maxlength="40" value="',$Daten{"Ufirma"},'"/>
				<br><div class="comment">Firma</div>
		</td>
		</tr><tr>
		<td class="hell" colspan="2">
				<input type="text" name="Ustrasse" size="35" maxlength="40" value="',$Daten{"Ustrasse"},'"/>
				<br><div class="comment">Stra&szlig;e, Hausnummer</div>
		</td>
		</tr><tr>
		<td class="hell" width="67px">
				<input type="integer" name="Uplz" size="5" maxlength="5" value="',$Daten{"Uplz"},'" />
				<br><div class="comment">PLZ</div>
		</td>
		<td class="hell">
				<input type="text" name="Ustadt" size="25" maxlength="35" value="',$Daten{"Ustadt"},'" align="right" />
				<br><div class="comment">Stadt</div>
		</td>
		</tr><tr>
		<td class="hell" colspan="5">
				&nbsp;
		</td>
		</tr>
	</table>
	<TABLE cellpadding="0" cellspacing="0" align="center" width="1000">
		<tr>
			<td class="hell" width="90px" rowspan=2>
				&nbsp;
			</td>
			<td class="hell">
			<table cellpadding="0" cellspacing="0" align="center">
				<tr>
					<td class="hell" colspan=3><h3>Folgende Konten sollen verwendet werden:</h3></td>
					<td class="hell"><b>gegl&auml;ttet:<b></td>
				</tr>
				<tr>
					<td class="hell" colspan=4>&nbsp;</td>
				</tr>';

				
   my @Liste = @{Form::Auslesen("../data/$Datei")};
   my @Vorjahresliste = (length($Datei_vorjahr)>0)? @{Form::Auslesen("../data/$Datei_vorjahr")} : "";
   foreach (@Vorjahresliste) {
	push(@Liste, $_."\n");
	}
   my @Privatliste = (length($Datei_privat)>0)? @{Form::Auslesen("../data/$Datei_privat")} : "";
   foreach (@Privatliste) {
	push(@Liste, $_."\n");
	}
   my @Vorjahresprivatliste = (length($Datei_vorjahr_privat)>0)? @{Form::Auslesen("../data/$Datei_vorjahr_privat")} : "";
   foreach (@Vorjahresprivatliste) {
	push(@Liste, $_."\n");
	}
 

   my @Konto;
   for(my $i=0;$i<=$#Liste;$i++) {
        $Liste[$i]=~s/&minus;/-/g; # Bug workarround;
        my @Zeile = split(/#:#/, $Liste[$i]);
		my $E=int($Zeile[5]/100);
		my $Esub=substr($Zeile[5], 4, 2)*1;
		    # 4360 ohne Einschränkung "privat", weil immer mit Liste aus $Datei_privat zusammen
		if( $E==1592 or $E==2307 or $E==2309 or $E==4165 or $E==4360 or $E==4520 or $E==4540 or $E==4997 or $E==8600 ) {
			$Konto[$E][$Esub]+=Form::Zahl($Zeile[10]);
			}
		else {
			$Konto[$E]+=Form::Zahl($Zeile[10]);
			}
		my $B=int($Zeile[11]*1/100); 
		my $U=int($Zeile[13]*1/100); ;
		if( $Zeile[4] eq "E" ) {
			#Zaehlung fuer $Name einheitlich positiv
			$Konto[$B]+=Form::Zahl($Zeile[8]);
		} else {
			$Konto[$B]-=Form::Zahl($Zeile[8]);
			}
		$Konto[$U]+=Form::Zahl($Zeile[15]);
        }
	

   my @Konten=@{Form::Auslesen("../data/$Name.cfg")};

   # Ist schon eine Kontenvorauswahl gespeichert?
   my $Vorauswahl=0;
   if ( -e "../settings/$Name.cfg" ) {
	%Daten=%{Form::Auslesen_Spiegel("../settings/$Name.cfg", "A", "")};
	if( keys(%Daten)>0 ) { $Vorauswahl=1; }
	}

   # Nur Konten, die in Kontenliste gesch/privat vorgewaehlt sind und deren Inhalt groesser "0" ist
   my $Betrag=0;
   foreach (@Konten) {
	my @Werte=split("#:#", $_);
	$Werte[0]=substr( $Werte[0], 1, length($Werte[0]) );
	my $k=int($Werte[0]/100);
	my $ksub=substr($Werte[0], 4, 2)*1;
	if( $k==1592 or $k==2307 or $k==2309 or $k==4165 or $k==4360 or $k==4520 or $k==4540 or $k==4997 or $k==8600 ) {
#	if( $ksub>0 or $k==1592 or $k==2307 or $k==2309 or $k==4540 or $k==4997 or $k==8600) {
		$Betrag=Form::Zahl($Konto[$k][$ksub]); }
	else  { $Betrag=Form::Zahl($Konto[$k]); }
	if( ($Werte[4] or $Werte[5]) and ($Betrag!=0) ) {  
		my $Achecked=($Daten{"B".$Werte[0]} || !($Vorauswahl))? "checked" : "";
		my $Gchecked=($Daten{"G".$Werte[0]})? "checked" : "";
		$Werte[1] =~ s/VorSt./Abziehbare Vorsteuer/g;      #Selbst eingefuehrte Abkuerzungen ausschreiben
		$Werte[1] =~ s/UmSt./Umsatzsteuer/g;
		print '
				<tr>
					<td class="hell">&nbsp;',$Werte[0],'&nbsp;</td>
					<td class="hell">&nbsp;',$Werte[1],'&nbsp;</td>
					<td class="hell">&nbsp;<input type="checkbox" name="B',$Werte[0],'" value="1" ',$Achecked,'></td>
					<td class="hell" align="right"><input type="checkbox" name="G',$Werte[0],'" value="1" ',$Gchecked,'>&nbsp;</td>
				</tr>';
		}
	}

   print '
				<tr>
					<td colspan="4" align="right">
						<input type="button" value=" Alle zur&uuml;cksetzen " onClick="selectbox(0)" style="font-size:x-small;" />&nbsp;
						<input type="button" value=" Alle ausw&auml;hlen " onClick="selectbox(1)" style="font-size:x-small;" />&nbsp;
					</td>
				</tr>
				<tr>
					<td colspan="4">&nbsp;
					</td>
				</tr>
			</table>
			</td>
			<td class="hell" width="90px" rowspan="2">
				&nbsp;
			</td>
		</tr>
		<tr>
			<td>
			<table cellpadding="4" cellspacing="0" align="center">
				<tr>
					<td class="hell" colspan=10><b>F&uuml;r folgende Buchungen ist eine Zuordnung zwischen Betriebsausgaben im eigentlichen Sinn und <a href="../hints/hinweis_sgb2einkommen.html" onclick="HinweisOeffnen(this.href); return false">Brutto des bereinigten Einkommens</a> n&ouml;tig:<b></td>
				</tr>
				<tr>
					<td class="hell">&nbsp;</td>
				</tr>
			</table>
			<table cellpadding="0" cellspacing="0" align="center" class="List">
				<tr>
					<TH class="rahmen">Eing.</TH><TH class="rahmen">Anz.</TH><TH class="rahmen">Datum</TH><TH class="rahmen">Beleg</TH><TH class="rahmen">Art</TH><TH class="rahmen">B/E-Konto</TH><TH class="rahmen">Bezeichnung</TH><TH class="rahmen">Buchungstext</TH><TH class="rahmen">Betrag</TH><TH class="rahmen">inkl.</TH><TH class="rahmen">netto</TH>
					<td class="hell" align=bottom><b>&nbsp;privat&nbsp;<b></td>
					<td class="hell" align=bottom><b>&nbsp;betriebl.&nbsp;<b></td>
					<td class="hell" align=bottom><b>&nbsp;Verh&auml;l.&nbsp;<b></td>
				</tr>
';


#  Einstellungen fuer Input-Felder, vorerst keine Deklaraton fuer TD
   my @Width = qw( 2 2 9 2 2 6 20 35 7 1 7); 
   my @Align = qw( center center center center center center left left right center); 

   my @Zeilen;
   my $Anzeige=0;
   my $y=0;
   my $z;
    for (my $i=0; $i<=$#Liste; $i++) {
	$z=0;
	my @Zeile=split("#:#", $Liste[$i]);
	#Stnachzahl. Vorj. v. Einkomm und Ertrag
	if( $Zeile[5] eq "228000" || $Zeile[5] eq "228200" ) { $z=1; }
	#Versicherungen
	if( $Zeile[5] eq "436000" ) { $z=2; }
	#Kfz-Versicherungen
	if( $Zeile[5] eq "452000" ) { $z=3; }
	#Fahrten Whg-Betrieb (abziehbarer Teil) hier komplett gestrichen
	#if( $Zeile[5] eq "467800" || $Zeile[5] eq "468000"  ) { $z=4; }
	#Reisekosten Unternehmer
	if( $Zeile[5] eq "467000" || $Zeile[5] eq "467400" ) { $z=4; }
	#Reisekosten Untern. &Uuml;bernachtungsaufwand
	if( $Zeile[5] eq "467600" ) { $z=5; }
	#Telefon & Telefax
	if( $Zeile[5] eq "492000" || $Zeile[5] eq "492500" ) { $z=6; }
	#Privatkonten Telefon & DSL
	if( $Zeile[5] eq "230908" ) { $z=7; }
	#Privatkonten Einkommensteuer
	if( $Zeile[5] eq "228050" ) { $z=8; }
	#Privatkonten gesetzliche KV PV RV
	if( $Zeile[5] eq "413050" ) { $z=9; }
	#Privatkonten private KV
	if( $Zeile[5] eq "415050" ) { $z=10; }
	#Privatkonten Rente - Achtung, dieses Konto is ambivalent!
	if( $Zeile[5] eq "416500" ) { $z=11; }
	#Privatkonten RV, Kapitallebensversicherung, Versorgungswerk (sofern nicht 416503, wo Zuordnung als privat klar)
	if( $Zeile[5] eq "416501" || $Zeile[5] eq "416502" || $Zeile[5] eq "416503" ) { $z=12; }
	#Privatkonten Versorgungswerk (sofern nicht Konto 416503 verwendet, wo Zuordnung als privat klar)
	if( $Zeile[5] eq "416000" ) { $z=13; }
	#Privatkonten Kfz-Haftpflicht 
	if( $Zeile[5] eq "452001" ) { $z=14; }
	#Privatkonten Versicherungen, Berufshaftpflicht - Achtung, dieses Konto is ambivalent!
	if( $Zeile[5] eq "436000" || $Zeile[5] eq "436001" ) { $z=15; }
	#Privatkonten Privathaftpflicht
	if( $Zeile[5] eq "436002" ) { $z=16; }
	#Privatkonten Riester
	if( $Zeile[5] eq "416504" ) { $z=17; }
	#Privatkonten Abgrenzungsposten SGB III und BAfoeG
	if( $Zeile[5] eq "416100" ) { $z=18; }
	#Privatkonten titulierter Unterhalt
	if( $Zeile[5] eq "412810" ) { $z=19; }

	$Daten{"Beginn"} = (length($cgi->param("Start1"))>0)? $Monat[$cgi->param("Start1")][1] : 0 ; #(Jahr 1970)
        $Daten{"Ende"}   = (length($cgi->param("Start1"))>0)? $Monat[($cgi->param("Start1")+5)][2] : 2840043600; #(Jahr 2060)
        
	if( length($Liste[$i])>0 && $z>0 && Form::Zeit($Zeile[2])>=$Daten{"Beginn"} && Form::Zeit($Zeile[2])<$Daten{"Ende"} ) {
		$y++;
		my $Farbe;
		if(  $z < 7 ) { $Farbe = ( $z % 2 )?  "dunkel" : "hell"; }
		else          { $Farbe = ( $z % 2 )?  "#fff072" : "#e2cb0c"; }
		$Zeilen[$z].= '		<TR class='.$Farbe.'>
			';
		for (my $k=0; $k<=10; $k++) {                           # Zeile auswerfen
			$Zeilen[$z].= '<TD><INPUT TYPE="TEXT" SIZE="'.$Width[$k].'" VALUE="'.$Zeile[$k].'" class="'.$Farbe.'" style="text-align:'.$Align[$k].'"></TD>';
			}
		
#		my $Pchecked=($Daten{"C".$Zeile[1]."_privat"})? " checked" : "";  fuehrt zu Rechenfehlern, weil Zielfeld jahresCXa nicht mituebergeben wird
		my $Bchecked=($Daten{"C".$Zeile[1]."_betrieb"})? "checked" : "";
		$Zeilen[$z].= '
			<TD class="hell" align=center><input type="checkbox" name="C'.$Zeile[1].'_privat" value="1"  onClick="this.name[0].disabled==false;" onClick=javascript:selectedaccount(this.name); onChange=javascript:selectaccount("C'.$Zeile[1].'","'.$Zeile[5].'",'.Form::Zahl($Zeile[8]).',"privat","'.$Zeile[2].'")></TD>
			<TD class="hell" align=center><input type="checkbox" name="C'.$Zeile[1].'_betrieb" value="1" '.$Bchecked.' onClick=javascript:selectedaccount(this.name); onChange=javascript:selectaccount("C'.$Zeile[1].'","'.$Zeile[5].'",'.Form::Zahl($Zeile[8]).',"betrieb","'.$Zeile[2].'")></TD>
			<TD class="hell" align=center><input type="text" SIZE="2" name="C'.$Zeile[1].'_verh" value="'.$Daten{"C".$Zeile[1]."_verh"}.'" onClick=javascript:selectedaccount(this.name); onChange=javascript:selectaccount("C'.$Zeile[1].'","'.$Zeile[5].'",'.Form::Zahl($Zeile[8]).',"verh","'.$Zeile[2].'")></TD>
		</TR>
';		}
	}
   for (my $i=1; $i<=19; $i++) {
	#if( lenghth($Zeilen[$i])>0 ) {
	if( $Zeilen[$i] && length($Zeilen[$i])>0 ) {
		print $Zeilen[$i]; 
		}
	}
   

   print '			</table>
			</td>
		</tr>
	</TABLE>
';
   # Sichere Daten vorab vorgeben
   $Daten{"jahresC4g"}||=$Konto[416503]; # Versorgungswerk
   
   print @{Form::HTML("account6mstate", \%Daten)};

  print '
  <TABLE cellpadding=10 cellpadding="0" cellspacing="0" align="center" width="1000">
		<TR>
			<td class="hell" colspan="3">
				&nbsp;
			</td>
		</TR>
		<TR>
			<td class="hell" width="70px" rowspan=3>
				&nbsp;
			</td>
			<td class="hell">
				<input type="checkbox" name="vorhanden" value="1" onChange=kfz()> Ich f&uuml;hre ein <select name="Ukfz" onChange=document.as.vorhanden.checked=true,kfz();><option value="betrieb">betriebliches<option value="privat">privates</select> Kraftfahrzeug, das ich bei <input type="text" name="Ukm" value="',$Daten{"Ukm"},'" size=5 maxsize=10 style="text-align:right"> km insgesamt <span name="kfztext">&nbsp;</span>
				<div name="kfzkm"></div>
			</td>
			<td class="hell" width="70px" rowspan=3>
				&nbsp;
			</td>
		</TR>
		<TR>
			<td class="hell">
				&nbsp;
			</td>
		</TR>
		<TR>
			<td class="auswahl" align="center">
				<h4>Eigener Dateiname (fakultativ)</h4>
				<input type="file" name="Dateiname"  size="35" maxlength="100000" accept="*.odt" onChange=javascript:inputfile("Dateiname","Zielpfad","Zieldatei"); >
				<br>Pfad: <input type="text" name="Zielpfad"  size="10" value="../data" />
				Datei: <input type="text" name="Zieldatei" size="20" value="',$Daten{"Zieldatei"},'" />
			</td>
		</TR>
		<TR>
			<td class="hell" colspan="3">
				&nbsp;
			</td>
		</TR>
	</TABLE>

	<TABLE cellpadding=10 align="center" width="1000">
		<TR>
		<TD align="right">
			<input type="button" value="  Erstellen  " onClick="javascript:Name_vorjahr.value=0,submit()" class="button">
		</TD>
		</TR>
	</TABLE>
	<INPUT TYPE="hidden" name="Datei" value="',$Datei,'">
	<INPUT TYPE="hidden" name="Name" value="',$Name,'">
	<INPUT TYPE="hidden" name="Datei_vorjahr" value="',$Datei_vorjahr,'">
	<INPUT TYPE="hidden" name="Name_vorjahr" value="',$Name_vorjahr,'">
	</FORM>
';

   print qq~<BR><BR>
   <BODY>
   <HTML>~;

########################################################################################
} else {
########################################################################################

   my  @Feldnamen       = $cgi->param();                    # fuer Aufruf aus account.pl POST-Methode (Stufe2)

   # Anfangswerte bei fehlender Eingabe setzen
   my $Start = ( $cgi->param("Start1") ne "")? $cgi->param("Start1") : 5;

   #Fruehere Auswahl einlesen
   my %Auswahl=%{Form::Auslesen_Spiegel("../settings/$Name.cfg", "[BCGSU]", "")};
   foreach (keys (%Auswahl)) {
	$Daten{$_}=$Auswahl{$_};
	}

   # Formulardaten mit cgi-Modul (POST) ermitteln und mit ihnen alte $Daten ueberschreiben
   my  %Auswahlkonten;
   foreach my $Feld (@Feldnamen) {
	if( $Feld =~ m/^B/ ) {
		$Daten{$Feld} = 1;                             # fuer $Name.cfg
		my $Kurzfeld = $Feld;
		$Kurzfeld =~ s/^B//g;
		$Kurzfeld*=1;
		$Auswahlkonten{$Kurzfeld} = $cgi->param($Feld);
	} else  {	
		$Daten{$Feld}  = Form::utf82html(encode("utf8",$cgi->param($Feld)));
		}
   }

   #Fruehere Schluessel anhaengen
   foreach (keys (%Auswahl)) {
	push(@Feldnamen, $_);
	$Daten{$_}=$Auswahl{$_};
	}

   @Feldnamen=sort(@Feldnamen);
   #Getroffene Kontauswahl abspeichern (kann immer geaendert werden)
   Form::Speichern_Spiegel(\@Feldnamen, \%Daten, "../settings/$Name.cfg", "[ACBGSU]");

   # Betriebs- unbd Privatkilometer aus Eingaben ermitteln, wenn Auto vorhanden
   if( !$Daten{"vorhanden"} ) {
	$Daten{"betriebkm"}=0;
	$Daten{"privatkm"}=0;
	}
   elsif( $Daten{"Ukfz"} eq "privat" ) {
	for(my $i=0;$i<6;$i++) {
		$Daten{"betriebkm"}+=Form::Zahl($Daten{"km".$i});
		}
	$Daten{"privatkm"}=Form::Zahl($Daten{"Ukm"})-$Daten{"betriebkm"};
	}
   elsif( $Daten{"Ukfz"} eq "betrieb" ) {
	for(my $i=0;$i<6;$i++) {
		$Daten{"privatkm"}+=Form::Zahl($Daten{"km".$i});
		}
	$Daten{"betriebkm"}=Form::Zahl($Daten{"Ukm"})-$Daten{"privatkm"};
	}




   my @Liste=@{Form::Auslesen("../data/$Datei")};
   my @Vorjahresliste = (length($Datei_vorjahr)>0)? @{Form::Auslesen("../data/$Datei_vorjahr")} : "";
   foreach (@Vorjahresliste) {
	push(@Liste, $_."\n");
	}
   # Liste umstellen und nach Datum sortieren
   my @NeueListe;
   for(my $i=0;$i<$#Liste;$i++) {  # nicht <= dies naehme Leerzeile am Ende mit
        $Liste[$i]=~s/&minus;/-/g; # Bug workarround;
        my @Zeile = split(/#:#/, $Liste[$i]);
	foreach (@Zeile) { 
		$_=~ s/\n//g;
		if( $_ =~ /^\d\d\.\d\d\.\d\d\d\d*/ ) { $_=Form::Zeit($_); }
		} 
	my $NeueZeile = $Zeile[2]."#:#".$Zeile[0]."#:#".$Zeile[1]."#:#";
	for(my $i=3;$i<=14;$i++) { $Zeile[$i]||=""; $NeueZeile.=$Zeile[$i]."#:#"; } 
	$NeueZeile.=$Zeile[15]."\n";
	push(@NeueListe, $NeueZeile);
	}
	
   @Liste=sort(@NeueListe);


   # Monatsnamen
   for(my $i=1;$i<7;$i++) {
	my $Zahl = $i-1+$Daten{"Ziel1"}*1;
	$Daten{"0,".$i}=$Monat[$Zahl][0];
	}
   for(my $i=0;$i<=4;$i++) {
	$Daten{(37+$i)."Bez"}="";
	}

   print "Content-type: text/html\n\n";
   print '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
       "http://www.w3.org/TR/html4/loose.dtd">

<HTML>
<HEAD>  <TITLE>Lawsuit - JC-Auswertung</TITLE>

	<link rel="icon" href="../favicon.ico" type="image/x-icon">
	<link rel="stylesheet" type="text/css" href="../stylesheets/lawsuit.css">
	<link rel="stylesheet" type="text/css" href="../stylesheets/',$Css,'.css">
</HEAD>
<BODY class="grund">

<BR><BR><BR>


	<TABLE cellpadding="50" cellspacing="0" align="center" width="600">
		<TR>
		<TD class="hell" align="left">
';

   my @Betriebskosten;
   $Daten{"kmbetrieblich"}=0; $Daten{"kmprivat"}=0; 
   my %Legende;
   for(my $i=0;$i<=$#Liste;$i++) {
        my @Zeile = split(/#:#/, $Liste[$i]);
		for(my $k=1;$k<7;$k++) {
			if( $Zeile[0]>=$Monat[$k-1+$Start][1] && $Zeile[0]<=$Monat[$k-1+$Start][2] && $Auswahlkonten{($Zeile[5]*1)} ) {
				if( length($Zeile[5])<1 ) { $Zeile[5] = 0; } #debug 
				if( length($Zeile[13])<1 ) { $Zeile[13] = 0; } #debug 
				#Einnahmen
				my $Eglatt=($Daten{"G".($Zeile[5]*1)})?  "glatt" : "";
				my $Uglatt=($Daten{"G".($Zeile[13]*1)})? "glatt" : "";
				if( (($Zeile[5]*1)>=810000 && ($Zeile[5]*1)<=854000) || (($Zeile[5]*1)>=880000 && ($Zeile[5]*1)<=882900) )  {
					$Daten{"1.".$k.$Eglatt}+=Form::Zahl($Zeile[10]); $Legende{$Zeile[5]}=$Zeile[6]; }
				if( ($Zeile[5]*1)>=890000 && ($Zeile[5]*1)<=899000 ) {
					$Daten{"2.".$k.$Eglatt}+=Form::Zahl($Zeile[10]); 
					$Daten{"6.".$k.$Uglatt}+=Form::Zahl($Zeile[15]); $Legende{$Zeile[5]}=$Zeile[6]; }	
				elsif( (($Zeile[13]*1)>=176000 && ($Zeile[13]*1)<=177800) || (($Zeile[13]*1)>=178400 && ($Zeile[13]*1)<=179900) ) {
					$Daten{"5.".$k.$Uglatt}+=Form::Zahl($Zeile[15]); $Legende{$Zeile[5]}=$Zeile[6]; }	
				if( ( ($Zeile[5]*1)>=859000 && ($Zeile[5]*1)<=860000 ) || ( ($Zeile[5]*1)>=861000 && ($Zeile[5]*1)<=865000 ) || ( ($Zeile[5]*1)>=250000 && ($Zeile[5]*1)<=279600 ) ) {	
					$Daten{"3.".$k.$Eglatt}+=Form::Zahl($Zeile[10]); $Legende{$Zeile[5]}=$Zeile[6]; }
				if( ($Zeile[5]*1)==155000 ) {
					my $Faktor=($Zeile[4] eq "E")? 1 : -1;
					$Daten{"4.".$k.$Eglatt}+=Form::Zahl($Zeile[10])*$Faktor; $Legende{$Zeile[5]}=$Zeile[6]; }
				if( ( (($Zeile[5]*1)>=170600 && ($Zeile[5]*1)<=170800) || (($Zeile[5]*1)>=170900 && ($Zeile[5]*1)<=173200) ) && $Zeile[4] eq "E" ) { #A4
					$Daten{"4.".$k.$Eglatt}+=Form::Zahl($Zeile[10]); $Legende{$Zeile[5]}=$Zeile[6]; }	
#				if( ( ($Zeile[5]*1)>=217000 && ($Zeile[5]*1)<=217600 ) || ( ($Zeile[5]*1)>=430000 && ($Zeile[5]*1)<=430600 ) 
#				      || ($Zeile[5]*1)==228700 || ($Zeile[5]*1)==360000 ) {
				if( ($Zeile[5]*1)==895500 ) {
					$Daten{"7.".$k.$Eglatt}+=Form::Zahl($Zeile[10]); }	
				if( (($Zeile[5]*1)>=63000 && ($Zeile[5]*1)<=99000) || (($Zeile[5]*1)>=160000 && ($Zeile[5]*1)<=170000) ) {
					$Daten{"8.".$k.$Eglatt}+=Form::Zahl($Zeile[10]); $Legende{$Zeile[5]}=$Zeile[6]; }	
				#Ausgaben
				if( ((($Zeile[5]*1)>=320000 && ($Zeile[5]*1)<=355900) || (($Zeile[5]*1)>=396000 && ($Zeile[5]*1)<=400000) || (($Zeile[5]*1)>=700000 && ($Zeile[5]*1)<=714000) ) && $Zeile[4] eq "A" ) {
					$Daten{"10.".$k.$Eglatt}+=Form::Zahl($Zeile[10]); $Legende{$Zeile[5]}=$Zeile[6]; }	
				# nicht spezifizierte Lohnbestandteile spaeter verteilen
				if( ($Zeile[5]*1)==410000 || ($Zeile[5]*1)==413000 || (($Zeile[5]*1)>=413800 && ($Zeile[5]*1)<=419900) || ($Zeile[5]*1)==494600 ) {
					$Daten{"9.".$k.$Eglatt}+=Form::Zahl($Zeile[10]); $Legende{$Zeile[5]}=$Zeile[6]; }	
				if( ($Zeile[5]*1)==410100 || ($Zeile[5]*1)==413100 ) {
					$Daten{"11.".$k.$Eglatt}+=Form::Zahl($Zeile[10]); $Legende{$Zeile[5]}=$Zeile[6]; }	
				if( ($Zeile[5]*1)==410200 || ($Zeile[5]*1)==413200 ) {
					$Daten{"12.".$k.$Eglatt}+=Form::Zahl($Zeile[10]); $Legende{$Zeile[5]}=$Zeile[6]; }	
				if( ($Zeile[5]*1)==410300 || ($Zeile[5]*1)==413300 ) {
					$Daten{"13.".$k.$Eglatt}+=Form::Zahl($Zeile[10]); $Legende{$Zeile[5]}=$Zeile[6]; }	
				if( ($Zeile[5]*1)==410400 || ($Zeile[5]*1)==413400 ) {
					$Daten{"14.".$k.$Eglatt}+=Form::Zahl($Zeile[10]); $Legende{$Zeile[5]}=$Zeile[6]; }	
				if( ($Zeile[5]*1)>=420000 && ($Zeile[5]*1)<=428900 ) {
				#if( ($Zeile[5]*1)==421000 || ($Zeile[5]*1)==424000 ) {
					$Daten{"15.".$k.$Eglatt}+=Form::Zahl($Zeile[10]); $Legende{$Zeile[5]}=$Zeile[6]; }	
				if( (($Zeile[5]*1)==436000 && $Daten{"C".$Zeile[2]."_betrieb"}) || ($Zeile[5]*1)==438000 ) { #B4
					$Daten{"16.".$k.$Eglatt}+=Form::Zahl($Zeile[10]); $Legende{$Zeile[5]}=$Zeile[6]; }	
				if( ($Zeile[5]*1)==451000 && $Daten{"Ukfz"} eq "betrieb") {
					$Daten{"17.".$k.$Eglatt}+=Form::Zahl($Zeile[10]); $Legende{$Zeile[5]}=$Zeile[6]; }	
				if( ($Zeile[5]*1)==452000 && $Daten{"Ukfz"} eq "betrieb") {
					$Daten{"18.".$k.$Eglatt}+=Form::Zahl($Zeile[10]); $Legende{$Zeile[5]}=$Zeile[6]; }	
				if( (($Zeile[5]*1)==453000 || ($Zeile[5]*1)==450000) && $Daten{"Ukfz"} eq "betrieb") {
					$Daten{"19.".$k.$Eglatt}+=Form::Zahl($Zeile[10]); $Legende{$Zeile[5]}=$Zeile[6]; }	
				if( (($Zeile[5]*1)==454000 || ($Zeile[5]*1)==467000) && $Daten{"Ukfz"} eq "betrieb") {
					$Daten{"20.".$k.$Eglatt}+=Form::Zahl($Zeile[10]); $Legende{$Zeile[5]}=$Zeile[6]; }	
				if( ($Zeile[5]*1)>=460000 && ($Zeile[5]*1)<=465300 ) {
					$Daten{"23.".$k.$Eglatt}+=Form::Zahl($Zeile[10]); $Legende{$Zeile[5]}=$Zeile[6]; }	
				if( ($Zeile[5]*1)==466600  || ($Zeile[5]*1)==467600 ) {
					$Daten{"24.".$k.$Eglatt}+=Form::Zahl($Zeile[10]); $Legende{$Zeile[5]}=$Zeile[6]; }	
				if( ($Zeile[5]*1)==466400 || ($Zeile[5]*1)==467400 || ($Zeile[5]*1)==466500  || ($Zeile[5]*1)==467500 ) {
					$Daten{"25.".$k.$Eglatt}+=Form::Zahl($Zeile[10]); }	
				if( ($Zeile[5]*1)==466700  || ($Zeile[5]*1)==467700 ) {
					$Daten{"26.".$k.$Eglatt}+=Form::Zahl($Zeile[10]); $Legende{$Zeile[5]}=$Zeile[6]; }	
				if( ($Zeile[5]*1)>=1000 && ($Zeile[5]*1)<=60000 && ($Zeile[5]*1)!=42100 && ($Zeile[5]*1)!=43100) { #B8
					$Daten{"27.".$k.$Eglatt}+=Form::Zahl($Zeile[10]); $Legende{$Zeile[5]}=$Zeile[6]; }	
				if( ($Zeile[5]*1)==42100 || ($Zeile[5]*1)==43100 || ($Zeile[5]*1)==61000 ) { #B9
					$Daten{"28.".$k.$Eglatt}+=Form::Zahl($Zeile[10]); $Legende{$Zeile[5]}=$Zeile[6]; }	
				if(  ($Zeile[5]*1)==471000 || ($Zeile[5]*1)==491000 || (($Zeile[5]*1)>=493000 && ($Zeile[5]*1)<=494000) ) { #B10
					$Daten{"29.".$k.$Eglatt}+=Form::Zahl($Zeile[10]); $Legende{$Zeile[5]}=$Zeile[6]; }	
				if( ($Zeile[5]*1)>=492000 && ($Zeile[5]*1)<=492500 ) {
					if ( $Daten{"C".$Zeile[2]."_privat"} ) {
						$Daten{"30.".$k.$Eglatt}+=Form::Zahl($Zeile[10])/2; }	
					elsif( $Daten{"C".$Zeile[2]."_betrieb"} ) {
						$Daten{"30.".$k.$Eglatt}+=Form::Zahl($Zeile[10]); }
					$Legende{$Zeile[5]}=$Zeile[6]; }	
				if( ($Zeile[5]*1)>=495000 && ($Zeile[5]*1)<=495500 ) {
					$Daten{"31.".$k.$Eglatt}+=Form::Zahl($Zeile[10]); $Legende{$Zeile[5]}=$Zeile[6]; }
				if( ($Zeile[5]*1)==494500 || ($Zeile[5]*1)==495700 ) {
					$Daten{"32.".$k.$Eglatt}+=Form::Zahl($Zeile[10]); $Legende{$Zeile[5]}=$Zeile[6]; }
				if( ($Zeile[5]*1)==426000 || ($Zeile[5]*1)==454001 || ($Zeile[5]*1)==478000 || ($Zeile[5]*1)==480900 ) { #B14a
					$Daten{"33.".$k.$Eglatt}+=Form::Zahl($Zeile[10]); $Legende{$Zeile[5]}=$Zeile[6]; }
				if( (($Zeile[5]*1)>=481000 && ($Zeile[5]*1)<=481500) || ($Zeile[5]*1)==496000 ) { #B14b
					$Daten{"34.".$k.$Eglatt}+=Form::Zahl($Zeile[10]); $Legende{$Zeile[5]}=$Zeile[6]; }
				if( ($Zeile[5]*1)==497000 ) { #B14c
					$Daten{"35.".$k.$Eglatt}+=Form::Zahl($Zeile[10]); $Legende{$Zeile[5]}=$Zeile[6]; }	
				if( ($Zeile[5]*1)==427500 ) { #B14d
					$Daten{"36.".$k.$Eglatt}+=Form::Zahl($Zeile[10]); $Legende{$Zeile[5]}=$Zeile[6]; }	
                # Weitere Ausgaben in freien Tabellenzeilen auflisten
				if( ($Zeile[5]*1)==100 || (($Zeile[5]*1)>=96000 && ($Zeile[5]*1)<=98600) || (($Zeile[5]*1)>=200000 && ($Zeile[5]*1)<=202000) || ($Zeile[5]*1)==380000 || ($Zeile[5]*1)==385000 || (($Zeile[5]*1)>=300000 && ($Zeile[5]*1)<=310000) || (($Zeile[5]*1)>=425000 && ($Zeile[5]*1)<=435500) || (($Zeile[5]*1)>=437000 && ($Zeile[5]*1)<=439700) || (($Zeile[5]*1)>=454001 && ($Zeile[5]*1)<=458000) || ($Zeile[5]*1)==470000 || (($Zeile[5]*1)>=473000 && ($Zeile[5]*1)<=490900) || (($Zeile[5]*1)>=498000 && ($Zeile[5]*1)<=499700) || (($Zeile[5]*1)>=870000 && ($Zeile[5]*1)<=879000) ) {
					my $found=0;
					# Zu vorhandender Betreibskostenzeile addieren
					for(my $i=0;$i<=$#Betriebskosten; $i++) {
						if( $Betriebskosten[$i]==($Zeile[5]*1) ) {
							$Daten{(37+$i).".".$k.$Eglatt}+=Form::Zahl($Zeile[10]); 
							$found=1; }
						}
                    # Neue Betriebskostenzeile aufsetzen
					if( $found==0 ) {
						push(@Betriebskosten,($Zeile[5]*1));
						$Daten{(37+$#Betriebskosten)."Bez"}=Form::html2utf8($Zeile[6]);
						$Daten{(37+$#Betriebskosten).".".$k.$Eglatt}=Form::Zahl($Zeile[10]);
						}
					$Legende{$Zeile[5]}=$Zeile[6]; }
				if( ($Zeile[5]*1)==212100 ) { 
					$Daten{"42.".$k.$Eglatt}+=Form::Zahl($Zeile[10]); $Legende{$Zeile[5]}=$Zeile[6]; }	
				if( ($Zeile[5]*1)>=210000 && ($Zeile[5]*1)<=216500 ) {
					$Daten{"43.".$k.$Eglatt}+=Form::Zahl($Zeile[10]); $Legende{$Zeile[5]}=$Zeile[6]; }	
				if( ( (($Zeile[5]*1)>=170600 && ($Zeile[5]*1)<=170800) || (($Zeile[5]*1)>=170900 && ($Zeile[5]*1)<=173200) ) && $Zeile[4] eq "A" )  { #B16
					$Daten{"43.".$k.$Eglatt}+=Form::Zahl($Zeile[10]); $Legende{$Zeile[5]}=$Zeile[6]; }	
				if( ($Zeile[13]*1)>=155600 && ($Zeile[13]*1)<=158900 ) {
					$Daten{"44.".$k.$Uglatt}+=Form::Zahl($Zeile[15]); $Legende{$Zeile[13]}=$Zeile[14];  }	
				if( (($Zeile[5]*1)>=178000 && ($Zeile[5]*1)<=179100 )  ) { 
					$Daten{"45.".$k.$Eglatt}+=Form::Zahl($Zeile[10]); $Legende{$Zeile[5]}=$Zeile[6];  }	
			}
		}
	}

   #Kilometerpauschalen ausrechnen
   for(my $k=1;$k<7;$k++) {
				if( $Daten{"vorhanden"} && $Daten{"Ukfz"} eq "betrieb") {
					$Daten{"21.".$k}=-1*Form::Zahl($Daten{"km".($k-1)})*0.1; 
					$Daten{"kmprivat"}+=Form::Zahl($Daten{"km".($k-1)}); }
				if( $Daten{"vorhanden"} && $Daten{"Ukfz"} eq "privat" ) {
					$Daten{"22.".$k}+=$Daten{"km".($k-1)}*0.1; 
					$Daten{"kmbetrieblich"}+=Form::Zahl($Daten{"km".($k-1)}); 
					}
			}
   #Gesamtfahrtenkilometer betrieblich oder privat zuordnen
   if( $Daten{"Ukfz"} eq "privat" ) {
	$Daten{"kmprivat"} = Form::Zeigezahl(Form::Zahl($Daten{"Ukm"})-$Daten{"kmbetrieblich"}); 
	$Daten{"kmbetrieblich"} = Form::Zeigezahl($Daten{"kmbetrieblich"}); }
	else {
	$Daten{"kmbetrieblich"} = Form::Zeigezahl(Form::Zahl($Daten{"Ukm"})-$Daten{"kmprivat"}); 
	$Daten{"kmprivat"} = Form::Zeigezahl($Daten{"kmprivat"}); }

	
   #Weitere Arbeitnehmerkosten aus unsichtbarer Zeile 9 akkumulieren auf jeweils ersten Arbeitnehmer
   my $Zielzeile=100;
   for(my $k=1;$k<7;$k++) {
   	if( $Daten{"14".$k."glatt"} || $Daten{"14".$k} ) { unless( $Zielzeile<14) { $Zielzeile=14; } }
   	if( $Daten{"13".$k."glatt"} || $Daten{"13".$k} ) { unless( $Zielzeile<13) { $Zielzeile=13; } }
   	if( $Daten{"12".$k."glatt"} || $Daten{"12".$k} ) { unless( $Zielzeile<12) { $Zielzeile=12; } }
   	if( $Daten{"11".$k."glatt"} || $Daten{"11".$k} ) { $Zielzeile=11; }
	}
   if( $Zielzeile==100 ) { $Zielzeile=11; }
   
   for(my $k=1;$k<7;$k++) {
	$Daten{"9.".$k."glatt"}||=0; # error_log
	if( $Daten{"#".$Zielzeile} ) {
		unless ($Daten{$Zielzeile.".".$k."glatt"}) { $Daten{$Zielzeile.".".$k."glatt"} = 0; }  # error_log
		$Daten{$Zielzeile.".".$k."glatt"}+=$Daten{"9.".$k."glatt"}*1;
		}
	else {
		unless ($Daten{$Zielzeile.".".$k}) { $Daten{$Zielzeile.".".$k} = 0; }  # error_log
		$Daten{$Zielzeile.".".$k}+=$Daten{"9.".$k."glatt"}*1;
		}
	}

   #Summe fuer alle Zeilen bilden
   foreach my $Schluessel (keys %Daten) {
	if( $Schluessel =~ m/^\d+\./ ) {
		my @Woerter = split(/\./, $Schluessel); my $Neu = "#".$Woerter[0];
		$Daten{$Neu}+=$Daten{$Schluessel};
		}
	}
	
   #Einzelkonten mit Durchschnittssaetzen fuellen und Vorsteuer negativ setzen
   for(my $i=1;$i<=45;$i++) {
	for(my $k=1;$k<7;$k++) {
		$Daten{$i.".".$k}||=0;
		if( Form::Zahl($Daten{$i.".".$k."glatt"})>0 ) { 
			$Daten{$i.".".$k} = $Daten{"#".$i}/6;  #unsichtbare Zahl 
			$Daten{$i.",".$k} = Form::Zeigezahl(($Daten{"#".$i}/6),2);   #sichtbare Zahl
			}
		else    {
			$Daten{$i.",".$k} = Form::Zeigezahl($Daten{$i.".".$k},2);    #sichtbare Zahl
			#print $i,"  ",$k,":  ",$Daten{$i.".".$k},"<br>";
			}
		}
		#Summen in Zeile 8
		$Daten{$i.".8"} = $Daten{"#".$i};  #unsichtbare Zahl 
		$Daten{$i.",8"} = Form::Zeigezahl($Daten{"#".$i},2);   #sichtbare Zahl
	}
		

   $Daten{"Beginn"}=Form::Zeigezeit($Monat[$Daten{"Ziel1"}][1]);
   $Daten{"Ende"}=Form::Zeigezeit($Monat[($Daten{"Ziel1"}+5)][2]);
#   Entfaellt durch ausfuehrlichere Auswahl
#   # Prognose beginnt vor oder zugleich mit Basiszeitraums -> naechstes Jahr gemeint
#   my $NeuesJahr=($Daten{"Ziel1"}<$Daten{"Start1"})? ($Jahr+1) : $Jahr;
#   if( $Daten{"typ"} eq "Prognose" ) {
#	$Daten{"Beginn"} =~ s/$Jahr/$NeuesJahr/;
#	$Daten{"Ende"} =~ s/$Jahr/$NeuesJahr/;
#	}
#   # Prognose ueberspringt Neujahr -> naechstes Jahr gemeint
#   my $NeuesJahr=($Daten{"Ziel1"}>6)?  ($Jahr+1) : $Jahr;
#   if( $Daten{"typ"} eq "Prognose" ) {
#	$Daten{"Ende"} =~ s/$Jahr/$NeuesJahr/;
#	}
   $Daten{"Kleinnein"}=($Daten{"Ukleinunternehmer"})? "" : "x";
   $Daten{"Kleinja"}=($Daten{"Ukleinunternehmer"})? "x" : "";
   my $Vorlage=($Daten{"typ"} eq "Prognose")? "jc_prognose.odt" : "jc_bilanz.odt";

#   Ausfuehrliche Ausgabe der Werte
#   print "Berechnungen sind fertig.<br>\nJetzt folgt die Ausgabe aller Zahlen:<br>";
#	 my @Zahlen =  grep( m~^[\d\.]+$~, keys(%Daten)); # Zahlenwerte vorziehen
#	    @Zahlen =  reverse(@{Form::NummernSort(\@Zahlen)});
#	 foreach (@Zahlen) { print $_,":",$Daten{$_},"<br>\n"; } 	
#	 my @Schluessel =  grep( m~\D\D~, keys(%Daten)); # Restwerte bilden
#
#   print "Und die Ausgabe aller anderen Daten:<br>";
#   foreach (sort(@Schluessel)) { print $_,":",$Daten{$_},"<br>\n"; } 


#   Form::Formular(\%Daten, $Vorlage);

   unless( $Daten{"Zieldatei"} =~ m/\.odt$/ ) {
	$Daten{"Zieldatei"}.=".odt";
	}
	
   # EINSCHUB STATT Form::Formular
   my $Draft=$Vorlage;


      mkdir("../draft/cocoon",0777) || die "Unterverzeichnis cocoon kann in draft nicht angelegt werden :\n$!" unless -e "../draft/cocoon"; 
      #my $zip = Archive::Zip->new();
      #$zip->read( $Draft );
      #$zip->extractTree( $Draft, '../draft/cocoon' ); # mit Archive::Zip arbeiten
      #chdir("../draft/cocoon");
      
      chdir("../draft/cocoon");

print "<p>Unzippe... (bitte bis zu 3 Minuten warten)<br>\n";
      system("unzip -oq ../$Draft");
print "Unzippen der Datei $Draft abgeschlossen.<br>\n";
                    
      #Textvariablen in content.xml und styles.xml (Fusszeile) einfuegen
      foreach my $xml ("content", "styles") {
      
         my $xmldatei=$xml.'.xml';
	 my @Zeilen;
	 open(VORLAGE, "<$xmldatei") || die "Das XMl-Content der Vorlage $Draft kann nicht ausgelesen werden:\n$!";
		@Zeilen = <VORLAGE>;
	 close(VORLAGE);

	 #Kodierte Filenamen fuer utf8-Umgebung aufloesen z.B. agmuenster.sxw und Werte austauschen

	 my $f;
	 my $Feld;
	 my @ODT;
	 my @Schluessel = keys(%Daten);
	 @Schluessel=sort(@Schluessel);    # Doppeltes Ueberschreiben vermeiden
	 @Schluessel=reverse(@Schluessel); # umlageEUR vor umlage austauschen
	 my @Zahlen =  grep( m~^[\d\.]+$~, @Schluessel); # Zahlenwerte vorziehen
	 @Zahlen=reverse(@{Form::NummernSort(\@Zahlen)});# und numerisch sortiert pruefen, große zuerst
	 my @Schluessel =  grep( m~\D~, @Schluessel);    # Rest bilden
	 
	  foreach my $Zeile (@Zeilen) {
	  
	        #vorab Zahlfelder austauschen
		foreach my $Zahl (@Zahlen) {

			$f = $Daten{$Zahl};
			#$f = Form::html2utf8($f);
			#$f = encode("utf8", $f); # wieder noetig, nachdem Updateverwirrung mit utf8 erneut aufgetreten ist

			$Zeile =~ s/office:value=.(Â)?°$Zahl.\>/office:value=\"$f\"\>/g if defined $Zeile;

			}
	        #alle anderen Variablen austauschen
		foreach my $Schluessel (@Schluessel) {
			
			$Feld = "°".$Schluessel;
			$f = $Daten{$Schluessel};

			$f = Form::html2utf8($f);
			#$f = encode("utf8", $f); # wieder noetig, nachdem Updateverwirrung mit utf8 erneut aufgetreten ist

			$Zeile =~ s/(Â)?$Feld/$f/g if defined $Zeile;

			}
		push (@ODT, $Zeile);
		}

	 unlink($xmldatei) || die "Kann die ODT-interne $xmldatei nicht aus der Vorlage loeschen.\n$!";   # Rueckfrage vermeiden	

	 open(DATEI, ">$xmldatei") || die "Neue $xmldatei kann nicht in den ODT-Entwurf hineingeschrieben werden:\n$!";
		print DATEI @ODT;
	 close(DATEI);
	 
	 }

      system("find ./* -print | zip -qq $Draft -@");
      #ZIP ($Draft, '../../draft/cocoon');
      system("mv $Draft ../../cgi-bin/tmp/ | chmod 644 $Draft");
      
      # Aufrauemen
      my @Eintraege = glob("*");
      my $Dateien = 0;
      my $Verzeichnisse = 0;
      foreach (@Eintraege) {
        if ( -d $_) {
          my @U_1eintraege = glob("$_/*");
          foreach(@U_1eintraege) {
            if ( -d $_) {
               my @U_2eintraege = glob("$_/*");
               foreach(@U_2eintraege) {
                  if ( -d $_) {
                     my @U_3eintraege = glob("$_/*");
                     foreach(@U_3eintraege) {
                        unless ( -d $_) {
                        $Dateien+= unlink($_); }
                       }
                    $Verzeichnisse+= rmdir("$_");
                  } else {
                    $Dateien+= unlink($_);
                    }
                  }
               $Verzeichnisse+= rmdir("$_");
            } else {
               $Dateien+= unlink($_);
               }
            }
          $Verzeichnisse+= rmdir("$_");
        } else {
          $Dateien+= unlink($_);
          }
        }
     
     chdir("../../cgi-bin");
     rmdir("../draft/cocoon") || die "Loeschen des Hilfsverzeichnisses nicht erfolgreich:\n$!"; 


   # ENDE EINSSCHUB FUER Form::Formular
   
   #Kodierten Filenamen fuer utf8-Umgebung aufloesen
   $Daten{"Zieldatei"}=Form::html2utf8($Daten{"Zieldatei"});
   $Daten{"Zielpfad"}=Form::html2utf8($Daten{"Zielpfad"});

   my $Ziel = $Daten{"Zielpfad"}."/".$Daten{"Zieldatei"};
   my $Alte = $Ziel; $Alte=~s/\.odt/\.old/;
   system(-e "rm $Alte"); 				# alte Sicherungsdatei entfernen, um Rueckfrage zu vermeiden 
   system("mv $Ziel $Alte | chmod 777 ../$Alte");       # alte Datei in Sicherungsdatei umbenennen
   system("mv ../cgi-bin/tmp/$Vorlage $Ziel | chmod 777 ../$Ziel");


  

   print '<p><p><a href="',$Ziel,'">',$Daten{"Zieldatei"},'</a><p>';
   
   #print "<p>Nachfolgend die zugeh&ouml;rige Konten-Legende:\n";
   print Form::Legendenbildung(\%Legende, "kontenzuordnung.odt");



   print '	
		</TD>
		</TR>
	</TABLE>

<BR><BR>
<BODY>
<HTML>
';



}# ENDE ELSE
