#=====================================================================
#
# Lawsuit - Smallbusiness-Software 
#           fuer Rechtsanwaelte 
#
# Copyright (C) 2008
#
#  Author : RA Matthias Hermanns
#     Web : http://www.iustus.eu
#
#======================================================================

package Stamm;

   use LS::Form;
   use Encode; # fuer OpenOffice - Konvertierung in UTF-8 mit Modul Formular 


sub Vertreter {
    my $feldwerte=shift;	#%Daten
    my %feldwerte=%{$feldwerte};
    my $x = shift;		#Kombiniertes Praefix

    my $return=
qq|	      		</TR>
				<TD COLSPAN=6 ALIGN=CENTER VALIGN=TOP class="hell">
					<H4><a name="|.$x.qq|vertreten">|.$feldwerte{$x."vertreter"}.qq|</a></H4>
				</TD>
			</TR>
	      		</TR>
				<TD WIDTH=200 ALIGN=RIGHT class="hell">
					Anrede:&nbsp;&nbsp;
				</TD>
				<TD COLSPAN=5 WIDTH=450 ALIGN=LEFT VALIGN=TOP class="hell">
|.$feldwerte{$x."Ges"}.qq| 
|.$feldwerte{$x."Titel"}.qq|
				</TD>
			</TR>
			<TR>
				<TD WIDTH=200 ALIGN=RIGHT  class="hell">
					<font color="red">*</font>Name|.$feldwerte{$x."namenstext"}.qq|&nbsp;
				</TD>
				<TD COLSPAN=5 WIDTH=450 ALIGN=LEFT VALIGN=TOP class="hell">
					<INPUT TYPE=TEXT NAME="|.$x.qq|name" SIZE=33 MAXLENGTH=50 onChange="javascript:klaeren(this.name)|.$feldwerte{$x."aktion"}.qq|" VALUE="|.$feldwerte{$x."name"}.qq|">
				</TD>
			</TR>
			<TR style="display:|.$feldwerte{$x."hiddenstellung"}.qq|">
				<TD WIDTH=200 ALIGN=RIGHT  class="hell">
					Stellung|.$feldwerte{$x."stellungtext"}.qq|:&nbsp;&nbsp;
				</TD>
				<TD COLSPAN=5 WIDTH=450 ALIGN=LEFT VALIGN=TOP class="hell">
					<INPUT TYPE=TEXT NAME="|.$x.qq|stellung" SIZE=33 MAXLENGTH=50 onChange="javascript:klaeren(this.name)" VALUE="|.$feldwerte{$x."stellung"}.qq|">
				</TD>
			</TR>
			<TR>
				<TD WIDTH=200 ALIGN=RIGHT class="hell">
					Stra&szlig;e:&nbsp;&nbsp;
				</TD>
				<TD COLSPAN=5 WIDTH=450 ALIGN=LEFT VALIGN=TOP class="hell">
					<INPUT TYPE=TEXT NAME="|.$x.qq|strasse" SIZE=33 MAXLENGTH=50 onChange="javascript:klaeren(this.name)" VALUE="|.$feldwerte{$x."strasse"}.qq|">
				</TD>
			</TR>
			<TR>
				<TD WIDTH=200 ALIGN=RIGHT class="hell">
					Stadt:&nbsp;&nbsp;
				</TD>
				<TD COLSPAN=5 WIDTH=450 ALIGN=LEFT VALIGN=TOP class="hell">
					
|.$feldwerte{$x."Land"}.qq|
					 - <INPUT TYPE=TEXT NAME="|.$x.qq|plz" SIZE=5 MAXLENGTH=10 VALUE="|.$feldwerte{$x."plz"}.qq|" onChange="javascript:klaeren(this.name).gericht(|.$x.qq|");"><INPUT TYPE=TEXT NAME="|.$x.qq|stadt" SIZE=21 MAXLENGTH=35 onChange="javascript:klaeren(this.name)" VALUE="|.$feldwerte{$x."stadt"}.qq|">&nbsp;<a href=javascript:plz("|.$x.qq|")><img src="../img/post.gif" height=15 width=15 border=""></a>&nbsp;<a href=javascript:verzeichnis("|.$x.qq|")><img src="../img/telefon.gif" height=15 width=15 border=""></a>
				</TD>
			</TR>
			<TR>
				<TD WIDTH=200 ALIGN=RIGHT class="hell">
					Beteiligten-Nr.:&nbsp;&nbsp;
				</TD>
				<TD COLSPAN=5 WIDTH=450 ALIGN=LEFT VALIGN=TOP class="hell">
					<INPUT TYPE=TEXT NAME="|.$x.qq|beteiligtennr" SIZE=10 MAXLENGTH=10 VALUE="|.$feldwerte{$x."beteiligtennr"}.qq|">
				</TD>
			</TR>
			<TR>
				<TD WIDTH=200 ALIGN=RIGHT class="hell">
					<INPUT TYPE=CHECKBOX NAME="|.$x.qq|vertreten" |.$feldwerte{"vertr_".$x}.qq| onChange="javascript:addrepresentation(this.name)">&nbsp;&nbsp;
				</TD>
				<TD COLSPAN=5 WIDTH=450 ALIGN=LEFT VALIGN=TOP class="hell">
					wird gesetzlich durch |.$feldwerte{$x."Repnummer"}.qq| vertreten
				</TD>
			</TR>
|;

   return $return;
}


sub Typ {
    my $P = shift; #Partei
    my $p = lc($P); 
    my $daten = shift;
    my %daten = %{$daten};
    my $ges = shift;
    my @ges = @{$ges};
    my $land = shift;
    my @land = @{$land};
    my $titel = shift;
    my @titel = @{$titel};

	# Fuer Aufruf als "weitere" Partei vorlage bereinigt und hier ergaenzt.
	$daten{$P."typ"}||= "Person";

	   # Auf rechtsfaehige/eingetragene Gesellschaft umschalten und unter Unternehmer eintragen
	   if($daten{$P."rechtsfaehig"}) {
		$daten{$P."typ"}="Unternehmen";
		if ($daten{$P."mehrheit"} == 4) { 
			$daten{$P."unternehmen"} = 3;
			}
		if ($daten{$P."mehrheit"} == 5) { 
			$daten{$P."unternehmen"} = 1;
			}
		}
	
	   $daten{$p."typ_Unternehmen"} = ($daten{$P."typ"} eq "Unternehmen")? "checked" : "" ;
	   $daten{$p."typ_Mehrheit"} = ($daten{$P."typ"} eq "Mehrheit")? "checked" : "" ;
	   $daten{$p."typ_Person"} = ($daten{$P."typ"} eq "Person")? "checked" : "" ;
	   $daten{$p."typ_Verwalter"} = ($daten{$P."typ"} eq "Verwalter")? "checked" : "" ;
	   $daten{$p."typ_Verwaltungstraeger"} = ($daten{$P."typ"} eq "Verwaltungstraeger")? "checked" : "" ;
	   $daten{"Gbezeichnung"} = "Gegner";

	if( $daten{"Crechtsgebiet"} eq "BG" && $P eq "G") {
		$daten{"Gbezeichnung"} = "Zust&auml;ndige Verfolgungsbeh&ouml;rde";
		$daten{$p."typ_Unternehmen"} = "" ;
		$daten{$p."typ_Mehrheit"} = "" ;
		$daten{$p."typ_Person"} = "" ;
		$daten{$p."typ_Verwalter"} = "" ;
		$daten{$p."typ_Verwaltungstraeger"} =  "checked";
		}
	if( $daten{"Crechtsgebiet"} eq "SR" && $P eq "G") {
		$daten{$P."zeiletyp"} = '
			<TR style="display:none">
				<TD WIDTH=200 ALIGN=RIGHT class="hell">
					Typ:&nbsp;&nbsp;
				</TD>
				<TD COLSPAN=5 WIDTH=450 ALIGN=LEFT VALIGN=TOP class="hell">
					<input name=Gtyp type=text size=33 value="Staatsanwaltschaft">
				</TD>
			</TR>
';
		$daten{"Gbezeichnung"} = "Zust&auml;ndige Staatsanwaltschaft";
		}
	else { $daten{$P."zeiletyp"} = '
			<TR>
				<TD WIDTH=200 ALIGN=RIGHT class="hell">
					Typ:&nbsp;&nbsp;
				</TD>
				<TD ALIGN=LEFT WIDTH=90 VALIGN=TOP class="hell">
					<input name='.$P.'typ type=radio value="Unternehmen" '.$daten{$p."typ_Unternehmen"}.' onChange="javascript:typeset(this.name);"><small>Unternehm.</small>
				</TD>
				<TD ALIGN=LEFT WIDTH=90 VALIGN=TOP class="hell">
					<input name='.$P.'typ type=radio value="Mehrheit" '.$daten{$p."typ_Mehrheit"}.' onChange="javascript:typeset(this.name);"><small>Mehrheit</small>
				</TD>
				<TD ALIGN=LEFT WIDTH=90 VALIGN=TOP class="hell">
					<input name='.$P.'typ type=radio value="Person" '.$daten{$p."typ_Person"}.' onChange="javascript:typeset(this.name);"><small>nat. Person</small>
				</TD>
				<TD ALIGN=LEFT WIDTH=90 VALIGN=TOP class="hell">
					<input name='.$P.'typ type=radio value="Verwalter" '.$daten{$p."typ_Verwalter"}.' onChange="javascript:typeset(this.name);"><small>Verwalter</small>
				</TD>
				<TD ALIGN=LEFT WIDTH=90 VALIGN=TOP class="hell">
					<input name='.$P.'typ type=radio value="Verwaltungstraeger" '.$daten{$p."typ_Verwaltungstraeger"}.' onChange="javascript:typeset(this.name);"><small>VwTr&auml;ger</small>
				</TD>
			</TR>
';
		}
	   $daten{$p."kfm_eV"} = ($daten{$P."unternehmen"} == 1)? "checked" : "" ;
	   $daten{$p."kfm_Stiftung"} = ($daten{$P."unternehmen"} == 2)? "checked" : "" ;
	   $daten{$p."kfm_GbR"} = ($daten{$P."unternehmen"} == 3)? "checked" : "" ;
	   $daten{$p."kfm_Einzelhaendler"} = ($daten{$P."unternehmen"} == 4)? "checked" : "" ;
	   $daten{$p."kfm_Gmbhco"} = ($daten{$P."unternehmen"} == 5)? "checked" : "" ;
	   $daten{$p."kfm_Sonstige"} = ($daten{$P."unternehmen"} == 10)? "checked" : "" ;

	   my $Unternehmen = qq|
			<TR>
				<TD WIDTH=200 ALIGN=RIGHT class="hell">
					Gesellschaftsform:&nbsp;&nbsp;
				</TD>
				<TD COLSPAN=5 WIDTH=450 ALIGN=LEFT VALIGN=TOP class="hell">

					<input name=|.$P.qq|unternehmen type=radio value="1" |.$daten{$p."kfm_eV"}.qq| onChange="javascript:typeset(this.name);"> 
					e.V.<br>
					<input name=|.$P.qq|unternehmen type=radio value="2" |.$daten{$p."kfm_Stiftung"}.qq| onChange="javascript:typeset(this.name);"> 
					Stiftung<br>
					<input name=|.$P.qq|unternehmen type=radio value="3" |.$daten{$p."kfm_GbR"}.qq| onChange="javascript:typeset(this.name);"> 
					Publikums-GbR<br>
					<input name=|.$P.qq|unternehmen type=radio value="4" |.$daten{$p."kfm_Einzelhaendler"}.qq| onChange="javascript:kaufmann(this.name);"> 
					Einzelkaufmann<br>
					<input name=|.$P.qq|unternehmen type=radio value="5" |.$daten{$p."kfm_Gmbhco"}.qq| onChange="javascript:typeset(this.name);"> 
					GmbH & Co KG<br>
					<input name=|.$P.qq|unternehmen type=radio value="10" |.$daten{$p."kfm_Sonstige"}.qq| onChange="javascript:typeset(this.name);">
					Sonstige:
					<input type=hidden name=|.$P.qq|prefix size=2 maxlength=2 value="3">
					<input type=hidden name=|.$P.qq|mehrheit size=3 maxlength=3 value="0">
					<input type=hidden name=|.$P.qq|verwalter size=3 maxlength=3 value="0">
					<input type=hidden name=|.$P.qq|traeger size=3 maxlength=3 value="0">

				</TD>
			</TR>
|;

	   if ($daten{$P."unternehmen"} == 10) {
	    $daten{$P."form"} ||= "GmbH";
	    $Unternehmen .= qq|
			<TR>
				<TD WIDTH=200 />
				<TD COLSPAN=5 WIDTH=408 ALIGN=LEFT VALIGN=TOP class="hell">
					&nbsp;&nbsp;&nbsp;&nbsp;
					<input name=|.$P.qq|form size=15 maxlength=40 value="|.$daten{$P."form"}.qq|" onChange="javascript:klaeren(this.name);">

				</TD>
			</TR>
|;
  }

	   $daten{$p."mehr_eheleute"} = ($daten{$P."mehrheit"} == 1)? "checked" : "" ;
	   $daten{$p."mehr_familie"} = ($daten{$P."mehrheit"} == 2)? "checked" : "" ;
	   $daten{$p."mehr_partner"} = ($daten{$P."mehrheit"} == 3)? "checked" : "" ;
	   $daten{$p."mehr_gbr"} = ($daten{$P."mehrheit"} == 4)? "checked" : "" ;
	   $daten{$p."mehr_verein"} = ($daten{$P."mehrheit"} == 5)? "checked" : "" ;

	   my $Mehrheit = qq|
			<TR>
				<TD WIDTH=200 ALIGN=RIGHT class="hell">
					Art:&nbsp;&nbsp;
				</TD>
				<TD class="hell" />
				<TD COLSPAN=4 ALIGN=LEFT VALIGN=TOP class="hell">
					<input name=|.$P.qq|mehrheit type=radio value="1" $daten{$p."mehr_eheleute"} onChange="javascript:typeset(this.name),klaeren(this.name),encode(all),submit();"> Eheleute mit gemeinsamer Anschrift<br>
					<input name=|.$P.qq|mehrheit type=radio value="2" $daten{$p."mehr_familie"} onChange="javascript:typeset(this.name),klaeren(this.name),encode(all),submit();"> Familie mit gemeinsamer Anschrift<br>
					<input name=|.$P.qq|mehrheit type=radio value="3" $daten{$p."mehr_partner"} onChange="javascript:typeset(this.name),klaeren(this.name),encode(all),submit();"> Lebenspartner mit gemeinsamer Anschrift<br>
					<input name=|.$P.qq|mehrheit type=radio value="4" $daten{$p."mehr_gbr"} onChange="javascript:typeset(this.name);"> Gesellschaft b&uuml;rgerlichen Rechts<br>
					<input name=|.$P.qq|mehrheit type=radio value="5" $daten{$p."mehr_verein"} onChange="javascript:typeset(this.name);"> Verein<br>
					<input type=hidden name=|.$P.qq|prefix size=2 maxlength=2 value="2">
					<input type=hidden name=|.$P.qq|unternehmen size=3 maxlength=3 value="0">
					<input type=hidden name=|.$P.qq|form size=32 maxlength=40 value="">
					<input type=hidden name=|.$P.qq|verwalter size=3 maxlength=3 value="0">
					<input type=hidden name=|.$P.qq|traeger size=3 maxlength=3 value="0">
				</TD>
	 		</TR>
|;


	   if ($daten{$P."mehrheit"} == 4 || $daten{$P."mehrheit"} == 5 ) {
	    $Mehrheit .= qq|
			<TR>
				<TD WIDTH=200 />
				<TD class="hell" />
				<TD COLSPAN=4 ALIGN=LEFT VALIGN=TOP class="hell">
					&nbsp;&nbsp;&nbsp;&nbsp;
					<select name=|.$P.qq|rechtsfaehig onChange="javascript:rechtsfaehig(this.name);">
						<option value=0>ohne eigene Rechtsf&auml;higkeit
						<option value=1>mit eigener Rechtsf&auml;higkeit
					</select>
				</TD>
			</TR>
|;
  }

	   if ($daten{$P."verwalter"} == 1) {
	      $daten{$p."vw_inso"} = "checked";
	      $daten{$P."vw_bezeichnung"} ||= "Insolvenzverwalter";
	   }
	   elsif ($daten{$P."verwalter"} == 2) {
	      $daten{$p."vw_testa"} = "checked";
	      $daten{$P."vw_bezeichnung"} ||= "Testamentsvollstrecker";
	   }
	   elsif ($daten{$P."verwalter"} == 3) {
	      $daten{$p."vw_nachlass"} = "checked";
	      $daten{$P."vw_bezeichnung"} ||= "Nachlassverwalter";
	   }
	   elsif ($daten{$P."verwalter"} == 4) {
	      $daten{$p."vw_gewillkuert"} = "checked";
	      $daten{$P."vw_bezeichnung"} ||= "gewillk.&uuml;rte Prozessstandschaft";
	   }

	   my $Verwalter = qq|
			<TR>
				<TD WIDTH=200 ALIGN=RIGHT class="hell">
					Prozessstandschaft:&nbsp;&nbsp;
				</TD>
				<TD class="hell" />
				<TD class="hell" />
				<TD class="hell" />
				<TD COLSPAN=2 ALIGN=LEFT VALIGN=TOP class="hell">
					<input name=|.$P.qq|verwalter type=radio value="1" $daten{$p."vw_inso"} onChange="javascript:typeset(this.name),klaeren(this.name),encode(all),submit();"> Insolvenzverwalter<br>
					<input name=|.$P.qq|verwalter type=radio value="2" $daten{$p."vw_testa"} onChange="javascript:typeset(this.name);"> Testamentsvollstrecker<br>
					<input name=|.$P.qq|verwalter type=radio value="3" $daten{$p."vw_nachlass"} onChange="javascript:typeset(this.name);"> Nachlassverwalter<br>
					<input name=|.$P.qq|verwalter type=radio value="4" $daten{$p."vw_gewillkuert"} onChange="javascript:typeset(this.name);"> gewillk&uuml;rt
					<input type=hidden name=|.$P.qq|prefix size=2 maxlength=2 value="1">
					<input type=hidden name=|.$P.qq|unternehmen size=3 maxlength=3 value="0">
					<input type=hidden name=|.$P.qq|mehrheit size=3 maxlength=3 value="0">
					<input type=hidden name=|.$P.qq|form size=32 maxlength=40 value="">
					<input type=hidden name=|.$P.qq|traeger size=3 maxlength=3 value="0">
				</TD>
	 		</TR>
|;


	   $daten{$p."vw_Bund"} = ($daten{$P."traeger"} == 1)? "checked" : "" ;
	   $daten{$p."vw_Land"} = ($daten{$P."traeger"} == 2)? "checked" : "" ;
	   $daten{$p."vw_Kreis"} = ($daten{$P."traeger"} == 3)? "checked" : "" ;
	   $daten{$p."vw_Kommune"} = ($daten{$P."traeger"} == 4)? "checked" : "" ;
	   $daten{$p."vw_RP"} = ($daten{$P."traeger"} == 6)? "checked" : "" ;
	   $daten{$p."vw_Bundkoerperschaft"} = ($daten{$P."traeger"} == 7)? "checked" : "" ;
	   $daten{$p."vw_AoeR"} = ($daten{$P."traeger"} == 8)? "checked" : "" ;
	   $daten{$p."vw_Sonstige"} = ($daten{$P."traeger"} == 10)? "checked" : "" ;

	   my $Verwaltungstraeger = qq|
			<TR>
				<TD WIDTH=200 ALIGN=RIGHT class="hell">
					Gebietsk&ouml;rperschaft/&nbsp;&nbsp; Organisationsform:&nbsp;&nbsp;
				</TD>
				<TD class="hell" />
				<TD class="hell" />
				<TD class="hell" />
				<TD COLSPAN=2 ALIGN=LEFT VALIGN=TOP class="hell">

					<input name=|.$P.qq|traeger type=radio value="1" |.$daten{$p."vw_Bund"}.qq| onChange="javascript:typeset(this.name);"> 
					Bundesbeh&ouml;rde<br>
					<input name=|.$P.qq|traeger type=radio value="2" |.$daten{$p."vw_Land"}.qq| onChange="javascript:typeset(this.name);"> 
					Landesbeh&ouml;rde<br>
					<input name=|.$P.qq|traeger type=radio value="6" |.$daten{$p."vw_RP"}.qq| onChange="javascript:typeset(this.name);"> 
					Regierungsbezirk<br>
					<input name=|.$P.qq|traeger type=radio value="3" |.$daten{$p."vw_Kreis"}.qq| onChange="javascript:typeset(this.name);"> 
					Kreisbeh&ouml;rde<br>
					<input name=|.$P.qq|traeger type=radio value="4" |.$daten{$p."vw_Kommune"}.qq| onChange="javascript:typeset(this.name);"> 
					Kommunalbeh&ouml;rde<br>
					<input name=|.$P.qq|traeger type=radio value="7" |.$daten{$p."vw_Bundkoerperschaft"}.qq| onChange="javascript:typeset(this.name);"> 
					Bundk&ouml;rpersch. (LWL)<br>
					<input name=|.$P.qq|traeger type=radio value="8" |.$daten{$p."vw_AoeR"}.qq| onChange="javascript:typeset(this.name);"> 
					Anstalt &ouml;ff. Rechts<br>
					<input name=|.$P.qq|traeger type=radio value="10" |.$daten{$p."vw_Sonstige"}.qq| onChange="javascript:typeset(this.name);">
					Sonstige:
					<input type=hidden name=|.$P.qq|prefix size=2 maxlength=2 value="1">
					<input type=hidden name=|.$P.qq|unternehmen size=3 maxlength=3 value="0">
					<input type=hidden name=|.$P.qq|mehrheit size=3 maxlength=3 value="0">
					<input type=hidden name=|.$P.qq|form size=32 maxlength=40 value="">
					<input type=hidden name=|.$P.qq|verwalter size=3 maxlength=3 value="0">

				</TD>
			</TR>
|;

	   if ($daten{$P."traeger"} == 10) {
	    $daten{$P."organisation"} ||= "ArGe";
	    $Verwaltungstraeger .= qq|
			<TR>
				<TD WIDTH=200 />
				<TD COLSPAN=3 WIDTH=300 />
				<TD COLSPAN=2 ALIGN=LEFT VALIGN=TOP class="hell">
					&nbsp;&nbsp;&nbsp;&nbsp;
					<input name=|.$P.qq|organisation size=15 maxlength=40 value="|.$daten{$P."organisation"}.qq|" onChange="javascript:typeset(this.name);">

				</TD>
			</TR>
|;
  }

	   my $Gebietskoerperschaft = "";
	   if( $daten{$P."traeger"} == 1 ) { $daten{$P."gebietskoerperschaft"}="Bundesrepublik&nbsp;Deutschland"; }
	   if( $daten{$P."traeger"} == 3 ) { $daten{$P."gebietskoerperschaft"}||="Kreis&nbsp;"; }
	   if( $daten{$P."traeger"} == 4 ) { $daten{$P."gebietskoerperschaft"}||="Stadt&nbsp;"; }
	   if( $daten{$P."traeger"} == 6 ) { $daten{$P."gebietskoerperschaft"}||="Bezirksregierung&nbsp;"; }
	   if( $daten{$P."traeger"} <= 6) { # Gebietskoerperschaft nach Abteilung aufgliedern z.B. Stadt Muenster - KSD
	    $Gebietskoerperschaft .= qq|
			<TR>
				<TD WIDTH=200 ALIGN=RIGHT  class="hell">
					Gebietsk&ouml;rperschaft:&nbsp;&nbsp;
				</TD>
				<TD COLSPAN=5 WIDTH=450 ALIGN=LEFT VALIGN=TOP class="hell">
|;
				my $hidden="";
				my $Bundesland="";
				if( $daten{$P."traeger"} == 2 ) { # wenn Gebietskoerperschaft das Land ist, Auswahlmenue

					my @Laender = qw( #:#-bitte&nbsp;Land&nbsp;ausw&auml;hlen- bw#:#Land&nbsp;Baden-W&uuml;rttemberg by#:#Freistaat&nbsp;Bayern bb#:#Land&nbsp;Brandenburg be#:#Land&nbsp;Berlin hb#:#Freie&nbsp;Hansestadt&nbsp;Bremen hh#:#Freie&nbsp;Hansestadt&nbsp;Hamburg he#:#Land&nbsp;Hessen mv#:#Land&nbsp;Mecklenburg-Vorpommern ns#:#Land&nbsp;Niedersachsen nw#:#Land&nbsp;Nordrhein-Westfalen rp#:#Land&nbsp;Rheinland-Pfalz sa#:#Land&nbsp;Sachsen-Anhalt sh#:#Land&nbsp;Schleswig-Holstein sl#:#Land&nbsp;Saarland sn#:#Freistaat&nbsp;Sachsen th#:#Freistaat&nbsp;Th&uuml;ringen );

					my $Auswahl=$daten{$P."bundesland"};
					$Bundesland=Form::Ausklappmenue(\@Laender, $P."bundesland", $Auswahl, "", 40, 200, 'onChange=javascript:land("'.$p.'")');

					$hidden="type=hidden";
				}
					$Gebietskoerperschaft .= qq|
$Bundesland
					<input $hidden name="|.$P.qq|gebietskoerperschaft" SIZE=33 MAXLENGTH=50 onChange="javascript:klaeren(this.name),stadt(&quot;|.$P.qq|&quot;)" VALUE="|.$daten{$P."gebietskoerperschaft"}.qq|">

				</TD>
			</TR>
|;
  }


	   # Einschub und Zusatzzeilen auswerfen, Anrede anpassen
	   $daten{$P."einschub"} = "";
	   $daten{$P."zusatzzeile"} = "";
	   $daten{$P."behoerde"} = "";
	   $daten{$P."achn"} = "";
	   $daten{$P."hiddenname"} = "TYPE=TEXT";
	   $daten{$P."hiddennachname"} = "TYPE=HIDDEN";
	   $daten{$P."hiddenvorname"} = "none";
	   $daten{$P."hiddenperson"} = "none";
	   $daten{$P."zeilegeb"} = "";
	   $daten{$P."zusatzvertreter"} = "";
	   if  ($daten{$P."typ"} eq "Unternehmen") {
			$daten{$P."einschub"} = $Unternehmen; $daten{$P."ges"}=1;
			}
	   if  ( ($daten{$P."typ"} eq "Unternehmen") || ($daten{"Crechtsgebiet"} eq "SR" && $P eq "G") ) {
			if( $daten{$P."unternehmen"}!=4 ) { $daten{$P."ges"}=3; $daten{$P."titel"}=""; }
			if( $daten{$P."form"}=~m/V/ ) { $daten{$P."ges"}=5; $daten{$P."titel"}=""; }
			if( $daten{$P."unternehmen"}==4 ) { $daten{$P."ges"}=1; }
			if( ($daten{$P."unternehmen"}==5) || ($daten{$P."form"}=~/.+&.Co.+/) ) { 
				$daten{$P."vertreten"}=1; $daten{"vertr_".$P}="checked";
				$daten{$P."A0ges"}=3;
				$daten{$P."A0titel"}="";
				$daten{$P."A0namenstext"}=":&nbsp;";
				$daten{$P."A0hiddenstellung"} = "none";
				$daten{$P."A0vertreter"}="Komplement&auml;rgesellschaft";
				$daten{$P."A0vertreten"}=1; $daten{"vertr_".$P."A0"}="checked";
				unless( $daten{$P."A0praefix"} ) { $daten{$P."A0praefix"}="1"; }
				unless( $daten{$P."B0stellung"} ) { $daten{$P."B0stellung"}="Gesch&auml;ftsf&uuml;hrer"; } }
			}
	   elsif  ( $daten{$P."typ"} eq "Mehrheit" ) { $daten{$P."einschub"} = $Mehrheit; 
			if( $daten{$P."mehrheit"} == 2 ) {
				# unter 18?
				my @Datum=split(/\./, $daten{$P."geboren"});
				$Datum[2]+=18;	my $Datum=join( ".", @Datum);
				if( Form::Zeit((Form::Datum(1,0)))<Form::Zeit($Datum) ) {
					# Checkbox und Repnummer setzt schon Javascript geboren
					$daten{$P."A0ges"}=2;
					$daten{$P."A0stellung"}="Mutter";
					$daten{$P."A0strasse"}=$daten{$P."strasse"};
					$daten{$P."A0name"}=$daten{$P."nachname"}.", ";
					$daten{$P."A0land"}=$daten{$P."land"};
					$daten{$P."A0plz"}=$daten{$P."plz"};
					$daten{$P."A0stadt"}=$daten{$P."stadt"};
					$daten{$P."A1ges"}=1;
					$daten{$P."A1stellung"}="Vater";
					$daten{$P."A1name"}=$daten{$P."nachname"}.", ";
					$daten{$P."A1strasse"}=$daten{$P."strasse"};
					$daten{$P."A1land"}=$daten{$P."land"};
					$daten{$P."A1plz"}=$daten{$P."plz"};
					$daten{$P."A1stadt"}=$daten{$P."stadt"};
				}
			}
			elsif( $daten{$P."mehrheit"} == 4 ) { $daten{$P."ges"}=3; $daten{$P."titel"}=""; }
			elsif( $daten{$P."mehrheit"} == 5 ) { $daten{$P."ges"}=5; $daten{$P."titel"}=""; }
			# personalisieren
			$daten{$P."achn"}="achn";
			$daten{$P."hiddenname"}="TYPE=HIDDEN";
			$daten{$P."hiddennachname"} = "TYPE=TEXT";
			$daten{$P."hiddenvorname"} = "table-row";
			$daten{$P."hiddenperson"} = "table-row";
			}
	   elsif  ( $daten{$P."typ"} eq "Person" ) { 
			# personalisieren
			$daten{$P."achn"}="achn";
			$daten{$P."hiddenname"}="TYPE=HIDDEN";
			$daten{$P."hiddennachname"} = "TYPE=TEXT";
			$daten{$P."hiddenvorname"} = "table-row";
			$daten{$P."hiddenperson"} = "table-row";
			# unter 18?
			my @Datum=split(/\./, $daten{$P."geboren"});
			$Datum[2]+=118;	my $Datum=join( ".", @Datum);
			my $Datum1=Form::Zeit($Datum);
			my $Datum2=Form::Zeit(Form::Datum(1,36525));
			if( $Datum1>$Datum2 && length($daten{$P."A0name"})<1 ) { #minderjaehrig, nur wenn leer vorschlagen
				# Checkbox und Repnummer setzt schon Javascript geboren 
				$daten{$P."A0ges"}=2;
				$daten{$P."A0stellung"}="Mutter";
				$daten{$P."A0strasse"}=$daten{$P."strasse"};
				$daten{$P."A0name"}=$daten{$P."nachname"}.", ";
				$daten{$P."A0land"}=$daten{$P."land"};
				$daten{$P."A0plz"}=$daten{$P."plz"};
				$daten{$P."A0stadt"}=$daten{$P."stadt"};
				$daten{$P."A1ges"}=1;
				$daten{$P."A1stellung"}="Vater";
				$daten{$P."A1name"}=$daten{$P."nachname"}.", ";
				$daten{$P."A1strasse"}=$daten{$P."strasse"};
				$daten{$P."A1land"}=$daten{$P."land"};
				$daten{$P."A1plz"}=$daten{$P."plz"};
				$daten{$P."A1stadt"}=$daten{$P."stadt"};
				}
			}
	   elsif( $daten{$P."typ"} eq "Verwalter") { $daten{$P."einschub"} = $Verwalter; $daten{$P."ges"}=1; }
	   elsif( $daten{$P."typ"} eq "Verwaltungstraeger") { 
			$daten{$P."einschub"} = $Verwaltungstraeger; 
			$daten{$P."ges"}=3; $daten{$P."titel"}="";
			if( $daten{$P."traeger"} == 2 ) { $daten{$P."ges"}=4; }
			if( $daten{$P."traeger"} == 3 ) { $daten{$P."ges"}=5; }
			if( $daten{$P."traeger"} <= 6 ) { 
				$daten{$P."zusatzzeile"}=$Gebietskoerperschaft;
				$daten{$P."behoerde"}=" der Beh&ouml;rde/Amt";
				}
			}
	   my $X=$P;  #Vertreterebenenbuchstabe
	   my $x=65;  #Vertreterebenenbuchstabencode
	   my $y=0;   #Vertreternummer innmerhalb Ebene
	   $daten{"vertr_".$X}=""; #Kaestchen nicht anklicken
	   my $representatives="";
	   my $neueEbene=$daten{$X."vertreten"};
	   my @Ebenenvertreter; 
	   $Ebenenvertreter[65]=$daten{$X."repnummer"};
	   while( $neueEbene ) {
		$neueEbene=0;
		while( $y <= $Ebenenvertreter[$x] ) {
			$daten{"vertr_".$X}=($daten{$X."vertreten"})? "checked" : "";
			my $Y = ( $Ebenenvertreter[$x] > 0 )? $y+1 : "";  #Vertreteranzeige in Ebene
			$X=$P.chr($x).$y;
			my $Auswahl=($daten{$X."ges"})? $daten{$X."ges"} : 1;
			$daten{$X."Ges"}=Form::Ausklappmenue(\@ges, $X."ges", $Auswahl, "", 40, 150);
			unless($daten{$X."namenstext"}) { $daten{$X."namenstext"}=" (Nach-, Vorname):&nbsp;"; }
			unless($daten{$X."hiddenstellung"}) {$daten{$X."hiddenstellung"}="table-row";}
			$Auswahl=$daten{$X."land"} ||= "D";
			$daten{$X."Land"}=Form::Ausklappmenue(\@land, $X."land", $Auswahl, "", 30, 100, "");
			$Auswahl=$daten{$X."titel"} ||= "";
			$daten{$X."Titel"}=Form::Ausklappmenue(\@titel, $X."titel", $Auswahl, "", 40, 150, "");
			my $Auswahl=$daten{$X."repnummer"};
			my @Repnummer = qw(0#:#Alleinvertretungsberechtigten 1#:#zwei&nbsp;gemeinschaftlich 2#:#drei&nbsp;gemeinschaftlich 3#:#vier&nbsp;gemeinschaftlich 4#:#f&uuml;nf&nbsp;gemeinschaftlich 5#:#sechs&nbsp;gemeinschaftlich 6#:#sieben&nbsp;gemeinschaftlich);
			$daten{$X."Repnummer"}=Form::Ausklappmenue(\@Repnummer, $X."repnummer", $Auswahl, "", 100, 300, 'onChange=javascript:addrepresentation("'.$X.'vertreten")');

			my %Vorlage=%{Form::Auslesen_Spiegel("./tmp/vorlage_vertret.cfg", "", "")};
			foreach my $schluessel (keys %Vorlage) { # mit Leerfeldern fuellen, wenn nicht belegt
				unless( length($daten{$X.$schluessel})>0 ) {
					$daten{$X.$schluessel}=$Vorlage{$schluessel};
					}
				}
			unless($daten{$X."vertreter"}) { $daten{$X."vertreter"}="Gesetzlicher Vertreter ".$Y." - Ebene ".chr($x); }
			unless( $daten{$X."praefix"} ) { $daten{$X."praefix"}="4"; }
			if( $daten{$X."vertreten"} ) { 
				$daten{"vertr_".$X}="checked"; 
				$neueEbene=1; # Neue Ebene und Zahl ihrer Vertreter ermitteln
				if( $Ebenenvertreter[($x+1)]<$daten{$X."repnummer"} ) {$Ebenenvertreter[($x+1)]=$daten{$X."repnummer"};}
			} else { $daten{"vertr_".$X}=""; }
			$representatives.=Stamm::Vertreter(\%daten, $X);
			$y++; $X=($x==65)? $P : $P.chr($x); # bei erster Runde verweilen
			}
		$x++; $y=0; $Ebenenvertreter[($x+1)]=0; 
		$X=$P.chr($x).$y;

		}
	   $daten{$P."vertreter"}=$representatives;

	return \%daten;	
}



sub Adressliste {
   my $Name   = shift;
   my $Prefixe = shift;
   my $Typ = shift;
   my $Verzeichnis;
   my @Option;
       
    
   while( length($Prefixe)>0 ) {
   
        my $Prefix=chop($Prefixe);
   
        if( $Prefix eq "M" ) { $Verzeichnis="../clients/all.cfg"; }
        if( $Prefix eq "G" ) { $Verzeichnis="../opponents/all.cfg"; }
        if( $Prefix eq "W" ) { $Verzeichnis="../opponents/all.cfg"; }
        if( $Prefix eq "X" ) { $Verzeichnis="../clients/all.cfg"; }
        if( $Prefix eq "P" ) { $Verzeichnis="../parties/all.cfg"; }
        if( $Prefix eq "A" ) { $Verzeichnis="../staff/all.cfg"; }

        $Typ =~ s/\"\"//g;
        foreach(@{Form::Auslesen($Verzeichnis)}) {
        my @Zeile=split(/#?\:#?/,encode("utf8", $_));
        if( $Zeile[1] =~ m/^$Name.*/ && $Zeile[3]=~ m/^$Typ.*/ ) {
            pop(@Zeile);
            my $Option = $Prefix.join(" -- ", @Zeile);
            $Option =~ s/ -- /#:#/o;
            $Option =~ s/\n//g;
            push (@Option, $Option);
            }
        }
   }

   return \@Option;
}



sub Rubrumklar {
   my $rubrum = shift;  # Rubrumteil vor und nach ./.

	$rubrum =~s/^Strs(\.)?(\s)?(&nbsp;)?//g	 if defined $rubrum;     # Strafsache
	$rubrum =~s/^O[Ww][Ii](\s)?(&nbsp;)?//g	 if defined $rubrum;     # OWi-Angelegenheit
	$rubrum =~s/^Ber(\.)?(\s)?(&nbsp;)?//g	 if defined $rubrum;     # Beratung (kein Gegner)
	$rubrum =~s/^Betr(\.)?(\s)?(&nbsp;)?//g	 if defined $rubrum;     # Betreuungssache (kein Gegner)
	$rubrum =~s/^Ins[Oo](\s)?(&nbsp;)?//g	 if defined $rubrum;     # Insolvenz (Masseverfahren)
	$rubrum =~s/^Nls(\.)?(\s)?(&nbsp;)?//g	 if defined $rubrum;     # Nachlasssache
	$rubrum =~s/\su.a.(\s)?(&nbsp;)?$//g	 if defined $rubrum;     # Hinweis auf weitere Beteiligte
	$rubrum =~s/\s[XIV]([XIV])?([XIV])?([XIV])?([XIV])?(\s)?#//g 	 if defined $rurbrum;
	$rubrum =~s/^\s(\s)?(&nbsp;)?//g	 if defined $rubrum;
	$rubrum =~s/\s(\s)?$//g			 if defined $rubrum;
	
	$rubrum =~s/^ //g	 if defined $rubrum;
	$rubrum =~s/ $//g	 if defined $rubrum;
	$rubrum =~s/^&nbsp;//g	 if defined $rubrum;
	$rubrum =~s/&nbsp;$//g   if defined $rubrum;
	$rubrum =~s/^&#160;//g	 if defined $rubrum;
	$rubrum =~s/&#160;$//g	 if defined $rubrum;
	
	$rubrum =~s/&#160;/&nbsp;/g	 if defined $rubrum;

   return $rubrum;
}



sub Vwkurz {
   my $vw = shift;  # Verwaltungstraegerbezeichnung standardisieren

	$vw =~ s/Staatsanwaltschaft/StA/;
	$vw =~ s/Arbeitsgemeinschaft/ArGe/;
	$vw =~ s/Arbeitsagentur/AA/;
	$vw =~ s/Jobcenter/JC/;
	$vw =~ s/Rentenversicherung/RV/;
	$vw =~ s/Bezirksregierung/BezR/;
	$vw =~ s/Kreis/LK/;
	$vw =~ s/(Samt)[Gg]emeinde/Gem./;
	$vw =~ s/Stiftung/Sftg./;
	$vw =~ s/ - .*//; 
	$vw =~ s/,.*//; 

   return $vw;
}


sub Fritz {
   my $fritz = shift;  # Fritzboxtelefonbuch um neue Fritzzeilen ergaenzen
   my @fritzzeilen=@{$fritz};
      foreach(@fritzzeilen) { $_=decode("utf8", Form::html2utf8($_)); }
   my $fritzzeilen=join("\n", @fritzzeilen);
   my @zeilen;

   my ($sekunden, $minuten, $stunden, $monatstag, $monat,
       $jahr, $wochentag, $jahrestag, $sommerzeit) = localtime(time);
       $monat+=1;
       $jahrestag+=1;
       $monat = $monat < 10 ? $monat = "0".$monat : $monat;
       $monatstag = $monatstag < 10 ? $monatstag = "0".$monatstag : $monatstag;
       $minuten = $minuten < 10 ? $minuten = "0".$minuten : $minuten;
   my $fritzname="FRITZ.Box_Telefonbuch_".$monatstag.".".$monat.".".($jahr-100)."_".$stunden.$minuten;
   my @fritzanfang='<?xml version="1.0" encoding="iso-8859-1"?>
<phonebooks>
<phonebook>
<contact><category>0</category><person><realName /></person><telephony /><services /><setup /></contact>';
   my @fritzende='</phonebook>
</phonebooks>
';

   if( $fritzzeilen =~ m/realName/ ) {  #nur Personen mit Telefon aufnehmen

	my @fritzdateien = glob("../../Downloads/FRITZ.Box_Telefonbuch_*.xml");
	if( $#fritzdateien >= 0 ) {
		#Altergaenzung
		my $zeit=0;
		my $gefunden = "";
		my $auswahl="";
		foreach (@fritzdateien) {
			my @info = stat($_);
			if( $info[9] > $zeit ) { 
				$zeit = $info[9] ;
				$auswahl = $_; 
				}
			}
		open(DATEI, "<$auswahl") || die "$auswahl kann nicht gelesen werden";
			@zeilen = <DATEI>;
		close(DATEI);
		# Kodieren und Leerzeilen loeschen
		foreach(@zeilen) { $_=encode("utf8",$_); $_=~s/^\n$//g; }
		#Anfang und Ende entfernen und Umbrueche auf Kontaktanfang berichtigen 
		my $fritzdatei=join("UMBRUCH", @zeilen);
		   $fritzdatei=~s/<\?xml.+\?>//g;
		   $fritzdatei=~s/.+<phonebook>(\n)//g;
		   $fritzdatei=~s/<phonebook name=\"\w+\">(\n)//g;
		   $fritzdatei=~s/<phonebooks>(\n)//g;
		   $fritzdatei=~s/<\/contact><contact>/<\/contact>UMBRUCH<contact>/g;
		   $fritzdatei=~s/<\/phonebook>(\n)//g;
		   $fritzdatei=~s/<\/phonebooks>(\n)//g;
		$fritzdatei.=$fritzzeilen;
		@zeilen=split(/UMBRUCH/, $fritzdatei);
		#foreach(@zeilen) { $_.="\n"; }
		#Eintrag mit diesem Namen schon vorhanden? Dann mit neuer Nummern ueberschreiben 
		my @altnamen=grep(/<realName>.+<\/realName>/,@zeilen);
		my %altnamen;
		foreach(@altnamen) { my @zuweisung=split(/<\/realName>/, $_); $altname{$zuweisung[0]."<\realName>"}=$zuweisung[1];}
		my $zeilen="";
		foreach(keys(%altnamen)) { 
		        if( $_=~m/^<contact>/ ) {
			    push(@zeilen, $_.$altname{$_}); }
		        }
		@zeilen=sort(@zeilen);
		foreach(@zeilen) { $_=decode("utf8",$_); }
		}
	open(DATEI, ">../../Downloads/$fritzname.xml") || die "$fritzname kann nicht beschrieben werden";
		print DATEI @fritzanfang;
		print DATEI @zeilen;
		print DATEI @fritzende;
	close(DATEI);
	chmod(0777, "../../Downloads/$fritzname.xml");
	}
   ############

}


sub Neues_Schreiben { 
   
   #Wirft aufgrund des aufgeschlagenen Verzeichnisses das nächste freie Schreiben aus, entweder Postein- ($Inout="_") oder Postausgang ($Inout="")
   
   my $Fall = shift;
   my $Inout= shift;

        my $Name;
	my @Name;
	my $Aktiv=0;
	
	# Stufe ermitteln
	my @Files = glob("$Fall/*.*");
	my @Infiles = glob("$Fall/*$Inout*.*");
	my $Staub=400000;    # Tage seit dem letzten Öffnen
	my $Newfile;

	foreach(@Infiles) {    # neuste Datei herausziehen
		#$_=Form::utf82html("utf8",$_)); 
		if( -M $_< $Staub ) {
			$Staub=-M $_;
			$Newfile=$_; 
			}
		}	
		
	#Schreiben sind im Fall vorhanden
	my $fehlt=1;
	if( length($Newfile)>0 ) {   # Schreiben im Fall vorhanden
		$Name = $Newfile;
		$Name =~ s/.+\///g;
		$Name =~ s/(\-\w+)?\.\w\w\w(\w)?$//;
	     my $Pos =index(/[A-Z]\d+$/, $Name);
	     my @Teil=( substr($Name,0,$Pos), substr($Name,$Pos) );        
	        $Name = join(/$Inout/, @Teil);
	        if( length($Inout)>0 ) {
			$Name =~s/__/_/g; }
	        $Name=~s/\d+//g;
	     
	     #gerichtlich vorhanden und aktiv -> diesen Buchstaben behalten
	     if( $Name =~ m/[A-Z]$/ ) { 
	        my $Last=0;
		foreach (@Files) {
		        if( $_=~m/$Name/ ) {
				$_ =~ s/.+\///g;
				$_ =~ s/\D+//g;
				if( $_*1>$Last ) { $Last=$_*1; }
				}
			} 
                $Last++;
                $Name.=$Last;
                $Name[1]=Form::utf82html($Name);
		$Aktiv=1;
		$fehlt=0;
		}
			
	     # gerichtlich, aber nicht aktiv -> höchsten Buchstaben global suchen
	     else { #gerichtlich inaktiv		        
	        $Name =~s/_//g;
	        my %Courts;
		foreach (@Files) { 
			$_ =~ s/.+\///g;
		        $_ =~ s/(\-\w+)?\.\w\w\w(\w)?$//;
			if( $_=~m/[A-Z]\d+$/ ) { #gerichtlich im Ordner vorhanden
				if($_=~m/$Name/) { 
				   $_=~s/$Name//; 
				   if($Court{substr($_,0,1)}) {
						if($Court{substr($_,0,1)}*1<substr($_,1)*1) {
						   $Court{substr($_,0,1)}=substr($_,1)*1; }
						}
				   else { $Court{substr($_,0,1)}=substr($_,1)*1; }
				   }
			     my @Buchstaben=sort(keys(%Court));
				$Name[1] = $Name.$Inout.pop(@Buchstaben);
			     my $Last    = 0+$Court{"$Name[1]"}*1+1;
				$Name[1].= $Last;
				$Name[1] = Form::utf82html($Name[1]);
				$fehlt=0;
				}
			}
		}
	     }
	     my %Beteiligte=%{Form::Auslesen_Spiegel("$Fall/data/stammdaten.cfg", "", "")};
		$Name=$Beteiligte{"Cmfile"}.$Inout;
		$Name=Form::html2utf8($Name);
	     if( $fehlt>0 ) { #gerichtlich im Ordner nicht vorhanden -> global suchen
			my @Buchstaben=("A"); #Fallback
			my @Allfiles = glob("$Documentfolder/*/*/$Name*.*");
			foreach (@Allfiles) {
				$_ =~ s/.+\///g;
		                $_ =~ s/(\-\w+)?\.\w\w\w(\w)?$//;
				if($_=~m/$Name/) {
				   $_=~s/$Name//;
				   if(substr($_,0,1)=~m/[A-Z]/) {
					 push(@Buchstaben,substr($_,0,1)); 
					 }
				   }
				 }
		        sort(@Buchstaben);
			$Name[1] = $Name.pop(@Buchstaben)."1";
			$Name[1] = Form::utf82html($Name[1]);
			}   
			    
	     # außergericht einheitlich global ermitteln
	     my $Last = 0;
		#  Ziffer ermitteln
	     my $Documentfolder=$Fall;
		$Documentfolder=~s/\/\d+\/\d+//g;
		my @Allfiles = glob("$Documentfolder/*/*/$Name*.*"); 
		foreach (@Allfiles) {
			$_ =~ s/.+\///g;
			$_ =~ s/(\-\w+)?\.\w\w\w(\w)?$//;
			$_=~s/$Name//;
			unless(substr($_,0,1)=~m/[A-Z]/) {
			        $_=~s/\D//g;
			        if($_*1>$Last) { $Last=$_*1; }
				}
			} 
		$Last++;
		
		$Name    = $Name.$Last;   
		$Name[0] = Form::utf82html($Name);
		
		$Name[2] = $Aktiv;

	return \@Name;  #[0]:freier außergerichtlicher Name, [1]: freier Gerichtsname selbe Ebene, [3]: welcher von beiden ist aktiv (0 oder 1)?
	
}

1;
