#=====================================================================
#
# Lawsuit - Smallbusiness-Software 
#           fuer Rechtsanwaelte 
#
# Copyright (C) 2008
#
#  Author : RA Matthias Hermanns
#     Web : http://www.iustus.eu
#
#======================================================================

#############################
# Benötigt das Programm zip #
##############################


package Form;

   use Encode;     # fuer OpenOffice - Konvertierung in UTF-8 mit Modul Formular 
   use File::Copy; # um Verzeichnis aus komplett zu verschieben
   use ODF::lpOD;   # um ODT-Dokumente ohne CRC-Fehler zu zippen 
   use CGI;
   use strict;
   use warnings;
   
sub Session {
     my $sessionid=shift; 	# SitzungsID
     my $sessionlength=shift; 	# Sitzungslaenge in Sekunden
     my $redirect=shift;	# Umleitung auf diese Login-Seite
     my $oldpassword=shift;	# Passwort
     my $newpassword=shift;	# Neues Passowrt (optional)
     my @pswd=($oldpassword, $newpassword);
     my $zeit;
     my @key;
     my @session;

     #Forward aus Monaten 0-11 entwickeln
     my ($Sekunden, $Minuten, $Stunden, $Monatstag, $Monat,
        $Jahr, $Wochentag, $Jahrestag, $Sommerzeit) = localtime(time);
        
     for(my $k=0; $k<2; $k++) {
     
        # Passwort in Integer umsetzen
	$key[$k]=Form::Kontrollziffer(Form::kryptisch($pswd[$k],$Monat,100),0,97);
	
        #Passwort mit Zeit seit 1970 abzgl. Kaschierungszeit multiplizieren (Math.floor^=int) 
           $zeit = time();
	   $session[$k] = $key[$k] * int(($zeit-18000)/$sessionlength);
	}
	
     # nur bei neuem Passwort alternieren	
     unless($newpassword) { $key[1]=$key[0]; }
     # Abweichung selbst vom Vorzeitrahmen->Ausstieg mit Fehlermeldung und Umleitung
     if($sessionid != $session[0] && $sessionid !=$session[0]-1 ) {
        print "Pragma: no-cache\nContent-type: text/html\n\n";
        if( $key[0]==0 ) {
	      print "session: ",$sessionid,"<br>password: ",$oldpassword,"<br>key: ",$key[0],"\n";
	      print "<br><b>No password given!</b>";
	      }
	else {
	      my $ende=$sessionid/$key[0]*$sessionlength+18000;
	      #juenger als lfd. Monat (s. Forward) -> praezise Fehlermeldung, sonst allgemein
	      $ende=($zeit-$ende>0 && $zeit-$ende<$Monatstag*86400)? "since ".localtime($ende) : "a long time ago";
	      print qq~<HEAD><TITLE>Error</TITLE>
	      <script type="text/javascript">
	      <!--
	      setTimeout(function () {
		  window.location.href = window.location.href.replace(/\/[0-9a-zA-Z]\.pl.+$/,"~,$redirect,qq~");
	      }, 10000);
	      //–>
	      </script>
	      </HEAD><BODY bgcolor="#ffffff"><BR><BR><BR><table align="center" width="500">
	      <tr><td align="center"><B><FONT COLOR="#aa0000"><H2>Error!</h2></FONT><FONT COLOR="#000080"><BR>This session has expired ~,$ende,qq~!<br><br>
	      Aufgrund l&auml;ngerer Inaktivit&auml;t oder, weil Sie &uuml;ber l&auml;ngere Zeit ausgeloggt waren, 
	      wurde Ihre Sitzung automatisch beendet, um unerlaubten Zugriff auszuschlie&szlig;en.<br>
	      Bitte loggen Sie sich erneut ein!<br><br>
	      Pour cause d&apos;inactivit&eacute; prolong&eacute;e ou parce que vous vous &ecirc;tes d&eacute;connect&eacute;(e) pendant un certain temps,<br> 
	      votre session a expir&eacute; automatiquement afin d&apos;emp&ecirc;cher un acc&egrave;s non autoris&eacute;.
	      Reconnectez vous, s.v.p.!
	      </FONT></B><BR><BR>
	      <input type=button onClick="window.location.href=window.location.href.replace(/\\d/,&quot;1&quot;);" value="Okay">
	      <BR><BR></td></tr></table></BODY></HTML>~;
	      }
	exit;
	}
	
      # keine Abweichung->Rueckgabe der neuen SessionID

      return $session[1];
	   
}
	

sub Speichern_Spiegel {
    my $feldnamen=shift;
    my @feldnamen=@{$feldnamen};
    my $feldwerte=shift;
    my %feldwerte=%{$feldwerte};
    my $datei = shift;
    my $praefix = shift;
    my @zeilen;
    my $wert="";
    my @neuezeilen;

    if( -e "./$datei" )  {
        open(DATEI, "<$datei") || die "die Datei nicht gefunden";
          @zeilen = <DATEI>;
        close(DATEI);

        foreach my $zeile (@zeilen) {
            my @woerter = split(/#?\:#?/, $zeile);
            $wert="";
            for( my $i = 1; $i <= $#woerter; $i++) {
                  $wert .= $woerter[$i].":";
               }
            $wert =~ s/\n//;
            #$Wert = decode("utf8", $Wert);
            chop($wert);
	    # Booleans erkennen
	    $wert =~ s/^\&Acirc\;*/1/;
            # Booleans  ausfiltern und Praefixbedingung pruefen
            if( $wert ne "1" && ($woerter[0] =~ /^$praefix/) )  {
                foreach( my $i = 0; $i <= $#feldnamen; $i++) { # nicht $#feldnamen, um noch anzuhaengen
                      if( $feldnamen[$i] and $woerter[0] eq $feldnamen[$i]  ) {
                          $wert = utf82html($feldwerte{$feldnamen[$i]});
                          undef($feldnamen[$i]);
                          $wert =~s/\r\n/<br>/g if defined $wert
;
	                  $wert =~ s/\s/&nbsp;/g if defined $wert;         # Leerzeichenfehler 1. Aufruf (utf8)
	                  #$Wert = encode("latin1", $Wert);
		          }
                      }
                $zeile = "$woerter[0]#\:#$wert\n";
                push (@neuezeilen, $zeile);
                }
        }

   } 
   my $zeile;
   foreach my $feld (@feldnamen) {
       if( $feld && ($feld =~ /^$praefix/) ) {
          $wert = utf82html($feldwerte{$feld});
          $wert =~ s/^\&Acirc\;*/1/;          # Neue Booleans erkennen und anhaengen
          $zeile = "$feld#\:#$wert\n";
          push (@neuezeilen, $zeile);
       }
   }
      open(DATEI, ">$datei") || die "die Datei $datei kann nicht geschrieben werden :\n$!";
        print DATEI @neuezeilen;
      close(DATEI);
      chmod(0777, $datei);

}


sub Speichern {
    my $datei=shift;
    my $zeilen=shift;
    my @zeilen=@{$zeilen};
    my $fehlertext=shift;

    foreach my $zeile (@zeilen) {
	$zeile=utf82html($zeile)."\n";
	$zeile=~s/&nbsp;&nbsp;$//g	if defined $zeile;
	$zeile=~s/&nbsp;$//g	if defined $zeile;
	$zeile=~s/#&#58;#/#:#/g	if defined $zeile;
	$zeile=decode("utf8", $zeile);  #Update-Verwirrung
	if( $datei=~m/user.cfg/ ) {$zeile=~s/&#58;/:/g if defined $zeile;}
	}
    open(DATEI, ">$datei") || die $fehlertext;
	print DATEI @zeilen;
    close(DATEI);
    chmod(0777, $datei);

}


sub Adresszeilen {
    ## Adressfeld zusammenstellen ##
    my $daten=shift;
    my %daten=%{$daten};
    my $praefixe=shift;
    my @parteien;

    my %langland;
    my @laender=@{Auslesen("../data/land.cfg")};
    	foreach (@laender) {
		my @woerter=split(/#?\:#?/,$_);
		$langland{$woerter[0]} = $woerter[3];
		}
    
    while( length($praefixe)>0 ) {
	push(@parteien, chop($praefixe) );
	}

    foreach my $P (@parteien) {


	if( length($daten{$P."telefax"})>0 && ($P eq "G" || $P eq "P") ) {
		$daten{$P."adresse0"}="&minus;&nbsp;vorab&nbsp;per&nbsp;Telefax&nbsp;".$daten{$P."telefax"}."&nbsp;&minus;";
	} elsif( $P eq "G" ) {
		$daten{$P."adresse0"}="&minus;&nbsp;per&nbsp;Einwurfeinschreiben&nbsp;&minus;";
	} else {
		$daten{$P."adresse0"}="";
		}
	if( $daten{$P."typ"} eq "Verwaltungstraeger" or $daten{$P."typ"} eq "Kanzlei" or $daten{$P."typ"} eq "Versicherung") {
		$daten{$P."langname"}=$daten{$P."gebietskoerperschaft"}."&nbsp;&minus;&nbsp;".$daten{$P."name"};
		$daten{$P."name"}=~s/&nbsp;&minus;&nbsp;/ - /g if defined $daten{$P."name"};
		my @woerter=split(/ - /,$daten{$P."name"});
		$daten{$P."adresse1"}=$woerter[0];
		$daten{$P."adresse2"}="&minus;&nbsp;".$woerter[1]."&nbsp;&minus;";
		$daten{$P."name"}=$woerter[0];
	} else {
		my @ges=("", "Herr", "Frau", "An&nbsp;die", "An&nbsp;das", "An&nbsp;den", "Eheleute", "Familie");
		if( length($daten{$P."anrede"})<=0 ) {$daten{$P."anrede"}=$ges[$daten{$P."ges"}]; }
		$daten{$P."adresse1"}=$daten{$P."anrede"};
		$daten{$P."adresse2"}=$daten{$P."name"};
		}
	if( $daten{$P."ges"}<3 || $daten{$P."ges"}>5 ) { # Erweiterung ab 6 fuer Eheleute und Familie
		$daten{$P."anrdekliniert"}=$daten{$P."anrede"};
		$daten{$P."anrdekliniert"}=~s/Herr/Herrn/g if defined $daten{$P."anrdekliniert"};
;
		$daten{$P."adresse1"}=$daten{$P."anrdekliniert"};
		$daten{$P."adresse2"}=$daten{$P."vorname"}."&nbsp;".$daten{$P."nachname"};
		}
	   $daten{$P."adresse3"} =  $daten{$P."strasse"};
	   $daten{$P."adresse4"} = ($daten{$P."land"} ne "D")? $daten{$P."land"}."&nbsp;&minus;&nbsp;" : "";
	   $daten{$P."adresse4"} .= $daten{$P."plz"}."&nbsp;".$daten{$P."stadt"};
           $daten{$P."adresse5"} = ($daten{$P."land"} ne "D")? $langland{$daten{$P."langland"}} : "";
	if( length($daten{$P."korrespondenzadresse1"})>1 ) {
		if( $daten{$P."korrespondenzadresse1"} =~ m/\|/ ) { # Zeile mit Splittinghinweis "|" aufteilen
			if( $daten{$P."typ"} eq "Verwaltungstraeger" ) {
				$daten{$P."adresse1"} = $daten{$P."langname"}; }
			else {  $daten{$P."adresse1"} = $daten{$P."adresse2"}; }
			my @woerter = split(/(\&nbsp;)?\s?\|\s?(\&nbsp;)?/, $daten{$P."korrespondenzadresse1"});
			$daten{$P."adresse2"} = $woerter[0];
			$daten{$P."adresse3"} = $woerter[3];
			}
		else {
			$daten{$P."adresse3"} = $daten{$P."korrespondenzadresse1"};
			}
		$daten{$P."adresse4"} = $daten{$P."korrespondenzadresse2"}."&nbsp;".$daten{$P."korrespondenzadresse3"};
		# nur bei gleicher Stadt Ausland von oben beibehalten
		if( $daten{$P."korrespondenzadresse3"} ne $daten{$P."stadt"} )  { 
			$daten{$P."adresse5"} = ($daten{$P."land"} ne "D")? $langland{$daten{$P."langland"}} : ""; }
		}
	if( length($daten{$P."gruss"})<1 ) {
		$daten{$P."gruss"} = "Mit&nbsp;freundlichen&nbsp;Gr&uuml;&szlig;en"; 
		}
	my $p = lc($P);
	## Gegner grds. durch Anwalt ersetzten, ausser Notfall, § 12 BORA; eigenen Anwalt unter A.. fuehren
	if( $daten{'Cmuntervollmacht'} and $p eq "m" ) { $p="m1" }; # Bei Untervollmacht Hauptbevollmaechtigten statt Mdt anschreiben
	if( length($daten{'C'.$p.'anwalt'})>0 ) {
		my %kanzlei;
                my $kanzleidatei;
		my $anwaltsdatei;
		my @anwaltszeilen=@{Form::Auslesen("../attorney/all.cfg")};
		foreach (@anwaltszeilen) {
		@_=split("#:#", $_);
		$_[4]=~s/\n//g;
		$kanzlei{"$_[3]#:#$_[4]"}.="$_[0]#:#";
		if( $_[1] eq $daten{'C'.$p.'anwalt'} ) { 
			$kanzleidatei = html2utf8($_[3]); 
			$anwaltsdatei = html2utf8($_[0]);
			}
		}
		my %adresse=%{Auslesen_Spiegel("../attorney/$kanzleidatei/adresse.cfg", "", "")};
		my %anwalt= %{Auslesen_Spiegel("../attorney/$kanzleidatei/$anwaltsdatei.cfg", "", "")};
		# Ueberschreiben, im Notfall statt Parteifile die Anwaltsfile nennen
                if( $P eq "M" && $p ne "m1" ) { $P="A"; }
                if( $P eq "G" && $daten{"notfall"} ) { $P="X"; $daten{$P."file"} = $anwalt{"Afile"}; }
                $daten{$P."mail"} = ( length($anwalt{"Amail"})>0 )? $anwalt{"Amail"} :  $adresse{"Kmail"};
                $daten{$P."telefax"} = $adresse{"Ktelefax"};
                if( $anwalt{"Ages"}==1 ) { $daten{$P."anrede"} = "Herr&nbsp;Rechtsanwalt&nbsp;"; }
                if( $anwalt{"Ages"}==2 ) { $daten{$P."anrede"} = "Frau&nbsp;Rechtsanw&auml;ltin&nbsp;"; }
                if( $anwalt{"Ages"}==3 ) { $daten{$P."anrede"} = "Herr&nbsp;Rechtsanwalt&nbsp;und&nbsp;Notar&nbsp;"; }
                if( $anwalt{"Ages"}==4 ) { $daten{$P."anrede"} = "Frau&nbsp;Rechtsanw&auml;ltin&nbsp;und&nbsp;Notarin&nbsp;"; }
                if( $anwalt{"Ages"}==5 ) { $daten{$P."anrede"} = "Herr&nbsp;"; }
                if( $anwalt{"Ages"}==6 ) { $daten{$P."anrede"} = "Frau&nbsp;"; }
                $daten{$P."anrdekliniert"} = $daten{$P."anrede"};
		$daten{$P."anrdekliniert"}=~s/Herr/Herrn/g if defined $daten{$P."anrdekliniert"};
                my @name;
		if( $anwalt{"Aname"}=~m/\,/ )  {
			 @name = split(/\,\s?/,$anwalt{"Aname"});
			 $name[1] =~ s/\&nbsp\;//;
		} else { $name[1] = $anwalt{"Aname"};
			 $name[0] = ""; }
		if( length($daten{$P."telefax"})>0 ) {
			 $daten{$P."adresse0"}="&minus;&nbsp;vorab&nbsp;per&nbsp;Telefax&nbsp;".$daten{$P."telefax"}."&nbsp;&minus;"; }
		$daten{$P."adresse1"}  = $adresse{"Kname"};
		$daten{$P."adresse2" } = $daten{$P."anrdekliniert"};
		$daten{$P."adresse2"} .= ($anwalt{"Atitel"})? $anwalt{"Atitel"}."&nbsp;" : "";
		$daten{$P."adresse2"} .= $name[1]."&nbsp;".$name[0];
		$daten{$P."adresse3"}  = $adresse{"Kstrasse"};
		$daten{$P."adresse4"}  = ($adresse{"Kland"} ne "D")? $adresse{"Kland"}."&nbsp;&minus;&nbsp;" : "";
		$daten{$P."adresse4"} .= $adresse{"Kplz"}."&nbsp;".$adresse{"Kstadt"};
		$daten{$P."land"}      = $adresse{"Kland"};
		$daten{$P."adresse5"} = ($daten{$P."land"} ne "D")? $langland{$daten{$P."langland"}} : "";
		$daten{$P."ansprache"} = ($anwalt{"Ages"}%2==0)? "Sehr&nbsp;geehrte&nbsp;Frau&nbsp;Kollegin&nbsp;" : "Sehr&nbsp;geehrter&nbsp;Herr&nbsp;Kollege&nbsp;";
		$daten{$P."ansprache"}.= (length($anwalt{"Atitel"})>0)? $anwalt{"Atitel"}."&nbsp;" : "";
		$daten{$P."ansprache"}.= $name[1]."&nbsp;".$name[0].",";
		$daten{$P."gruss"}     = "Mit&nbsp;freundlichen&nbsp;kollegialen&nbsp;Gr&uuml;&szlig;en";
		$daten{$P."zeichen"} = $daten{"C".$p."anwzeichen"}
		}
	}
   

   return \%daten;

}


sub Letzter {
    # gibt aus einer Dateiensammlung den juengsten Eintrag zurueck, der zum Suchschema passt
    my $datei=shift;
    
    my @ListDateien = glob("$datei*");
    my @SortDateien; 
    foreach(@ListDateien) {
	my @Info = stat($_);
	$_=Form::utf82html($_);
	push(@SortDateien, $Info[9]."#:#".$_);
	}
    @SortDateien=sort(@SortDateien);
    $datei=pop(@SortDateien);
    $datei=~s/^.+#:#//;

    return $datei;
   
}


sub kryptisch {
    # verschiebt, zieht Nullen heraus, setzt Zufallswerte ein und den Inhalt danach in eine Zahlenkolonne um, die zu Buchstaben komprimiert wird
    my $s =shift; # Wert
    my $f =shift; # Forward-Schub
    my $j =shift; # Joker alle j Zeichen eine Zufallszahl
    my $k =shift; # Kuerzung aktivieren
    my $e =shift; # Kodierung

    # Modulo-Division durch 0 ist nicht erlaubt
    $f=(length($f)<1)? 2 : $f;
    $j=(length($j)<1)? 999 : $j;
    
    # Format anpassen
    $s =( lc($e) =~ m/utf-?8/ )? Form::utf82html($s) : Form::utf82html(encode("utf8",$s));

    # Aufblasen, Zerstückeln, Abkochen
    my $x=1;
    my $q="";
    my $b=":0b"; # Boolean
    my $r=($k)? 2 : 3;                              # wenn keine Kürzung, Zahlen dreistellig lassen
    while(length($s)>0) {
	  my $c=ord(chop($s))-32+ord(substr($f,($x % length($f)),1))-32; 
          # bereichsuebergreifend 
      $b.=int($c/100)*1;
      if( length($b) % 7 == 0 ) { $b.=":0b";}       # Oktett erreicht?
      if($k) { $c=$c % 100; }
	  while(length($c)<$r) {
         $c="0".$c; }   
	  $q=$c.$q;
  	  if($x % $j == 0) {
	     $c=(int(rand(58))+64);                     # Zufallszahl einstreuen
	     $b.=(int($c/100))*1;                       # Oktett erreicht?
	     if( length($b) % 7 == 0 ) { $b.=":0b";}
	     if($k) { $c=$c % 100; }
	     while(length($c)<$r) { 
            $c="0".$c; }
         $q=$c.$q;
	     }
	  $x++;
	  }
    
    
    if( $k ) {
        # zu Buchstaben
        my $c;
        for(my $y=42; $y<=67; $y++) {
            $c=chr($y+55);
            $q =~ s/$y/$c/g;
            }
        for(my $y=10; $y<=35; $y++) {
            $c=chr($y+55);
            $q =~ s/$y/$c/g;
            }
        
        # Bytes anhaengen
           $b =~ s/\:0b$//;                         # ueberfluessigen Anhang entfernen
        my @octet = split /:/, $b;
            shift(@octet);                          # Anfangsleerfeld entfernen
        foreach(@octet) { while(length($_)<6) { $_.="0"; } $q.= sprintf("%X",oct($_)); }
        
        # Info anhaengen
        $q.=$#octet;                                # Anzahl anhaengen
        }
     
   return $q;
 
 }

 
sub unkryptisch {
    # tauscht Buchstaben in Zahlen zurueck, rechnet Zahlenkolonne in Zeichenkette zurueck und filtert die Zufallswerte wieder heraus
    my $s =shift; # Wert
    my $f =shift; # Forward-Schub
    my $j =shift; # Joker alle j Zeichen eine Zufallszahl
    my $k =shift; # Kuerzung aktiviert
    my $e =shift; # Kodierung

    # Modulo-Division durch 0 ist nicht erlaubt
    $f=(length($f)<1)? 2 : $f;

    # Bytes auslesen
    my $l=($k)? chop($s) : -1; 
    my $o=substr($s,(length($s)-$l-1),($l+1));      
       $s=substr($s,0,(length($s)-$l-1));
    my $b=sprintf( "%B", hex $o); while( length($b)<(($l+1)*4) ) { $b="0".$b; } 
       $b=reverse($b); 

    # Buchstaben rueckumwandeln
    if( $k ) {
        my $c;
        for(my $y=10; $y<=35; $y++) {
            $c=chr($y+55);
            $s =~ s/$c/$y/g;
            }
        for(my $y=42; $y<=67; $y++) {
            $c=chr($y+55);
            $s =~ s/$c/$y/g;
            }
        }
    
    #Einfrieren, Zusammensetzen, Mangeln
    my $x=length($s);
    my $c="";
    my $q="";
    my $r=($k)? 1 : 2;                              # Zahlen dreistellig, wenn keine Kuerzung
    my $y=0;                                        # Joker wird rueckwaerts gezaehlt
    my $pause=0;
    while(length($s)>0) {
	 $c=chop($s).$c;
	 if( length($c)>$r  ) {
	     if( $y % $j == 0 && $y!=0 && !($pause) ) { # Joker heraus
		 $c=""; $x--; $pause=1; chop($b); }         # Oktett weiterzaehlen
	     else {
            if($k) { $c=chop($b).$c; } 
            $c=int($c*1)+32-ord(substr($f,(($y+1) % length($f)),1))+32; 
            # bereichsuebergreifend
            $q=chr($c).$q;
            $c="";
            $y++;
            $pause=0;
            }
        $x--;
	    }
	}
    
    # Format anpassen
    $q =( lc($e) =~ m/utf-?8/ )? Form::utf82html($q) : decode("utf8",Form::utf82html($q));
    
    return $q;
    
}


sub html2utf8 {
    # Hinweis: &amp; fuer "&" und &lt; fuer "<" und &gt; fuer ">" koennen so uebernommen werden, keine weitere Kodierung erforderlich
    my $f = shift;  #encode("utf8",$shift); #wieder noetig; Updateverwirrung mit utf8 ist nicht behoben
		# OpenOffice
		$f =~ s/&bdquo;/„/g	 if defined $f;
		$f =~ s/&rdquo;/“/g	 if defined $f;
		$f =~ s/&ndash;/–/g	 if defined $f;
		$f =~ s/ /&nbsp;/g	 if defined $f;   #Formatierungsfehler (Teilzeichen)
		$f =~ s/&nbsp;nbsp;/&nbsp;/g	 if defined $f;   #Formatierungsfehler (Teilzeichen)
	#	$f =~ s/&#160;/&nbsp;/g	 if defined $f;  # keine Veraenderung fuer Uebersendungszettel
		$f =~ s/&amp;nbsp;/ /g	 if defined $f;  
		$f =~ s/&nbsp;/ /g	 if defined $f;   # wird nicht erkannt
		
	#	$f =~ s/ //g	 if defined $f;
	#	$f =~ s/&#x00A0;/test/g	 if defined $f;
		$f =~ s/&#160;/&#160;/g	 if defined $f;
		$f =~ s/&Agrave;/À/g	 if defined $f;
		$f =~ s/&Aacute;/Á/g	 if defined $f;
		$f =~ s/&Acirc;/Â/g	 if defined $f;
		$f =~ s/&Atilde;/Ã/g	 if defined $f;
		$f =~ s/&Auml;/Ä/g	 if defined $f;
		$f =~ s/&Aring;/Å/g	 if defined $f;
		$f =~ s/&AElig;/Æ/g	 if defined $f;
		$f =~ s/&agrave;/à/g	 if defined $f;
		$f =~ s/&aacute;/á/g	 if defined $f;
		$f =~ s/&acirc;/â/g	 if defined $f;
		$f =~ s/&atilde;/ã/g	 if defined $f;
		$f =~ s/&auml;/ä/g	 if defined $f;
		$f =~ s/&aring;/å/g	 if defined $f;
		$f =~ s/&aelig;/æ/g	 if defined $f;

		$f =~ s/&Ccedil;/Ç/g	 if defined $f;
		$f =~ s/&ccedil;/ç/g	 if defined $f;

		$f =~ s/&Egrave;/È/g	 if defined $f;
		$f =~ s/&Eacute;/É/g	 if defined $f;
		$f =~ s/&Ecirc;/Ê/g	 if defined $f;
		$f =~ s/&Etilde;/?/g	 if defined $f;
		$f =~ s/&egrave;/è/g	 if defined $f;
		$f =~ s/&eacute;/é/g	 if defined $f;
		$f =~ s/&ecirc;/ê/g	 if defined $f;
		$f =~ s/&euml;/ë/g	 if defined $f;

		$f =~ s/&#287;/ğ/g	 if defined $f;

		$f =~ s/&Igrave;/Ì/g	 if defined $f;
		$f =~ s/&Iacute;/Í/g	 if defined $f;
		$f =~ s/&Icirc;/Î/g	 if defined $f;
		$f =~ s/&Iuml;/Ï/g	 if defined $f;
		$f =~ s/&igrave;/ì/g	 if defined $f;
		$f =~ s/&iacute;/í/g	 if defined $f;
		$f =~ s/&icirc;/î/g	 if defined $f;
		$f =~ s/&iuml;/ï/g	 if defined $f;

		$f =~ s/&#208;//g	 if defined $f;
		$f =~ s/&#240;//g	 if defined $f;
		$f =~ s/&Ntilde;/Ñ/g	 if defined $f;
		$f =~ s/&ntilde;/ñ/g	 if defined $f;

		$f =~ s/&Ograve;/Ò/g	 if defined $f;
		$f =~ s/&Oacute;/Ó/g	 if defined $f;
		$f =~ s/&Ocirc;/Ô/g	 if defined $f;
		$f =~ s/&Otilde;/Õ/g	 if defined $f;
		$f =~ s/&Ouml;/Ö/g	 if defined $f;
		$f =~ s/&Oslash;/Ø/g	 if defined $f;
		$f =~ s/&ograve;/ò/g	 if defined $f;
		$f =~ s/&oacute;/ó/g	 if defined $f;
		$f =~ s/&ocirc;/ô/g	 if defined $f;
		$f =~ s/&otilde;/õ/g	 if defined $f;
		$f =~ s/&ouml;/ö/g	 if defined $f;
		$f =~ s/&oslash;/ø/g	 if defined $f;

		$f =~ s/&Ugrave;/Ù/g	 if defined $f;
		$f =~ s/&Uacute;/Ú/g	 if defined $f;
		$f =~ s/&Ucirc;/Û/g	 if defined $f;
		$f =~ s/&Uuml;/Ü/g	 if defined $f;
		$f =~ s/&ugrave;/ù/g	 if defined $f;
		$f =~ s/&uacute;/ú/g	 if defined $f;
		$f =~ s/&ucirc;/û/g	 if defined $f;
		$f =~ s/&uuml;/ü/g	 if defined $f;

		$f =~ s/&Yacute;/Ý/g	 if defined $f;
		$f =~ s/&Yuml;/Ÿ/g	 if defined $f;
		$f =~ s/&yacute;/ý/g	 if defined $f;

		$f =~ s/\&THORN;/þ/g	 if defined $f;
		$f =~ s/\&#215;/×/g	 if defined $f;

		$f =~ s/&szlig;/ß/g	 if defined $f;
		$f =~ s/&euro;/€/g	 if defined $f;
		$f =~ s/&sect;/§/g	 if defined $f;
		$f =~ s/&copy;/©/g	 if defined $f;
		$f =~ s/&reg;/®/g	 if defined $f;

		$f =~ s/&Alpha;/Α/g	 if defined $f;
		$f =~ s/&alpha;/α/g	 if defined $f;
		$f =~ s/&#945;/α/g	 if defined $f;
		$f =~ s/&Beta;/Β/g	 if defined $f;
		$f =~ s/&beta;/β/g	 if defined $f;
		$f =~ s/&#946;/β/g	 if defined $f;
		$f =~ s/&Gamma;/Γ/g	 if defined $f;
		$f =~ s/&gamma;/γ/g	 if defined $f;
		$f =~ s/&#947;/γ/g	 if defined $f;
		$f =~ s/&#947;/γ/g	 if defined $f;		
		$f =~ s/&Delta;/Δ/g	 if defined $f;
		$f =~ s/&delta;/δ/g	 if defined $f;
		$f =~ s/&#948;/δ/g	 if defined $f;

		$f =~ s/&Epsilon;/Ε/g	 if defined $f;
		$f =~ s/&epsilon;/ε/g	 if defined $f;
		$f =~ s/&#949;/ε/g	 if defined $f;
		$f =~ s/&Zeta;/Ζ/g	 if defined $f;
		$f =~ s/&#950;/ζ/g	 if defined $f;
		$f =~ s/&zeta;/ζ/g	 if defined $f;
		$f =~ s/&Eta;/Η/g	 if defined $f;
		$f =~ s/&eta;/η/g	 if defined $f;
		$f =~ s/&#951;/η/g	 if defined $f;
		$f =~ s/&Theta;/Θ/g	 if defined $f;
		$f =~ s/&theta;/θ/g	 if defined $f;
		$f =~ s/&#952;/θ/g	 if defined $f;

		$f =~ s/&Iota;/Ι/g	 if defined $f;
		$f =~ s/&iota;/ι/g	 if defined $f;
		$f =~ s/&#953;/ι/g	 if defined $f;
		$f =~ s/&Kappa;/Κ/g	 if defined $f;
		$f =~ s/&kappa;/κ/g	 if defined $f;
		$f =~ s/&#954;/κ/g	 if defined $f;
		$f =~ s/&Lambda;/Λ/g	 if defined $f;
		$f =~ s/&lambda;/λ/g	 if defined $f;
		$f =~ s/&#955;/λ/g	 if defined $f;
		$f =~ s/&Mu;/Μ/g	 if defined $f;
		$f =~ s/&mu;/μ/g	 if defined $f;
		$f =~ s/&#956;/μ/g	 if defined $f;

		$f =~ s/&Nu;/Ν/g	 if defined $f;
		$f =~ s/&nu;/ν/g	 if defined $f;
		$f =~ s/&#957;/ν/g	 if defined $f;
		$f =~ s/&Xi;/Ξ/g	 if defined $f;
		$f =~ s/&xi;/ξ/g	 if defined $f;
		$f =~ s/&#958;/ξ/g	 if defined $f;
		$f =~ s/&Omicron;/Ο/g	 if defined $f;
		$f =~ s/&omicron;/ο/g	 if defined $f;
		$f =~ s/&#959;/ο/g	 if defined $f;
		$f =~ s/&Pi;/Π/g	 if defined $f;
		$f =~ s/&pi;/π/g	 if defined $f;
		$f =~ s/&#960;/π/g	 if defined $f;

		$f =~ s/&Rho;/Ρ/g	 if defined $f;
		$f =~ s/&rho;/ρ/g	 if defined $f;
		$f =~ s/&#961;/ρ/g	 if defined $f;
		$f =~ s/&Sigma;/Σ/g	 if defined $f;
		$f =~ s/&sigmaf;/ς/g	 if defined $f;
		$f =~ s/&#962;/ς/g	 if defined $f;
		$f =~ s/&sigma;/σ/g	 if defined $f;
		$f =~ s/&#963;/σ/g	 if defined $f;
		$f =~ s/&Tau;/Τ/g	 if defined $f;
		$f =~ s/&tau;/τ/g	 if defined $f;
		$f =~ s/&#964;/τ/g	 if defined $f;
		$f =~ s/&Upsilon;/Υ/g	 if defined $f;
		$f =~ s/&upsilon;/υ/g	 if defined $f;
		$f =~ s/&#965;/υ/g	 if defined $f;

		$f =~ s/&Phi;/Φ/g	 if defined $f;
		$f =~ s/&phi;/φ/g	 if defined $f;
		$f =~ s/&#966;/φ/g	 if defined $f;
		$f =~ s/&Chi;/Χ/g	 if defined $f;
		$f =~ s/&chi;/χ/g	 if defined $f;
		$f =~ s/&#967;/χ/g	 if defined $f;
		$f =~ s/&Psi;/Ψ/g	 if defined $f;
		$f =~ s/&psi;/ψ/g	 if defined $f;
		$f =~ s/&#968;/ψ/g	 if defined $f;
		$f =~ s/&Omega;/Ω/g	 if defined $f;
		$f =~ s/&omega;/ω/g	 if defined $f;
		$f =~ s/&#969;/ω/g	 if defined $f;
		
		$f =~ s/&#040;/\(/g	 if defined $f;
		$f =~ s/&#041;/\)/g	 if defined $f;
		$f =~ s/&laquo;/«/g	 if defined $f;
		$f =~ s/&raquo;/»/g	 if defined $f;
		$f =~ s/&minus;/-/g	 if defined $f;
		$f =~ s/&frasl;/\//g	 if defined $f;
		$f =~ s/&#8260;/\//g	 if defined $f;     # Workaround HTML-charset UTF8
		$f =~ s/&#8722;/-/g	 if defined $f;     # Workaround HTML-charset UTF8
		$f =~ s/&ndash/-/g	 if defined $f;     # Workaround HTML-charset UTF8
		$f =~ s/&mdash;/-/g	 if defined $f;     # Workaround HTML-charset UTF8
		$f =~ s/\&bull;/•/g	 if defined $f;     # neu fuer iustus
	#	$f =~ s/\&deg;/°/g	 if defined $f;     # neu fuer iustus
		$f =~ s/\&#58;/:/g	 if defined $f;
		$f =~ s/\&#43;/\+/g	 if defined $f;
		$f =~ s/\&#42;/\*/g	 if defined $f;     # neu fuer iustus
		$f =~ s/\&#64;/@/g	 if defined $f;     # neu fuer accounting.pl
		$f =~ s/\&euro;/€/g	 if defined $f;     # neu fuer accounting.pl

	#	$f =~ s/\s//g	 if defined $f;          # fuehrt zu Fehlern in all.cfg
		$f =~ s/&\s/&amp; /g	 if defined $f;
		$f =~ s/&amp;amp;/&amp;/g	 if defined $f;
		$f =~ s/&amp;lt;/&lt;/g	 if defined $f;
		$f =~ s/&amp;gt;/&gt;/g	 if defined $f;
	#decode("utf8",$f);
   return $f;
}


sub html2form {
    my $f = shift;  
		$f =~ s/\&nbsp;/\40/g	 if defined $f;   
		$f =~ s/&minus;/-/g	 if defined $f;   
   return $f;
}


sub utf82html {
    my $f = shift;  #encode("utf8",$f); #wieder noetig; Updateverwirrung mit utf8 ist nicht behoben
		#OpenOffice
		$f =~ s/„/&bdquo;/g	 if defined $f;
		$f =~ s/“/&rdquo;/g	 if defined $f;
		$f =~ s/–/&ndash;/g	 if defined $f;
	#	$f =~ s/&#160;/&nbsp;/g	 if defined $f;   keine Veraenderung fuer uebersendungszettel
		$f =~ s/ /&nbsp;/g	 if defined $f;   # fuer Kodierungsfehler beim doppelten Speichern von Leerzeichen
		
		$f =~ s/À/&Agrave;/g	 if defined $f;
		$f =~ s/Á/&Aacute;/g	 if defined $f;
		$f =~ s/Â/&Acirc;/g	 if defined $f;
		$f =~ s/Ã/&Atilde;/g	 if defined $f;
		$f =~ s/Ä/&Auml;/g	 if defined $f;
		$f =~ s/Å/&Aring;/g	 if defined $f;
		$f =~ s/Æ/&AElig;/g	 if defined $f;
		$f =~ s/à/&agrave;/g	 if defined $f;
		$f =~ s/á/&aacute;/g	 if defined $f;
		$f =~ s/â/&acirc;/g	 if defined $f;
		$f =~ s/ã/&atilde;/g	 if defined $f;
		$f =~ s/ä/&auml;/g	 if defined $f;
		$f =~ s/å/&aring;/g	 if defined $f;
		$f =~ s/æ/&aelig;/g	 if defined $f;

		$f =~ s/Ç/&Ccedil;/g	 if defined $f;
		$f =~ s/ç/&ccedil;/g	 if defined $f;

		$f =~ s/È/&Egrave;/g	 if defined $f;
		$f =~ s/É/&Eacute;/g	 if defined $f;
		$f =~ s/Ê/&Ecirc;/g	 if defined $f;
		$f =~ s/è/&egrave;/g	 if defined $f;
		$f =~ s/é/&eacute;/g	 if defined $f;
		$f =~ s/ê/&ecirc;/g	 if defined $f;
		$f =~ s/ë/&euml;/g	 if defined $f;

		$f =~ s/ğ/&#287;/g	 if defined $f;

		$f =~ s/Ì/&Igrave;/g	 if defined $f;
		$f =~ s/Í/&Iacute;/g	 if defined $f;
		$f =~ s/Î/&Icirc;/g	 if defined $f;
		$f =~ s/Ï/&Iuml;/g	 if defined $f;
		$f =~ s/ì/&igrave;/g	 if defined $f;
		$f =~ s/í/&iacute;/g	 if defined $f;
		$f =~ s/î/&icirc;/g	 if defined $f;
		$f =~ s/ï/&iuml;/g	 if defined $f;

		$f =~ s/&#208;//g	 if defined $f;
		$f =~ s/&#240;//g	 if defined $f;
		$f =~ s/Ñ/&Ntilde;/g	 if defined $f;
		$f =~ s/ñ/&ntilde;/g	 if defined $f;

		$f =~ s/Ò/&Ograve;/g	 if defined $f;
		$f =~ s/Ó/&Oacute;/g	 if defined $f;
		$f =~ s/Ô/&Ocirc;/g	 if defined $f;
		$f =~ s/Õ/&Otilde;/g	 if defined $f;
		$f =~ s/Ö/&Ouml;/g	 if defined $f;
		$f =~ s/Ø/&Oslash;/g	 if defined $f;
		$f =~ s/ò/&ograve;/g	 if defined $f;
		$f =~ s/ó/&oacute;/g	 if defined $f;
		$f =~ s/ô/&ocirc;/g	 if defined $f;
		$f =~ s/õ/&otilde;/g	 if defined $f;
		$f =~ s/ö/&ouml;/g	 if defined $f;
		$f =~ s/ø/&oslash;/g	 if defined $f;

		$f =~ s/Ù/&Ugrave;/g	 if defined $f;
		$f =~ s/Ú/&Uacute;/g	 if defined $f;
		$f =~ s/Û/&Ucirc;/g	 if defined $f;
		$f =~ s/Ü/&Uuml;/g	 if defined $f;
		$f =~ s/ù/&ugrave;/g	 if defined $f;
		$f =~ s/ú/&uacute;/g	 if defined $f;
		$f =~ s/û/&ucirc;/g	 if defined $f;
		$f =~ s/ü/&uuml;/g	 if defined $f;

		$f =~ s/Ý/&Yacute;/g	 if defined $f;
		$f =~ s/Ÿ/&Yuml;/g	 if defined $f;
		$f =~ s/ý/&yacute;/g	 if defined $f;

		$f =~ s/þ/&THORN;/g	 if defined $f;
		$f =~ s/×/&#215;/g	 if defined $f;

		$f =~ s/ß/&szlig;/g	 if defined $f;
		$f =~ s/€/&euro;/g	 if defined $f;
		$f =~ s/§/&sect;/g	 if defined $f;
		$f =~ s/©/&copy;/g	 if defined $f;
		$f =~ s/®/&reg;/g	 if defined $f;
		
		$f =~ s/Α/&Alpha;/g	 if defined $f;
		$f =~ s/α/&alpha;/g	 if defined $f;
		$f =~ s/Β/&Beta;/g	 if defined $f;
		$f =~ s/β/&beta;/g	 if defined $f;
		$f =~ s/Γ/&Gamma;/g	 if defined $f;
		$f =~ s/γ/&gamma;/g	 if defined $f;
		$f =~ s/Δ/&Delta;/g	 if defined $f;
		$f =~ s/δ/&delta;/g	 if defined $f;

		$f =~ s/Ε/&Epsilon;/g	 if defined $f;
		$f =~ s/ε/&epsilon;/g	 if defined $f;
		$f =~ s/Ζ/&Zeta;/g	 if defined $f;
		$f =~ s/ζ/&zeta;/g	 if defined $f;
		$f =~ s/Η/&Eta;/g	 if defined $f;
		$f =~ s/η/&eta;/g	 if defined $f;
		$f =~ s/Θ/&Theta;/g	 if defined $f;
		$f =~ s/θ/&theta;/g	 if defined $f;

		$f =~ s/Ι/&Iota;/g	 if defined $f;
		$f =~ s/ι/&iota;/g	 if defined $f;
		$f =~ s/Κ/&Kappa;/g	 if defined $f;
		$f =~ s/κ/&kappa;/g	 if defined $f;
		$f =~ s/Λ/&Lambda;/g	 if defined $f;
		$f =~ s/λ/&lambda;/g	 if defined $f;
		$f =~ s/Μ/&Mu;/g	 if defined $f;
		$f =~ s/μ/&mu;/g	 if defined $f;

		$f =~ s/Ν/&Nu;/g	 if defined $f;
		$f =~ s/ν/&nu;/g	 if defined $f;
		$f =~ s/Ξ/&Xi;/g	 if defined $f;
		$f =~ s/ξ/&xi;/g	 if defined $f;
		$f =~ s/Ο/&Omicron;/g	 if defined $f;
		$f =~ s/ο/&omicron;/g	 if defined $f;
		$f =~ s/Π/&Pi;/g	 if defined $f;
		$f =~ s/π/&pi;/g	 if defined $f;

		$f =~ s/Ρ/&Rho;/g	 if defined $f;
		$f =~ s/ρ/&rho;/g	 if defined $f;
		$f =~ s/Σ/&Sigma;/g	 if defined $f;
		$f =~ s/ς/&sigmaf;/g	 if defined $f;
		$f =~ s/σ/&sigma;/g	 if defined $f;
		$f =~ s/Τ/&Tau;/g	 if defined $f;
		$f =~ s/τ/&tau;/g	 if defined $f;
		$f =~ s/Υ/&Upsilon;/g	 if defined $f;
		$f =~ s/υ/&upsilon;/g	 if defined $f;

		$f =~ s/Φ/&Phi;/g	 if defined $f;
		$f =~ s/φ/&phi;/g	 if defined $f;
		$f =~ s/Χ/&Chi;/g	 if defined $f;
		$f =~ s/χ/&chi;/g	 if defined $f;
		$f =~ s/Ψ/&Psi;/g	 if defined $f;
		$f =~ s/ψ/&psi;/g	 if defined $f;
		$f =~ s/Ω/&Omega;/g	 if defined $f;
		$f =~ s/ω/&omega;/g	 if defined $f;
		
		$f =~ s/\(/&#040;/g	 if defined $f;
		$f =~ s/\)/&#041;/g	 if defined $f;
		$f =~ s/«/&laquo;/g	 if defined $f;
		$f =~ s/»/&raquo;/g	 if defined $f;
		$f =~ s/-/&minus;/g	 if defined $f;
		$f =~ s/\&#8722;/&minus;/g	 if defined $f;     # Workaround HTML-charset UTF8
		$f =~ s/(Â)?–/&minus;/g	 if defined $f;     # Workaround HTML-charset UTF8
		$f =~ s/(Â)?—/&minus;/g	 if defined $f;     # Workaround HTML-charset UTF8
		$f =~ s/•/&bull;/g	 if defined $f;     # neu fuer iustus
#		$f =~ s/°/&deg;/g	 if defined $f;     # neu fuer iustus
		$f =~ s/\/&frasl;//g	 if defined $f;
		$f =~ s/\+/\&#43;/g	 if defined $f;
		$f =~ s/\*/&#42;/g	 if defined $f;     # neu fuer iustus
		$f =~ s/@/&#64;/g	 if defined $f;     # neu fuer accounting.pl
		$f =~ s/€/&euro;/g	 if defined $f;     # neu fuer accounting.pl
		$f =~ s/\&#60;/&lt;/g	 if defined $f;     # neu fuer uz.pl
		$f =~ s/\&#62;/&gt;/g	 if defined $f;     # neu fuer uz.pl

#		$f =~ s/ /\&nbsp;/g	 if defined $f;
		$f =~ s/\s/\&nbsp;/g	 if defined $f;
		$f =~ s/\&#8260;/&frasl;/g	 if defined $f;
#	        $f =~ s/:/&#58;/g	 if defined $f;        # ungeeignet fuer etikett.cfg
#       	$f =~ s/\//&frasl;/g	 if defined $f;   # zu viel Chaos in Stammdaten / faelle.cfg
#       	$f =~ s/ /&nbsp;/g	 if defined $f;       # fuer all.cfg, um genannten Fehler auszuschliessen

		$f =~ s/\&\&nbsp;/&nbsp;/g	 if defined $f;

  return $f;
}

sub umbruch {

    my  $f = shift;
		$f =~ s/(\s+)?\&lt;p\&gt;/\n\n<br>/g	 if defined $f;     # neu fuer stammdaten.pl
		$f =~ s/(\s+)?\&lt;br\&gt;/\n<br>/g	 if defined $f;     # neu fuer stammdaten.pl
  return $f;
}	

sub fritzform {

    my  $f = shift;
		$f =~ s/&#160;/ /g	 if defined $f;
		$f =~ s/&nbsp;/ /g	 if defined $f;
		$f =~ s/\///g	 	 if defined $f;
		$f =~ s/&frasl;//g	 if defined $f;
		$f =~ s/^\+/00/g	 if defined $f;                                # Int. Vorwahl aufloesen
		$f =~ s/^0049/0/g	 if defined $f;                               # ausser im Inland
		$f =~ s/\(0\)//g	 if defined $f;                                # Eventualvorwahl loeschen
		if ($f =~ /[0-9]-[0-9]/m ) { $f =~ s/-//g	 if defined $f; }     # Durchwahltrenner entfernen
		if ($f =~ /^\d\d\d+.\D+/m ) { $f =~ s/.\D+//g	 if defined $f; } # Hinweise zur Telefonnummer entfernen
		if ($f =~ /^\W+$/m ) { $f =~ s/ //g	 if defined $f; }           # In reinen Nummern Leerzeichen entfernen
  return $f;
}	

sub html2uri_old {

   my $return=shift;

	my @html=qw(&amp; &auml; &ouml; &uuml; &szlig; &frasl; &Auml; &Ouml; &Uuml; &agrave; &aacute; &acirc; &ograve; &oacute; &ocirc; &ugrave; &uacute; &ucirc; &egrave; &eacute; &euml; &Agrave; &Aacute; &Acirc; &Egrave; &Eacute; &Ecirc; &sect; &minus;);
	my @uri=qw(%26 %C3%A4 %C3%B6 %C3%BC %C3%9F %5C %C3%84 %C3%96 %C3%9C %C3%A0 %C3%A1 %C3%A2 %C3%B2 %C3%B3 %C3%B4 %C3%B9 %C3%BA %C3%BB %C3%A8 %C3%A9 %C3%AB %C3%80 %C3%81 %C3%82 %C3%88 %C3%89 %C3%8A %C2%A7 %E2%88%92);
   for(my $i=0;$i<=$#html;$i++) {
	my $e=$html[$i];
	my $r=$uri[$i];
	$return=~s/$e/$r/g if defined $return;
;
   }
   $return=~s/\s/%20/g if defined $return;
;

   return $return;

}


sub html2uri {

   my $return=html2utf8(shift);
   
   #$return=decode("utf8",$return);

   $return =~ s/([^\w])/sprintf("%%%2.2X", ord($1))/ge;
   
   # weiteren UTF8-Bug bei Zweitaufruf beheben
   $return=~s/Â\%/%/g;
   $return=~s/Ã\%/%/g;
  
   return $return;
}


sub URI {

   my $roh=shift;

	my @utf=qw(\& ; ä ö ü ß \ Ä Ö Ü â à á ò ó ô ù ú û è é ë À Á Â È É Ê § - =);
	my @uri=qw(%26 %3B %C3%A4 %C3%B6 %C3%BC %C3%9F %5C %C3%84 %C3%96 %C3%9C %C3%A2 %C3%A0 %C3%A1 %C3%B2 %C3%B3 %C3%B4 %C3%B9 %C3%BA %C3%BB %C3%A8 %C3%A9 %C3%AB %C3%80 %C3%81 %C3%82 %C3%88 %C3%89 %C3%8A %C2%A7 %E2%88%92 %3D);
   for(my $i=0;$i<=$#utf;$i++) {
	my $e=$utf[$i];
	my $r=$uri[$i];
	$roh=~s/\$e/\$r/g if defined $roh;
	}
   $roh=~s/\s/%20/g if defined $roh;
  
   my $return=$roh;
   return $return;

}


sub URI_neu {
    # ungetestet! http://code.activestate.com/recipes/577450-perl-url-encode-and-decode/
    
    my $roh = shift;
    
    $roh =~ s/([^A-Za-z0-9])/sprintf("%%%2.2X", ord($1))/ge;

    my $return=utf82html($roh);
    return $return;
}


sub noURI_alt {

   my $encode=shift;

	my @uri=qw(%26 %3B %C3%A4 %C3%B6 %C3%BC %C3%9F %5C %C3%84 %C3%96 %C3%9C %C3%A2 %C3%A0 %C3%A1 %C3%B2 %C3%B3 %C3%B4 %C3%B9 %C3%BA %C3%BB %C3%A8 %C3%A9 %C3%AB %C3%80 %C3%81 %C3%82 %C3%88 %C3%89 %C3%8A %C2%A7 %E2%88%92 &minus; %3D);
	my @utf=qw(& ; ä ö ü ß \ Ä Ö Ü â à á ò ó ô ù ú û è é ë À Á Â È É Ê § - − =);
   for(my $i=0;$i<=$#uri;$i++) {
	my $e=$uri[$i];
	my $r=$utf[$i];
	$encode=~s/$e/$r/g if defined $encode;
	}
   $encode=~s/%20/ /g if defined $encode;
  
   my $return=utf82html($encode);
   return $return;

}


sub noURI {
   #neue Version insbesondere fuer %FC=ü u.a. automatische Kodierung durch Firefox
     
   my $encode=shift;
   
   $encode =~ s/\+/ /g;
   $encode =~ s/%(..)/pack("c",hex($1))/ge;
   
   my $return=utf82html($encode);
   return $return;
}


sub Datum {
    # Datum der Uebermittlung ermitteln und weitere Daten erzeugen
    my $Version = shift;
    my $Korrekturtage = shift;
       $Korrekturtage*=86400;
    my $Zeit = shift;
    my $Datum;

    $Zeit||= time+$Korrekturtage;
    my ($Sekunden, $Minuten, $Stunden, $Monatstag, $Monat,
        $Jahr, $Wochentag, $Jahrestag, $Sommerzeit) = localtime($Zeit);
    my @Wochentage = ("Sonntag","Montag","Dienstag","Mittwoch","Donnerstag","Freitag","Samstag");
    my @Monatsnamen = ("","Januar","Februar","M&auml;rz","April","Mai","Juni",
           "Juli","August","September","Oktober","November","Dezember");
    $Monat+=1;
    $Jahrestag+=1;
    $Jahr-=100;

    if( $Version == 0 ) { $Datum = $Monatstag.".".$Monat.".".$Jahr; }
    
    $Jahr+=2000;
    if( $Version == 3 ) { $Datum = $Monatstag.". ".$Monatsnamen[$Monat]." ".$Jahr; }

    $Monat = $Monat < 10 ? $Monat = "0".$Monat : $Monat;
    $Monatstag = $Monatstag < 10 ? $Monatstag = "0".$Monatstag : $Monatstag;
    $Stunden = $Stunden < 10 ? $Stunden = "0".$Stunden : $Stunden;
    $Minuten = $Minuten < 10 ? $Minuten = "0".$Minuten : $Minuten;
    $Sekunden = $Sekunden < 10 ? $Sekunden = "0".$Sekunden : $Sekunden;

    $Jahr-=2000;
    if( $Version == 1 ) { $Datum = $Monatstag.".".$Monat.".".$Jahr; }

    $Jahr+=2000;
    if( $Version == 2 ) { $Datum = $Monatstag.".".$Monat.".".$Jahr; }
    if( $Version == 4 ) { $Datum = $Wochentage[$Wochentag].", den ".$Monatstag.".".$Monat.".".$Jahr; }

    my $Zeit=$Stunden.":".$Minuten;

    return $Datum;
}


sub Zeit {
    # Kontinentaldatum (UTC+1) ab 2001 um 0:00 Uhr in Zeit umwandeln, im Sommer 1:00 Uhr
    my $datum = shift;
    my $zeit  = shift;

    my @tage;
       @tage = split(/\./, $datum);
       if( $tage[2]*1<100 ) { $tage[2]+=2000 } # kurzes Jahresformat umstellen
       
    my @monatstage;
    if( ($tage[2] % 4 == 0 && $tage[2] % 100 != 0) || $tage[2] % 1000 == 0 ) {
    	@monatstage = (0, 0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366);
    } else {
    	@monatstage = (0, 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365);
    	}

    my @zeiten=split(/\:/, $zeit); # 16:45:20 Uhr in Einzelteile aufsplitten
       @zeiten[0]*=3600; @zeiten[1]*=60; @zeiten[2]=(length(@zeiten[2])>0)? (@zeiten[2]*1) : 0;
       
    #15.09.2008
    #15.+ Monatstage September 273/274 + Schalttage seit 2000 ohne akt. Jahr + Jahre seit 2000 x 365 + Sylvester 2000 (seit 1970) in Sekunden
    $zeit = ($tage[0]+$monatstage[($tage[1])]+int(($tage[2]*1-2001)/4))*86400+($tage[2]*1-2000)*31536000+946681200+@zeiten[0]+@zeiten[1]+@zeiten[2];
  
    #Korrekt, aber fuehrt zu ungewolltem Datumssprung bei unpraezis rollierender Abfrage: besser Fehler "1.00 h" als Fehler "23:00 h":
    #my ($Sekunden, $Minuten, $Stunden, $Monatstag, $Monat,
    #    $Jahr, $Wochentag, $Jahrestag, $Sommerzeit) = localtime($zeit);
    #$zeit-=($Sommerzeit)? 3600 : 0;    

    return $zeit;
}

sub Zeigezeit {
    # Zeit in Kontinentaldatum umwandeln (ueberfluessig geworden, siehe erweiterte Utility Datum)
    my $zeit = shift;

    my ($sekunden, $minuten, $stunden, $monatstag, $monat,
        $jahr, $wochentag, $jahrestag, $sommerzeit) = localtime($zeit);
	$monat+=1;
	$jahrestag+=1;
	$monat = $monat < 10 ? $monat = "0".$monat : $monat;
	$monatstag = $monatstag < 10 ? $monatstag = "0".$monatstag : $monatstag;
	$jahr+=1900;
    my  $datum = $monatstag.'.'.$monat.'.'.$jahr;

    return $datum;
}

sub Zahl {
    # Deutsches in englisches Zahlenformat ueberfuehren
    my $wert = shift;
    my $zahl;
    
    $wert||=""; 	# error_log
    $wert=~s/&#160;//g;	# Gliederungsleerstellen entfernen

    if( length($wert)<= 0 ) { 
	$wert="0,00"; }
    unless( $wert =~ m/\.\d\d$/ ) {
	$wert =~s/\.//g if defined $wert; }

    $wert =~ s/,/\./g if defined $wert;
    $wert =~ s/\n//g if defined $wert; # debug account6mstate

    $zahl=$wert;
    $zahl*=1;

    return $zahl;
}

sub Zeigezahl {
    # Deutsches Zahlenformat erstellen
    my $zahl = shift;
    my $stellen = shift;
    my $wert;
    my $minus="";

    unless($stellen) { $stellen=0; } #debug
    
    if( $zahl<0 ) { 
	$minus="-"; 
	$zahl*=-1; }

    #Runden
    $zahl=$zahl*(10**7);
    for(my $i=7; $i>$stellen; $i--) {
	$zahl=int($zahl+0.5);
	$zahl/=10;
	}
    $zahl=int($zahl+0.5)/10**$stellen;

    if( $zahl<1 ) {
	if($zahl==0) { if($stellen>0) {$wert="0.";} else {$wert="0";} } else { $wert=$zahl; } 
	$wert=$zahl;
	$wert=~s/\./,/g if defined $wert;

	while( length($wert)<$stellen+2 ) {
		$wert.="0"; 
		}
	}
    else {
	# deutsches oder englisches Format aufspalten
        my @teil=($zahl=~m/^[\d\.]+,\d+$/)? split(/,/,$zahl) : split(/\./, $zahl); 
	my $vorkomma=$teil[0];
	my $nachkomma=($teil[1])? $teil[1] : "";
	if( length($vorkomma)==0 ) { $vorkomma="0"; }
	my $punkte = int((length($vorkomma)-1)/3);

	my @vorkomma;
	for(my $i=1; $i<=$punkte; $i++) {
		$vorkomma[$i]=substr($vorkomma, (length($vorkomma)-$i*3), (length($vorkomma)-($i-1)*3));
		}
	if( $punkte>0 ) { 
		$vorkomma=substr($vorkomma, 0, (length($vorkomma)-$punkte*3)); }

	for(my $i=$punkte; $i>=1; $i--) {
		$vorkomma.=".".$vorkomma[$i];
		}

        while( length($nachkomma)<$stellen ) { $nachkomma.="0"; }
        
	$wert = $minus.$vorkomma;
	if( length($nachkomma)>0 ) {
		$wert.=",".$nachkomma; 
		}
	}
    return $wert;
}


sub Kontrollziffer {
    # Kontrollziffer aus String entwickeln
    
    my $text = shift;
    my $weight = shift;
    my $modulo = shift;
    my $ziffer;
    
    my $summe=0;
    # Skript gewichtet den Zeichenwert mit einem von $weight aus aufsteigenden Faktor 
    # und modulodividiert am Ende die Summe aller gewichteten Zeichenwerte durch $modulo
    for( my $x=0;$x<=length($text);$x++ ) {
	  $summe+=ord(substr($text,$x,1))*$weight;
	  $weight++;
	  }
    $ziffer=$summe%$modulo;
    $ziffer=($ziffer<10)? "0".$ziffer : $ziffer;
        
    return $ziffer;
}


sub Formular {

    my $daten=shift;
    my %daten=%{$daten};
    my $draft = shift;
    my $datum = shift;
    my @zeilen;
    my $topdf = shift;

    $daten{"datum"}=($datum)? $datum : Datum(2,0);
    $daten{"Cprozessdatum"}=Datum(2,14);
    $daten{"Cmahndatum"}=Datum(3,8);

    if ($draft) {
      mkdir("../draft/cocoon",0777) || die "Unterverzeichnis cocoon kann in draft nicht angelegt werden :\n$!" unless -e "../draft/cocoon"; 
      
      #my $zip = Archive::Zip->new();
      #$zip->read( $Draft );
      #$zip->extractTree( $Draft, '../draft/cocoon' ); # mit Archive::Zip arbeiten
      #chdir("../draft/cocoon");
      
      chdir("../draft/cocoon");
      system("unzip -oqq ../$draft");
      
      #QR-Code mit Bankdaten einfuegen, wenn vorhanden (Eintrag unten mit ODF;;plOD funktioniert nicht)
      my $random="10000200000000".(int(rand(1000000000000))+1000000000000).chr(int(rand(6)+65)).int(rand(99)).chr(int(rand(6)+65)).int(rand(9));
      if( $daten{"qrbank"} ) {
              my $qr=html2utf8($daten{"qrbank"}).$daten{"datum"}."\n\n";
	      system(qq~qrencode -o Pictures/$random.png "$qr"~);
              }
      if( $daten{"qrcode"} ) {
              my $qr=html2utf8($daten{"qrcode"});
	      system(qq~qrencode -o Pictures/$random.png "$qr"~);
              }
     
                    
      #Textvariablen in content.xml und styles.xml (Fusszeile) einfuegen
      foreach my $xml ("content", "styles", "META-INF/manifest") {
      
         my $xmldatei=$xml.'.xml';
	 
	 open(VORLAGE, "<$xmldatei") || die "Das XMl-Content der Vorlage $draft kann nicht ausgelesen werden:\n$!";
		@zeilen = <VORLAGE>;
	 close(VORLAGE);

	 #Kodierte Filenamen fuer utf8-Umgebung aufloesen z.B. agmuenster.sxw und Werte austauschen

	 my $f;
	 my $feld;
	 my @odt;
	 my @schluessel = keys(%daten);
	 @schluessel=sort(@schluessel);    # Doppeltes Ueberschreiben vermeiden
	 @schluessel=reverse(@schluessel); # umlageEUR vor umlage austauschen
	 
	  foreach my $zeile (@zeilen) {
	  
	        #CRC-Fehler durch langen PNG-Dateinamen verhindern
	        $zeile =~ s/qrbank\.png/$random.png/g;
            $zeile =~ s/qrcode\.png/$random.png/g;

	        #alle Variablen austauschen
		foreach my $schluessel (@schluessel) {
			$feld = "°".$schluessel;
			$f = $daten{$schluessel};

			$f = html2utf8($f);
			#$f = encode("utf8", $f); # wieder noetig, nachdem Updateverwirrung mit utf8 erneut aufgetreten ist

			$zeile =~ s/(Â)?$feld/$f/g if defined $zeile;

			}
		push (@odt, $zeile);
		}
	 
	 #unlink($xmldatei) || die "Kann die ODT-interne $xmldatei nicht aus der Vorlage loeschen.\n$!";   # Rueckfrage vermeiden	
	 open(DATEI, ">$xmldatei") || die "Neue $xmldatei kann nicht in den ODT-Entwurf hineingeschrieben werden:\n$!";
		print DATEI @odt;
	 close(DATEI);
	 
	 }
      
      system(`zip -0 -X "$draft" mimetype #1>/dev/null`);
      system(`zip -r "$draft" * -x mimetype #1>/dev/null`);
      #system("find ./* -print | zip -qq $Draft -@");
      system("chown matthias:users $draft");
      chmod(0666, $draft); # NICHT ALS LINUXBEFEHL (chmod 666 $draft), weil Sicherheitseinstellungen chmod sperren
      system("mv $draft ../../cgi-bin/tmp/");
      
      if($topdf) {
	      system("unoconv -f pdf ../../cgi-bin/tmp/$draft") || die "Die Umwandlung in ein PDF-Dokument ist gescheitert:\n$!";
	      $draft=~s/\.odt/.pdf/;
	      }
             
      # Aufrauemen
      my @Eintraege = glob("*");
      my $Dateien = 0;
      my $Verzeichnisse = 0;
      foreach (@Eintraege) {
        if ( -d $_) {
          my @U_1eintraege = glob("$_/*");
          foreach(@U_1eintraege) {
            if ( -d $_) {
               my @U_2eintraege = glob("$_/*");
               foreach(@U_2eintraege) {
                  if ( -d $_) {
                     my @U_3eintraege = glob("$_/*");
                     foreach(@U_3eintraege) {
                        unless ( -d $_) {
                        $Dateien+= unlink($_); }
                       }
                    $Verzeichnisse+= rmdir("$_");
                  } else {
                    $Dateien+= unlink($_);
                    }
                 }
               $Verzeichnisse+= rmdir("$_");
            } else {
               $Dateien+= unlink($_);
               }
            }
          $Verzeichnisse+= rmdir("$_");
        } else {
          $Dateien+= unlink($_);
          }
        }
     chdir("../../cgi-bin");
     rmdir("../draft/cocoon") || die "Loeschen des Hilfsverzeichnisses nicht erfolgreich:\n$!"; 

     
     return ("<a href=../cgi-bin/tmp/$draft>$draft</a>");
     }
}

sub Formular_old {

    my $daten=shift;
    my %Daten=%{$daten};
    my $Draft = shift;
    my @Zeilen;

    $Daten{"datum"}=Datum(3,0);
    $Daten{"Cprozessdatum"}=Datum(2,14);
    $Daten{"Cmahndatum"}=Datum(3,8);

    if ($Draft) {
      mkdir("../draft/cocoon",0777) || die "Unterverzeichnis cocoon kann in draft nicht angelegt werden :\n$!" unless -e "../draft/cocoon"; 
      chdir("../draft/cocoon");
      system("unzip -qq -d ./ ../$Draft");
      
      #QR-Code mit Bankdaten einfuegen, wenn vorhanden
      if( length($Daten{"qrbank"})>0 ) {
              my $qr=html2utf8($Daten{"qrbank"}).Datum(1,0)."\n\n";
	      system(qq~qrencode -o Pictures/qrbank.png "$qr"~);
              }
              
      #Textvariablen in content.xml und styles.xml (Fusszeile) einfuegen
      foreach my $xmldatei ("content", "styles") {
      
	 open(VORLAGE, "<$xmldatei.xml") || die "Das XMl-Content der Vorlage $Draft kann nicht ausgelesen werden:\n$!";
		@Zeilen = <VORLAGE>;
	 close(VORLAGE);

	 #Kodierte Filenamen fuer utf8-Umgebung aufloesen z.B. agmuenster.sxw und Werte austauschen

	 my $f;
	 my $Feld;
	 my @ODT;
	 my @Schluessel = keys(%Daten);
	 @Schluessel=sort(@Schluessel);    # Doppeltes Ueberschreiben vermeiden
	 @Schluessel=reverse(@Schluessel); # umlageEUR vor umlage austauschen
	  
	  foreach my $Zeile (@Zeilen) {
		foreach my $Schluessel (@Schluessel) {
			$Feld = "°".$Schluessel;
			$f = $Daten{$Schluessel};

			$f = html2utf8($f);
			#$f = encode("utf8", $f); # wieder noetig, nachdem Updateverwirrung mit utf8 erneut aufgetreten ist

			$Zeile =~ s/(Â)?$Feld/$f/g if defined $Zeile;

			}
		push (@ODT, $Zeile);
		}
		
	 open(DATEI, ">$xmldatei.xml") || die "Alte content.xml kann nicht ueberschrieben werden:\n$!";
		print DATEI @ODT;
	 close(DATEI);
	 
	 }

      system("find ./* -print | zip -qq $Draft -@");
      system("mv $Draft ../../cgi-bin/tmp/ | chmod 777 $Draft");
      chmod(0777, "../../cgi-bin/tmp/Draft"); # NICHT ALS LINUXBEFEHL, weil Sicherheitseinstellungen chmod sperren
    
             
      # Aufrauemen
      my @Eintraege = glob("*");
      my $Dateien = 0;
      my $Verzeichnisse = 0;
      foreach (@Eintraege) {
        if ( -d $_) {
          my @U_1eintraege = glob("$_/*");
          foreach(@U_1eintraege) {
            if ( -d $_) {
               my @U_2eintraege = glob("$_/*");
               foreach(@U_2eintraege) {
                  if ( -d $_) {
                     my @U_3eintraege = glob("$_/*");
                     foreach(@U_3eintraege) {
                        unless ( -d $_) {
                        $Dateien+= unlink($_); }
                       }
                    $Verzeichnisse+= rmdir("$_");
                  } else {
                    $Dateien+= unlink($_);
                    }
                  }
               $Verzeichnisse+= rmdir("$_");
            } else {
               $Dateien+= unlink($_);
               }
            }
          $Verzeichnisse+= rmdir("$_");
        } else {
          $Dateien+= unlink($_);
          }
        }
     chdir("../../cgi-bin");
     rmdir("../draft/cocoon") || die "Loeschen des Hilfsverzeichnisses nicht erfolgreich:\n$!"; 
      #fuer quittung.pl (Frames) geaendert:
      #return ("<a href=/tmp/$Draft>$Draft</a>");
      return ("<a href=../cgi-bin/tmp/$Draft>$Draft</a>");
   }
 }

sub Legendenbildung {

    my $daten=shift;
    my %Daten=%{$daten};
    my $Draft = shift;
    my @Zeilen;

    if ($Draft) {
      mkdir("../draft/cocooner",0777) || die "Unterverzeichnis cocooner kann in draft nicht angelegt werden :\n$!" unless -e "../draft/cocooner"; 
      chdir("../draft/cocooner");
      system("unzip -qq -d ./ ../$Draft");
      
      foreach my $xmldatei ("content") {
      
	 open(VORLAGE, "<$xmldatei.xml") || die "Das XMl-Content der Vorlage $Draft kann nicht ausgelesen werden:\n$!";
		@Zeilen = <VORLAGE>;
	 close(VORLAGE);

	 # JC kennt keine Fahrten Whg-Betrieb -> Konto 468000 komplett gestrichen
	 delete $Daten{"467800"};
	 delete $Daten{"468000"};
	 
	 #Kodierte Filenamen fuer utf8-Umgebung aufloesen z.B. agmuenster.sxw und Werte austauschen

	 my $Nummer;
	 my $Text;
	 my @ODT;
	 my @Schluessel = keys(%Daten);
	 @Schluessel=sort(@Schluessel);    # Doppeltes Ueberschreiben vermeiden

	 foreach my $Zeile (@Zeilen) {
		foreach my $Schluessel (@Schluessel) {
			$Nummer = $Schluessel;
			$Text = $Daten{$Schluessel};

			$Text = html2utf8($Text);
			$Text =~ s/&#8722;/&minus;/g;
			$Text =~ s/&minus;/-/g;          
			#$Text = encode("utf8", $Text); # wieder noetig, nachdem Updateverwirrung mit utf8 erneut aufgetreten ist
			# Bug beheben: "Rest 1-5 Jahre" wird nicht erkannt
			if($Nummer=="170700") {
				$Zeile =~ s/<text\:p text:style-name="P8">Darlehen betr. Rest 1-5 Jahre<\/text:p>/<text\:p text\:style-name="P6">$Text<\/text\:p>/g if defined $Zeile; }
			$Zeile =~ s/<text\:p text:style-name="P8">$Text<\/text:p>/<text\:p text\:style-name="P6">$Text<\/text\:p>/g if defined $Zeile;
			$Zeile =~ s/<text\:p text:style-name="P9">$Nummer<\/text:p>/<text\:p text\:style-name="P7">$Nummer<\/text:p>/g if defined $Zeile;
			}
		push (@ODT, $Zeile);
		}
	open(DATEI, ">$xmldatei.xml") || die "Alte content.xml kann nicht ueberschrieben werden:\n$!";
		print DATEI @ODT;
	close(DATEI);
	
	}
	
      system(`zip -0 -X "$Draft" mimetype #1>/dev/null`);
      system(`zip -r "$Draft" * -x mimetype #1>/dev/null`);
      #system("find ./* -print | zip -qq $Draft -@");
      system("mv $Draft ../../cgi-bin/tmp/ | chmod 777 $Draft");
      chmod(0777, "../../cgi-bin/tmp/$Draft"); # NICHT ALS LINUXBEFEHL, weil Sicherheitseinstellungen chmod sperren

      # Aufrauemen
      my @Eintraege = glob("*");
      my $Dateien = 0;
      my $Verzeichnisse = 0;
      foreach (@Eintraege) {
        if ( -d $_) {
          my @U_1eintraege = glob("$_/*");
          foreach(@U_1eintraege) {
            if ( -d $_) {
               my @U_2eintraege = glob("$_/*");
               foreach(@U_2eintraege) {
                  if ( -d $_) {
                     my @U_3eintraege = glob("$_/*");
                     foreach(@U_3eintraege) {
                        unless ( -d $_) {
                        $Dateien+= unlink($_); }
                       }
                    $Verzeichnisse+= rmdir("$_");
                  } else {
                    $Dateien+= unlink($_);
                    }
                  }
               $Verzeichnisse+= rmdir("$_");
            } else {
               $Dateien+= unlink($_);
               }
            }
          $Verzeichnisse+= rmdir("$_");
        } else {
          $Dateien+= unlink($_);
          }
        }
     chdir("../../cgi-bin");
     rmdir("../draft/cocooner") || die "Loeschen des Hilfsverzeichnisses nicht erfolgreich:\n$!"; 
      #fuer quittung.pl (Frames) geaendert:
      #return ("<a href=/tmp/$Draft>$Draft</a>");
      return ("<a href=../cgi-bin/tmp/$Draft>$Draft</a>");
   }
 }

 
sub Auslesen {

    my $datei=shift;

    my @pfad=split(/\//,$datei);
    my $name=pop(@pfad);
    my $verzeichnis=pop(@pfad);

    my @selection;
    open(DATEI, "<$datei") || die "die Datei $datei besteht nicht, oder Sie haben keine Leseberechtigung im Verzeichnis $verzeichnis:\n$!";
         @selection = <DATEI>;
    close(DATEI);

    my @return=@selection;
    return \@return;
}

sub Auslesen_Teil {

    my $datei=shift;
    my $zeiger=shift;
    unless($zeiger>0) { $zeiger=0; } #wenn keine Uebergabe

    my @pfad=split(/\//,$datei);
    my $name=pop(@pfad);
    my $verzeichnis=pop(@pfad);

    my @selection;
    open(DATEI, "<$datei") || die "die Datei $datei besteht nicht, oder Sie haben keine Leseberechtigung im Verzeichnis $verzeichnis:\n$!";
	seek(DATEI, $zeiger, 0);
	my $i=0;
	while(! eof(DATEI)) {
		$selection[$i].=getc(DATEI);
		if($selection[$i] =~ m/\n$/) {
		   $i++;
		   }
		}
	close(DATEI);

    my @return=@selection;
    return \@return;
}

sub Auslesen_Spiegel {

    my $datei=shift;
    my $ausnahme_links=shift;  # regulaerer Ausdruck
    my $ausnahme_rechts=shift; # regulaerer Ausdruck
    my %selection;
    my @zeilen;
    my @Woerter;
       $ausnahme_links ||= "";  # leere Uebergabe
       $ausnahme_rechts||= "";  # leere Uebergabe

    open(DATEI, "<$datei") || die "die Datei $datei besteht nicht, oder Sie haben keine Leseberechtigung:\n$!";
         @zeilen = <DATEI>; 
    close(DATEI);
    foreach (@zeilen) {
       @Woerter = split(/#?\:#?/, $_);
       my $feld=$Woerter[0];
       shift(@Woerter);
       my $wert=join("#:#",@Woerter);
       $wert =~ s/\n//;
       #$wert = decode("utf8", $wert);
       if( !($feld=~/$ausnahme_links/) and !($wert=~/$ausnahme_rechts/) ) {
         $selection{$feld}=$wert;
         }
       }

    return \%selection;
}

sub Move {

    my $quelle=shift;
    my $ziel=shift;
    my @x;

      unless(-e $ziel ) { mkdir( $ziel ) || die "Bitte Eigentum an $ziel auf wwwrun setzen:\n$!"; 
      chmod(0777, "$ziel" ) || die "Bitte Eigentum an $ziel auf wwwrun setzen:\n$!";  }
      my @aeintraege = glob("$quelle/*"); 
      foreach my $a (@aeintraege) { 
	@x=split("/", $a); my $A=pop(@x);     #print "$a $A";
        if ( -d $a) {                         #print "$ziel/$A";
	   unless(-e "$ziel/$A" ) { mkdir( "$ziel/$A" ) || die "Bitte Eigentum an $ziel auf wwwrun setzen:\n$!";
	   chmod(0777, "$ziel/$A" ) || die "Bitte Eigentum an $ziel auf wwwrun setzen:\n$!";  }
           my @beintraege = glob("$quelle/$A/*");
           foreach my $b (@beintraege) {
	     @x=split("/", $b); my $B=pop(@x); #print "$b $B";
             if ( -d $b) {
	        unless(-e  "$ziel/$A/$B" ) { mkdir( "$ziel/$A/$B" ) || die "$!";
		chmod(0777, "$ziel/$A/$B" ) || die "Bitte Eigentum an $ziel auf wwwrun setzen:\n$!";  }
                my @ceintraege = glob("$quelle/$A/$B/*");
                foreach my $c (@ceintraege) {
		  @x=split("/", $c); my $C=pop(@x);
                  if ( -d $c) {
		     unless(-e  "$ziel/$A/$B/$C" ) { mkdir( "$ziel/$A/$B/$C" ) || die "Bitte Eigentum an $ziel auf wwwrun setzen:\n$!";
		     chmod(0777, "$ziel/$A/$B/$C" ) || die "Bitte Eigentum an $ziel auf wwwrun setzen:\n$!";  }
		     my @deintraege = glob("$quelle/$A/$B/$C/*");
		     foreach my $d (@deintraege) {
		       @x=split("/", $d); my $D=pop(@x);
		       if ( -d $d) {
			  unless(-e "$ziel/$A/$B/$C/$D" ) { mkdir( "$ziel/$A/$B/$C/$D" ) || die "Bitte Eigentum an $ziel auf wwwrun setzen:\n$!";
			  chmod(0777, "$ziel/$A/$B/$C/$D" ) || die "Bitte Eigentum an $ziel auf wwwrun setzen:\n$!";  }
			  my @eeintraege = glob("$quelle/$A/$B/$C/$D/*");
			  foreach my $e (@eeintraege) {
			    @x=split("/", $e); my $E=pop(@x);
			    if ( -d $e) {
			       unless(-e "$ziel/$A/$B/$C/$D/$E" ) { mkdir( "$ziel/$A/$B/$C/$D/$E" ) || die "Bitte Eigentum an $ziel auf wwwrun setzen:\n$!";
			       chmod(0777, "$ziel/$A/$B/$C/$D/$E" ) || die "Bitte Eigentum an $ziel auf wwwrun setzen:\n$!";  }
			       my @feintraege = glob("$quelle/$A/$B/$C/$D/$E/*");
			       foreach my $f (@feintraege) {
				 @x=split("/", $f); my $F=pop(@x);
				 unless ( -d $f) {
				   unless( $F=~m/\.dir*/ ) { move("$quelle/$A/$B/$C/$D/$E/$F", "$ziel/$A/$B/$C/$D/$E/$F") || die "Bitte Eigentum an $ziel auf wwwrun setzen:\n$!";  
				   chmod(0777, "$ziel/$A/$B/$C/$D/$E/$F");   }}
				 }
			    } else {
			       unless( $E=~m/\.dir*/ ) { move("$quelle/$A/$B/$C/$D/$E", "$ziel/$A/$B/$C/$D/$E") || die "Bitte Eigentum an $ziel auf wwwrun setzen:\n$!";  
			       chmod(0777, "$ziel/$A/$B/$C/$D/$E");  }}
			    }
		       } else {
			  unless( $D=~m/\.dir*/ ) { move("$quelle/$A/$B/$C/$D", "$ziel/$A/$B/$C/$D") || die "Bitte Eigentum an $ziel auf wwwrun setzen:\n$!";  
			  chmod(0777, "$ziel/$A/$B/$C/$D");  }}
                       }
		  } else {
		     unless( $C=~m/\.dir*/ ) { move("$quelle/$A/$B/$C", "$ziel/$A/$B/$C") || die "Bitte Eigentum an $ziel auf wwwrun setzen:\n$!";  
		     chmod(0777, "$ziel/$A/$B/$C");  }}
		  }
	     } else {
	        unless( $B=~m/\.dir*/ ) { move("$quelle/$A/$B", "$ziel/$A/$B") || die "Bitte Eigentum an $ziel auf wwwrun setzen und Berichtigungen zu Dateien in den Unterverzeichnissen media und supp nicht vergessen:\n$!"; 
		chmod(0777, "$ziel/$A/$B");  }}
             }
	} else {
	   unless( $A=~m/\.dir*/ ) { move("$quelle/$A", "$ziel/$A") || die "Bitte Eigentum an $ziel auf wwwrun setzen:\n$!";  
           chmod(0777, "$ziel/$A");  }}
        }
      # sofern keine Fehlermeldungen beim Verschieben zum Abbruch fuehrten, 
      # koennen bis auf versteckte directory-Eintraege leere Verzeichnisse 
      # nun rekursiv geloescht werden:
      exec("rm -Rf $quelle"); 
}


sub Liste  {

    my $P=shift;
    my $p=lc($P);
    my $beteiligter=shift||0;
    my $daten=shift;
    my %daten=%{$daten};
    my $adresse=shift;
    my %adresse=%{$adresse};

    my @spalte;
    my $zeile="";

        if( $adresse{"Pname"} ) { $P="P"; }
	#Eine Seite zurueck,falsches Leerzeichen
	if($beteiligter==0) {
		$spalte[0] = $daten{"C".$p."file"}; 
		$spalte[1] = $daten{$p."rohname"};
		if( $daten{"Crechtsgebiet"} eq "SR" or $daten{"Crechtsgebiet"} eq "BG" ) {
			$spalte[1] = ( $daten{$p."rohname"} )? Stamm::Vwkurz($daten{$p."rohname"}) : Stamm::Vwkurz($adresse{$P."name"}); }
		# Bei Behoerde nur Amt anzeigen. Problem: Sortierung "LK" fällt dann aus
		# if( $adresse{$P."typ"} eq "Verwaltungstraeger" ) { 
		#	$spalte[1] =~ s/^.*\&minus\;(\&nbsp\;)?//; 
		#	} 
		$spalte[2] = $adresse{$P."name"};
		$spalte[2] =~ s/\,\W/\,&nbsp;/g; $spalte[2] =~ s/ /&nbsp;/g; $spalte[2] =~ s/&nbsp;nbsp;/&nbsp;/g; 
	} else {
		$spalte[0] = $daten{"C".$p.$beteiligter."file"}; 
		$spalte[1] = "";
		$spalte[2] = $adresse{$P."name"};
		$spalte[2] =~ s/\,\W/\,&nbsp;/g; $spalte[2] =~ s/ /&nbsp;/g; $spalte[2] =~ s/&nbsp;nbsp;/&nbsp;/g;
 		if( $daten{"Crechtsgebiet"} eq "SR" or $daten{"Crechtsgebiet"} eq "BG" ) {
			$spalte[1] = Stamm::Vwkurz($adresse{$P."name"}); }
                if( $adresse{$P."typ"} eq "Person" ) {
			my @teil   = split(",", $spalte[2]);
			$spalte[1] = $teil[0].",&nbsp;".substr($teil[1],6,1)."."; 
			}
		# Bei Behoerde nur Amt anzeigen. Problem: Sortierung "LK", "StA" fällt dann aus
		# if( $adresse{$P."typ"} eq "Verwaltungstraeger" ) { 
		#	$spalte[1] =~ s/^.*\&minus\;(\&nbsp\;)?//; 
		#	} 
		}
	$spalte[3] = $adresse{$P."typ"};
        for(my $i=0;$i<4;$i++) {
		$zeile.=$spalte[$i]."#:#";
		}
	$zeile =~ s/#:#$//g;
	$zeile = utf82html($zeile);

	return $zeile;
}


sub Ausklappmenue  {

    my $werte=shift;
#       my $u=join("<br>",@{$werte}); # workaround offenbar nur fuer array und nur in subroutine noetig - komisch
#    my @zeilen=split("<br>", $u);
    my @zeilen=@{$werte};
    my $name=shift;
    my $auswahl=shift;    #Value
    my $laenge=shift;     #Integer-Zahl (Zeilen)
    my $minbreite=shift;  #Integer-Zahl (Pixel)
    my $maxbreite=shift;  #Integer-Zahl (Pixel)
    my $javascript=shift;
    my $k;

    my   $back="";

    if( $laenge ) { $k="1"; } else { $k=""; $laenge=50; } 
    
    #Zentrieren, wenn wenig Text auf viel Raum
    my $center=($minbreite>=100)? 1 : 0;
 	foreach (@zeilen) {
		if( length($_)>13 ) { $center=0; }
		}
	$center=($center==1)? " text-align:center;" : "";
    
    if( $#zeilen >= 0 ) {
        $javascript=~ s/\"\)/$k\"\)/g if defined $javascript;
        $javascript=~ s/&quot;\)/$k&quot;\)/g if defined $javascript;

        $back.='				<SELECT NAME="'.$name.$k.'" STYLE="min-width:'.$minbreite.'px; max-width:'.$maxbreite.'px;'.$center.' overflow:auto" '.$javascript.'>'."\n";
        my $i=1;
        foreach (@zeilen) {
            $_=~s/\n//g;
            my @daten=split(/#?\:#?/, $_);
            my $selected="";
            if ( $daten[0] eq $auswahl ) { $selected="SELECTED"; }
            $back.= '					<OPTION '.$selected.' VALUE="'.$daten[0].'">'.$daten[1].' </OPTION>'."\n";
            if( ($i % $laenge == 0) && ($i<$#zeilen) ) {   #kommt wrklich noch was?
                $k++;
                $javascript=~ s/\d+\"\)/$k\"\)/;
                $back.='				</SELECT>'."\n";
                $back.='				<SELECT NAME="'.$name.$k.'" STYLE="min-width:'.$minbreite.'px; max-width:'.$maxbreite.'px;'.$center.' overflow:auto" '.$javascript.'>'."\n";
                }
            $i++;
            }
        $back.='				</SELECT>'."\n";
	}

    return $back;
}

sub HTML {

   my $htmldatei=shift;
   my $werte=shift;
   my %werte=%{$werte};
   my @zeilen;

   open(DATEI, "<../html/$htmldatei.html") || die "Die Datei $htmldatei.html kann nicht gelesen werden, evtl. haben Sie keine Leseberechtigung:\n$!";
      @zeilen = <DATEI>;
   close(DATEI);
   
   my @html;
   my @schluessel = keys(%werte);
   @schluessel=sort(@schluessel);    # Doppeltes Ueberschreiben vermeiden
   @schluessel=reverse(@schluessel); # umlageEUR vor umlage austauschen
   foreach my $zeile (@zeilen) {
     foreach my $schluessel (@schluessel) {
       my $f = '°'.$schluessel;
       my $t = html2form($werte{$schluessel});
       $zeile =~ s/(Â)?(Ã)?$f/$t/g if defined $zeile;
       }
     # nicht gefundene Variablen loeschen
     $zeile=~s/(Â)?°[a-zA-Z0-9_]+"/"/g; 
     $zeile=~s/(Â)?°[a-zA-Z0-9_]+>/>/g; 
     $zeile=~s/(Â)?°[a-zA-Z0-9_]+\s//g; 

     push (@html, $zeile);
     }
   
   my @return = @html;
   return \@return;
 
}

sub DRAFT {

   my $htmldatei=shift;
   my $werte=shift;
   my %werte=%{$werte};
   my @zeilen;

   open(DATEI, "<$htmldatei") || die "Die Datei $htmldatei.html kann nicht gelesen werden, evtl. haben Sie keine Leseberechtigung:\n$!";
      @zeilen = <DATEI>;
   close(DATEI);
   
   my @html;
   my @schluessel = keys(%werte);
   @schluessel=sort(@schluessel);    # Doppeltes Ueberschreiben vermeiden
   @schluessel=reverse(@schluessel); # umlageEUR vor umlage austauschen
   foreach my $zeile (@zeilen) {
     foreach my $schluessel (@schluessel) {
       my $f = '°'.$schluessel;
       my $t = html2form($werte{$schluessel});
       $zeile =~ s/(Â)?(Ã)?$f/$t/g if defined $zeile;
       }
     # nicht gefundene Variablen loeschen
     $zeile=~s/(Â)?°[a-zA-Z0-9_]+"/"/g; 
     $zeile=~s/(Â)?°[a-zA-Z0-9_]+>/>/g; 
     $zeile=~s/(Â)?°[a-zA-Z0-9_]+\s//g; 

     push (@html, $zeile);
     }
   
   my @return = @html;
   return \@return;
 
}

sub ZIP {
   #benutzt simpleres achrive::zip statt zypper
   die "usage: $0 zipfile.zip file [...]\n"
   if (scalar(@ARGV) < 2);

   my $zipName = shift(@ARGV);
   my $zip = Archive::Zip->new();

   foreach my $memberName (map { glob } @ARGV) {
	if (-d $memberName ) {
		warn "Can't add tree $memberName\n"
		if $zip->addTree( $memberName, $memberName ) != "AZ_OK";
		}
	else {
		$zip->addFile( $memberName )
		or warn "Can't add file $memberName\n";
		}
	}

   my $status = $zip->writeToFileNamed($zipName);

   exit $status;

}


sub Gergebuehr {
    #berechnet die GKG-$gebuehr
   
    my $sw=shift;
    my $streitwert = $sw*1;
    my $gebuehr = 0;
    my $bis = 0;
            if ( $streitwert <=      0 ) { $gebuehr  =    0; }
	    if ( $streitwert >       0 ) { $gebuehr +=   35; }
	    if ( $streitwert >     500 ) { $bis=($streitwert>2000)? 2000 : $streitwert; $gebuehr+=int($bis/500)*18; }
	    if ( $streitwert >    2000 ) { $bis=($streitwert>10000)? 10000 : $streitwert; $gebuehr+=(int($bis/1000)-1)*19; }
	    if ( $streitwert >   10000 ) { $bis=($streitwert>25000)? 25000 : $streitwert; $gebuehr+=(int(($bis-1000)/3000)-2)*26; }
	    if ( $streitwert >   25000 ) { $bis=($streitwert>50000)? 50000 : $streitwert;
	                                  $gebuehr+=int(($bis/5000)-4)*35; }
	    if ( $streitwert >   50000 ) { $bis=($streitwert>200000)? 200000 : $streitwert;
	                                  $gebuehr+=(int(($bis+10000)/15000)-4)*120; }
	    if ( $streitwert >  200000 ) { $bis=($streitwert>500000)? 500000 : $streitwert;
	                                  $gebuehr+=(int(($bis+10000)/30000)-6)*179; }
	    if ( $streitwert >  500000 ) { $gebuehr+=(int(($streitwert)/50000)-9)*180; }

    return $gebuehr;
 
 }


sub Ragebuehr {
    #berechnet die RVG-$gebuehr

    my $sw=shift;
    my $streitwert = $sw*1;
    my $gebuehr = 0;
    my $bis = 0;
            if ( $streitwert <=      0 ) { $gebuehr  =    0; }
	    if ( $streitwert >       0 ) { $gebuehr +=   45; }
	    if ( $streitwert >     500 ) { $bis=($streitwert>2000)? 2000 : $streitwert; $gebuehr+=int($bis/500)*35; }
	    if ( $streitwert >    2000 ) { $bis=($streitwert>10000)? 10000 : $streitwert; $gebuehr+=(int($bis/1000)-1)*51; }
	    if ( $streitwert >   10000 ) { $bis=($streitwert>25000)? 25000 : $streitwert; $gebuehr+=(int(($bis-1000)/3000)-2)*46; }
	    if ( $streitwert >   25000 ) { $bis=($streitwert>50000)? 50000 : $streitwert;
	                                  $gebuehr+=(int($bis/5000)-4)*75; }
	    if ( $streitwert >   50000 ) { $bis=($streitwert>200000)? 200000 : $streitwert;
	                                  $gebuehr+=(int(($bis+10000)/15000)-3)*85; }
	    if ( $streitwert >  200000 ) { $bis=($streitwert>500000)? 500000 : $streitwert;
	                                  $gebuehr+=(int(($bis+10000)/30000)-6)*120; }
	    if ( $streitwert >  500000 ) { $gebuehr+=(int(($streitwert)/50000)-9)*150; }

    return($gebuehr);

}


sub NummernSort {
   # sortiert Zahlen mit bis drei Nachkommastellen aufsteigend

   my $zahlen=shift;
   my @zahlen=@{$zahlen};

   foreach(@zahlen) { $_*=1000; }
   
   my @return = sort {
      ($a =~ /^\d+$/) ?       # $a ist eine Zahl?
          ($b =~ /^\d+$/) ?   # $b ist eine Zahl?
              $a <=> $b : -1  # -1 = Zahl kleiner (=VOR) Buchstabe
      :                       # $a ist KEINE Zahl!
          ($b !~ /^\d+$/) ?   # $b ist KEINE Zahl?
              $a cmp $b : 1   # 1 = Buchstabe grösser (=NACH) Zahl
    } @zahlen; 		      # --> 0 1 2 3 4 5 6 8 9 10 11 A B C
 
    foreach(@return) { $_/=1000; }
    
    return \@return;
 
}



1;
